/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.session;

import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.Task;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.util.base.ListPool;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.jms.client.session.WaiterThread;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class ThreadPool
extends ListPool
implements ThreadSystem {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.session.ThreadPool");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private int maxThreads = 0;
    private int instancesCount = 0;
    private int freeInstances = 0;

    public ThreadPool(int initialSize, int maxThreads) {
        super(initialSize, maxThreads);
        this.maxThreads = maxThreads;
    }

    public ThreadContext getThreadContext() {
        return null;
    }

    public void startThread(Runnable thread, boolean system, boolean instantly) {
        this.startThread(thread, system);
    }

    public synchronized WaiterThread getWaiterThread() throws InterruptedException {
        while (this.instancesCount == this.maxThreads && this.freeInstances == 0) {
            this.wait();
        }
        --this.freeInstances;
        return (WaiterThread)this.getObject();
    }

    public synchronized void releaseObject(NextItem item) {
        super.releaseObject(item);
        ++this.freeInstances;
        this.notify();
    }

    public void startThread(Runnable thread, boolean system) {
        try {
            this.getWaiterThread().setRunnableObject(thread);
        }
        catch (InterruptedException e) {
            logger.warningT(tracer, "startThread", "InterruptedException caught.");
            LoggingHelper.traceThrowable(400, tracer, "startThread", e);
        }
    }

    public NextItem newInstance() {
        WaiterThread waiterThread = new WaiterThread(this);
        waiterThread.start();
        try {
            waiterThread.waitToStart();
        }
        catch (InterruptedException e) {
            logger.warningT(tracer, "newInstance", "InterruptedException caught.");
            LoggingHelper.traceThrowable(400, tracer, "newInstance", e);
        }
        ++this.instancesCount;
        ++this.freeInstances;
        return waiterThread;
    }

    public synchronized int getLimit() {
        return this.maxThreads;
    }

    public synchronized void setLimit(int maxThreads) {
        super.setLimit(maxThreads);
        if (maxThreads > this.maxThreads) {
            this.notifyAll();
        }
        this.maxThreads = maxThreads;
    }

    public synchronized void freeMemory() {
        this.freeMemory(0);
    }

    public synchronized void freeMemory(int count) {
        int i = this.freeInstances - count - 1;
        while (i >= 0) {
            Thread thread = (Thread)((Object)this.removeFirstItem());
            if (thread != null) {
                thread.interrupt();
                --this.freeInstances;
                --this.instancesCount;
            }
            --i;
        }
    }

    public int registerContextObject(String name, ContextObject object) {
        return -1;
    }

    public int getContextObjectId(String name) {
        return -1;
    }

    public void unregisterContextObject(String name) {
    }

    public void startTask(Task task, boolean instantly) {
    }

    public void startTask(Task task, long timeout) {
    }

    public void startThread(Runnable thread, String taskName, String threadName, boolean system) {
    }

    public void startThread(Runnable thread, String taskName, String threadName, boolean system, boolean instantly) {
    }

    public void startThread(Task task, String taskName, String threadName, boolean instantly) {
    }

    public void startThread(Task task, String taskName, String threadName, long timeout) {
    }

    public void startCleanThread(Runnable thread, boolean instantly) {
        throw new UnsupportedOperationException();
    }

    public void startCleanThread(Task task, boolean instantly) {
        throw new UnsupportedOperationException();
    }

    public void startCleanThread(Runnable runnable, boolean system, boolean instantly) {
        throw new UnsupportedOperationException();
    }

    public void startCleanThread(Task task, boolean system, boolean instantly) {
        throw new UnsupportedOperationException();
    }
}

