/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.session;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.util.EnumerationLong;
import com.sap.engine.lib.util.HashMapLongInt;
import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.TextFormatter;
import com.sap.jms.client.Util;
import com.sap.jms.client.connection.Connection;
import com.sap.jms.client.destination.Destination;
import com.sap.jms.client.destination.TemporaryQueue;
import com.sap.jms.client.memory.MemoryManager;
import com.sap.jms.client.message.MapMessage;
import com.sap.jms.client.message.MessageFactory;
import com.sap.jms.client.message.ObjectMessage;
import com.sap.jms.client.session.MessageConsumer;
import com.sap.jms.client.session.MessageProducer;
import com.sap.jms.client.session.MessageWrapper;
import com.sap.jms.client.session.QueueBrowser;
import com.sap.jms.client.session.QueueReceiver;
import com.sap.jms.client.session.QueueSender;
import com.sap.jms.client.session.QueueSession;
import com.sap.jms.client.session.TopicPublisher;
import com.sap.jms.client.session.TopicSession;
import com.sap.jms.client.session.TopicSubscriber;
import com.sap.jms.client.session.WaitBlockableQueue;
import com.sap.jms.protocol.Packet;
import com.sap.jms.protocol.notification.ConsumerCreateResponse;
import com.sap.jms.protocol.notification.DestinationCreateResponse;
import com.sap.jms.protocol.notification.ProducerCreateResponse;
import com.sap.jms.protocol.notification.QueueBrowserCreateResponse;
import com.sap.jms.protocol.notification.ServerExceptionResponse;
import com.sap.jms.util.MessageID;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;

public class Session
implements javax.jms.Session {
    public static final int SESSION_TRANSACTED = 0;
    public static final byte QUEUE_SESSION = 0;
    public static final byte TOPIC_SESSION = 1;
    public static final byte GENERIC_SESSION = 2;
    public static final byte XA_QUEUE_SESSION = 3;
    public static final byte XA_TOPIC_SESSION = 4;
    public static final byte XA_GENERIC_SESSION = 5;
    private static final long SYNC_DEQUEUE_TIMEOUT = 1000L;
    private static final long DEQUEUE_TIMEOUT = 200L;
    private static final long NULL_CONSUMER_ID = 0L;
    private static final byte DESTINATION_QUEUE = 0;
    private static final byte DESTINATION_TOPIC = 1;
    private static final long LISTENER_REDELIVERY_ATTEMPTS = 10L;
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.session.Session");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private static final Object messageIDSync = new Object();
    protected static long messageIDCounter = 0L;
    protected int acknowledgeMode;
    protected boolean isClosed = false;
    protected HashMapLongObject producers = null;
    protected HashMapLongObject browsers = null;
    protected HashMapLongObject consumers = null;
    protected HashMapLongObject consumerQueues = null;
    protected HashMapLongObject browserQueues = null;
    protected HashMapLongObject listeners = null;
    protected HashMapLongInt consumedMessages = null;
    protected HashMapObjectObject subscriptions = null;
    protected WaitBlockableQueue wrappers = null;
    protected long messageIDBase = 0L;
    private boolean isStarted = false;
    private boolean isRunning = false;
    private boolean isWaitingToStop = false;
    private boolean providingMessage = false;
    private int sessionID = 0;
    private MessageFactory messageFactory = null;
    private ThreadSystem threadSystem = null;
    private MessageListener messageListener = null;
    private Connection connection;
    private javax.jms.Destination nullConsumerDestination = null;
    private Object syncThis = new Object();
    private Object syncObject = new Object();
    private MemoryManager memoryManager = MemoryManager.getMemoryManager();
    private boolean pausedByConnection = false;
    private boolean listenersLocked = false;
    Session bound = null;
    private boolean isCommitted = false;
    private Object syncWaitCommit = new Object();

    public Session(int sessionID, int acknowledgeMode, Connection connection, ThreadSystem threadSystem) throws JMSException {
        this.sessionID = sessionID;
        this.acknowledgeMode = acknowledgeMode;
        this.connection = connection;
        this.threadSystem = threadSystem;
        this.messageFactory = MessageFactory.getFactory();
        this.producers = new HashMapLongObject();
        this.browsers = new HashMapLongObject();
        this.consumers = new HashMapLongObject();
        this.consumerQueues = new HashMapLongObject();
        this.browserQueues = new HashMapLongObject();
        this.listeners = new HashMapLongObject();
        this.wrappers = new WaitBlockableQueue();
        this.consumedMessages = new HashMapLongInt();
    }

    public void close() throws JMSException {
        tracer.entering("close");
        Object object = this.syncThis;
        synchronized (object) {
            if (this.isClosed) {
                tracer.exiting();
                return;
            }
            try {
                if (this.acknowledgeMode == 0) {
                    this.rollback();
                } else if (this.acknowledgeMode == 2) {
                    this.recover();
                }
                this.isClosed = true;
            }
            catch (IllegalStateException ise) {
                this.isClosed = true;
            }
        }
        this.connection.stopDeliveryToSession(this.sessionID);
        this.stopDelivery();
        this.connection.closeSession(this.sessionID);
        Object ref = null;
        Enumeration enumeration = this.producers.elements();
        while (enumeration.hasMoreElements()) {
            ref = ((WeakReference)enumeration.nextElement()).get();
            if (ref == null) continue;
            ((MessageProducer)ref).close();
        }
        enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            ref = ((WeakReference)enumeration.nextElement()).get();
            if (ref == null) continue;
            ((MessageConsumer)ref).close();
        }
        enumeration = this.browsers.elements();
        while (enumeration.hasMoreElements()) {
            ref = ((WeakReference)enumeration.nextElement()).get();
            if (ref == null) continue;
            ((QueueBrowser)ref).close();
        }
        this.browsers = null;
        this.consumers = null;
        this.listeners = null;
        this.consumerQueues = null;
        this.browserQueues = null;
        this.consumedMessages = null;
        this.subscriptions = null;
        this.messageFactory = null;
        this.threadSystem = null;
        this.producers = null;
        if (tracer.beInfo()) {
            tracer.infoT(logger, "JMS session closed:\n {0}", new Object[]{this});
        }
        this.connection = null;
        tracer.exiting();
    }

    public void commit() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("commit");
            this.attemptToUse();
            if (!this.getTransacted()) {
                tracer.infoT(logger, "Illegal client call to Session#commit() is made for a non-transacted JMS session");
                tracer.exiting();
                throw new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1020", null));
            }
            this.connection.stopDeliveryToSession(this.sessionID);
            try {
                Object object2 = this.syncObject;
                synchronized (object2) {
                    if (this.listeners.size() == 0) {
                        this.pauseDelivery(false);
                    }
                    long[] consumers = new long[this.consumedMessages.size()];
                    int[] numbersOfMessages = new int[consumers.length];
                    this.fillConsumedMessagesArrays(consumers, numbersOfMessages);
                    Packet packet = this.connection.sendPacket(Util.PACKET_FACTORY.createSessionCommitRequest(this.connection.getConnectionID(), this.sessionID, consumers, numbersOfMessages, consumers.length));
                    this.checkReceivedPacket(packet, (byte)-22);
                    this.resetConsumedMessages();
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.startDelivery(false);
                this.connection.startDeliveryToSession(this.sessionID);
                this.setCommitted();
                throw throwable;
            }
            this.startDelivery(false);
            this.connection.startDeliveryToSession(this.sessionID);
            this.setCommitted();
            tracer.exiting();
        }
    }

    public void rollback() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("rollback");
            this.attemptToUse();
            if (!this.getTransacted()) {
                tracer.infoT(logger, "Illegal client call to Session#rollback() is made for a non-transacted JMS session");
                tracer.exiting();
                throw new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1020", null));
            }
            this.connection.stopDeliveryToSession(this.sessionID);
            try {
                Object object2 = this.syncObject;
                synchronized (object2) {
                    if (this.listeners.size() == 0) {
                        this.pauseDelivery(false);
                    }
                    long[] consumers = new long[this.consumedMessages.size()];
                    int[] numbersOfMessages = new int[consumers.length];
                    this.fillConsumedMessagesArrays(consumers, numbersOfMessages);
                    Packet packet = this.connection.sendPacket(Util.PACKET_FACTORY.createSessionRollbackRequest(this.connection.getConnectionID(), this.sessionID, consumers, numbersOfMessages, consumers.length));
                    this.checkReceivedPacket(packet, (byte)-24);
                    this.resetConsumedMessages();
                    if (this.listeners.size() > 0) {
                        this.wrappers.clear();
                    } else {
                        Enumeration enumeration = this.consumerQueues.elements();
                        while (enumeration.hasMoreElements()) {
                            ((WaitBlockableQueue)enumeration.nextElement()).clear();
                        }
                    }
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.startDelivery(false);
                this.connection.startDeliveryToSession(this.sessionID);
                this.setCommitted();
                throw throwable;
            }
            this.startDelivery(false);
            this.connection.startDeliveryToSession(this.sessionID);
            this.setCommitted();
            tracer.exiting();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.attemptToUse();
        return this.messageListener;
    }

    public Connection getConnection() throws JMSException {
        this.attemptToUse();
        return this.connection;
    }

    private final boolean mustAcknowledgeImmediately() {
        return this.acknowledgeMode == 1 || this.acknowledgeMode == 3;
    }

    public boolean getTransacted() throws JMSException {
        this.attemptToUse();
        return this.acknowledgeMode == 0;
    }

    public void recover() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("recover");
            this.attemptToUse();
            if (this.getTransacted()) {
                tracer.infoT(logger, "Illegal client call to Session#recover() is made for a transacted JMS session!");
                tracer.exiting();
                throw new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1043", null));
            }
            this.connection.stopDeliveryToSession(this.sessionID);
            try {
                Object object2 = this.syncObject;
                synchronized (object2) {
                    this.attemptToUse();
                    if (this.listeners.size() == 0) {
                        this.pauseDelivery(false);
                    }
                    long[] consumers = new long[this.consumedMessages.size()];
                    int[] numbersOfMessages = new int[consumers.length];
                    this.fillConsumedMessagesArrays(consumers, numbersOfMessages);
                    Packet packet = Util.PACKET_FACTORY.createSessionRecoverRequest(this.connection.getConnectionID(), this.sessionID, consumers, numbersOfMessages, consumers.length);
                    packet = this.connection.sendPacket(packet);
                    this.checkReceivedPacket(packet, (byte)-26);
                    this.resetConsumedMessages();
                    if (this.listeners.size() > 0) {
                        this.wrappers.clear();
                    } else {
                        Enumeration enumeration = this.consumerQueues.elements();
                        while (enumeration.hasMoreElements()) {
                            ((WaitBlockableQueue)enumeration.nextElement()).clear();
                        }
                    }
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.startDelivery(false);
                this.connection.startDeliveryToSession(this.sessionID);
                throw throwable;
            }
            this.startDelivery(false);
            this.connection.startDeliveryToSession(this.sessionID);
            tracer.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        block29: {
            try {
                block30: {
                    try {
                        if (this.messageListener != null) {
                            com.sap.jms.client.message.Message message = null;
                            Object object2 = this.syncObject;
                            synchronized (object2) {
                                message = (com.sap.jms.client.message.Message)this.wrappers.dequeueNoWait();
                                if (message == null) {
                                    this.isStarted = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 10, 27, 28] lbl10 : MonitorExitStatement: MONITOREXIT : var2_4
                                    Object var17_6 = null;
                                    object = this.syncObject;
                                    break block29;
                                }
                            }
                            long expiration = message.getJMSExpiration();
                            if (expiration != 0L && expiration <= System.currentTimeMillis()) break block30;
                            int i = 0;
                            while ((long)i < 10L && (expiration == 0L || expiration > System.currentTimeMillis())) {
                                try {
                                    this.messageListener.onMessage((Message)message);
                                    break block30;
                                }
                                catch (Throwable t) {
                                    logger.warningT(tracer, "A JMS client threw an exception during message processing! See trace file for more details!");
                                    tracer.throwing(t);
                                    if (this.mustAcknowledgeImmediately()) {
                                        message.setJMSRedelivered(true);
                                        ++i;
                                        continue;
                                    }
                                    break block30;
                                }
                            }
                            break block30;
                        }
                        while (this.isStarted) {
                            MessageWrapper messageWrapper = null;
                            Object object3 = this.syncObject;
                            synchronized (object3) {
                                messageWrapper = (MessageWrapper)this.wrappers.dequeueNoWait();
                                if (messageWrapper == null) {
                                    this.isStarted = false;
                                    break;
                                }
                                this.listenersLocked = true;
                            }
                            com.sap.jms.client.message.Message message = messageWrapper.getMessage();
                            long consumerID = messageWrapper.getConsumerID();
                            if (!this.consumers.containsKey(consumerID) || this.processFinalMessage(message, consumerID)) continue;
                            Object object4 = this.syncObject;
                            synchronized (object4) {
                                this.consumedMessages.put(consumerID, this.consumedMessages.get(consumerID) + 1);
                            }
                            long expiration = message.getJMSExpiration();
                            int i = 0;
                            while ((long)i < 10L && (expiration == 0L || expiration > System.currentTimeMillis())) {
                                try {
                                    ((MessageListener)this.listeners.get(consumerID)).onMessage((Message)message);
                                    break;
                                }
                                catch (Throwable t) {
                                    logger.warningT(tracer, "A JMS client threw an exception during message processing! See trace file for more details!");
                                    tracer.throwing(t);
                                    if (!this.mustAcknowledgeImmediately()) break;
                                    message.setJMSRedelivered(true);
                                    ++i;
                                }
                            }
                            HashMapLongObject hashMapLongObject = this.listeners;
                            synchronized (hashMapLongObject) {
                                this.listenersLocked = false;
                                this.listeners.notify();
                            }
                            int consumed = this.consumedMessages.get(consumerID);
                            if (!this.mustAcknowledgeImmediately() || consumed <= 0) continue;
                            this.consumedMessages.put(consumerID, consumed - 1);
                            this.acknowledge(consumerID);
                        }
                    }
                    catch (JMSException e) {
                        if (this.mustAcknowledgeImmediately()) {
                            this.resetConsumedMessages();
                        }
                        logger.warningT(tracer, "A JMS session threw an exception during delivery to listeners! See trace file for details!");
                        tracer.debugT("run", Util.getJMSExceptionStackTrace(e));
                        Object var17_8 = null;
                        Object object5 = this.syncObject;
                        synchronized (object5) {
                            this.isRunning = false;
                            if (!this.isWaitingToStop) return;
                            this.syncObject.notify();
                            return;
                        }
                    }
                }
                Object var17_7 = null;
                Object object6 = this.syncObject;
                synchronized (object6) {
                    this.isRunning = false;
                    if (!this.isWaitingToStop) return;
                    this.syncObject.notify();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var17_9 = null;
                Object object7 = this.syncObject;
                synchronized (object7) {
                    this.isRunning = false;
                    if (!this.isWaitingToStop) throw throwable;
                    this.syncObject.notify();
                    throw throwable;
                }
            }
        }
        synchronized (object) {
            this.isRunning = false;
            if (!this.isWaitingToStop) return;
            this.syncObject.notify();
            return;
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.attemptToUse();
        this.messageListener = messageListener;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.attemptToUse();
        com.sap.jms.client.message.BytesMessage message = this.messageFactory.createBytesMessage();
        message.setSession(this);
        return message;
    }

    public javax.jms.MapMessage createMapMessage() throws JMSException {
        this.attemptToUse();
        MapMessage message = this.messageFactory.createMapMessage();
        message.setSession(this);
        return message;
    }

    public Message createMessage() throws JMSException {
        this.attemptToUse();
        com.sap.jms.client.message.Message message = this.messageFactory.createMessage();
        message.setSession(this);
        return message;
    }

    public javax.jms.ObjectMessage createObjectMessage() throws JMSException {
        this.attemptToUse();
        ObjectMessage message = this.messageFactory.createObjectMessage();
        message.setSession(this);
        return message;
    }

    public javax.jms.ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.attemptToUse();
        ObjectMessage message = this.messageFactory.createObjectMessage(object);
        message.setSession(this);
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.attemptToUse();
        com.sap.jms.client.message.StreamMessage message = this.messageFactory.createStreamMessage();
        message.setSession(this);
        return message;
    }

    public TextMessage createTextMessage() throws JMSException {
        this.attemptToUse();
        com.sap.jms.client.message.TextMessage message = this.messageFactory.createTextMessage();
        message.setSession(this);
        return message;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.attemptToUse();
        com.sap.jms.client.message.TextMessage message = this.messageFactory.createTextMessage(string);
        message.setSession(this);
        return message;
    }

    public void addMessageListener(long consumerID, MessageListener listener) throws JMSException {
        tracer.entering("addMessageListener");
        Object object = this.syncObject;
        synchronized (object) {
            WaitBlockableQueue queue = (WaitBlockableQueue)this.consumerQueues.get(consumerID);
            if (listener == null) {
                HashMapLongObject hashMapLongObject = this.listeners;
                synchronized (hashMapLongObject) {
                    while (this.listenersLocked) {
                        try {
                            this.listeners.wait();
                        }
                        catch (InterruptedException inte) {
                            tracer.warningT(logger, "JMS could not compete addMessageListener operation because the thread was interrupted!");
                            tracer.throwing("addMessageListener", (Throwable)inte);
                            tracer.exiting();
                            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1024", null));
                        }
                    }
                }
                this.listeners.remove(consumerID);
                WaitBlockableQueue newWrappers = new WaitBlockableQueue();
                MessageWrapper wrapper = (MessageWrapper)this.wrappers.dequeueNoWait();
                while (wrapper != null) {
                    if (wrapper.getConsumerID() == consumerID) {
                        queue.enqueue(wrapper.getMessage());
                        continue;
                    }
                    newWrappers.enqueue(wrapper);
                }
                this.wrappers.destroyQueue();
                this.wrappers = newWrappers;
            } else {
                this.listeners.put(consumerID, listener);
                if (queue.isDequeueBlocked()) {
                    queue.setDequeueBlocked(false);
                    com.sap.jms.client.message.Message message = (com.sap.jms.client.message.Message)queue.dequeueNoWait();
                    while (message != null) {
                        this.wrappers.enqueue(new MessageWrapper(message, consumerID));
                        message = (com.sap.jms.client.message.Message)queue.dequeueNoWait();
                    }
                    queue.setDequeueBlocked(true);
                } else {
                    com.sap.jms.client.message.Message message = (com.sap.jms.client.message.Message)queue.dequeueNoWait();
                    while (message != null) {
                        this.wrappers.enqueue(new MessageWrapper(message, consumerID));
                        message = (com.sap.jms.client.message.Message)queue.dequeueNoWait();
                    }
                }
            }
        }
        tracer.exiting();
    }

    public void startDelivery(boolean byConnection) throws JMSException {
        tracer.entering("startDelivery");
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.connection.isStarted() || this.isStarted) {
                tracer.exiting();
                return;
            }
            if (byConnection) {
                this.pausedByConnection = false;
            } else if (this.pausedByConnection) {
                return;
            }
            if (this.messageListener != null || this.listeners.size() > 0) {
                this.isStarted = true;
                this.threadSystem.startThread((Runnable)((Object)this), false);
                this.isRunning = true;
            } else {
                EnumerationLong enumerationLong = this.consumers.keys();
                while (enumerationLong.hasMoreElements()) {
                    ((WaitBlockableQueue)this.consumerQueues.get(enumerationLong.nextElement())).setDequeueBlocked(false);
                }
            }
        }
        tracer.exiting();
    }

    public void pauseDelivery(boolean byConnection) throws JMSException {
        tracer.entering("pauseDelivery");
        Object object = this.syncObject;
        synchronized (object) {
            if (this.pausedByConnection) {
                return;
            }
            if (byConnection) {
                this.pausedByConnection = true;
            }
            if (this.listeners.size() > 0) {
                this.isStarted = false;
                this.stopDeliveryToListeners();
            } else {
                Enumeration enumeration = this.consumerQueues.elements();
                while (enumeration.hasMoreElements()) {
                    ((WaitBlockableQueue)enumeration.nextElement()).setDequeueBlocked(true);
                }
            }
        }
        tracer.exiting();
    }

    public void stopDelivery() throws JMSException {
        tracer.entering("stopDelivery");
        Object object = this.syncObject;
        synchronized (object) {
            if (this.listeners.size() > 0) {
                this.isStarted = false;
                this.stopDeliveryToListeners();
                this.wrappers.destroyQueue();
            } else {
                Enumeration enumeration = this.consumerQueues.elements();
                while (enumeration.hasMoreElements()) {
                    ((WaitBlockableQueue)enumeration.nextElement()).destroyQueue();
                }
                this.stopDeliveryToReceivers();
            }
        }
        tracer.exiting();
    }

    public void stopDeliveryToListeners() throws JMSException {
        tracer.entering("stopDeliveryToListeners");
        while (this.isRunning) {
            try {
                this.isWaitingToStop = true;
                this.syncObject.wait();
                this.isWaitingToStop = false;
            }
            catch (InterruptedException e) {
                tracer.warningT(logger, "JMS could not complete stopDeliveryToListeners operation because the thread was interrupted!");
                tracer.throwing("stopDeliveryToListeners", (Throwable)e);
                tracer.exiting();
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1024", null));
            }
        }
        tracer.exiting();
    }

    public void stopDeliveryToReceivers() throws JMSException {
        tracer.entering("stopDeliveryToReceivers");
        while (this.providingMessage) {
            try {
                this.syncObject.wait();
            }
            catch (InterruptedException e) {
                tracer.warningT(logger, "JMS could not complete stopDeliveryToReceivers operation because the thread was interrupted!");
                tracer.throwing("stopDeliveryToReceivers", (Throwable)e);
                tracer.exiting();
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1024", null));
            }
        }
        tracer.exiting();
    }

    public final int getAcknowledgeMode() throws JMSException {
        this.attemptToUse();
        return this.acknowledgeMode;
    }

    private void attemptToUse() throws IllegalStateException {
        if (this.isClosed || this.connection.isClosed()) {
            IllegalStateException ise = new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1021", null));
            tracer.warningT(logger, "Attempt to use a closed JMS session!");
            tracer.throwing("attemptToUse", (Throwable)ise);
            throw ise;
        }
    }

    protected void closeConsumer(long consumerID) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("closeConsumer");
            if (!this.isClosed) {
                this.connection.stopDeliveryToSession(this.sessionID);
                this.pauseDelivery(false);
                try {
                    Packet packet = this.connection.sendPacket(Util.PACKET_FACTORY.createConsumerCloseRequest(this.sessionID, consumerID, this.consumedMessages.get(consumerID)));
                    this.checkReceivedPacket(packet, (byte)-36);
                    Object object2 = this.syncObject;
                    synchronized (object2) {
                        this.consumers.remove(consumerID);
                        this.consumerQueues.remove(consumerID);
                        this.listeners.remove(consumerID);
                        if (this.consumedMessages.get(consumerID) == 0) {
                            this.consumedMessages.remove(consumerID);
                        }
                    }
                    if (this.subscriptions != null) {
                        Enumeration enumeration = this.subscriptions.keys();
                        Object nextElement = null;
                        Object subscriber = null;
                        while (enumeration.hasMoreElements()) {
                            nextElement = enumeration.nextElement();
                            subscriber = this.subscriptions.get(nextElement);
                            if (((TopicSubscriber)subscriber).consumerID != consumerID) continue;
                            this.subscriptions.remove(nextElement);
                            break;
                        }
                        if (this.subscriptions.size() == 0) {
                            this.subscriptions = null;
                        }
                    }
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    this.startDelivery(false);
                    this.connection.startDeliveryToSession(this.sessionID);
                    throw throwable;
                }
                this.startDelivery(false);
                this.connection.startDeliveryToSession(this.sessionID);
                {
                }
            }
            this.memoryManager.unregisterConsumer();
            tracer.exiting();
        }
    }

    public void closeBrowser(long browserID) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("closeBrowser");
            if (!this.isClosed) {
                Packet packet = this.connection.sendPacket(Util.PACKET_FACTORY.createQueueBrowserCloseRequest(this.sessionID, browserID));
                this.checkReceivedPacket(packet, (byte)-36);
                Object object2 = this.syncObject;
                synchronized (object2) {
                    this.browsers.remove(browserID);
                    this.browserQueues.remove(browserID);
                }
            }
            this.memoryManager.unregisterConsumer();
            tracer.exiting();
        }
    }

    public void closeProducer(long producerID) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("closeProducer");
            if (!this.isClosed) {
                Packet packet = this.connection.sendPacket(Util.PACKET_FACTORY.createProducerCloseRequest(this.sessionID, producerID));
                this.checkReceivedPacket(packet, (byte)-40);
                this.producers.remove(producerID);
            }
            tracer.exiting();
        }
    }

    public void sendMessage(com.sap.jms.client.message.Message message) throws JMSException {
        tracer.entering("sendMessage");
        message.getMessagePacket().setConnectionID(this.connection.getConnectionID());
        message.getMessagePacket().setSessionID(this.sessionID);
        message.flush();
        Packet packet = this.connection.sendPacket(message.getMessagePacket());
        this.checkReceivedPacket(packet, (byte)-96);
        tracer.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message provideMessage(long consumerID, long timeout) throws JMSException {
        com.sap.jms.client.message.Message message;
        block19: {
            Object object;
            Message message2;
            block18: {
                tracer.entering("provideMessage");
                if (this.messageListener != null) {
                    JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1022", null));
                    tracer.warningT(logger, "Illegal use of JMS session! Attempt to recieve message synchronously for JMS session with distinguished listener!");
                    tracer.throwing("provideMessage", (Throwable)jmse);
                    tracer.exiting();
                    throw jmse;
                }
                if (this.listeners.size() > 0) {
                    JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1022", null));
                    tracer.warningT(logger, "Illegal use of JMS session! Attempt to recieve message synchronously for JMS session with asynchronous consumers!");
                    tracer.throwing("provideMessage", (Throwable)jmse);
                    tracer.exiting();
                    throw jmse;
                }
                WaitBlockableQueue queue = null;
                Object object2 = this.syncObject;
                synchronized (object2) {
                    queue = (WaitBlockableQueue)this.consumerQueues.get(consumerID);
                    if (queue == null) {
                        return null;
                    }
                    this.providingMessage = true;
                }
                timeout = timeout == 0L ? Long.MAX_VALUE : timeout;
                int temp = 0;
                long expiration = 0L;
                try {
                    com.sap.jms.client.message.Message message3;
                    do {
                        message3 = null;
                        try {
                            while (!((long)temp >= timeout || this.isClosed || this.connection == null || this.connection.isAdapterClosed() || (message3 = (com.sap.jms.client.message.Message)queue.dequeue(timeout - (long)temp < 1000L ? timeout - (long)temp : 1000L)) != null && !this.processFinalMessage(message3, consumerID))) {
                                message3 = null;
                                temp = (int)((long)temp + 1000L);
                            }
                            if (message3 == null && this.connection != null && this.connection.isAdapterClosed()) {
                                tracer.exiting();
                                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1023", null));
                            }
                        }
                        catch (InterruptedException inte) {
                            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1024", null));
                            jmse.setLinkedException((Exception)inte);
                            tracer.warningT(logger, "JMS could not complete message receipt because the thread was interrupted!");
                            tracer.throwing("provideMessage", (Throwable)jmse);
                            tracer.exiting();
                            throw jmse;
                        }
                        if (message3 == null) {
                            tracer.exiting();
                            message2 = null;
                            Object var14_15 = null;
                            object = this.syncObject;
                            break block18;
                        }
                        if (this.mustAcknowledgeImmediately()) {
                            this.acknowledge(consumerID);
                            continue;
                        }
                        this.consumedMessages.put(consumerID, this.consumedMessages.get(consumerID) + 1);
                    } while ((expiration = message3.getJMSExpiration()) > 0L && expiration < System.currentTimeMillis());
                    tracer.debugT("provideMessage", "Successful delivery of message " + message3.getJMSMessageID() + " to consumer " + consumerID);
                    tracer.exiting();
                    message = message3;
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    Object object3 = this.syncObject;
                    synchronized (object3) {
                        this.providingMessage = false;
                        this.syncObject.notify();
                        throw throwable;
                    }
                }
            }
            synchronized (object) {
                this.providingMessage = false;
                this.syncObject.notify();
                return message2;
            }
        }
        Object var14_16 = null;
        Object object = this.syncObject;
        synchronized (object) {
            this.providingMessage = false;
            this.syncObject.notify();
            return message;
        }
    }

    protected boolean processFinalMessage(com.sap.jms.client.message.Message message, long consumerID) throws JMSException {
        if (!message.getBooleanProperty("JMS_SAP_EndMessage")) {
            this.memoryManager.deallocateMemoryForBigMessage(consumerID);
            return false;
        }
        int nextMessageSize = message.getIntProperty("JMS_SAP_NextSize");
        if (nextMessageSize > this.memoryManager.getChunkSize()) {
            this.memoryManager.allocateMemoryForBigMessage(consumerID, nextMessageSize);
            this.sendRequestForMessage(consumerID, nextMessageSize);
        } else {
            this.sendRequestForMessage(consumerID, this.memoryManager.getChunkSize());
        }
        return true;
    }

    private void sendRequestForMessage(long consumerID, int limit) throws JMSException {
        int destinationID;
        WeakReference ref = (WeakReference)this.consumers.get(consumerID);
        if (ref == null) {
            ref = (WeakReference)this.browsers.get(consumerID);
            QueueBrowser browser = (QueueBrowser)ref.get();
            if (browser == null) {
                return;
            }
            destinationID = ((Destination)browser.getQueue()).getDestinationID();
        } else {
            MessageConsumer consumer = (MessageConsumer)ref.get();
            if (consumer == null) {
                return;
            }
            destinationID = consumer.getDestinationID();
        }
        Packet packet = Util.PACKET_FACTORY.createStartMessageDeliveryRequest(destinationID, consumerID, limit);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-104);
    }

    public com.sap.jms.client.message.Message getNextMessage(long browserID) throws JMSException {
        WaitBlockableQueue queue = (WaitBlockableQueue)this.browserQueues.get(browserID);
        return (com.sap.jms.client.message.Message)queue.dequeue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveMessage(com.sap.jms.client.message.Message message, long consumerID) throws JMSException {
        tracer.entering("receiveMessage");
        message.setSession(this);
        message.reset();
        message.setWriteEnabledProperties(false);
        Object object = this.syncObject;
        synchronized (object) {
            if (this.messageListener != null) {
                this.wrappers.enqueue(message);
                tracer.debugT("receiveMessage", "Message " + message.getJMSMessageID() + "successfully received by session " + this.sessionID);
                tracer.exiting();
                return;
            }
            WeakReference ref = (WeakReference)this.consumers.get(consumerID);
            MessageListener listener = null;
            if (ref != null) {
                MessageConsumer consumer = (MessageConsumer)ref.get();
                if (consumer == null) {
                    tracer.exiting();
                    return;
                }
                message.setJMSDestination(consumer.destination);
                listener = (MessageListener)this.listeners.get(consumerID);
            } else {
                ref = (WeakReference)this.browsers.get(consumerID);
                if (ref != null) {
                    QueueBrowser browser = (QueueBrowser)ref.get();
                    if (browser == null) {
                        tracer.exiting();
                        return;
                    }
                    message.setJMSDestination((javax.jms.Destination)browser.queue);
                } else {
                    message.setJMSDestination(this.nullConsumerDestination);
                }
            }
            if (listener != null) {
                this.wrappers.enqueue(new MessageWrapper(message, consumerID));
                this.startDelivery(false);
            } else {
                WaitBlockableQueue queue = (WaitBlockableQueue)this.consumerQueues.get(consumerID);
                if (queue != null) {
                    queue.enqueue(message);
                } else {
                    queue = (WaitBlockableQueue)this.browserQueues.get(consumerID);
                    if (queue != null) {
                        queue.enqueue(message);
                    } else {
                        queue = (WaitBlockableQueue)this.consumerQueues.get(0L);
                        if (queue != null) {
                            queue.enqueue(message);
                        } else {
                            queue = (WaitBlockableQueue)this.browserQueues.get(0L);
                            if (queue != null) {
                                queue.enqueue(message);
                            }
                        }
                    }
                }
            }
        }
        tracer.debugT("receiveMessage", "Message " + message.getJMSMessageID() + "successfully received by session " + this.sessionID);
        tracer.exiting();
    }

    public void acknowledge(String messageID) throws JMSException {
        tracer.entering("acknowledge");
        this.attemptToUse();
        if (this.acknowledgeMode != 2) {
            return;
        }
        long[] consumers = new long[this.consumedMessages.size()];
        int[] numbersOfMessages = new int[consumers.length];
        this.fillConsumedMessagesArrays(consumers, numbersOfMessages);
        Packet packet = Util.PACKET_FACTORY.createMessageAcknowledgeRequest(this.sessionID, consumers, numbersOfMessages, consumers.length);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-81);
        this.resetConsumedMessages();
        tracer.exiting();
    }

    public void acknowledge(long consumerID) throws JMSException {
        tracer.entering("acknowledge");
        this.attemptToUse();
        Packet packet = Util.PACKET_FACTORY.createMessageAcknowledgeRequest(this.sessionID, consumerID);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-81);
        tracer.exiting();
    }

    public javax.jms.QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public javax.jms.QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        QueueBrowser queueBrowser;
        block9: {
            tracer.entering("createBrowser");
            this.attemptToUse();
            if (queue == null || !(queue instanceof com.sap.jms.client.destination.Queue)) {
                tracer.exiting();
                throw new InvalidDestinationException("Illegal destination!");
            }
            String instanceName = ((com.sap.jms.client.destination.Queue)queue).getInstanceName();
            if (instanceName != null && !instanceName.equals(this.connection.getServerInstance())) {
                tracer.exiting();
                throw new InvalidDestinationException("Illegal destination!");
            }
            this.memoryManager.registerNewConsumer();
            boolean success = false;
            try {
                this.nullConsumerDestination = queue;
                this.browserQueues.put(0L, new WaitBlockableQueue());
                Packet packet = Util.PACKET_FACTORY.createQueueBrowserCreateRequest(this.sessionID, queue.getQueueName(), messageSelector, this.memoryManager.getChunkSize());
                packet = this.connection.sendPacket(packet);
                this.checkReceivedPacket(packet, (byte)-43);
                QueueBrowserCreateResponse response = (QueueBrowserCreateResponse)packet;
                long browserID = response.getBrowserID();
                QueueBrowser browser = new QueueBrowser(browserID, queue, messageSelector, this);
                Object object = this.syncObject;
                synchronized (object) {
                    this.browsers.put(browserID, new WeakReference<QueueBrowser>(browser));
                    this.browserQueues.put(browserID, this.browserQueues.remove(0L));
                    this.nullConsumerDestination = null;
                }
                if (tracer.beInfo()) {
                    tracer.infoT(logger, "JMS QueueBrowser successfully created:\n {0}", new Object[]{browser});
                }
                success = true;
                queueBrowser = browser;
                Object var12_12 = null;
                if (success) break block9;
                this.memoryManager.unregisterConsumer();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (!success) {
                    this.memoryManager.unregisterConsumer();
                }
                tracer.exiting();
                throw throwable;
            }
        }
        tracer.exiting();
        return queueBrowser;
    }

    public javax.jms.MessageConsumer createConsumer(javax.jms.Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public javax.jms.MessageConsumer createConsumer(javax.jms.Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public javax.jms.MessageConsumer createConsumer(javax.jms.Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        MessageConsumer messageConsumer;
        block11: {
            tracer.entering("createConsumer");
            this.attemptToUse();
            if (destination == null || !(destination instanceof Destination)) {
                tracer.exiting();
                throw new InvalidDestinationException("Illegal destination!");
            }
            String instanceName = ((Destination)destination).getInstanceName();
            if (instanceName != null && !instanceName.equals(this.connection.getServerInstance())) {
                tracer.exiting();
                throw new InvalidDestinationException("Illegal destination!");
            }
            this.memoryManager.registerNewConsumer();
            boolean success = false;
            try {
                Packet packet = null;
                long consumerID = 0L;
                if (destination instanceof Queue) {
                    Queue queue = (Queue)destination;
                    packet = Util.PACKET_FACTORY.createConsumerCreateRequest(this.sessionID, null, queue.getQueueName(), (byte)0, noLocal, messageSelector, this.memoryManager.getChunkSize());
                } else {
                    Topic topic = (Topic)destination;
                    packet = Util.PACKET_FACTORY.createConsumerCreateRequest(this.sessionID, null, topic.getTopicName(), (byte)1, noLocal, messageSelector, this.memoryManager.getChunkSize());
                }
                this.nullConsumerDestination = destination;
                this.consumerQueues.put(0L, new WaitBlockableQueue());
                packet = this.connection.sendPacket(packet);
                this.checkReceivedPacket(packet, (byte)-34);
                consumerID = ((ConsumerCreateResponse)packet).getConsumerID();
                MessageConsumer consumer = null;
                consumer = destination instanceof Queue ? new QueueReceiver((Queue)destination, consumerID, this, messageSelector) : new TopicSubscriber((Topic)destination, consumerID, this, messageSelector, noLocal);
                Object object = this.syncObject;
                synchronized (object) {
                    this.consumers.put(consumerID, new WeakReference<QueueReceiver>((QueueReceiver)consumer));
                    this.consumedMessages.put(consumerID, 0);
                    this.consumerQueues.put(consumerID, this.consumerQueues.remove(0L));
                    this.nullConsumerDestination = null;
                }
                if (tracer.beInfo()) {
                    tracer.infoT(logger, "JMS consumer successfully created:\n {0}", new Object[]{consumer});
                }
                success = true;
                messageConsumer = consumer;
                Object var12_12 = null;
                if (success) break block11;
                this.memoryManager.unregisterConsumer();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (!success) {
                    this.memoryManager.unregisterConsumer();
                }
                tracer.exiting();
                throw throwable;
            }
        }
        tracer.exiting();
        return messageConsumer;
    }

    public javax.jms.TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public javax.jms.TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriber topicSubscriber;
        block12: {
            tracer.entering("createDurableSubscriber");
            this.attemptToUse();
            if (topic == null || !(topic instanceof com.sap.jms.client.destination.Topic)) {
                tracer.exiting();
                throw new InvalidDestinationException("Invalid destination");
            }
            String instanceName = ((com.sap.jms.client.destination.Topic)topic).getInstanceName();
            if (instanceName != null && !instanceName.equals(this.connection.getServerInstance())) {
                tracer.exiting();
                throw new InvalidDestinationException("Illegal destination!");
            }
            if (name == null || name.equals("")) {
                tracer.exiting();
                throw new JMSException("Subscription name NULL or empty");
            }
            this.memoryManager.registerNewConsumer();
            boolean success = false;
            try {
                Packet packet = null;
                long consumerID = 0L;
                this.nullConsumerDestination = topic;
                this.consumerQueues.put(0L, new WaitBlockableQueue());
                name = this.connection.getClientID() != null ? this.connection.getClientID() + "_" + name : "_" + name;
                if (this.subscriptions != null && this.subscriptions.containsKey(name)) {
                    tracer.exiting();
                    throw new JMSException("There is an active subscriber for this subscription!");
                }
                packet = Util.PACKET_FACTORY.createConsumerCreateRequest(this.sessionID, name, topic.getTopicName(), (byte)1, noLocal, messageSelector, this.memoryManager.getChunkSize());
                packet = this.connection.sendPacket(packet);
                this.checkReceivedPacket(packet, (byte)-34);
                consumerID = ((ConsumerCreateResponse)packet).getConsumerID();
                TopicSubscriber subscriber = new TopicSubscriber(topic, consumerID, this, messageSelector, noLocal);
                Object object = this.syncObject;
                synchronized (object) {
                    this.consumers.put(consumerID, new WeakReference<TopicSubscriber>(subscriber));
                    this.consumedMessages.put(consumerID, 0);
                    this.consumerQueues.put(consumerID, this.consumerQueues.remove(0L));
                    this.nullConsumerDestination = null;
                }
                if (this.subscriptions == null) {
                    this.subscriptions = new HashMapObjectObject();
                }
                this.subscriptions.put(name, subscriber);
                if (tracer.beInfo()) {
                    tracer.infoT(logger, "JMS DurableSubscriber successfully created:\n {0}", new Object[]{subscriber});
                }
                success = true;
                topicSubscriber = subscriber;
                Object var13_13 = null;
                if (success) break block12;
                this.memoryManager.unregisterConsumer();
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (!success) {
                    this.memoryManager.unregisterConsumer();
                }
                tracer.exiting();
                throw throwable;
            }
        }
        tracer.exiting();
        return topicSubscriber;
    }

    public javax.jms.MessageProducer createProducer(javax.jms.Destination destination) throws JMSException {
        tracer.entering("createProducer");
        this.attemptToUse();
        Packet packet = null;
        long producerID = 0L;
        if (destination != null) {
            if (destination instanceof com.sap.jms.client.destination.Queue) {
                Queue queue = (Queue)destination;
                packet = Util.PACKET_FACTORY.createProducerCreateRequest(this.sessionID, queue.getQueueName(), (byte)0);
            } else if (destination instanceof com.sap.jms.client.destination.Topic) {
                Topic topic = (Topic)destination;
                packet = Util.PACKET_FACTORY.createProducerCreateRequest(this.sessionID, topic.getTopicName(), (byte)1);
            } else {
                tracer.exiting();
                throw new InvalidDestinationException("Illegal destination!");
            }
            packet = this.connection.sendPacket(packet);
            this.checkReceivedPacket(packet, (byte)-38);
            producerID = ((ProducerCreateResponse)packet).getProducerID();
        }
        MessageProducer producer = null;
        if (destination == null) {
            producer = this instanceof QueueSession ? new QueueSender(null, producerID, this) : (this instanceof TopicSession ? new TopicPublisher(null, producerID, this) : new MessageProducer(null, producerID, this));
        } else if (destination instanceof Queue) {
            producer = new QueueSender((Queue)destination, producerID, this);
            this.producers.put(producerID, new WeakReference<QueueSender>((QueueSender)producer));
        } else {
            producer = new TopicPublisher((Topic)destination, producerID, this);
            this.producers.put(producerID, new WeakReference<QueueSender>((QueueSender)producer));
        }
        if (tracer.beInfo()) {
            tracer.infoT(logger, "JMS producer successfully created:\n {0}", new Object[]{producer});
        }
        tracer.exiting();
        return producer;
    }

    public Queue createQueue(String name) throws JMSException {
        tracer.entering("createQueue");
        this.attemptToUse();
        Packet packet = Util.PACKET_FACTORY.createDestinationCreateRequest(this.connection.getConnectionID(), name, (byte)0, false);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-98);
        int destinationID = ((DestinationCreateResponse)packet).getDestinationID();
        Destination.setIDNameMapping(destinationID, name);
        com.sap.jms.client.destination.Queue dest = new com.sap.jms.client.destination.Queue(name, destinationID);
        if (tracer.beInfo()) {
            tracer.infoT(logger, "JMS queue successfully created:\n {0}", new Object[]{dest});
        }
        tracer.exiting();
        return dest;
    }

    public Topic createTopic(String name) throws JMSException {
        tracer.entering("createTopic");
        this.attemptToUse();
        Packet packet = Util.PACKET_FACTORY.createDestinationCreateRequest(this.connection.getConnectionID(), name, (byte)1, false);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-98);
        int destinationID = ((DestinationCreateResponse)packet).getDestinationID();
        Destination.setIDNameMapping(destinationID, name);
        com.sap.jms.client.destination.Topic dest = new com.sap.jms.client.destination.Topic(name, destinationID);
        if (tracer.beInfo()) {
            tracer.infoT(logger, "JMS topic successfully created:\n {0}", new Object[]{dest});
        }
        tracer.exiting();
        return dest;
    }

    public javax.jms.TemporaryQueue createTemporaryQueue() throws JMSException {
        tracer.entering("createTemporaryQueue");
        this.attemptToUse();
        Packet packet = Util.PACKET_FACTORY.createDestinationCreateRequest(this.connection.getConnectionID(), null, (byte)0, true);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-98);
        DestinationCreateResponse response = (DestinationCreateResponse)packet;
        int destinationID = response.getDestinationID();
        String destinationName = response.getDestinationName();
        Destination.setIDNameMapping(destinationID, destinationName);
        TemporaryQueue dest = new TemporaryQueue(destinationName, destinationID, this.connection);
        if (tracer.beInfo()) {
            tracer.infoT(logger, "JMS TemporaryQueue successfully created:\n {0}", new Object[]{dest});
        }
        tracer.exiting();
        return dest;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        tracer.entering("createTemporaryTopic");
        this.attemptToUse();
        Packet packet = Util.PACKET_FACTORY.createDestinationCreateRequest(this.connection.getConnectionID(), null, (byte)1, true);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-98);
        DestinationCreateResponse response = (DestinationCreateResponse)packet;
        int destinationID = response.getDestinationID();
        String destinationName = response.getDestinationName();
        Destination.setIDNameMapping(destinationID, destinationName);
        com.sap.jms.client.destination.TemporaryTopic dest = new com.sap.jms.client.destination.TemporaryTopic(destinationName, destinationID, this.connection);
        if (tracer.beInfo()) {
            tracer.infoT(logger, "JMS TemporaryTopic successfully created:\n {0}", new Object[]{dest});
        }
        tracer.exiting();
        return dest;
    }

    public void unsubscribe(String name) throws JMSException {
        TopicSubscriber sub;
        tracer.entering("unsubscribe");
        this.attemptToUse();
        name = this.connection.getClientID() != null ? this.connection.getClientID() + "_" + name : "_" + name;
        if (this.subscriptions != null && (sub = (TopicSubscriber)this.subscriptions.get(name)) != null) {
            sub.close();
        }
        Packet packet = Util.PACKET_FACTORY.createSubscriptionRemoveRequest(name);
        packet = this.connection.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-83);
        tracer.exiting();
    }

    public void checkReceivedPacket(Packet packet, byte expectedPacketType) throws JMSException {
        if (packet == null) {
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1011", null));
            tracer.throwing("checkReceivedPacket", (Throwable)jmse);
            logger.warningT(tracer, "checkReceivedPacket", "Session " + this.sessionID + " could not receive expected packet because socket was closed()!");
            throw jmse;
        }
        if (packet.getPacketType() == -112) {
            JMSException jmse = ((ServerExceptionResponse)packet).getException();
            tracer.throwing("checkReceivedPacket", (Throwable)jmse);
            tracer.debugT("checkReceivedPacket", "ServerException:\n" + Util.getJMSExceptionStackTrace(jmse));
            logger.warningT(tracer, "checkReceivedPacket", "Exception on server occured! " + jmse.getMessage());
            throw jmse;
        }
        if (packet.getPacketType() != expectedPacketType) {
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS0001", null));
            tracer.throwing("checkReceivedPacket", (Throwable)jmse);
            logger.fatalT(tracer, "checkReceivedPacket", "Internal JMS error : unexpected message received! Expected packet type " + expectedPacketType + " received packet type " + packet.getPacketType());
            throw jmse;
        }
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String toString() {
        long connectionID;
        StringBuffer buffer = new StringBuffer();
        TextFormatter.header(buffer, "Session");
        TextFormatter.addColumn(buffer, "ID:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.sessionID, 0);
        TextFormatter.addColumn(buffer, "Type:", 30, 0);
        if (this instanceof XAQueueSession) {
            TextFormatter.addColumn(buffer, "XAQueueSession", 0);
        } else if (this instanceof QueueSession) {
            TextFormatter.addColumn(buffer, "QueueSession", 0);
        } else if (this instanceof XATopicSession) {
            TextFormatter.addColumn(buffer, "XATopicSession", 0);
        } else if (this instanceof TopicSession) {
            TextFormatter.addColumn(buffer, "TopicSession", 0);
        } else if (this instanceof XASession) {
            TextFormatter.addColumn(buffer, "(Generic)XASession", 0);
        } else {
            TextFormatter.addColumn(buffer, "(Generic)Session", 0);
        }
        TextFormatter.addColumn(buffer, "ConnectionID:", 30, 0);
        try {
            connectionID = this.connection.getConnectionID();
        }
        catch (Exception e) {
            connectionID = -1L;
        }
        TextFormatter.addColumn(buffer, Long.toString(connectionID), 0);
        TextFormatter.addColumn(buffer, "AcknowledgeMode:", 30, 0);
        switch (this.acknowledgeMode) {
            case 1: {
                TextFormatter.addColumn(buffer, "AUTO_ACKNOWLEDGE", 0);
                break;
            }
            case 2: {
                TextFormatter.addColumn(buffer, "CLIENT_ACKNOWLEDGE", 0);
                break;
            }
            case 3: {
                TextFormatter.addColumn(buffer, "DUPS_OK_ACKNOWLEDGE", 0);
                break;
            }
            default: {
                TextFormatter.addColumn(buffer, "Transacted session!", 0);
            }
        }
        if (this.messageListener != null) {
            TextFormatter.addColumn(buffer, "MessageListener:", 30, 0);
            TextFormatter.addColumn(buffer, this.messageListener.toString(), 0);
        }
        TextFormatter.footer(buffer);
        return buffer.toString();
    }

    public void setMessageIDBase(long messageIDBase) {
        this.messageIDBase = messageIDBase;
    }

    protected final String generateMessageID() {
        Object object = messageIDSync;
        synchronized (object) {
            String string = MessageID.toString(this.messageIDBase, ++messageIDCounter);
            return string;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception e) {
            try {
                tracer.warningT(logger, "Exception during finalization of Session");
                tracer.catching(logger, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void fillConsumedMessagesArrays(long[] consumers, int[] numbersOfMessages) {
        EnumerationLong enumerationLong = this.consumedMessages.keys();
        int index = 0;
        while (enumerationLong.hasMoreElements()) {
            consumers[index] = enumerationLong.nextElement();
            numbersOfMessages[index] = this.consumedMessages.get(consumers[index]);
            ++index;
        }
    }

    private void resetConsumedMessages() {
        EnumerationLong enumerationLong = this.consumers.keys();
        this.consumedMessages.clear();
        while (enumerationLong.hasMoreElements()) {
            this.consumedMessages.put(enumerationLong.nextElement(), 0);
        }
    }

    public Session getBoundSession() {
        return this.bound;
    }

    public void bindSession(Session session) {
        this.bound = session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitCommit() {
        Object object = this.syncWaitCommit;
        synchronized (object) {
            while (!this.isCommitted) {
                try {
                    this.syncWaitCommit.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            this.isCommitted = false;
            return;
        }
    }

    public void setCommitted() {
        Object object = this.syncWaitCommit;
        synchronized (object) {
            this.isCommitted = true;
            this.syncWaitCommit.notify();
        }
    }

    void checkForMessages(long consumerID) throws JMSException {
        boolean serverHitRequired;
        Object object = this.syncObject;
        synchronized (object) {
            WaitBlockableQueue queue = (WaitBlockableQueue)this.consumerQueues.get(consumerID);
            serverHitRequired = !this.connection.isClosed() && queue != null && queue.isEmpty();
        }
        if (serverHitRequired) {
            WeakReference ref = (WeakReference)this.consumers.get(consumerID);
            MessageConsumer consumer = (MessageConsumer)ref.get();
            int destinationID = consumer.getDestinationID();
            if (tracer.bePath()) {
                tracer.pathT(logger, "Will check in server for messages for destination id {0} and consumer : {1}", new Object[]{new Integer(destinationID), consumer});
            }
            Packet packet = Util.PACKET_FACTORY.createConsumerRefreshRequest(this.sessionID, consumerID, destinationID);
            packet = this.connection.sendPacket(packet);
            this.checkReceivedPacket(packet, (byte)-49);
        }
    }
}

