/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.session;

import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.TextFormatter;
import com.sap.jms.client.Util;
import com.sap.jms.client.message.Message;
import com.sap.jms.client.session.Session;
import com.sap.jms.protocol.Packet;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueueBrowser
implements javax.jms.QueueBrowser {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.MessageConsumer");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    protected long browserID = 0L;
    protected Queue queue = null;
    protected Session session = null;
    private String messageSelector = null;
    private boolean isClosed = false;
    private Enumeration enum = null;
    private Object syncThis = new Object();

    public QueueBrowser(long browserID, Queue queue, String messageSelector, Session session) throws JMSException {
        this.browserID = browserID;
        this.queue = queue;
        this.messageSelector = messageSelector;
        this.session = session;
    }

    public Queue getQueue() throws JMSException {
        this.attemptToUse();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.attemptToUse();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        tracer.entering("getEnumeration");
        Object object = this.syncThis;
        synchronized (object) {
            this.attemptToUse();
            if (this.enum != null && this.enum.hasMoreElements()) {
                tracer.exiting();
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1019", null));
            }
            Packet response = this.session.getConnection().sendPacket(Util.PACKET_FACTORY.createQueueBrowserEnumerationRequest(this.session.getSessionID(), this.browserID));
            this.session.checkReceivedPacket(response, (byte)-47);
            this.enum = new Enumeration(){
                Message message = null;
                boolean hasMoreElements = true;

                public boolean hasMoreElements() {
                    if (this.message != null) {
                        return true;
                    }
                    if (this.hasMoreElements) {
                        try {
                            this.message = QueueBrowser.this.session.getNextMessage(QueueBrowser.this.browserID);
                            if (this.message != null && QueueBrowser.this.session.processFinalMessage(this.message, QueueBrowser.this.browserID)) {
                                this.message = QueueBrowser.this.session.getNextMessage(QueueBrowser.this.browserID);
                            }
                            if (this.message != null && !this.message.getBooleanProperty("JMS_SAP_EnumEnd")) {
                                return true;
                            }
                            this.hasMoreElements = false;
                            this.message = null;
                            return false;
                        }
                        catch (JMSException e) {
                            this.message = null;
                            this.hasMoreElements = false;
                            return false;
                        }
                    }
                    return false;
                }

                public Object nextElement() {
                    if (!this.hasMoreElements()) {
                        throw new NoSuchElementException();
                    }
                    Message temp = this.message;
                    this.message = null;
                    return temp;
                }
            };
            tracer.exiting();
            Enumeration enumeration = this.enum;
            return enumeration;
        }
    }

    public void close() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("close");
            if (this.isClosed) {
                tracer.exiting();
                return;
            }
            this.isClosed = true;
            this.session.closeBrowser(this.browserID);
            if (tracer.beInfo()) {
                tracer.infoT(logger, "JMS QueueBrowser closed:\n {0}", new Object[]{this});
            }
            tracer.exiting();
        }
    }

    private void attemptToUse() throws IllegalStateException {
        if (this.isClosed) {
            IllegalStateException ise = new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1040", null));
            tracer.warningT(logger, "attemptToUse", "Attempt to use a closed JMS QueueBrowser!");
            tracer.throwing("attemptToUse", (Throwable)ise);
            throw ise;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TextFormatter.header(buffer, "QueueBrowser");
        TextFormatter.addColumn(buffer, "ID:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.browserID, 0);
        TextFormatter.addColumn(buffer, "Queue:", 30, 0);
        try {
            TextFormatter.addColumn(buffer, this.queue.getQueueName(), 0);
        }
        catch (Exception e) {
            TextFormatter.addColumn(buffer, "Error! Could not get property!", 0);
        }
        TextFormatter.addColumn(buffer, "SessionID:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.session.getSessionID(), 0);
        TextFormatter.addColumn(buffer, "IsClosed:", 30, 0);
        TextFormatter.addColumn(buffer, this.isClosed ? "YES" : "NO", 0);
        if (this.messageSelector != null) {
            TextFormatter.addColumn(buffer, "Selector:", 30, 0);
            TextFormatter.addColumn(buffer, this.messageSelector, 0);
        }
        TextFormatter.footer(buffer);
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception e) {
            try {
                tracer.warningT(logger, "Exception during finalization of QueueBrowser");
                tracer.catching(logger, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

