/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.session;

import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.TextFormatter;
import com.sap.jms.client.destination.Destination;
import com.sap.jms.client.message.Message;
import com.sap.jms.client.session.QueueSender;
import com.sap.jms.client.session.Session;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public class MessageProducer
implements javax.jms.MessageProducer {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.MessageProducer");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    protected Session session;
    protected long producerID = -1L;
    protected boolean isClosed = true;
    protected boolean messageIDEnabled = true;
    protected boolean messageTimestampEnabled = true;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected javax.jms.Destination destination = null;
    protected Map helperProducers = null;
    private boolean normalSend = false;
    private Object syncThis = new Object();

    public MessageProducer(javax.jms.Destination destination, long producerID, Session session) throws JMSException {
        this.session = session;
        this.destination = destination;
        if (destination == null) {
            this.helperProducers = new HashMap();
        } else {
            Destination.setIDNameMapping(((Destination)destination).getDestinationID(), ((Destination)destination).getName());
        }
        this.producerID = producerID;
        this.isClosed = false;
    }

    public void close() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("close");
            if (this.isClosed) {
                tracer.exiting();
                return;
            }
            this.isClosed = true;
            if (this.helperProducers != null) {
                Iterator iter = this.helperProducers.values().iterator();
                while (iter.hasNext()) {
                    ((javax.jms.MessageProducer)iter.next()).close();
                }
                this.helperProducers.clear();
                this.helperProducers = null;
                tracer.exiting();
                return;
            }
            this.session.closeProducer(this.producerID);
            if (tracer.beInfo()) {
                tracer.infoT(logger, "JMS producer closed:\n {0}", new Object[]{this});
            }
            tracer.exiting();
        }
    }

    public int getDeliveryMode() throws JMSException {
        this.attemptToUse();
        return this.deliveryMode;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.attemptToUse();
        return !this.messageIDEnabled;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.attemptToUse();
        return this.messageTimestampEnabled;
    }

    public int getPriority() throws JMSException {
        this.attemptToUse();
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        this.attemptToUse();
        return this.timeToLive;
    }

    public void send(javax.jms.Message clientMessage) throws JMSException {
        this.send(clientMessage, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(javax.jms.Message clientMessage, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(ClientJMSResourceAccessor.formatString("JMS1017", null));
        }
        this.normalSend = true;
        try {
            this.send(this.destination, clientMessage, deliveryMode, priority, timeToLive);
            Object var7_5 = null;
            this.normalSend = false;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.normalSend = false;
            throw throwable;
        }
    }

    public void send(javax.jms.Destination destination, javax.jms.Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(javax.jms.Destination destination, javax.jms.Message clientMessage, int deliveryMode, int priority, long timeToLive) throws JMSException {
        tracer.entering("send");
        this.attemptToUse();
        if (!this.normalSend) {
            if (this.destination != null) {
                tracer.exiting();
                throw new UnsupportedOperationException(ClientJMSResourceAccessor.formatString("JMS1017", null));
            }
            if (destination == null) {
                tracer.exiting();
                throw new UnsupportedOperationException(ClientJMSResourceAccessor.formatString("JMS1018", null));
            }
            if (!(destination instanceof Destination)) {
                tracer.exiting();
                throw new InvalidDestinationException("Illegal destination!");
            }
            MessageProducer helperProducer = (MessageProducer)this.helperProducers.get(destination);
            if (helperProducer == null) {
                String instanceName = ((Destination)destination).getInstanceName();
                if (instanceName != null && !instanceName.equals(this.session.getConnection().getServerInstance())) {
                    tracer.exiting();
                    throw new InvalidDestinationException("Illegal destination!");
                }
                helperProducer = (MessageProducer)this.session.createProducer(destination);
                this.helperProducers.put(destination, helperProducer);
            }
            helperProducer.send(clientMessage, deliveryMode, priority, timeToLive);
            tracer.exiting();
            return;
        }
        Message message = null;
        long timestamp = 0L;
        clientMessage.setJMSDestination(destination);
        long l = timestamp = this.messageTimestampEnabled ? System.currentTimeMillis() : 0L;
        if (this.messageTimestampEnabled) {
            clientMessage.setJMSTimestamp(timestamp);
        }
        timestamp = timeToLive == 0L ? 0L : timeToLive + timestamp;
        clientMessage.setJMSExpiration(timestamp);
        clientMessage.setJMSPriority(priority);
        clientMessage.setJMSDeliveryMode(deliveryMode);
        String messageID = "";
        if (this.messageIDEnabled) {
            messageID = this.session.generateMessageID();
            clientMessage.setJMSMessageID(messageID);
        }
        message = Message.convertMessage(clientMessage);
        if (!(clientMessage instanceof Message) && this.messageIDEnabled) {
            message.setJMSMessageID(messageID);
        }
        Session temp = message.getSession();
        message.setSession(this.session);
        this.session.sendMessage(message);
        message.setSession(temp);
        tracer.exiting();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.attemptToUse();
        switch (deliveryMode) {
            case 1: {
                this.deliveryMode = 1;
                break;
            }
            case 2: {
                this.deliveryMode = 2;
                break;
            }
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.attemptToUse();
        this.messageIDEnabled = !value;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.attemptToUse();
        this.messageTimestampEnabled = !value;
    }

    public void setPriority(int priority) throws JMSException {
        this.attemptToUse();
        if (priority >= 0 && priority <= 9) {
            this.priority = priority;
        }
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.attemptToUse();
        if (timeToLive >= 0L) {
            this.timeToLive = timeToLive;
        }
    }

    protected void attemptToUse() throws IllegalStateException {
        if (this.isClosed) {
            IllegalStateException ise = new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1039", null));
            tracer.warningT(logger, "Attempt to use a closed JMS message producer!");
            tracer.throwing("attemptToUse", (Throwable)ise);
            throw ise;
        }
    }

    public javax.jms.Destination getDestination() throws JMSException {
        return this.destination;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TextFormatter.header(buffer, "MessageProducer");
        TextFormatter.addColumn(buffer, "ID:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.producerID, 0);
        TextFormatter.addColumn(buffer, "Type:", 30, 0);
        if (this instanceof QueueSender) {
            TextFormatter.addColumn(buffer, "QueueSender", 0);
        } else {
            TextFormatter.addColumn(buffer, "TopicSender", 0);
        }
        TextFormatter.addColumn(buffer, "Destination:", 30, 0);
        if (this.destination != null) {
            TextFormatter.addColumn(buffer, ((Destination)this.destination).getName(), 0);
        } else {
            TextFormatter.addColumn(buffer, "Not specified!", 0);
        }
        TextFormatter.addColumn(buffer, "SessionID:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.session.getSessionID(), 0);
        TextFormatter.addColumn(buffer, "IsClosed:", 30, 0);
        TextFormatter.addColumn(buffer, this.isClosed ? "YES" : "NO", 0);
        TextFormatter.addColumn(buffer, "MessagePriority:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.priority, 0);
        TextFormatter.addColumn(buffer, "MessageIDEnabled:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.messageIDEnabled, 0);
        TextFormatter.addColumn(buffer, "MessageTimestampEnabled:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.messageTimestampEnabled, 0);
        TextFormatter.addColumn(buffer, "MessageTimeToLive:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.timeToLive, 0);
        TextFormatter.footer(buffer);
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception e) {
            try {
                tracer.warningT(logger, "Exception during finalization of MessageProducer");
                tracer.catching(logger, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

