/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.session;

import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.TextFormatter;
import com.sap.jms.client.destination.Destination;
import com.sap.jms.client.session.QueueReceiver;
import com.sap.jms.client.session.Session;
import com.sap.jms.client.session.TopicSubscriber;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class MessageConsumer
implements javax.jms.MessageConsumer {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.MessageConsumer");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    protected Session session;
    protected long consumerID = -1L;
    protected javax.jms.Destination destination;
    protected MessageListener listener = null;
    protected String selector = null;
    private boolean isClosed = true;

    public MessageConsumer(javax.jms.Destination destination, long consumerID, Session session, String selector) throws JMSException {
        this.destination = destination;
        this.consumerID = consumerID;
        this.session = session;
        this.selector = selector;
        this.isClosed = false;
        Destination.setIDNameMapping(((Destination)destination).getDestinationID(), ((Destination)destination).getName());
    }

    public synchronized void close() throws JMSException {
        tracer.entering("close");
        if (this.isClosed) {
            tracer.exiting();
            return;
        }
        this.isClosed = true;
        this.session.closeConsumer(this.consumerID);
        if (tracer.beInfo()) {
            tracer.infoT(logger, "JMS consumer closed:\n {0}", new Object[]{this});
        }
        tracer.exiting();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.attemptToUse();
        return this.listener;
    }

    public String getMessageSelector() throws JMSException {
        this.attemptToUse();
        return this.selector;
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    public Message receive(long timeout) throws JMSException {
        tracer.entering("receive");
        this.attemptToUse();
        Message message = this.session.provideMessage(this.consumerID, timeout);
        tracer.exiting();
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        Message result = null;
        tracer.entering("receiveNoWait");
        try {
            this.attemptToUse();
            try {
                this.session.checkForMessages(this.consumerID);
            }
            catch (Exception e) {
                tracer.catching(logger, (Throwable)e);
            }
            result = this.session.provideMessage(this.consumerID, 1L);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            tracer.exiting();
            throw throwable;
        }
        tracer.exiting();
        return result;
    }

    protected void attemptToUse() throws IllegalStateException {
        if (this.isClosed) {
            IllegalStateException ise = new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1038", null));
            tracer.warningT(logger, "Attempt to use a closed JMS message consumer!");
            tracer.throwing("attemptToUse", (Throwable)ise);
            throw ise;
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.attemptToUse();
        this.listener = listener;
        this.session.addMessageListener(this.consumerID, listener);
    }

    public int getDestinationID() {
        return ((Destination)this.destination).getDestinationID();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TextFormatter.header(buffer, "MessageConsumer");
        TextFormatter.addColumn(buffer, "ID:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.consumerID, 0);
        TextFormatter.addColumn(buffer, "Type:", 30, 0);
        if (this instanceof QueueReceiver) {
            TextFormatter.addColumn(buffer, "QueueReceiver", 0);
        } else {
            TextFormatter.addColumn(buffer, "TopicSubscriber", 0);
            TextFormatter.addColumn(buffer, "NoLocal:", 30, 0);
            try {
                TextFormatter.addColumn(buffer, "" + ((TopicSubscriber)this).getNoLocal(), 0);
            }
            catch (Exception e) {
                TextFormatter.addColumn(buffer, "Error! Could not get property!", 0);
            }
        }
        TextFormatter.addColumn(buffer, "Destination:", 30, 0);
        TextFormatter.addColumn(buffer, ((Destination)this.destination).getName(), 0);
        TextFormatter.addColumn(buffer, "SessionID:", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.session.getSessionID(), 0);
        TextFormatter.addColumn(buffer, "IsClosed:", 30, 0);
        TextFormatter.addColumn(buffer, this.isClosed ? "YES" : "NO", 0);
        if (this.selector != null) {
            TextFormatter.addColumn(buffer, "Selector:", 30, 0);
            TextFormatter.addColumn(buffer, this.selector, 0);
        }
        if (this.listener != null) {
            TextFormatter.addColumn(buffer, "Listener:", 30, 0);
            TextFormatter.addColumn(buffer, "" + this.listener, 0);
        }
        TextFormatter.footer(buffer);
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception e) {
            try {
                tracer.warningT(logger, "Exception during finalization of MessageConsumer");
                tracer.catching(logger, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

