/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.message;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.message.Message;
import com.sap.jms.client.message.MessageProperties;
import com.sap.jms.protocol.message.MessageRequest;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;

public final class TextMessage
extends Message
implements javax.jms.TextMessage {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.message.TextMessage");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private String body = null;
    boolean flushed = false;

    public TextMessage() throws JMSException {
        super((byte)2);
        this.setMode(2);
    }

    public TextMessage(MessageRequest messagePacket) throws JMSException {
        super(messagePacket);
        this.flushed = true;
    }

    public TextMessage(javax.jms.TextMessage message) throws JMSException {
        super((byte)2);
        this.copyPropertiesFrom((javax.jms.Message)message);
        this.body = message.getText();
        this.setMode(2);
    }

    public void clearBody() throws JMSException {
        this.setMode(2);
        if (this.flushed) {
            MessageRequest oldMessagePacket = this.messagePacket;
            this.messagePacket = new MessageRequest(2, 64, this.connectionID, this.sessionID);
            try {
                this.messageProperties = new MessageProperties(oldMessagePacket);
            }
            catch (JMSException e) {
                this.messageProperties = new MessageProperties();
            }
            this.flushed = false;
        }
        this.body = null;
    }

    public Object clone() {
        try {
            if (this.body != null) {
                this.messagePacket.setMessageBodyAndType(this.body, (byte)2);
            }
            if (this.messageProperties != null) {
                this.messagePacket.setMessageProperties(this.messageProperties.getPropertiesTable());
            }
            return new TextMessage((MessageRequest)this.messagePacket.clone());
        }
        catch (JMSException e) {
            logger.warningT(tracer, "clone", "Could not clone TextMessage due to " + e.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "clone", e);
            return null;
        }
    }

    public String getText() throws JMSException {
        if (this.flushed) {
            this.body = (String)this.messagePacket.getMessageBody();
        }
        return this.body;
    }

    public void setText(String string) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.body = string;
        this.flushed = false;
    }

    public void flush() throws JMSException {
        this.flushToBuffer(this.body);
        this.flushed = true;
    }
}

