/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.message;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.message.Message;
import com.sap.jms.protocol.message.MessageRequest;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public final class StreamMessage
extends Message
implements javax.jms.StreamMessage {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.message.StreamMessage");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private static final int STEP = 100;
    private static final byte BYTE_VALUE = 1;
    private static final byte BOOLEAN_VALUE = 2;
    private static final byte CHAR_VALUE = 3;
    private static final byte SHORT_VALUE = 4;
    private static final byte INT_VALUE = 5;
    private static final byte LONG_VALUE = 6;
    private static final byte FLOAT_VALUE = 7;
    private static final byte DOUBLE_VALUE = 8;
    private static final byte STRING_VALUE = 9;
    private static final byte BYTEARRAY_VALUE = 10;
    private static final byte NULL_VALUE = 11;
    private byte[] body = null;
    private int index = 0;
    private int endIndex = 0;
    private int readBytesCount = -1;

    public StreamMessage() throws JMSException {
        super((byte)3);
        this.body = new byte[100];
        this.setMode(1);
    }

    public StreamMessage(MessageRequest messagePacket) throws JMSException {
        super(messagePacket);
    }

    public StreamMessage(javax.jms.StreamMessage alien) throws JMSException {
        super((byte)3);
        this.copyPropertiesFrom((javax.jms.Message)alien);
        this.copyBodyStreamFrom(alien);
    }

    public void clearBody() throws JMSException {
        this.body = new byte[100];
        this.endIndex = 0;
        this.index = 0;
        this.setMode(1);
    }

    public Object clone() {
        try {
            if (this.body != null) {
                this.messagePacket.setMessageBodyAndType(this.body, this.endIndex, (byte)3);
            }
            if (this.messageProperties != null) {
                this.messagePacket.setMessageProperties(this.messageProperties.getPropertiesTable());
            }
            return new StreamMessage((MessageRequest)this.messagePacket.clone());
        }
        catch (JMSException e) {
            logger.warningT(tracer, "clone", "Could not clone StreamMessage due to " + e.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "clone", e);
            return null;
        }
    }

    public boolean readBoolean() throws JMSException {
        boolean s;
        block13: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = false;
            try {
                byte theSwitch = 0;
                if (this.endIndex - this.index > 0) {
                    theSwitch = this.body[this.index];
                    switch (theSwitch) {
                        case 2: {
                            if (this.endIndex - this.index > 1) {
                                s = Convert.byteArrToBoolean(this.body, this.index + 1);
                                this.index += 2;
                                break block13;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 9: {
                            String temp = this.getString(this.index + 1);
                            ++this.index;
                            s = temp.equalsIgnoreCase("true");
                            break block13;
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public byte readByte() throws JMSException {
        byte s;
        block14: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = 0;
            int oldIndex = this.index;
            try {
                byte theSwitch = 0;
                if (this.endIndex - this.index > 0) {
                    theSwitch = this.body[this.index];
                    switch (theSwitch) {
                        case 1: {
                            if (this.endIndex - this.index > 1) {
                                s = this.body[this.index + 1];
                                this.index += 2;
                                break block14;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 9: {
                            String temp = this.getString(this.index + 1);
                            s = Byte.parseByte(temp);
                            ++this.index;
                            break block14;
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (NumberFormatException nfe) {
                this.index = oldIndex;
                throw nfe;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        if (this.body == null) {
            this.body = (byte[])this.messagePacket.getMessageBody();
        }
        switch (this.readBytesCount) {
            case -1: {
                try {
                    byte theSwitch = 0;
                    int available = this.endIndex - this.index;
                    if (available > 0) {
                        theSwitch = this.body[this.index];
                        --available;
                        switch (theSwitch) {
                            case 11: {
                                ++this.index;
                                return -1;
                            }
                            case 10: {
                                if (available < 4) {
                                    throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                                }
                                int len = Convert.byteArrToInt(this.body, this.index + 1);
                                if (len <= (available -= 4)) {
                                    if (len < value.length) {
                                        System.arraycopy(this.body, this.index + 5, value, 0, len);
                                        this.index = this.index + 5 + len;
                                        return len;
                                    }
                                    int temp = value.length;
                                    System.arraycopy(this.body, this.index + 5, value, 0, temp);
                                    this.index = this.index + 5 + temp;
                                    this.readBytesCount = len - temp;
                                    return temp;
                                }
                                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                            }
                        }
                        throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                    }
                    throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                }
                catch (MessageFormatException mfe) {
                    throw mfe;
                }
                catch (MessageEOFException mee) {
                    throw mee;
                }
                catch (Exception e) {
                    throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
                }
            }
            case 0: {
                --this.readBytesCount;
                return -1;
            }
        }
        if (this.readBytesCount < value.length) {
            System.arraycopy(this.body, this.index, value, 0, this.readBytesCount);
            this.index += this.readBytesCount;
            int read = this.readBytesCount;
            this.readBytesCount = -1;
            return read;
        }
        int temp = value.length;
        System.arraycopy(this.body, this.index, value, 0, temp);
        this.index += temp;
        this.readBytesCount -= temp;
        return temp;
    }

    public char readChar() throws JMSException {
        char s;
        block14: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = '\u0000';
            try {
                byte theSwitch = 0;
                if (this.endIndex - this.index > 0) {
                    theSwitch = this.body[this.index];
                    switch (theSwitch) {
                        case 3: {
                            if (this.endIndex - this.index > 2) {
                                s = Convert.byteArrToChar(this.body, this.index + 1);
                                this.index += 3;
                                break block14;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 11: {
                            throw new NullPointerException();
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (NullPointerException npe) {
                throw npe;
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public double readDouble() throws JMSException {
        double s;
        block16: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = 0.0;
            int oldIndex = this.index;
            try {
                byte theSwitch = 0;
                int available = this.endIndex - this.index;
                if (available > 0) {
                    theSwitch = this.body[this.index];
                    --available;
                    switch (theSwitch) {
                        case 8: {
                            if (available >= 8) {
                                s = Convert.byteArrToDouble(this.body, this.index + 1);
                                this.index += 9;
                                break block16;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 7: {
                            if (available >= 4) {
                                s = Convert.byteArrToFloat(this.body, this.index + 1);
                                this.index += 5;
                                break block16;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 9: {
                            String temp = this.getString(this.index + 1);
                            ++this.index;
                            s = Double.parseDouble(temp);
                            break block16;
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (NumberFormatException nfe) {
                this.index = oldIndex;
                throw nfe;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public float readFloat() throws JMSException {
        float s;
        block14: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = 0.0f;
            int oldIndex = this.index;
            try {
                byte theSwitch = 0;
                int available = this.endIndex - this.index;
                if (available > 0) {
                    theSwitch = this.body[this.index];
                    --available;
                    switch (theSwitch) {
                        case 7: {
                            if (available >= 4) {
                                s = Convert.byteArrToFloat(this.body, this.index + 1);
                                this.index += 5;
                                break block14;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 9: {
                            String temp = this.getString(this.index + 1);
                            ++this.index;
                            s = Float.parseFloat(temp);
                            break block14;
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (NumberFormatException nfe) {
                this.index = oldIndex;
                throw nfe;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public int readInt() throws JMSException {
        int s;
        block18: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = 0;
            int oldIndex = this.index;
            try {
                byte theSwitch = 0;
                int available = this.endIndex - this.index;
                if (available > 0) {
                    theSwitch = this.body[this.index];
                    --available;
                    switch (theSwitch) {
                        case 5: {
                            if (available >= 4) {
                                s = Convert.byteArrToInt(this.body, this.index + 1);
                                this.index += 5;
                                break block18;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 4: {
                            if (available >= 2) {
                                s = Convert.byteArrToShort(this.body, this.index + 1);
                                this.index += 3;
                                break block18;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 1: {
                            if (available > 0) {
                                s = this.body[this.index + 1];
                                this.index += 2;
                                break block18;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 9: {
                            String temp = this.getString(this.index + 1);
                            ++this.index;
                            s = Integer.parseInt(temp);
                            break block18;
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (NumberFormatException nfe) {
                this.index = oldIndex;
                throw nfe;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public long readLong() throws JMSException {
        long s;
        block20: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = 0L;
            int oldIndex = this.index;
            try {
                byte theSwitch = 0;
                int available = this.endIndex - this.index;
                if (available > 0) {
                    theSwitch = this.body[this.index];
                    --available;
                    switch (theSwitch) {
                        case 6: {
                            if (available >= 8) {
                                s = Convert.byteArrToLong(this.body, this.index + 1);
                                this.index += 9;
                                break block20;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 5: {
                            if (available >= 4) {
                                s = Convert.byteArrToInt(this.body, this.index + 1);
                                this.index += 5;
                                break block20;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 4: {
                            if (available >= 2) {
                                s = Convert.byteArrToShort(this.body, this.index + 1);
                                this.index += 3;
                                break block20;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 1: {
                            if (available > 0) {
                                s = this.body[this.index + 1];
                                this.index += 2;
                                break block20;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 9: {
                            String temp = this.getString(this.index + 1);
                            ++this.index;
                            s = Long.parseLong(temp);
                            break block20;
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (NumberFormatException nfe) {
                this.index = oldIndex;
                throw nfe;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public Object readObject() throws JMSException {
        if (this.body == null) {
            this.body = (byte[])this.messagePacket.getMessageBody();
        }
        if (this.readBytesCount != -1) {
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        try {
            byte theSwitch = 0;
            if (this.endIndex - this.index > 0) {
                theSwitch = this.body[this.index];
                switch (theSwitch) {
                    case 11: {
                        ++this.index;
                        return null;
                    }
                    case 9: {
                        return this.readString();
                    }
                    case 2: {
                        return new Boolean(this.readBoolean());
                    }
                    case 1: {
                        return new Byte(this.readByte());
                    }
                    case 4: {
                        return new Short(this.readShort());
                    }
                    case 5: {
                        return new Integer(this.readInt());
                    }
                    case 6: {
                        return new Long(this.readLong());
                    }
                    case 7: {
                        return new Float(this.readFloat());
                    }
                    case 8: {
                        return new Double(this.readDouble());
                    }
                    case 3: {
                        return new Character(this.readChar());
                    }
                    case 10: {
                        if (this.mode == 1) {
                            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
                        }
                        if (this.endIndex - this.index + 1 >= 4) {
                            int len = Convert.byteArrToInt(this.body, this.index + 1);
                            if (len <= this.endIndex - this.index + 5) {
                                byte[] temp = new byte[len];
                                System.arraycopy(this.body, this.index + 5, temp, 0, len);
                                this.index = this.index + 5 + len;
                                return temp;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                    }
                }
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        catch (MessageNotReadableException mnre) {
            throw mnre;
        }
        catch (MessageFormatException mfe) {
            throw mfe;
        }
        catch (MessageEOFException meo) {
            throw meo;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
        }
    }

    public short readShort() throws JMSException {
        short s;
        block16: {
            if (this.mode == 1) {
                throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
            }
            if (this.readBytesCount != -1) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            if (this.body == null) {
                this.body = (byte[])this.messagePacket.getMessageBody();
            }
            s = 0;
            int oldIndex = this.index;
            try {
                byte theSwitch = 0;
                int available = this.endIndex - this.index;
                if (available > 0) {
                    theSwitch = this.body[this.index];
                    --available;
                    switch (theSwitch) {
                        case 4: {
                            if (available >= 2) {
                                s = Convert.byteArrToShort(this.body, this.index + 1);
                                this.index += 3;
                                break block16;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 1: {
                            if (available > 0) {
                                s = this.body[this.index + 1];
                                this.index += 2;
                                break block16;
                            }
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        case 9: {
                            String temp = this.getString(this.index + 1);
                            ++this.index;
                            s = Short.parseShort(temp);
                            break block16;
                        }
                        default: {
                            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
                        }
                    }
                }
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            catch (MessageEOFException mee) {
                throw mee;
            }
            catch (MessageFormatException mfe) {
                throw mfe;
            }
            catch (NumberFormatException nfe) {
                this.index = oldIndex;
                throw nfe;
            }
            catch (Exception e) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
            }
        }
        return s;
    }

    public String readString() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        if (this.readBytesCount != -1) {
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        if (this.body == null) {
            this.body = (byte[])this.messagePacket.getMessageBody();
        }
        try {
            byte theSwitch = 0;
            if (this.endIndex - this.index > 0) {
                theSwitch = this.body[this.index];
                switch (theSwitch) {
                    case 9: {
                        String s = this.getString(this.index + 1);
                        ++this.index;
                        return s;
                    }
                    case 11: {
                        ++this.index;
                        return null;
                    }
                    case 2: {
                        return "" + this.readBoolean();
                    }
                    case 1: {
                        return "" + this.readByte();
                    }
                    case 4: {
                        return "" + this.readShort();
                    }
                    case 5: {
                        return "" + this.readInt();
                    }
                    case 6: {
                        return "" + this.readLong();
                    }
                    case 7: {
                        return "" + this.readFloat();
                    }
                    case 8: {
                        return "" + this.readDouble();
                    }
                    case 3: {
                        return "" + this.readChar();
                    }
                }
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
            }
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        catch (MessageFormatException mfe) {
            --this.index;
            throw mfe;
        }
        catch (MessageEOFException meo) {
            --this.index;
            throw meo;
        }
        catch (Exception e) {
            --this.index;
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1035", null));
        }
    }

    public void reset() throws JMSException {
        if (this.body == null) {
            this.body = (byte[])this.messagePacket.getMessageBody();
            this.endIndex = this.messagePacket.getMessageBodySize() - 4;
        }
        this.setMode(0);
        this.index = 0;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 2) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 2;
            Convert.writeBooleanToByteArr(this.body, this.endIndex + 1, value);
            this.endIndex += 2;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 2) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 1;
            this.body[this.endIndex + 1] = value;
            this.endIndex += 2;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (value != null) {
            this.writeBytes(value, 0, value.length);
        } else {
            this.writeBytes(value, 0, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (value == null) {
            if (this.endIndex == this.body.length) {
                this.increaseBody();
            }
            this.body[this.endIndex++] = 11;
            return;
        }
        if (length >= 0 && length <= value.length) ** GOTO lbl11
        throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
lbl-1000:
        // 1 sources

        {
            this.increaseBody();
lbl11:
            // 2 sources

            ** while (this.body.length - this.endIndex < length + 1 && length <= value.length - offset)
        }
lbl12:
        // 1 sources

        try {
            this.body[this.endIndex] = 10;
            Convert.writeIntToByteArr(this.body, this.endIndex + 1, length);
            System.arraycopy(value, offset, this.body, this.endIndex + 5, length);
            this.endIndex = this.endIndex + 5 + length;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeChar(char value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 3) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 3;
            Convert.writeCharToByteArr(this.body, this.endIndex + 1, value);
            this.endIndex += 3;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 9) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 8;
            Convert.writeDoubleToByteArr(this.body, this.endIndex + 1, value);
            this.endIndex += 9;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 5) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 7;
            Convert.writeFloatToByteArr(this.body, this.endIndex + 1, value);
            this.endIndex += 5;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeInt(int value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 5) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 5;
            Convert.writeIntToByteArr(this.body, this.endIndex + 1, value);
            this.endIndex += 5;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeLong(long value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 9) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 6;
            Convert.writeLongToByteArr(this.body, this.endIndex + 1, value);
            this.endIndex += 9;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeObject(Object obj) throws JMSException {
        if (obj == null) {
            if (this.endIndex == this.body.length) {
                this.increaseBody();
            }
            this.body[this.endIndex++] = 11;
            return;
        }
        if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj);
        } else if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
        } else if (obj instanceof Short) {
            this.writeShort((Short)obj);
        } else if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
        } else if (obj instanceof Long) {
            this.writeLong((Long)obj);
        } else if (obj instanceof Character) {
            this.writeChar(((Character)obj).charValue());
        } else if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            this.writeDouble((Double)obj);
        } else if (obj instanceof String) {
            this.writeString((String)obj);
        } else if (obj instanceof byte[]) {
            this.writeBytes((byte[])obj);
        } else {
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1034", null));
        }
    }

    public void writeShort(short value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (this.body.length - this.endIndex < 3) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 4;
            Convert.writeShortToByteArr(this.body, this.endIndex + 1, value);
            this.endIndex += 3;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    public void writeString(String value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (value == null) {
            if (this.endIndex == this.body.length) {
                this.increaseBody();
            }
            this.body[this.endIndex++] = 11;
            return;
        }
        int bytesLength = 2 * value.length();
        while (this.body.length - this.endIndex < bytesLength + 5) {
            this.increaseBody();
        }
        try {
            this.body[this.endIndex] = 9;
            Convert.writeIntToByteArr(this.body, this.endIndex + 1, value.length());
            Convert.writeUStringToByteArr(this.body, this.endIndex + 5, value);
            this.endIndex = this.endIndex + 5 + bytesLength;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1037", null));
        }
    }

    private void increaseBody() {
        byte[] b = new byte[this.body.length + 100];
        System.arraycopy(this.body, 0, b, 0, this.endIndex);
        this.body = b;
    }

    private String getString(int fromIndex) throws MessageEOFException {
        int available = this.endIndex - fromIndex;
        int len = 0;
        if (available < 4) {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        len = Convert.byteArrToInt(this.body, fromIndex);
        if ((available -= 4) >= len) {
            String s = Convert.byteArrToUString(this.body, fromIndex + 4, len);
            this.index = this.index + 4 + 2 * len;
            return s;
        }
        throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
    }

    /*
     * Unable to fully structure code
     */
    private void copyBodyStreamFrom(javax.jms.StreamMessage alien) throws JMSException {
        this.clearBody();
        alien.reset();
        v = new Vector<Object>(5, 5);
        o = null;
        try {
            while (true) {
                o = alien.readObject();
                v.add(o);
                this.writeObject(o);
            }
        }
        catch (MessageEOFException meof) {
            this.setMode(0);
            alien.clearBody();
            ** while (v.size() > 0)
        }
lbl-1000:
        // 1 sources

        {
            alien.writeObject(v.remove(0));
            continue;
        }
lbl18:
        // 1 sources

        this.setMode(1);
    }

    public void flush() throws JMSException {
        this.flushToBuffer(this.body, this.endIndex);
    }
}

