/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.message;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.message.Message;
import com.sap.jms.client.message.MessageProperties;
import com.sap.jms.protocol.message.MessageRequest;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;

public final class ObjectMessage
extends Message
implements javax.jms.ObjectMessage {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.message.ObjectMessage");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");

    public ObjectMessage() throws JMSException {
        super((byte)5);
        this.setMode(2);
    }

    public ObjectMessage(MessageRequest messagePacket) throws JMSException {
        super(messagePacket);
    }

    public ObjectMessage(javax.jms.ObjectMessage alien) throws JMSException {
        super((byte)5);
        this.setMode(2);
        this.copyPropertiesFrom((javax.jms.Message)alien);
        this.setObject(alien.getObject());
    }

    public void clearBody() throws JMSException {
        this.setMode(2);
        MessageRequest oldMessagePacket = this.messagePacket;
        this.messagePacket = new MessageRequest(5, 64, this.connectionID, this.sessionID);
        try {
            this.messageProperties = new MessageProperties(oldMessagePacket);
        }
        catch (JMSException e) {
            this.messageProperties = new MessageProperties();
        }
    }

    public Object clone() {
        try {
            if (this.messageProperties != null) {
                this.messagePacket.setMessageProperties(this.messageProperties.getPropertiesTable());
            }
            return new ObjectMessage((MessageRequest)this.messagePacket.clone());
        }
        catch (JMSException e) {
            logger.warningT(tracer, "clone", "Could not clone ObjectMessage due to " + e.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "clone", e);
            return null;
        }
    }

    public Serializable getObject() throws JMSException {
        return (Serializable)this.messagePacket.getMessageBody();
    }

    public void setObject(Serializable object) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.flushToBuffer(object);
    }

    public void flush() throws JMSException {
        this.flushToBuffer(null);
    }
}

