/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.message;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.protocol.message.MessageRequest;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public final class MessageProperties {
    private HashMapObjectObject properties;

    protected MessageProperties() {
        this.properties = new HashMapObjectObject();
    }

    protected MessageProperties(MessageRequest messagePacket) throws JMSException {
        if (messagePacket != null) {
            this.properties = messagePacket.getMessageProperties();
        }
        if (this.properties == null) {
            this.properties = new HashMapObjectObject();
        }
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof Boolean) {
                return (Boolean)property;
            }
            if (property instanceof String) {
                return Boolean.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return false;
    }

    public byte getByteProperty(String name) throws JMSException {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof Byte) {
                return (Byte)property;
            }
            if (property instanceof String) {
                return Byte.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        throw new NumberFormatException(ClientJMSResourceAccessor.formatString("JMS1033", null));
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof Double) {
                return (Double)property;
            }
            if (property instanceof Float) {
                return ((Float)property).floatValue();
            }
            if (property instanceof String) {
                return Double.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        throw new NullPointerException(ClientJMSResourceAccessor.formatString("JMS1033", null));
    }

    public float getFloatProperty(String name) throws JMSException {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof Float) {
                return ((Float)property).floatValue();
            }
            if (property instanceof String) {
                return Float.valueOf((String)property).floatValue();
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        throw new NullPointerException(ClientJMSResourceAccessor.formatString("JMS1033", null));
    }

    public int getIntProperty(String name) throws JMSException {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof Integer) {
                return (Integer)property;
            }
            if (property instanceof Byte) {
                return ((Byte)property).byteValue();
            }
            if (property instanceof Short) {
                return ((Short)property).shortValue();
            }
            if (property instanceof String) {
                return Integer.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        throw new NumberFormatException(ClientJMSResourceAccessor.formatString("JMS1033", null));
    }

    public long getLongProperty(String name) throws JMSException {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof Long) {
                return (Long)property;
            }
            if (property instanceof Integer) {
                return ((Integer)property).intValue();
            }
            if (property instanceof Byte) {
                return ((Byte)property).byteValue();
            }
            if (property instanceof Short) {
                return ((Short)property).shortValue();
            }
            if (property instanceof String) {
                return Long.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        throw new NumberFormatException(ClientJMSResourceAccessor.formatString("JMS1033", null));
    }

    public Object getObjectProperty(String name) {
        return this.properties.get(name);
    }

    public short getShortProperty(String name) throws JMSException {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof Short) {
                return (Short)property;
            }
            if (property instanceof Byte) {
                return ((Byte)property).byteValue();
            }
            if (property instanceof String) {
                return Short.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        throw new NumberFormatException(ClientJMSResourceAccessor.formatString("JMS1033", null));
    }

    public String getStringProperty(String name) {
        Object property = this.properties.get(name);
        if (property != null) {
            if (property instanceof String) {
                return (String)property;
            }
            if (property instanceof Integer) {
                return ((Integer)property).toString();
            }
            if (property instanceof Byte) {
                return ((Byte)property).toString();
            }
            if (property instanceof Short) {
                return ((Short)property).toString();
            }
            if (property instanceof Long) {
                return ((Long)property).toString();
            }
            if (property instanceof Boolean) {
                return ((Boolean)property).toString();
            }
            if (property instanceof Float) {
                return ((Float)property).toString();
            }
            if (property instanceof Double) {
                return ((Double)property).toString();
            }
            return null;
        }
        return null;
    }

    public Enumeration getPropertyNames() {
        return this.properties.keys();
    }

    public boolean propertyExists(String name) {
        return this.properties.containsKey(name);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.properties.put(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) {
        this.properties.put(name, new Byte(value));
    }

    public void setDoubleProperty(String name, double value) {
        this.properties.put(name, new Double(value));
    }

    public void setFloatProperty(String name, float value) {
        this.properties.put(name, new Float(value));
    }

    public void setIntProperty(String name, int value) {
        this.properties.put(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) {
        this.properties.put(name, new Long(value));
    }

    public void setObjectProperty(String name, Object value) throws MessageFormatException {
        if (!(value instanceof String || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Float || value instanceof Double)) {
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1034", null));
        }
        this.properties.put(name, value);
    }

    public void setShortProperty(String name, short value) {
        this.properties.put(name, new Short(value));
    }

    public void setStringProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Object clone() {
        MessageProperties cloning = new MessageProperties();
        cloning.properties = (HashMapObjectObject)this.properties.clone();
        return cloning;
    }

    public HashMapObjectObject getPropertiesTable() {
        return this.properties;
    }
}

