/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.message;

import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.destination.Destination;
import com.sap.jms.client.destination.Queue;
import com.sap.jms.client.destination.TemporaryQueue;
import com.sap.jms.client.destination.TemporaryTopic;
import com.sap.jms.client.destination.Topic;
import com.sap.jms.client.message.MessageFactory;
import com.sap.jms.client.message.MessageProperties;
import com.sap.jms.client.session.Session;
import com.sap.jms.protocol.Packet;
import com.sap.jms.protocol.message.MessageRequest;
import com.sap.jms.protocol.notification.DestinationNameRequest;
import com.sap.jms.protocol.notification.DestinationNameResponse;
import com.sap.jms.util.MessageID;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;

public class Message
implements javax.jms.Message,
Cloneable {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.message.Message");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    protected static final int R_MODE = 0;
    protected static final int W_MODE = 1;
    protected static final int RW_MODE = 2;
    private static final String PROPERTIES_ERROR_MESSAGE = ClientJMSResourceAccessor.formatString("JMS1032", null);
    private static final String NOT_SUPPORTED_ERROR_MESSAGE = ClientJMSResourceAccessor.formatString("JMS0003", null);
    protected int mode = 1;
    protected int sessionID = -1;
    protected boolean writeEnabledProperties = true;
    protected MessageRequest messagePacket = null;
    protected MessageProperties messageProperties = null;
    private Session session = null;
    protected long connectionID = 0L;

    protected Message() throws JMSException {
        this.messagePacket = new MessageRequest(6, 64, this.connectionID, this.sessionID);
        this.messageProperties = new MessageProperties();
    }

    protected Message(javax.jms.Message message) throws JMSException {
        this();
        this.copyPropertiesFrom(message);
    }

    protected Message(byte type) throws JMSException {
        this.messagePacket = new MessageRequest(type, 64, this.connectionID, this.sessionID);
        this.messageProperties = new MessageProperties();
    }

    protected Message(MessageRequest messagePacket) {
        this.messagePacket = messagePacket;
    }

    public void clearBody() throws JMSException {
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void acknowledge() throws JMSException {
        if (this.session != null && this.session.getAcknowledgeMode() == 2) {
            this.session.acknowledge(this.getJMSMessageID());
        }
    }

    public void reset() throws JMSException {
        this.mode = 0;
    }

    public void clearProperties() throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties();
        } else {
            this.messageProperties.clearProperties();
        }
        this.writeEnabledProperties = true;
    }

    public void setWriteEnabledProperties(boolean flag) {
        this.writeEnabledProperties = flag;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getByteProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getDoubleProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getFloatProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getIntProperty(name);
    }

    public long getLongProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getLongProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getObjectProperty(name);
    }

    public short getShortProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getShortProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getStringProperty(name);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.messagePacket.getJMSDeliveryMode();
    }

    private String resolveDestinationID(int id) throws JMSException {
        String name = null;
        if (id != 0 && (name = Destination.getNameForID(id)) == null) {
            Packet response = this.session.getConnection().sendPacket(new DestinationNameRequest(id));
            this.session.checkReceivedPacket(response, (byte)-102);
            name = ((DestinationNameResponse)response).getName();
            Destination.setIDNameMapping(id, name);
        }
        return name;
    }

    public javax.jms.Destination getJMSDestination() throws JMSException {
        Destination destination = null;
        int destinationID = this.messagePacket.getDestinationID();
        String name = this.resolveDestinationID(destinationID);
        if (name == null) {
            return null;
        }
        destination = this.messagePacket.isDestinationTopic() ? (this.messagePacket.isDestinationTemporary() ? new TemporaryTopic(name, destinationID, this.session.getConnection()) : new Topic(name, destinationID)) : (this.messagePacket.isDestinationTemporary() ? new TemporaryQueue(name, destinationID, this.session.getConnection()) : new Queue(name, destinationID));
        return destination;
    }

    public long getJMSExpiration() throws JMSException {
        return this.messagePacket.getJMSExpiration();
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.messagePacket.getJMSRedelivered();
    }

    public String getJMSMessageID() throws JMSException {
        return this.messagePacket.getJMSMessageID();
    }

    public int getJMSPriority() throws JMSException {
        return this.messagePacket.getJMSPriority();
    }

    public javax.jms.Destination getJMSReplyTo() throws JMSException {
        Destination destination = null;
        int destinationID = this.messagePacket.getJMSReplyToID();
        String name = this.resolveDestinationID(destinationID);
        if (name == null) {
            return null;
        }
        destination = this.messagePacket.isJMSReplyToTopic() ? (this.messagePacket.isJMSReplyToTemporary() ? new TemporaryTopic(name, destinationID, this.session.getConnection()) : new Topic(name, destinationID)) : (this.messagePacket.isJMSReplyToTemporary() ? new TemporaryQueue(name, destinationID, this.session.getConnection()) : new Queue(name, destinationID));
        return destination;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.messagePacket.getJMSTimestamp();
    }

    public String getJMSType() throws JMSException {
        return this.messagePacket.getJMSType();
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.messagePacket.getJMSCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        throw new UnsupportedOperationException(NOT_SUPPORTED_ERROR_MESSAGE);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.getPropertyNames();
    }

    public boolean propertyExists(String name) throws JMSException {
        if (this.messageProperties == null) {
            this.messageProperties = new MessageProperties(this.messagePacket);
        }
        return this.messageProperties.propertyExists(name);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        this.messageProperties.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        this.messageProperties.setByteProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        this.messageProperties.setDoubleProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        this.messageProperties.setFloatProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        this.messageProperties.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        this.messageProperties.setLongProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        if (value != null) {
            this.messageProperties.setObjectProperty(name, value);
        } else {
            logger.errorT(tracer, "Null object property for name : {0} was filtered and was not transmitted", new Object[]{name});
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        this.messageProperties.setShortProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (!this.writeEnabledProperties) {
            throw new MessageNotWriteableException(PROPERTIES_ERROR_MESSAGE);
        }
        if (value != null) {
            this.messageProperties.setStringProperty(name, value);
        } else {
            logger.errorT(tracer, "Null string property for name : {0} was filtered and was not transmitted", new Object[]{name});
        }
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (correlationID != null) {
            this.messagePacket.setJMSCorrelationID(correlationID);
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        throw new UnsupportedOperationException(NOT_SUPPORTED_ERROR_MESSAGE);
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.messagePacket.setJMSDeliveryMode(deliveryMode);
    }

    public void setJMSDestination(javax.jms.Destination destination) throws JMSException {
        if (destination != null && destination instanceof Destination) {
            this.messagePacket.setJMSDestinationID(((Destination)destination).getDestinationID());
            if (((Destination)destination).isTopic()) {
                this.messagePacket.setDestinationTopic(true);
            } else {
                this.messagePacket.setDestinationTopic(false);
            }
            if (((Destination)destination).isTemporary()) {
                this.messagePacket.setDestinationTemporary(true);
            } else {
                this.messagePacket.setDestinationTemporary(false);
            }
        }
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.messagePacket.setJMSExpiration(expiration);
    }

    public void setJMSMessageID(String messageID) throws JMSException {
        if (messageID == null) {
            return;
        }
        try {
            this.setJMSMessageID(MessageID.toBytes(messageID));
        }
        catch (Exception ex) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1031", null));
        }
    }

    public void setJMSMessageID(byte[] messageID) throws JMSException {
        if (messageID != null) {
            this.messagePacket.setJMSMessageIDAsBytes(messageID);
        }
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.messagePacket.setJMSPriority(priority);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.messagePacket.setJMSRedelivered(redelivered);
    }

    public void setJMSReplyTo(javax.jms.Destination replyTo) throws JMSException {
        if (replyTo != null && replyTo instanceof Destination) {
            this.messagePacket.setJMSReplyToID(((Destination)replyTo).getDestinationID());
            if (((Destination)replyTo).isTopic()) {
                this.messagePacket.setJMSReplyToTopic(true);
            } else {
                this.messagePacket.setJMSReplyToTopic(false);
            }
            if (((Destination)replyTo).isTemporary()) {
                this.messagePacket.setJMSReplyToTemporary(true);
            } else {
                this.messagePacket.setJMSReplyToTemporary(false);
            }
            Destination.setIDNameMapping(((Destination)replyTo).getDestinationID(), ((Destination)replyTo).getName());
        }
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.messagePacket.setJMSTimestamp(timestamp);
    }

    public void setJMSType(String type) throws JMSException {
        if (type != null) {
            this.messagePacket.setJMSType(type);
        }
    }

    protected void setMode(int mode) {
        this.mode = mode;
    }

    public static Message convertMessage(javax.jms.Message message) throws JMSException {
        return MessageFactory.getFactory().convertMessage(message);
    }

    public void copyPropertiesFrom(javax.jms.Message message) throws JMSException {
        Enumeration e = message.getPropertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.setObjectProperty(key, message.getObjectProperty(key));
        }
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSDeliveryMode(message.getJMSDeliveryMode());
        this.setJMSDestination(message.getJMSDestination());
        this.setJMSExpiration(message.getJMSExpiration());
        if (message instanceof Message) {
            this.setJMSMessageID(message.getJMSMessageID());
        }
        this.setJMSPriority(message.getJMSPriority());
        this.setJMSRedelivered(message.getJMSRedelivered());
        this.setJMSReplyTo(message.getJMSReplyTo());
        this.setJMSTimestamp(message.getJMSTimestamp());
        this.setJMSType(message.getJMSType());
    }

    public MessageRequest getMessagePacket() {
        return this.messagePacket;
    }

    protected void flushToBuffer(Object body) throws JMSException {
        if (this.messageProperties != null) {
            this.messagePacket.setMessageProperties(this.messageProperties.getPropertiesTable());
        }
        if (body != null) {
            this.messagePacket.setMessageBody(body);
        }
        this.messagePacket.flush();
    }

    protected void flushToBuffer(byte[] body, int length) throws JMSException {
        if (this.messageProperties != null) {
            this.messagePacket.setMessageProperties(this.messageProperties.getPropertiesTable());
        }
        if (body != null) {
            this.messagePacket.setMessageBody(body, length);
        }
        this.messagePacket.flush();
    }

    public void flush() throws JMSException {
        this.flushToBuffer(null);
    }
}

