/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.message;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.message.Message;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.message.MessageRequest;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public final class MapMessage
extends Message
implements javax.jms.MapMessage {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.message.MapMessage");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private HashMapObjectObject body = null;
    private int sizeInBytes = 0;

    public MapMessage() throws JMSException {
        super((byte)4);
        this.body = new HashMapObjectObject();
        this.setMode(2);
    }

    public MapMessage(javax.jms.MapMessage alien) throws JMSException {
        super((byte)4);
        this.body = new HashMapObjectObject();
        this.setMode(2);
        this.copyPropertiesFrom((javax.jms.Message)alien);
        this.copyBodyPropertiesFrom(alien);
    }

    public MapMessage(MessageRequest messagePacket) {
        super(messagePacket);
    }

    public void clearBody() throws JMSException {
        this.setMode(2);
        this.messagePacket.setMessageBody(null);
        if (this.body != null) {
            this.body.clear();
        } else {
            this.body = new HashMapObjectObject();
        }
    }

    public Object clone() {
        try {
            if (this.body != null) {
                this.messagePacket.setMessageBodyAndType(this.body, (byte)4);
            }
            if (this.messageProperties != null) {
                this.messagePacket.setMessageProperties(this.messageProperties.getPropertiesTable());
            }
            return new MapMessage((MessageRequest)this.messagePacket.clone());
        }
        catch (JMSException e) {
            logger.warningT(tracer, "clone", "Could not clone MapMessage due to " + e.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "clone", e);
            return null;
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Boolean) {
                return (Boolean)property;
            }
            if (property instanceof String) {
                return Boolean.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return Boolean.valueOf(null);
    }

    public byte getByte(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Byte) {
                return (Byte)property;
            }
            if (property instanceof String) {
                return Byte.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return Byte.valueOf(null);
    }

    public byte[] getBytes(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof byte[]) {
                return (byte[])property;
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return null;
    }

    public char getChar(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Character) {
                return ((Character)property).charValue();
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        throw new NullPointerException(ClientJMSResourceAccessor.formatString("JMS0004", null));
    }

    public double getDouble(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Double) {
                return (Double)property;
            }
            if (property instanceof Float) {
                return ((Float)property).floatValue();
            }
            if (property instanceof String) {
                return Double.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return Double.valueOf(null);
    }

    public float getFloat(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Float) {
                return ((Float)property).floatValue();
            }
            if (property instanceof String) {
                return Float.valueOf((String)property).floatValue();
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return Float.valueOf(null).floatValue();
    }

    public int getInt(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Integer) {
                return (Integer)property;
            }
            if (property instanceof Byte) {
                return ((Byte)property).byteValue();
            }
            if (property instanceof Short) {
                return ((Short)property).shortValue();
            }
            if (property instanceof String) {
                return Integer.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return Integer.valueOf(null);
    }

    public long getLong(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Long) {
                return (Long)property;
            }
            if (property instanceof Integer) {
                return ((Integer)property).intValue();
            }
            if (property instanceof Byte) {
                return ((Byte)property).byteValue();
            }
            if (property instanceof Short) {
                return ((Short)property).shortValue();
            }
            if (property instanceof String) {
                return Long.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return Long.valueOf(null);
    }

    public Enumeration getMapNames() throws JMSException {
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        return this.body.keys();
    }

    public Object getObject(String name) throws JMSException {
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        return this.body.get(name);
    }

    public short getShort(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof Short) {
                return (Short)property;
            }
            if (property instanceof Byte) {
                return ((Byte)property).byteValue();
            }
            if (property instanceof String) {
                return Short.valueOf((String)property);
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return Short.valueOf(null);
    }

    public String getString(String name) throws JMSException {
        Object property;
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        if ((property = this.body.get(name)) != null) {
            if (property instanceof String) {
                return (String)property;
            }
            if (property instanceof Integer) {
                return ((Integer)property).toString();
            }
            if (property instanceof Byte) {
                return ((Byte)property).toString();
            }
            if (property instanceof Short) {
                return ((Short)property).toString();
            }
            if (property instanceof Long) {
                return ((Long)property).toString();
            }
            if (property instanceof Boolean) {
                return ((Boolean)property).toString();
            }
            if (property instanceof Float) {
                return ((Float)property).toString();
            }
            if (property instanceof Double) {
                return ((Double)property).toString();
            }
            if (property instanceof Character) {
                return ((Character)property).toString();
            }
            throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1030", null));
        }
        return null;
    }

    public boolean itemExists(String name) throws JMSException {
        if (this.body == null) {
            this.body = (HashMapObjectObject)this.messagePacket.getMessageBody();
        }
        return this.body.containsKey(name);
    }

    public void setBoolean(String name, boolean value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 2;
        this.body.put(name, new Boolean(value));
    }

    public void setByte(String name, byte value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 2;
        this.body.put(name, new Byte(value));
    }

    public void setBytes(String name, byte[] value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (value != null) {
            this.sizeInBytes += PacketImpl.strlenUTF8(name);
            this.sizeInBytes += value.length + 5;
            this.body.put(name, value);
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (value != null) {
            byte[] temp = new byte[length];
            System.arraycopy(value, offset, temp, 0, length);
            this.sizeInBytes += PacketImpl.strlenUTF8(name);
            this.sizeInBytes += value.length + 5;
            this.body.put(name, temp);
        }
    }

    public void setChar(String name, char value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 3;
        this.body.put(name, new Character(value));
    }

    public void setDouble(String name, double value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 9;
        this.body.put(name, new Double(value));
    }

    public void setFloat(String name, float value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 5;
        this.body.put(name, new Float(value));
    }

    public void setInt(String name, int value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 5;
        this.body.put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 9;
        this.body.put(name, new Long(value));
    }

    public void setObject(String name, Object obj) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (obj == null) {
            logger.errorT(tracer, "Null object for name : {0} was filtered and was not transmitted", new Object[]{name});
            return;
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        if (obj instanceof Boolean) {
            this.sizeInBytes += 2;
        } else if (obj instanceof Byte) {
            this.sizeInBytes += 2;
        } else if (obj instanceof byte[]) {
            byte[] temp = (byte[])obj;
            this.sizeInBytes += temp.length + 5;
        } else if (obj instanceof Character) {
            this.sizeInBytes += 3;
        } else if (obj instanceof Double) {
            this.sizeInBytes += 9;
        } else if (obj instanceof Float) {
            this.sizeInBytes += 5;
        } else if (obj instanceof Integer) {
            this.sizeInBytes += 5;
        } else if (obj instanceof Long) {
            this.sizeInBytes += 9;
        } else if (obj instanceof Short) {
            this.sizeInBytes += 3;
        } else if (obj instanceof String) {
            String string = (String)obj;
            this.sizeInBytes += PacketImpl.strlenUTF8(string) + 1;
        } else {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1036", null));
        }
        this.body.put(name, obj);
    }

    public void setShort(String name, short value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        this.sizeInBytes += PacketImpl.strlenUTF8(name);
        this.sizeInBytes += 3;
        this.body.put(name, new Short(value));
    }

    public void setString(String name, String value) throws MessageNotWriteableException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (value != null) {
            this.body.put(name, value);
            this.sizeInBytes += PacketImpl.strlenUTF8(name);
            this.sizeInBytes += PacketImpl.strlenUTF8(value) + 1;
        } else {
            logger.errorT(tracer, "Null string for name : {0} was filtered and was not transmitted", new Object[]{name});
        }
    }

    private void copyBodyPropertiesFrom(javax.jms.MapMessage alien) throws JMSException {
        Enumeration enumeration = null;
        try {
            enumeration = alien.getMapNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                this.setObject(name, alien.getObject(name));
            }
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Unable to copy the alien properties.");
            jmse.setLinkedException(e);
            throw jmse;
        }
    }

    public void flush() throws JMSException {
        this.flushToBuffer(this.body);
    }
}

