/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.message;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.util.ArrayByte;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.message.Message;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.message.MessageRequest;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public final class BytesMessage
extends Message
implements javax.jms.BytesMessage {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.message.BytesMessage");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private static final int STEP = 512;
    private int index;
    private int endIndex;
    private byte[] body = null;

    public BytesMessage() throws JMSException {
        super((byte)1);
        this.setMode(1);
        this.body = new byte[512];
        this.index = 0;
        this.endIndex = 0;
    }

    public BytesMessage(MessageRequest messagePacket) throws JMSException {
        super(messagePacket);
    }

    public BytesMessage(javax.jms.BytesMessage message) throws JMSException {
        super((byte)1);
        this.clearBody();
        ArrayByte bodyBytes = new ArrayByte();
        this.copyPropertiesFrom((javax.jms.Message)message);
        try {
            message.reset();
            while (true) {
                bodyBytes.addElement(message.readByte());
            }
        }
        catch (Exception e) {
            message.clearBody();
            this.body = bodyBytes.toArray();
            this.setMode(0);
            message.writeBytes(this.body);
            this.setMode(1);
            this.index = 0;
            this.endIndex = this.body.length;
            return;
        }
    }

    public Object clone() {
        try {
            if (this.body != null) {
                this.messagePacket.setMessageBodyAndType(this.body, this.endIndex, (byte)1);
            }
            if (this.messageProperties != null) {
                this.messagePacket.setMessageProperties(this.messageProperties.getPropertiesTable());
            }
            return new BytesMessage((MessageRequest)this.messagePacket.clone());
        }
        catch (JMSException e) {
            logger.warningT(tracer, "clone", "Could not clone BytesMessage due to " + e.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "clone", e);
            return null;
        }
    }

    public void clearBody() throws JMSException {
        this.body = new byte[512];
        this.index = 0;
        this.endIndex = 0;
        this.setMode(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readBoolean() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        boolean b = false;
        if (this.body == null) {
            byte temp = 0;
            try {
                temp = this.messagePacket.readByte();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            if (temp == 0) {
                return false;
            }
            if (temp != 1) throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1025", null));
            return true;
        }
        if (this.index >= this.endIndex) throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        if (this.body[this.index] == 0) {
            b = false;
        } else {
            if (this.body[this.index] != 1) throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1025", null));
            b = true;
        }
        ++this.index;
        return b;
    }

    public byte readByte() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        byte b = -1;
        if (this.body == null) {
            try {
                b = this.messagePacket.readByte();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else if (this.index < this.endIndex) {
            b = this.body[this.index];
            ++this.index;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return b;
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readBytes(byte[] value, int length) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        if (length < 0 || length > value.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int temp = 0;
        int pos = this.messagePacket.getPosition();
        if (this.body == null) {
            temp = this.messagePacket.getCapacity() - pos;
            this.messagePacket.setPosition(pos);
            if (temp <= 0) return -1;
            if (length <= temp) {
                temp = length;
            }
            try {
                int i = 0;
                while (i < temp) {
                    value[i] = this.messagePacket.readByte();
                    ++i;
                }
                return temp;
            }
            catch (BufferUnderflowException bue) {
                this.messagePacket.setPosition(pos);
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else {
            temp = this.endIndex - this.index;
            if (this.index >= this.endIndex) return -1;
            if (length <= temp) {
                temp = length;
            }
            System.arraycopy(this.body, this.index, value, 0, temp);
            this.index += temp;
        }
        return temp;
    }

    public char readChar() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        int b = -1;
        if (this.body == null) {
            try {
                b = this.messagePacket.readChar();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else if (this.index < this.endIndex + 1) {
            b = (int)(this.unsigned(this.body[this.index]) * 256L + this.unsigned(this.body[this.index + 1]));
            this.index += 2;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return (char)b;
    }

    public double readDouble() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        if (this.body == null) {
            try {
                return this.messagePacket.readDouble();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        }
        long b = -1L;
        if (this.index < this.endIndex + 7) {
            b = this.unsigned(this.body[this.index]) << 56;
            b += this.unsigned(this.body[this.index + 1]) << 48;
            b += this.unsigned(this.body[this.index + 2]) << 40;
            b += this.unsigned(this.body[this.index + 3]) << 32;
            b += this.unsigned(this.body[this.index + 4]) << 24;
            b += this.unsigned(this.body[this.index + 5]) << 16;
            b += this.unsigned(this.body[this.index + 6]) << 8;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        this.index += 8;
        return Double.longBitsToDouble(b += this.unsigned(this.body[this.index + 7]));
    }

    public float readFloat() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        if (this.body == null) {
            try {
                return this.messagePacket.readFloat();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        }
        int b = -1;
        if (this.index < this.endIndex + 3) {
            b = (int)(this.unsigned(this.body[this.index]) << 24);
            b += (int)(this.unsigned(this.body[this.index + 1]) << 16);
            b += (int)(this.unsigned(this.body[this.index + 2]) << 8);
            this.index += 4;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return Float.intBitsToFloat(b += (int)this.unsigned(this.body[this.index + 3]));
    }

    public int readInt() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        int b = -1;
        if (this.body == null) {
            try {
                b = this.messagePacket.readInt();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else if (this.index < this.endIndex + 3) {
            b = (int)(this.unsigned(this.body[this.index]) << 24);
            b += (int)(this.unsigned(this.body[this.index + 1]) << 16);
            b += (int)(this.unsigned(this.body[this.index + 2]) << 8);
            b += (int)this.unsigned(this.body[this.index + 3]);
            this.index += 4;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return b;
    }

    public long readLong() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        long b = -1L;
        if (this.body == null) {
            try {
                b = this.messagePacket.readLong();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else {
            if (this.index < this.endIndex + 7) {
                b = this.unsigned(this.body[this.index]) << 56;
                b += this.unsigned(this.body[this.index + 1]) << 48;
                b += this.unsigned(this.body[this.index + 2]) << 40;
                b += this.unsigned(this.body[this.index + 3]) << 32;
                b += this.unsigned(this.body[this.index + 4]) << 24;
                b += this.unsigned(this.body[this.index + 5]) << 16;
                b += this.unsigned(this.body[this.index + 6]) << 8;
                b += this.unsigned(this.body[this.index + 7]);
            } else {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            this.index += 8;
        }
        return b;
    }

    public short readShort() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        short b = -1;
        if (this.body == null) {
            try {
                b = this.messagePacket.readShort();
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else if (this.index < this.endIndex + 1) {
            b = (short)(this.unsigned(this.body[this.index]) * 256L + this.unsigned(this.body[this.index + 1]));
            this.index += 2;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return b;
    }

    public int readUnsignedByte() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        int b = -1;
        if (this.body == null) {
            try {
                b = (int)this.unsigned(this.messagePacket.readByte());
            }
            catch (BufferUnderflowException bue) {
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else if (this.index < this.endIndex) {
            b = (int)this.unsigned(this.body[this.index]);
            ++this.index;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return b;
    }

    public int readUnsignedShort() throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotReadableException(ClientJMSResourceAccessor.formatString("JMS1026", null));
        }
        int b = -1;
        int pos = 0;
        if (this.body == null) {
            try {
                pos = this.messagePacket.getPosition();
                b = (int)this.unsigned((int)(this.unsigned(this.messagePacket.readByte()) * 256L + this.unsigned(this.messagePacket.readByte())));
            }
            catch (BufferUnderflowException bue) {
                this.messagePacket.setPosition(pos);
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        } else if (this.index < this.endIndex + 1) {
            b = (int)this.unsigned((int)(this.unsigned(this.body[this.index]) * 256L + this.unsigned(this.body[this.index + 1])));
            this.index += 2;
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return b;
    }

    public String readUTF() throws JMSException {
        StringBuffer b = new StringBuffer();
        int len = 0;
        int pos = 0;
        if (this.body == null) {
            pos = this.messagePacket.getPosition();
            byte[] temp = new byte[3];
            try {
                len = (this.readByte() & 0xFF) << 8;
                len |= this.readByte() & 0xFF;
            }
            catch (BufferUnderflowException bue) {
                this.messagePacket.setPosition(pos);
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
            try {
                int totalRead = 0;
                while (totalRead < len) {
                    temp[0] = this.messagePacket.readByte();
                    if ((temp[0] & 0x80) == 0) {
                        b.append((char)temp[0]);
                        ++totalRead;
                        continue;
                    }
                    temp[1] = this.messagePacket.readByte();
                    if ((temp[0] & 0x20) == 0) {
                        b.append((char)((temp[0] & 0x1F) << 6 & (temp[1] & 0xFF3F)));
                        totalRead += 2;
                        continue;
                    }
                    temp[2] = this.messagePacket.readByte();
                    b.append((char)((temp[0] & 0xF) << 12 & (temp[1] & 0xFF3F) << 6) & (temp[2] & 0xFF3F));
                    totalRead += 3;
                }
            }
            catch (BufferUnderflowException bue) {
                this.messagePacket.setPosition(pos - 4);
                throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
            }
        }
        if (this.index < this.endIndex + 4) {
            pos = this.index;
            len = Convert.byteArrToInt(this.body, this.index);
            this.index += 4;
            int i = 0;
            while (i < len) {
                if (this.index >= this.endIndex) {
                    this.index = pos;
                    throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                }
                if ((this.body[this.index] & 0x80) == 0) {
                    b.append(this.body[this.index++]);
                } else {
                    if (this.index + 1 >= this.endIndex) {
                        this.index = pos;
                        throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                    }
                    if ((this.body[this.index] & 0x20) == 0) {
                        b.append((char)((this.body[this.index] & 0x1F) << 6 & (this.body[this.index + 1] & 0xFF3F)));
                        this.index += 2;
                    } else {
                        if (this.index + 2 >= this.endIndex) {
                            this.index = pos;
                            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
                        }
                        b.append((char)((this.body[this.index] & 0xF) << 12 & (this.body[this.index + 1] & 0xFF3F) << 6) & (this.body[this.index + 2] & 0xFF3F));
                        this.index += 3;
                    }
                }
                ++i;
            }
        } else {
            throw new MessageEOFException(ClientJMSResourceAccessor.formatString("JMS1028", null));
        }
        return b.toString();
    }

    public void reset() throws JMSException {
        this.setMode(0);
        if (this.body == null) {
            this.messagePacket.setPosition(this.messagePacket.getMessageBodyOffset() - 14 + 4);
        } else {
            this.index = 0;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        try {
            if (this.endIndex != this.body.length) {
                this.body[this.endIndex] = value ? (byte)1 : 0;
            } else {
                this.increaseBody();
                this.body[this.endIndex] = value ? (byte)1 : 0;
            }
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1029", null));
        }
        ++this.endIndex;
    }

    public void writeByte(byte value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        try {
            if (this.endIndex != this.body.length) {
                this.body[this.endIndex++] = value;
            } else {
                byte[] b = new byte[this.body.length + 512];
                System.arraycopy(this.body, 0, b, 0, this.body.length);
                b[this.endIndex++] = value;
                this.body = b;
            }
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1029", null));
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        if (value == null) {
            throw new NullPointerException(ClientJMSResourceAccessor.formatString("JMS0004", null));
        }
        try {
            if (this.body.length - this.endIndex < value.length) {
                byte[] b = new byte[this.body.length + value.length];
                System.arraycopy(this.body, 0, b, 0, this.endIndex);
                System.arraycopy(value, 0, b, this.endIndex, value.length);
                this.body = b;
            } else {
                System.arraycopy(value, 0, this.body, this.endIndex, value.length);
            }
            this.endIndex += value.length;
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1029", null));
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        int size = length < value.length - offset ? length : value.length - offset;
        byte[] temp = new byte[size];
        System.arraycopy(value, offset, temp, 0, size);
        this.writeBytes(temp);
    }

    public void writeChar(char value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        try {
            if (this.body.length - this.endIndex < 2) {
                this.increaseBody();
            }
            this.body[this.endIndex] = (byte)(value / 256);
            this.body[this.endIndex + 1] = (byte)(value % 256);
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1029", null));
        }
        this.endIndex += 2;
    }

    public void writeDouble(double value) throws JMSException {
        long longValue = Double.doubleToLongBits(value);
        this.internalWrite(longValue, 8);
    }

    public void writeFloat(float value) throws JMSException {
        int intValue = Float.floatToIntBits(value);
        this.internalWrite(intValue, 4);
    }

    public void writeInt(int value) throws JMSException {
        this.internalWrite(value, 4);
    }

    public void writeLong(long value) throws JMSException {
        this.internalWrite(value, 8);
    }

    public void writeObject(Object obj) throws JMSException {
        if (obj == null) {
            throw new NullPointerException(ClientJMSResourceAccessor.formatString("JMS0004", null));
        }
        if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj);
        } else if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
        } else if (obj instanceof Character) {
            this.writeChar(((Character)obj).charValue());
        } else if (obj instanceof Double) {
            this.writeDouble((Double)obj);
        } else if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
        } else if (obj instanceof Long) {
            this.writeLong((Long)obj);
        } else if (obj instanceof Short) {
            this.writeShort((Short)obj);
        } else if (obj instanceof String) {
            this.writeUTF((String)obj);
        } else {
            try {
                byte[] b = (byte[])obj;
                this.writeBytes(b);
            }
            catch (ClassCastException cce) {
                throw new MessageFormatException(ClientJMSResourceAccessor.formatString("JMS1034", null));
            }
        }
    }

    public void writeShort(short value) throws JMSException {
        this.internalWrite(value, 2);
    }

    public void writeUTF(String value) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        int len = value.length();
        try {
            if (this.endIndex + 2 + len * 3 > this.body.length) {
                byte[] b = new byte[this.body.length + 4 + len * 3 + 512];
                System.arraycopy(this.body, 0, b, 0, this.endIndex);
                this.body = b;
            }
            int start = this.endIndex;
            this.endIndex += 2;
            int UTFSize = 0;
            int i = 0;
            while (i < len) {
                int currentLetter = value.charAt(i) & 0xFFFF;
                int n = (0xF800 & currentLetter) == 0 ? ((0x780 & currentLetter) == 0 ? 1 : 2) : (UTFSize = 3);
                if (UTFSize == 1) {
                    this.body[this.endIndex++] = (byte)currentLetter;
                } else if (UTFSize == 2) {
                    this.body[this.endIndex + 1] = (byte)(0x80 & (0x3F & currentLetter));
                    this.body[this.endIndex] = (byte)(0xC0 & (0x1F & currentLetter >>> 6));
                    this.endIndex += 2;
                } else {
                    this.body[this.endIndex + 2] = (byte)(0x80 & (0x3F & currentLetter));
                    this.body[this.endIndex + 1] = (byte)(0x80 & (0x3F & currentLetter >>> 6));
                    this.body[this.endIndex] = (byte)(0xE0 & (0xF & currentLetter >>> 12));
                }
                ++i;
            }
            this.body[start] = (byte)(0xFF & this.endIndex - start - 2 >> 8);
            this.body[start + 1] = (byte)(0xFF & this.endIndex - start - 2);
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1029", null));
        }
    }

    private long unsigned(byte signed) {
        return signed < 0 ? (long)signed + 256L : (long)signed;
    }

    private long unsigned(int signed) {
        return signed < 0 ? (long)signed + 65536L : (long)signed;
    }

    private void internalWrite(long longValue, int numBytes) throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotWriteableException(ClientJMSResourceAccessor.formatString("JMS1027", null));
        }
        try {
            if (this.body.length - this.endIndex < numBytes) {
                this.increaseBody();
            }
            int j = numBytes - 1;
            while (j > -1) {
                this.body[this.endIndex + j] = (byte)longValue;
                longValue >>>= 8;
                --j;
            }
        }
        catch (Exception e) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1029", null));
        }
        this.endIndex += numBytes;
    }

    private void increaseBody() {
        byte[] temp = new byte[this.body.length + 512];
        System.arraycopy(this.body, 0, temp, 0, this.endIndex);
        this.body = temp;
    }

    public long getBodyLength() throws JMSException {
        if (this.body == null) {
            return this.messagePacket.getMessageBodySize();
        }
        return this.endIndex;
    }

    public void flush() throws JMSException {
        this.flushToBuffer(this.body, this.endIndex);
    }
}

