/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.memory;

import com.sap.engine.lib.util.HashMapLongInt;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.server.JMSServerContainer;
import com.sap.jms.server.ServerComponentAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.jms.JMSException;

public class MemoryManager {
    private static MemoryManager manager = null;
    private static final Object sync = new Object();
    private static final int DEFAULT_MEMORY_SIZE = 0x1400000;
    private static final int DEFAULT_CHUNK_SIZE = 102400;
    private static final String PROPERTIES_FILE = "jms_client.properties";
    private static final String CONSUMER_BUFFER_SIZE = "clientConsumerBuffer";
    private static final String MEM_SIZE = "clientMemorySize";
    private static final char PROPS_SEPARATOR = '=';
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.memoryMemoryManager");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private HashMapLongInt bigMessagesAllocation = new HashMapLongInt();
    private int memoryAllocated = 0;
    private int memorySize = 0x1400000;
    private int chunkSize = 102400;
    private Object allocationSync = new Object();
    private int bigMesssageAllocations = 0;

    private MemoryManager() {
        this.getProperties();
    }

    public static MemoryManager getMemoryManager() {
        if (manager != null) {
            return manager;
        }
        Object object = sync;
        synchronized (object) {
            if (manager == null) {
                manager = new MemoryManager();
            }
        }
        return manager;
    }

    public void registerNewConsumer() throws JMSException {
        Object object = this.allocationSync;
        synchronized (object) {
            if (!this.allocate(this.chunkSize)) {
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1045", null));
            }
        }
    }

    public void unregisterConsumer() {
        Object object = this.allocationSync;
        synchronized (object) {
            this.deallocate(this.chunkSize);
        }
    }

    public void allocateMemoryForBigMessage(long consumerID, int sizeOfMessage) throws JMSException {
        Object object = this.allocationSync;
        synchronized (object) {
            int allocSize = sizeOfMessage - this.chunkSize;
            this.bigMessagesAllocation.put(consumerID, allocSize);
            if (!this.allocate(allocSize)) {
                this.bigMessagesAllocation.remove(consumerID);
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1045", null));
            }
        }
    }

    public void deallocateMemoryForBigMessage(long consumerID) {
        Object object = this.allocationSync;
        synchronized (object) {
            int deallocSize = 0;
            try {
                deallocSize = this.bigMessagesAllocation.get(consumerID);
            }
            catch (NoSuchElementException nse) {
                return;
            }
            this.deallocate(deallocSize);
            this.bigMessagesAllocation.remove(consumerID);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean allocate(int size) {
        free = this.memorySize - this.memoryAllocated;
        if (free >= size) {
            this.memoryAllocated += size;
            if (size > this.chunkSize) {
                ++this.bigMesssageAllocations;
            }
            return true;
        }
        if (this.bigMesssageAllocations != 0) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                this.allocationSync.wait();
            }
            catch (InterruptedException ie) {
                MemoryManager.logger.infoT(MemoryManager.tracer, "allocate", " InterruptedException caught : " + ie.getMessage());
                return false;
            }
            free = this.memorySize - this.memoryAllocated;
lbl17:
            // 2 sources

            ** while (free < size && this.bigMesssageAllocations > 0)
        }
lbl18:
        // 1 sources

        if (free < size) {
            return false;
        }
        this.memoryAllocated += size;
        if (size > this.chunkSize) {
            ++this.bigMesssageAllocations;
        }
        return true;
    }

    public void deallocate(int size) {
        this.memoryAllocated -= size;
        if (size > this.chunkSize) {
            --this.bigMesssageAllocations;
        }
        this.allocationSync.notifyAll();
    }

    private void getProperties() {
        try {
            if (ServerComponentAccessor.container != null) {
                Properties props = ((JMSServerContainer)ServerComponentAccessor.container).getFrame().getEnvironment().getServiceState().getProperties();
                this.chunkSize = Integer.parseInt((String)((Hashtable)props).get(CONSUMER_BUFFER_SIZE));
                this.memorySize = Integer.parseInt((String)((Hashtable)props).get(MEM_SIZE));
            } else {
                String line = null;
                String property = null;
                int separatorPos = 0;
                File file = new File(System.getProperty("user.home") + "/" + PROPERTIES_FILE);
                if (!file.isFile()) {
                    logger.infoT(tracer, "getProperties", "No JMS client properties file found in the user home directory! JMS memory manager will be initialized with its default values!");
                    return;
                }
                FileReader input = new FileReader(file);
                BufferedReader reader = new BufferedReader(input);
                line = reader.readLine();
                while (line != null) {
                    separatorPos = line.indexOf(61);
                    if (separatorPos > 0) {
                        property = line.substring(0, separatorPos);
                        if (property.equals(CONSUMER_BUFFER_SIZE)) {
                            this.chunkSize = Integer.parseInt(line.substring(separatorPos + 1));
                        } else if (property.equals(MEM_SIZE)) {
                            this.memorySize = Integer.parseInt(line.substring(separatorPos + 1));
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
                input.close();
            }
        }
        catch (Exception e) {
            this.chunkSize = 102400;
            this.memorySize = 0x1400000;
            tracer.throwing("getProperties", (Throwable)e);
            logger.warningT(tracer, "An error has occured while reading the JMS client properties! JMS memory manager will be initialized with its default values! See trace file for more details!");
            return;
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }
}

