/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.destination;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.jms.client.TextFormatter;
import java.io.Serializable;

public class Destination
implements javax.jms.Destination,
Serializable {
    static final long serialVersionUID = -1215450645697662945L;
    private static final HashMapIntObject map = new HashMapIntObject();
    protected String name = null;
    protected String instanceName = null;
    protected int destinationID = 0;
    protected boolean isQueue;
    protected boolean isTemporary = false;

    protected Destination(String name, int destinationID) {
        this.destinationID = destinationID;
        this.name = name;
    }

    public static final String getNameForID(int destinationID) {
        HashMapIntObject hashMapIntObject = map;
        synchronized (hashMapIntObject) {
            String string = (String)map.get(destinationID);
            return string;
        }
    }

    public static final void setIDNameMapping(int destinationID, String name) {
        HashMapIntObject hashMapIntObject = map;
        synchronized (hashMapIntObject) {
            if (!map.containsKey(destinationID)) {
                map.put(destinationID, name);
            }
        }
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getDestinationID() {
        return this.destinationID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isQueue() {
        return this.isQueue;
    }

    public boolean isTemporaryQueue() {
        return this.isQueue && this.isTemporary;
    }

    public boolean isTopic() {
        return !this.isQueue;
    }

    public boolean isTemporaryTopic() {
        return !this.isQueue && this.isTemporary;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean equals(Object ob) {
        return ob instanceof Destination && ((Destination)ob).destinationID == this.destinationID;
    }

    public int hashCode() {
        return this.destinationID;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TextFormatter.header(buffer, "Destination");
        TextFormatter.addColumn(buffer, "Type", 30, 0);
        if (this.isQueue()) {
            TextFormatter.addColumn(buffer, "Queue", 0);
        } else if (this.isTopic()) {
            TextFormatter.addColumn(buffer, "Topic", 0);
        } else if (this.isTemporaryQueue()) {
            TextFormatter.addColumn(buffer, "TemporaryQueue", 0);
        } else {
            TextFormatter.addColumn(buffer, "TemporaryTopic", 0);
        }
        TextFormatter.addColumn(buffer, "Name", 30, 0);
        if (this.name == null) {
            TextFormatter.addColumn(buffer, "null", 0);
        } else {
            TextFormatter.addColumn(buffer, this.name, 0);
        }
        TextFormatter.addColumn(buffer, "ID", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.destinationID, 0);
        TextFormatter.footer(buffer);
        return buffer.toString();
    }
}

