/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.connection;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.TextFormatter;
import com.sap.jms.client.Util;
import com.sap.jms.client.connection.Connection;
import com.sap.jms.client.connection.NetworkAdapter;
import com.sap.jms.client.session.ThreadPool;
import com.sap.jms.protocol.Packet;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.jms.JMSException;

public class SocketWrapper
implements NetworkAdapter {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.connection.SocketWrapper");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private ThreadSystem pool = null;
    private static int instanceCount = 0;
    private Socket socket = null;
    private BufferedInputStream input = null;
    private BufferedOutputStream output = null;
    private WeakReference connection = null;
    private ConcurrentHashMapLongObject waitTable = null;
    private boolean runFlag = true;
    private boolean isRunning = true;
    private String host = null;
    private int port = 0;
    private boolean isClosed = false;
    private long waitID = Long.MIN_VALUE;
    private Object destroySocketLock = new Object();
    private Exception closeException = null;
    private long connectionID = 0L;
    private byte[] packet_length_buffer;

    public SocketWrapper(String host, int port) throws UnknownHostException, IOException {
        this.socket = new Socket(host, port);
        this.input = new BufferedInputStream(this.socket.getInputStream());
        this.output = new BufferedOutputStream(this.socket.getOutputStream());
        this.waitTable = new ConcurrentHashMapLongObject();
        this.host = host;
        this.port = port;
        this.packet_length_buffer = Util.PACKET_FACTORY.getMemoryAllocator().malloc(4);
        SocketWrapper socketWrapper = this;
        synchronized (socketWrapper) {
            ++instanceCount;
        }
    }

    public Packet sendAndWait(Packet packet) throws IOException, JMSException {
        long waitID;
        tracer.entering("sendAndWait");
        this.checkIfClosed();
        SocketWrapper socketWrapper = this;
        synchronized (socketWrapper) {
            waitID = ++this.waitID;
        }
        packet.setRequestID(waitID);
        Object waitLock = new Object();
        Packet response = null;
        Object object = waitLock;
        synchronized (object) {
            tracer.debugT("sendAndWait", this.connectionID + ":Send message and wait for answer. WaitID: " + waitID);
            this.waitTable.put(waitID, waitLock);
            this.send(packet);
            while (waitLock.equals(this.waitTable.get(waitID))) {
                try {
                    waitLock.wait();
                    tracer.debugT("sendAndWait", this.connectionID + ":Response received. WaitID: " + waitID);
                }
                catch (InterruptedException e) {
                    tracer.throwing("sendAndWait", (Throwable)e);
                    logger.warningT(tracer, this.connectionID + ":Thread interrupted during sendAndWait");
                }
            }
            response = (Packet)this.waitTable.get(waitID);
            this.waitTable.remove(waitID);
        }
        tracer.exiting();
        return response;
    }

    public void send(Packet packet) throws IOException, JMSException {
        tracer.entering("send");
        this.checkIfClosed();
        this.output.write(packet.getBuffer(), packet.getOffset(), packet.getLength());
        this.output.flush();
        if (tracer.beDebug()) {
            tracer.debugT("send", this.connectionID + ":Message sent.\n{0}", new Object[]{packet});
        }
        tracer.exiting();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        requestID = 0L;
        waitLock = null;
        ref = null;
        try {
            while (this.runFlag) {
                SocketWrapper.tracer.debugT(this.connectionID + ":Begin receive of new message!");
                packet = Util.PACKET_FACTORY.createPacket(this.input, this.packet_length_buffer);
                requestID = packet.getRequestID();
                if (SocketWrapper.tracer.beDebug()) {
                    SocketWrapper.tracer.debugT(this.connectionID + ":Received packet:\n{0}", new Object[]{packet});
                }
                if (this.waitTable.containsKey(requestID)) {
                    var6_6 = waitLock = this.waitTable.get(requestID);
                    synchronized (var6_6) {
                        this.waitTable.put(requestID, packet);
                        waitLock.notify();
                        continue;
                    }
                }
                if (this.connection == null) {
                    SocketWrapper.tracer.debugT("JMS message received before the connection has been fully initialized! All other activity will be suspended!");
                    throw new JMSException(ClientJMSResourceAccessor.formatString("JMS0001", null));
                }
                ref = this.connection.get();
                if (ref != null) {
                    ((Connection)ref).onPacketReceived(packet);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.closeException = e;
            if (this.isClosed) {
                var9_10 = null;
                var10_14 = this.destroySocketLock;
                synchronized (var10_14) {
                    this.isRunning = false;
                    this.destroySocketLock.notify();
                }
                try {
                    this.close();
                    return;
                }
                catch (IOException ioe) {
                    SocketWrapper.logger.warningT(SocketWrapper.tracer, "run", "IOException occured while closing JMS client socket! See trace file for more details!");
                    SocketWrapper.tracer.throwing((Throwable)ioe);
                }
                return;
            }
            if (SocketWrapper.tracer.beError()) {
                SocketWrapper.tracer.errorT("run", Util.getStackTrace(e));
            }
            SocketWrapper.logger.addLog((Log)new ConsoleLog());
            SocketWrapper.logger.setEffectiveSeverity(700);
            SocketWrapper.logger.fatalT(SocketWrapper.tracer, "JMS internal error at socket receive! See trace file for more details!");
            try {
                ref = null;
                if (this.connection != null) {
                    ref = this.connection.get();
                }
                if (ref != null && this.runFlag && !((Connection)ref).isClosed()) {
                    ((Connection)ref).setAdapterClosed();
                    jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS0001", null));
                    jmse.setLinkedException(e);
                    SocketWrapper.tracer.throwing((Throwable)jmse);
                    ((Connection)ref).onException(jmse);
                }
            }
            catch (Exception jmse) {
                SocketWrapper.tracer.throwing(SocketWrapper.logger, "Exception while dispatching an error to a jms connection ExceptionListener", (Throwable)jmse);
            }
            var9_11 = null;
            var10_15 = this.destroySocketLock;
            synchronized (var10_15) {
                this.isRunning = false;
                this.destroySocketLock.notify();
            }
            try {}
            catch (IOException ioe) {
                SocketWrapper.logger.warningT(SocketWrapper.tracer, "run", "IOException occured while closing JMS client socket! See trace file for more details!");
                SocketWrapper.tracer.throwing((Throwable)ioe);
                return;
            }
            this.close();
            return;
        }
        var9_9 = null;
        var10_13 = this.destroySocketLock;
        ** GOTO lbl106
        {
            catch (Throwable var8_21) {
                var9_12 = null;
                var10_16 = this.destroySocketLock;
                synchronized (var10_16) {
                    this.isRunning = false;
                    this.destroySocketLock.notify();
                }
                ** try [egrp 5[TRYBLOCK] [5 : 471->478)] { 
lbl98:
                // 1 sources

                this.close();
                throw var8_21;
lbl100:
                // 1 sources

                catch (IOException ioe) {
                    SocketWrapper.logger.warningT(SocketWrapper.tracer, "run", "IOException occured while closing JMS client socket! See trace file for more details!");
                    SocketWrapper.tracer.throwing((Throwable)ioe);
                }
                throw var8_21;
            }
lbl106:
            // 1 sources

            synchronized (var10_13) {
                this.isRunning = false;
                this.destroySocketLock.notify();
            }
            try {}
            catch (IOException ioe) {}
            SocketWrapper.logger.warningT(SocketWrapper.tracer, "run", "IOException occured while closing JMS client socket! See trace file for more details!");
            SocketWrapper.tracer.throwing((Throwable)ioe);
            return;
            this.close();
            return;
        }
    }

    public void setConnection(Connection connection) {
        this.connection = new WeakReference<Connection>(connection);
        try {
            this.connectionID = connection.getConnectionID();
        }
        catch (JMSException jmse) {
            this.connectionID = -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws IOException {
        tracer.entering("close");
        if (this.isClosed) {
            tracer.debugT("close", this.connectionID + ":Socket already closed!");
            tracer.exiting();
            return;
        }
        this.isClosed = true;
        this.runFlag = false;
        this.socket.shutdownInput();
        this.socket.shutdownOutput();
        this.input.close();
        this.output.close();
        this.socket.close();
        if (--instanceCount == 0 && this.pool != null) {
            if (this.pool instanceof ThreadPool) {
                ((ThreadPool)this.pool).freeMemory();
            }
            this.pool = null;
        }
        Object object = this.destroySocketLock;
        synchronized (object) {
            while (this.isRunning) {
                try {
                    this.destroySocketLock.wait();
                }
                catch (InterruptedException e) {
                    logger.fatalT(tracer, "JMS client socket could not be closed correctly because of interrupted thread!");
                }
            }
        }
        long[] keys = this.waitTable.getAllKeys();
        Object value = null;
        int i = 0;
        while (i < keys.length) {
            value = this.waitTable.get(keys[i]);
            if (!(value instanceof Packet)) {
                Object object2 = value;
                synchronized (object2) {
                    this.waitTable.remove(keys[i]);
                    value.notify();
                }
            }
            ++i;
        }
        Object ref = null;
        if (this.connection != null) {
            ref = this.connection.get();
        }
        if (ref != null) {
            ((Connection)ref).setAdapterClosed();
        }
        this.connection = null;
        this.packet_length_buffer = null;
        tracer.exiting();
    }

    private final void checkIfClosed() throws IOException {
        if (this.closeException != null) {
            if (this.closeException instanceof IOException) {
                tracer.throwing("checkIfClosed", (Throwable)this.closeException);
                throw (IOException)this.closeException;
            }
            IOException ioe = new IOException(" Socket was closed due to " + this.closeException.getMessage());
            tracer.throwing("checkIfClosed", (Throwable)ioe);
            throw ioe;
        }
    }

    public void setThreadSystem(ThreadSystem threadSystem) {
        if (!this.isClosed) {
            this.pool = threadSystem;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TextFormatter.separator(buffer, "NetworkAdapter");
        TextFormatter.addColumn(buffer, "type", 30, 0);
        TextFormatter.addColumn(buffer, "SocketWrapper", 0);
        TextFormatter.addColumn(buffer, "host", 30, 0);
        TextFormatter.addColumn(buffer, this.host, 0);
        TextFormatter.addColumn(buffer, "port", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.port, 0);
        return buffer.toString();
    }
}

