/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.connection;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.util.LinkedList;
import com.sap.engine.lib.util.RandomGenerator;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.Util;
import com.sap.jms.client.connection.Connection;
import com.sap.jms.client.connection.NetworkAdapter;
import com.sap.jms.client.connection.QueueConnection;
import com.sap.jms.client.connection.SocketWrapper;
import com.sap.jms.client.connection.TopicConnection;
import com.sap.jms.client.session.ThreadPool;
import com.sap.jms.client.xa.XAConnection;
import com.sap.jms.client.xa.XAQueueConnection;
import com.sap.jms.client.xa.XATopicConnection;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.notification.ConnectionCreateResponse;
import com.sap.jms.protocol.notification.ServerExceptionResponse;
import com.sap.jms.server.ServerComponentAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;

public class ConnectionFactory
implements javax.jms.ConnectionFactory,
Serializable {
    static final long serialVersionUID = 3294517766353918551L;
    private static final transient int DEFAULT_MAX_POOL_SIZE = 128;
    private static final transient int DEFAULT_INITIAL_POOL_SIZE = 5;
    private static final transient String DEFAULT_USER_NAME = "Guest";
    private static final transient String DEFAULT_PASSWORD = "";
    private static final transient String DEFAULT_SERVER_INSTANCE = "default";
    private static final transient String PROPERTY_JMS_USER = "jms.user";
    private static final transient String PROPERTY_JMS_PASSWORD = "jms.password";
    private static final String LOCATION = "com.sap.jms.client.connection.ConnectionFactory";
    private static final String CATEGORY = "/Applications/JMS";
    private static final String LOG_PROPERTIES_FILE = "logging.properties";
    private static final String LOG_FILE = "sapjms.log";
    private static transient ThreadSystem threadSystem = null;
    private static boolean isLogInitialized = false;
    private int maxPoolSize = 128;
    private int initialPoolSize = 5;
    private LinkedList hosts = new LinkedList();
    private LinkedList ports = new LinkedList();
    private String userName = "Guest";
    private String password = "";
    private String serverInstance = "default";
    private String hardwareID;
    private String systemID;
    private Object container;
    private transient Category logger = null;
    private transient Location tracer = null;
    private transient int currentDispatcher = 0;
    private transient int[] dispatcherSequence = null;
    static /* synthetic */ Class class$java$lang$Object;

    public ConnectionFactory(String[] hosts, int[] ports, String serverInstance, String userName, String password, int initialPoolSize, int maxPoolSize, String systemID, String hardwareID) {
        this(hosts, ports, userName, password, systemID, hardwareID);
        this.serverInstance = serverInstance;
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    public ConnectionFactory(String[] hosts, int[] ports, String userName, String password, String systemID, String hardwareID) {
        this(hosts, ports, systemID, hardwareID);
        this.userName = userName;
        this.password = password;
    }

    public ConnectionFactory(String[] hosts, int[] ports, String serverInstance, String userName, String password, String systemID, String hardwareID) {
        this(hosts, ports, userName, password, systemID, hardwareID);
        this.serverInstance = serverInstance;
    }

    public ConnectionFactory(String[] hosts, int[] ports, String systemID, String hardwareID) {
        if (hosts.length != ports.length) {
            throw new IllegalArgumentException(ClientJMSResourceAccessor.formatString("JMS1012", null));
        }
        this.hardwareID = hardwareID;
        this.systemID = systemID;
        int i = 0;
        while (i < hosts.length) {
            this.hosts.add(hosts[i]);
            this.ports.add(new Integer(ports[i]));
            ++i;
        }
    }

    public void addDispatcher(String host, int port) {
        this.hosts.add(host);
        this.ports.add(new Integer(port));
    }

    public void removeDispatcher(String host) {
        int i = 0;
        while (i < this.hosts.size()) {
            if (this.hosts.get(i).equals(host)) {
                this.hosts.remove(i);
                this.ports.remove(i);
                return;
            }
            ++i;
        }
    }

    public void setServerInstance(String serverInstance) {
        this.serverInstance = serverInstance;
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    public void setDefaultCredentials(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void setDefaultClientPoolOptions(int initialPoolSize, int maxPoolSize) {
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    public javax.jms.Connection createConnection() throws JMSException {
        return this.createConnection((byte)2);
    }

    public javax.jms.Connection createConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password, (byte)2);
    }

    public javax.jms.Connection createConnection(byte connectionType) throws JMSException {
        String systemPropUser = null;
        String systemPropPassword = null;
        try {
            systemPropUser = System.getProperty(PROPERTY_JMS_USER);
            systemPropPassword = System.getProperty(PROPERTY_JMS_PASSWORD);
        }
        catch (Exception e) {
            return this.createConnection(this.userName, this.password, connectionType);
        }
        if (systemPropUser != null && systemPropPassword != null) {
            this.userName = systemPropUser;
            this.password = systemPropPassword;
        }
        return this.createConnection(this.userName, this.password, connectionType);
    }

    public javax.jms.Connection createConnection(String userName, String password, byte connectionType) throws JMSException {
        NetworkAdapter adapter = null;
        ConnectionCreateResponse response = null;
        this.tracer = Location.getLocation((String)LOCATION);
        this.logger = Category.getCategory((String)CATEGORY);
        this.container = ServerComponentAccessor.container;
        if (this.container != null && this.hardwareID != null && this.hardwareID.equals(ServerComponentAccessor.hardwareID) && this.systemID != null && this.systemID.equals(ServerComponentAccessor.systemID)) {
            try {
                Class<?> serverClientAdapter = Class.forName("com.sap.jms.server.ServerClientAdapter");
                Constructor<?> constructor = serverClientAdapter.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = ConnectionFactory.class$("java.lang.Object")) : class$java$lang$Object);
                adapter = (NetworkAdapter)constructor.newInstance(this.container);
            }
            catch (Exception cnfe) {
                JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1013", null));
                this.tracer.throwing("createConnection", (Throwable)jmse);
                this.logger.fatalT(this.tracer, "createConnection", "Failed to create JMS connection! See JMS service traces for more details!");
                throw jmse;
            }
            adapter.setThreadSystem(ServerComponentAccessor.threadSystem);
            threadSystem = ServerComponentAccessor.threadSystem;
        } else {
            if (ServerComponentAccessor.container == null && !isLogInitialized) {
                File logProperties = new File(System.getProperty("user.home") + "/" + LOG_PROPERTIES_FILE);
                if (logProperties.exists()) {
                    PropertiesConfigurator logConfigurator = new PropertiesConfigurator(logProperties);
                    logConfigurator.configure();
                } else {
                    String logFile = System.getProperty("user.home") + "/" + LOG_FILE;
                    Properties properties = new Properties();
                    ((Hashtable)properties).put("com.sap.jms.severity", "ERROR");
                    ((Hashtable)properties).put("log[Trace]", "FileLog");
                    ((Hashtable)properties).put("log[Trace].pattern", logFile);
                    ((Hashtable)properties).put("com.sap.jms.logs", "+log[Trace]");
                    PropertiesConfigurator logConfigurator = new PropertiesConfigurator(properties);
                    logConfigurator.configure();
                }
                isLogInitialized = true;
            }
            this.randomizeDispatcherSequence(this.hosts.size());
            adapter = this.getSocket();
            if (adapter == null) {
                JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1013", null));
                this.tracer.throwing("createConnection", (Throwable)jmse);
                this.logger.fatalT(this.tracer, "createConnection", "Failed to create JMS connection! See trace file for more details!");
                throw jmse;
            }
            threadSystem = ServerComponentAccessor.threadSystem != null ? ServerComponentAccessor.threadSystem : ConnectionFactory.getClientThreadPool(this.initialPoolSize, this.maxPoolSize);
            adapter.setThreadSystem(threadSystem);
            threadSystem.startThread(adapter, false);
        }
        response = this.sendConnectionCreateRequest(userName, password, adapter);
        Connection connection = null;
        switch (connectionType) {
            case 2: {
                connection = new Connection(response.getConnectionID(), this.serverInstance, adapter, threadSystem);
                break;
            }
            case 0: {
                connection = new QueueConnection(response.getConnectionID(), this.serverInstance, adapter, threadSystem);
                break;
            }
            case 1: {
                connection = new TopicConnection(response.getConnectionID(), this.serverInstance, adapter, threadSystem);
                break;
            }
            case 5: {
                connection = new XAConnection(response.getConnectionID(), this.serverInstance, adapter, threadSystem);
                break;
            }
            case 3: {
                connection = new XAQueueConnection(response.getConnectionID(), this.serverInstance, adapter, threadSystem);
                break;
            }
            case 4: {
                connection = new XATopicConnection(response.getConnectionID(), this.serverInstance, adapter, threadSystem);
            }
        }
        if (this.tracer.beInfo()) {
            this.tracer.infoT(this.logger, "JMS connection created:\n{0}", new Object[]{connection});
        }
        return connection;
    }

    private ConnectionCreateResponse sendConnectionCreateRequest(String userName, String password, NetworkAdapter adapter) throws JMSException {
        this.tracer.entering("sendConnectionCreateRequest");
        PacketImpl response = null;
        try {
            response = (PacketImpl)adapter.sendAndWait(Util.PACKET_FACTORY.createConnectionCreateRequest(this.serverInstance, userName, password));
        }
        catch (IOException ioe) {
            this.tracer.debugT("sendConnectionCreateRequest", "Could not send connection create request!\n" + Util.getStackTrace(ioe));
            this.logger.fatalT(this.tracer, "sendConnectionCreateRequest", "Could not create JMS connection because of IO error! See trace file for more details!");
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1014", null));
            jmse.setLinkedException((Exception)ioe);
            this.tracer.throwing("sendConnectionCreateRequest", (Throwable)jmse);
            this.tracer.exiting();
            throw jmse;
        }
        this.checkForException(response);
        this.tracer.exiting();
        return (ConnectionCreateResponse)response;
    }

    private void checkForException(PacketImpl packet) throws JMSException {
        if (packet == null) {
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1015", null));
            this.tracer.throwing("checkForException", (Throwable)jmse);
            this.logger.fatalT(this.tracer, "checkForException", "Failed to create connection! Reason: " + jmse.getMessage());
            throw jmse;
        }
        if (packet.getPacketType() == -112) {
            JMSException jmse = ((ServerExceptionResponse)packet).getException();
            this.tracer.throwing("checkForException", (Throwable)jmse);
            this.tracer.debugT("checkForException", "ServerException:\n" + Util.getJMSExceptionStackTrace(jmse));
            this.logger.fatalT(this.tracer, "checkForException", "Failed to create connection! Reason: " + jmse.getMessage());
            throw jmse;
        }
        if (packet.getPacketType() != -4) {
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1016", null));
            this.tracer.throwing("checkForException", (Throwable)jmse);
            this.logger.fatalT(this.tracer, "checkForException", "Failed to create connection! Reason: " + jmse.getMessage());
            throw jmse;
        }
    }

    private SocketWrapper getSocket() throws JMSException {
        if (this.dispatcherSequence == null) {
            return null;
        }
        SocketWrapper result = null;
        int i = this.currentDispatcher;
        while (i < this.dispatcherSequence.length) {
            try {
                result = new SocketWrapper((String)this.hosts.get(i), (Integer)this.ports.get(i));
                this.currentDispatcher = (i + 1) % this.dispatcherSequence.length;
                return result;
            }
            catch (Exception e) {
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < this.currentDispatcher) {
            try {
                result = new SocketWrapper((String)this.hosts.get(i2), (Integer)this.ports.get(i2));
                this.currentDispatcher = (i2 + 1) % this.dispatcherSequence.length;
                return result;
            }
            catch (Exception e) {
                ++i2;
            }
        }
        String triedHosts = this.getHostPortList();
        JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1046", new Object[]{triedHosts}));
        this.tracer.throwing("getSocket", (Throwable)jmse);
        this.logger.fatalT(this.tracer, "getSocket", "The following hosts (hostname:port) could not be reached: " + triedHosts + " - Please check host names and ports.");
        throw jmse;
    }

    private void randomizeDispatcherSequence(int size) {
        if (this.dispatcherSequence == null) {
            this.dispatcherSequence = new int[size];
            LinkedList available = new LinkedList(size);
            RandomGenerator generator = new RandomGenerator();
            int i = 0;
            while (i < size) {
                available.add(new Integer(i));
                ++i;
            }
            int i2 = 0;
            while (i2 < size) {
                this.dispatcherSequence[i2] = (Integer)available.remove(generator.nextInt() % available.size());
                ++i2;
            }
        }
    }

    private String getHostPortList() {
        StringBuffer sb = new StringBuffer();
        int i = this.currentDispatcher;
        while (i < this.dispatcherSequence.length) {
            if (i > this.currentDispatcher) {
                sb.append(", ");
            }
            sb.append(this.hosts.get(i));
            sb.append(":");
            sb.append(this.ports.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.currentDispatcher) {
            sb.append(", ");
            sb.append(this.hosts.get(i2));
            sb.append(":");
            sb.append(this.ports.get(i2));
            ++i2;
        }
        return sb.toString();
    }

    private static final synchronized ThreadSystem getClientThreadPool(int initialPoolSize, int maxPoolSize) {
        if (threadSystem == null) {
            threadSystem = new ThreadPool(initialPoolSize, maxPoolSize);
        }
        return threadSystem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

