/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.connection;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.connection.Connection;
import com.sap.jms.client.message.Message;
import com.sap.jms.client.session.MessageConsumer;
import com.sap.jms.client.session.Session;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;

public class ConnectionConsumer
implements javax.jms.ConnectionConsumer {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.connection.ConnectionConsumer");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    ServerSessionPool pool;
    Connection connection;
    int maxMessages = 1;
    boolean running = true;
    ThreadSystem threadSystem = null;
    MessageConsumer consumer = null;
    Session session = null;

    private ConnectionConsumer(ServerSessionPool pool, Connection connection, int maxMessages) throws JMSException {
        if (pool == null) {
            throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1044", null));
        }
        this.pool = pool;
        this.connection = connection;
        this.maxMessages = maxMessages;
        this.threadSystem = connection.getThreadSystem();
    }

    public ConnectionConsumer(Destination destination, String subscription, String messageSelector, ServerSessionPool pool, Connection connection, int maxMessages) throws JMSException {
        this(pool, connection, maxMessages);
        this.session = (Session)connection.createSession(true, 0);
        this.consumer = (MessageConsumer)this.session.createDurableSubscriber((Topic)destination, subscription, messageSelector, false);
        this.consumer.setMessageListener(new ConsumerListener());
    }

    public ConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool pool, Connection connection, int maxMessages) throws JMSException {
        this(pool, connection, maxMessages);
        this.session = (Session)connection.createSession(true, 0);
        this.consumer = (MessageConsumer)this.session.createConsumer(destination, messageSelector);
        this.consumer.setMessageListener(new ConsumerListener());
    }

    public void close() throws JMSException {
        this.consumer.close();
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.pool;
    }

    private class ConsumerListener
    implements MessageListener {
        ServerSession serverSession = null;

        private ConsumerListener() {
        }

        public void onMessage(javax.jms.Message message) {
            try {
                this.serverSession = ConnectionConsumer.this.pool.getServerSession();
                Session innerSession = (Session)this.serverSession.getSession();
                if (innerSession.getTransacted()) {
                    innerSession.bindSession(ConnectionConsumer.this.session);
                    innerSession.receiveMessage((Message)message, 0L);
                } else {
                    innerSession.receiveMessage((Message)message, 0L);
                    ConnectionConsumer.this.session.commit();
                }
                this.serverSession.start();
                ConnectionConsumer.this.session.waitCommit();
            }
            catch (JMSException e) {
                logger.errorT(tracer, "onMessage", "Failed to deliver JMS message! See JMS service traces for more details!");
                LoggingHelper.traceThrowable(400, tracer, "onMessage", e);
            }
        }
    }
}

