/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.connection;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.jms.client.ClientJMSResourceAccessor;
import com.sap.jms.client.TextFormatter;
import com.sap.jms.client.Util;
import com.sap.jms.client.connection.ConnectionConsumer;
import com.sap.jms.client.connection.ConnectionMetaData;
import com.sap.jms.client.connection.NetworkAdapter;
import com.sap.jms.client.connection.QueueConnection;
import com.sap.jms.client.connection.TopicConnection;
import com.sap.jms.client.message.Message;
import com.sap.jms.client.message.MessageFactory;
import com.sap.jms.client.session.QueueSession;
import com.sap.jms.client.session.TopicSession;
import com.sap.jms.client.xa.XAQueueSession;
import com.sap.jms.client.xa.XASession;
import com.sap.jms.client.xa.XATopicSession;
import com.sap.jms.protocol.Packet;
import com.sap.jms.protocol.message.MessageRequest;
import com.sap.jms.protocol.notification.ServerExceptionResponse;
import com.sap.jms.protocol.notification.SessionCreateResponse;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class Connection
implements javax.jms.Connection {
    public static final byte QUEUE_CONNECTION = 0;
    public static final byte TOPIC_CONNECTION = 1;
    public static final byte GENERIC_CONNECTION = 2;
    public static final byte XA_QUEUE_CONNECTION = 3;
    public static final byte XA_TOPIC_CONNECTION = 4;
    public static final byte XA_GENERIC_CONNECTION = 5;
    private static final ConnectionMetaData connectionMetaData = new ConnectionMetaData();
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.Connection");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private boolean isClosed = false;
    private boolean isStarted = false;
    private boolean adapterClosed = false;
    private long connectionID = 0L;
    private NetworkAdapter networkAdapter = null;
    private ThreadSystem threadSystem = null;
    private ConcurrentHashMapIntObject sessions = null;
    private ConnectionConsumer connectionConsumer = null;
    private String serverInstance = null;
    private String clientID = null;
    private boolean canSetClientID = true;
    private Object syncThis = new Object();
    private boolean isStopping = false;
    private ExceptionListener exceptionListener = null;
    private JMSException asyncException = null;

    public Connection(long connectionID, String serverInstance, NetworkAdapter networkAdapter, ThreadSystem threadSystem) {
        this.networkAdapter = networkAdapter;
        this.threadSystem = threadSystem;
        this.connectionID = connectionID;
        this.serverInstance = serverInstance;
        networkAdapter.setConnection(this);
        this.sessions = new ConcurrentHashMapIntObject();
    }

    public void close() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("close");
            if (this.isClosed || this.adapterClosed) {
                tracer.exiting();
                return;
            }
            this.isClosed = true;
            Enumeration enumeration = this.sessions.elements();
            Object ref = null;
            while (enumeration.hasMoreElements()) {
                ref = ((WeakReference)enumeration.nextElement()).get();
                if (ref == null) continue;
                ((com.sap.jms.client.session.Session)ref).close();
            }
            Packet response = this.sendPacket(Util.PACKET_FACTORY.createConnectionCloseRequest(this.connectionID));
            this.checkReceivedPacket(response, (byte)-2);
            try {
                this.networkAdapter.close();
            }
            catch (IOException ioe) {
                logger.warningT(tracer, "close", this.connectionID + ":Could not destroy socket properly!");
                tracer.debugT("close", this.connectionID + ":Could not destroy socket properly!\n" + Util.getStackTrace(ioe));
                JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1004", null));
                jmse.setLinkedException((Exception)ioe);
                tracer.throwing("close", (Throwable)jmse);
                tracer.exiting();
                throw jmse;
            }
            this.exceptionListener = null;
            this.connectionConsumer = null;
            this.threadSystem = null;
            this.sessions = null;
            if (tracer.beInfo()) {
                tracer.infoT(logger, "JMS connection closed:\n {0}", new Object[]{this});
            }
            tracer.exiting();
        }
    }

    public void closeSession(int sessionID) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("closeSession");
            if (!this.isClosed) {
                Packet packet = this.sendPacket(Util.PACKET_FACTORY.createSessionCloseRequest(this.connectionID, sessionID));
                this.checkReceivedPacket(packet, (byte)-20);
                this.sessions.remove(sessionID);
            }
            tracer.exiting();
        }
    }

    public javax.jms.ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            this.attemptToUse();
            this.canSetClientID = false;
            ConnectionConsumer connectionConsumer = this.connectionConsumer = new ConnectionConsumer(destination, messageSelector, serverSessionPool, this, maxMessages);
            return connectionConsumer;
        }
    }

    public javax.jms.ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelecor, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            this.attemptToUse();
            this.canSetClientID = false;
            ConnectionConsumer connectionConsumer = this.connectionConsumer = new ConnectionConsumer((Destination)topic, subscriptionName, messageSelecor, serverSessionPool, this, maxMessages);
            return connectionConsumer;
        }
    }

    public void closeConnectionConsumer() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            this.attemptToUse();
            this.canSetClientID = false;
            this.connectionConsumer.close();
        }
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, (byte)2);
    }

    public Session createSession(boolean transacted, int acknowledgeMode, byte sessionType) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("createSession");
            this.attemptToUse();
            this.canSetClientID = false;
            if (transacted) {
                acknowledgeMode = 0;
            } else if (acknowledgeMode != 1 && acknowledgeMode != 2 && acknowledgeMode != 3) {
                tracer.exiting();
                throw new JMSException(ClientJMSResourceAccessor.formatString("JMS1005", null));
            }
            Packet packet = null;
            packet = sessionType == 2 || sessionType == 0 || sessionType == 1 ? this.sendPacket(Util.PACKET_FACTORY.createSessionCreateRequest(this.connectionID, (byte)acknowledgeMode, false)) : this.sendPacket(Util.PACKET_FACTORY.createSessionCreateRequest(this.connectionID, (byte)acknowledgeMode, true));
            this.checkReceivedPacket(packet, (byte)-18);
            SessionCreateResponse response = (SessionCreateResponse)packet;
            com.sap.jms.client.session.Session session = null;
            XASession xa = null;
            switch (sessionType) {
                case 2: {
                    session = new com.sap.jms.client.session.Session(response.getSessionID(), acknowledgeMode, this, this.threadSystem);
                    break;
                }
                case 0: {
                    session = new QueueSession(response.getSessionID(), acknowledgeMode, this, this.threadSystem);
                    break;
                }
                case 1: {
                    session = new TopicSession(response.getSessionID(), acknowledgeMode, this, this.threadSystem);
                    break;
                }
                case 5: {
                    session = new com.sap.jms.client.session.Session(response.getSessionID(), acknowledgeMode, this, this.threadSystem);
                    xa = new XASession(session);
                    break;
                }
                case 3: {
                    session = new QueueSession(response.getSessionID(), acknowledgeMode, this, this.threadSystem);
                    xa = new XAQueueSession((QueueSession)session);
                    break;
                }
                case 4: {
                    session = new TopicSession(response.getSessionID(), acknowledgeMode, this, this.threadSystem);
                    xa = new XATopicSession((TopicSession)session);
                }
            }
            session.setMessageIDBase(response.getMessageIDBase());
            this.sessions.put(response.getSessionID(), new WeakReference<com.sap.jms.client.session.Session>(session));
            if (this.isStarted) {
                session.startDelivery(true);
            }
            if (tracer.beInfo()) {
                tracer.infoT(logger, "JMS session created:\n {0}", new Object[]{session});
            }
            tracer.exiting();
            if (xa != null) {
                XASession xASession = xa;
                return xASession;
            }
            com.sap.jms.client.session.Session session2 = session;
            return session2;
        }
    }

    public long getConnectionConsumerID() {
        this.canSetClientID = false;
        if (this.connectionConsumer != null) {
            return -1L;
        }
        return -1L;
    }

    public String getClientID() throws JMSException {
        this.attemptToUse();
        return this.clientID;
    }

    public long getConnectionID() throws JMSException {
        this.attemptToUse();
        return this.connectionID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            this.attemptToUse();
            this.canSetClientID = false;
            ExceptionListener exceptionListener = this.exceptionListener;
            return exceptionListener;
        }
    }

    public javax.jms.ConnectionMetaData getMetaData() throws JMSException {
        this.attemptToUse();
        this.canSetClientID = false;
        return connectionMetaData;
    }

    public void setClientID(String id) throws JMSException {
        this.attemptToUse();
        if (!this.canSetClientID) {
            throw new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1006", null));
        }
        this.clientID = id;
        this.canSetClientID = false;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            if (this.asyncException != null && exceptionListener != null) {
                JMSException exp = this.asyncException;
                this.asyncException = null;
                exceptionListener.onException(exp);
            }
            this.attemptToUse();
            this.canSetClientID = false;
            this.exceptionListener = exceptionListener;
        }
    }

    public void start() throws JMSException {
        Object object = this.syncThis;
        synchronized (object) {
            tracer.entering("start");
            this.attemptToUse();
            while (this.isStopping) {
                try {
                    this.syncThis.wait();
                }
                catch (InterruptedException ie) {
                    logger.warningT(tracer, "start", "JMS start connection failed due to interrupted thread! Messages cannot be received.");
                    tracer.throwing("start", (Throwable)ie);
                }
            }
            this.canSetClientID = false;
            if (this.isStarted) {
                tracer.exiting();
                return;
            }
            Packet packet = this.sendPacket(Util.PACKET_FACTORY.createConnectionStartRequest(this.connectionID));
            this.checkReceivedPacket(packet, (byte)-8);
            this.isStarted = true;
            Enumeration enumeration = this.sessions.elements();
            Object session = null;
            while (enumeration.hasMoreElements()) {
                session = ((WeakReference)enumeration.nextElement()).get();
                if (session == null) continue;
                ((com.sap.jms.client.session.Session)session).startDelivery(true);
            }
            tracer.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws JMSException {
        block13: {
            Object object;
            block12: {
                try {
                    Object object2 = this.syncThis;
                    synchronized (object2) {
                        tracer.entering("stop");
                        this.attemptToUse();
                        if (!this.isStarted) {
                            tracer.exiting();
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 11] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var6_2 = null;
                            object = this.syncThis;
                            break block12;
                        }
                        Packet packet = this.sendPacket(Util.PACKET_FACTORY.createConnectionStopRequest(this.connectionID));
                        this.checkReceivedPacket(packet, (byte)-6);
                        this.isStopping = true;
                        this.isStarted = false;
                    }
                    Object[] sessionsArray = this.sessions.getAllValues();
                    Object session = null;
                    int i = 0;
                    while (true) {
                        if (i >= sessionsArray.length) {
                            tracer.exiting();
                            break block13;
                        }
                        session = ((WeakReference)sessionsArray[i]).get();
                        if (session != null) {
                            ((com.sap.jms.client.session.Session)session).pauseDelivery(true);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    Object object3 = this.syncThis;
                    synchronized (object3) {
                        this.isStopping = false;
                        this.syncThis.notifyAll();
                        throw throwable;
                    }
                }
            }
            synchronized (object) {
                this.isStopping = false;
                this.syncThis.notifyAll();
                return;
            }
        }
        Object var6_3 = null;
        Object object = this.syncThis;
        synchronized (object) {
            this.isStopping = false;
            this.syncThis.notifyAll();
            return;
        }
    }

    private void attemptToUse() throws IllegalStateException {
        if (this.isClosed) {
            IllegalStateException ise = new IllegalStateException(ClientJMSResourceAccessor.formatString("JMS1007", null));
            tracer.warningT(logger, "Attempt to use a closed JMS connection!");
            tracer.throwing("attemptToUse", (Throwable)ise);
            throw ise;
        }
    }

    public void onPacketReceived(Packet packet) throws JMSException {
        tracer.entering("onPakcetReceived");
        int packetType = packet.getPacketType();
        if (packetType <= 0) {
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1008", null));
            logger.warningT(tracer, "onPacketReceived", "Invalid message with packet type " + packet.getPacketType() + " received");
            tracer.throwing("onPacketReceived", (Throwable)jmse);
            tracer.exiting();
            throw jmse;
        }
        MessageRequest messagePacket = (MessageRequest)packet;
        int sessionID = messagePacket.getSessionID();
        long consumerID = messagePacket.getJMSConsumerID();
        Message message = null;
        MessageFactory factory = MessageFactory.getFactory();
        switch (packetType) {
            case 1: {
                message = factory.createBytesMessage(messagePacket);
                break;
            }
            case 4: {
                message = factory.createMapMessage(messagePacket);
                break;
            }
            case 2: {
                message = factory.createTextMessage(messagePacket);
                break;
            }
            case 3: {
                message = factory.createStreamMessage(messagePacket);
                break;
            }
            case 5: {
                message = factory.createObjectMessage(messagePacket);
                break;
            }
            case 6: {
                message = factory.createMessage(messagePacket);
                break;
            }
            default: {
                JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1008", null));
                logger.warningT(tracer, "onPacketReceived", "Invalid message with packet type " + packet.getPacketType() + " received");
                tracer.throwing("onPacketReceived", (Throwable)jmse);
                tracer.exiting();
                throw jmse;
            }
        }
        Object session = ((WeakReference)this.sessions.get(sessionID)).get();
        if (session != null) {
            ((com.sap.jms.client.session.Session)session).receiveMessage(message, consumerID);
        }
        tracer.exiting();
    }

    public Packet sendPacket(Packet packet) throws JMSException {
        try {
            return this.networkAdapter.sendAndWait(packet);
        }
        catch (IOException ioe) {
            logger.warningT(tracer, "sendPacket", "Could not send JMS packet because of IO error! See debug traces for more details!");
            tracer.debugT("sendPacket", "Could not send packet because of IO error!\n" + Util.getStackTrace(ioe));
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1009", null));
            jmse.setLinkedException((Exception)ioe);
            tracer.throwing("sendPacket", (Throwable)jmse);
            throw jmse;
        }
    }

    private void checkReceivedPacket(Packet packet, byte expectedPacketType) throws JMSException {
        if (packet == null) {
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1011", null));
            logger.warningT(tracer, "checkReceivedPacket", "JMS operation could not be completed! Socket closed because of unknown reason!");
            tracer.throwing("checkReceivedPacket", (Throwable)jmse);
            throw jmse;
        }
        if (packet.getPacketType() == -112) {
            throw ((ServerExceptionResponse)packet).getException();
        }
        if (packet.getPacketType() != expectedPacketType) {
            JMSException jmse = new JMSException(ClientJMSResourceAccessor.formatString("JMS1010", null));
            logger.warningT(tracer, "checkReceivedPacket", "Internal JMS error : unexpected message received! Expected type " + expectedPacketType + " but received type " + packet.getPacketType());
            tracer.throwing("checkReceivedPacket", (Throwable)jmse);
            throw jmse;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void deleteTemporaryDestination(int destinationID) throws JMSException {
        tracer.entering("deleteTemporaryDestination");
        Packet packet = Util.PACKET_FACTORY.createDestinationDeleteRequest(this.connectionID, destinationID);
        packet = this.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-100);
        tracer.exiting();
    }

    public void startDeliveryToSession(int sessionID) throws JMSException {
        tracer.entering("startDeliveryToSession");
        Packet packet = Util.PACKET_FACTORY.createSessionStartRequest(this.connectionID, sessionID);
        packet = this.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-28);
        tracer.exiting();
    }

    public void stopDeliveryToSession(int sessionID) throws JMSException {
        tracer.entering("stopDeliveryToSession");
        Packet packet = Util.PACKET_FACTORY.createSessionStopRequest(this.connectionID, sessionID);
        packet = this.sendPacket(packet);
        this.checkReceivedPacket(packet, (byte)-30);
        tracer.exiting();
    }

    public ThreadSystem getThreadSystem() {
        return this.threadSystem;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TextFormatter.header(buffer, "Connection");
        TextFormatter.addColumn(buffer, "ID", 30, 0);
        TextFormatter.addColumn(buffer, "" + this.connectionID, 0);
        TextFormatter.addColumn(buffer, "Type", 30, 0);
        if (this instanceof QueueConnection) {
            TextFormatter.addColumn(buffer, "QueueConnection", 0);
        } else if (this instanceof TopicConnection) {
            TextFormatter.addColumn(buffer, "TopicConnection", 0);
        } else {
            TextFormatter.addColumn(buffer, "(Generic)Connection", 0);
        }
        TextFormatter.addColumn(buffer, "Mode", 30, 0);
        if (this.isStarted) {
            TextFormatter.addColumn(buffer, "STARTED", 0);
        } else {
            TextFormatter.addColumn(buffer, "STOPPED", 0);
        }
        TextFormatter.addColumn(buffer, "isClosed", 30, 0);
        if (this.isClosed) {
            TextFormatter.addColumn(buffer, "YES", 0);
        } else {
            TextFormatter.addColumn(buffer, "NO", 0);
        }
        if (this.exceptionListener != null) {
            TextFormatter.addColumn(buffer, "ExceptionListener", 30, 0);
            TextFormatter.addColumn(buffer, this.exceptionListener.toString(), 0);
        }
        if (this.connectionConsumer != null) {
            TextFormatter.addColumn(buffer, "ConnectionConsumer", 30, 0);
            TextFormatter.addColumn(buffer, this.connectionConsumer.toString(), 0);
        }
        if (this.networkAdapter != null) {
            buffer.append(this.networkAdapter.toString());
        }
        buffer.append(connectionMetaData.toString());
        TextFormatter.footer(buffer);
        return buffer.toString();
    }

    public void setAdapterClosed() {
        this.adapterClosed = true;
    }

    public boolean isAdapterClosed() {
        return this.adapterClosed;
    }

    public void onException(JMSException jmse) {
        Object object = this.syncThis;
        synchronized (object) {
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(jmse);
            } else {
                this.asyncException = jmse;
            }
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    protected void finalize() throws Throwable {
        tracer.debugT("finalize", "garbage collecting Connection ... ");
        try {
            this.close();
        }
        catch (Exception e) {
            try {
                tracer.warningT(logger, "caught exception during finalization of Connection");
                tracer.catching(logger, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

