/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.jms.server.exception.JMSResourceAccessor;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class ClientJMSResourceAccessor {
    private static JMSResourceAccessor resourceAccessor = null;
    public static Category logger = Category.getCategory((String)"/System/Server");
    public static Location tracer = Location.getLocation((String)"com.sap.jms");

    public static synchronized String formatString(String patternKey, Object[] args) {
        if (resourceAccessor == null) {
            resourceAccessor = (JMSResourceAccessor)JMSResourceAccessor.getResourceAccessor();
            JMSResourceAccessor.init(logger, tracer);
        }
        String message = null;
        try {
            message = LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)patternKey, (Object[])args);
        }
        catch (Exception e) {
            logger.warningT(tracer, "formatString", "Unexpected exception caught: " + e.toString());
            LoggingHelper.traceThrowable(400, tracer, "formatString", e);
            return null;
        }
        return message;
    }
}

