/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.utils;

import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;

public class SCCAlgorithm {
    private ComponentWrapper[] nodes;
    private ComponentWrapper[][] adjList;
    private int[] components;
    private int[] dfsnumber;
    private int[] highwater;
    private boolean[] onStack;
    private int lastdfsnumber;
    private int[] stack;
    private int head;

    SCCAlgorithm(ComponentWrapper[] nodes, ComponentWrapper[][] adjList) {
        this.nodes = nodes;
        this.adjList = adjList;
        this.components = new int[nodes.length];
        this.dfsnumber = new int[nodes.length];
        this.highwater = new int[nodes.length];
        this.onStack = new boolean[nodes.length];
        this.lastdfsnumber = 0;
        this.stack = new int[nodes.length];
        this.head = 0;
    }

    int[] strongComponents() {
        this.lastdfsnumber = 0;
        this.head = 0;
        int i = 0;
        while (i < this.nodes.length) {
            this.dfsnumber[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nodes.length) {
            if (this.dfsnumber[i2] == -1) {
                this.strong(i2);
            }
            ++i2;
        }
        return this.components;
    }

    private void push(int what) {
        this.stack[this.head] = what;
        ++this.head;
    }

    private int pop() {
        --this.head;
        return this.stack[this.head];
    }

    private void strong(int v) {
        int w = -1;
        this.dfsnumber[v] = ++this.lastdfsnumber;
        this.highwater[v] = this.lastdfsnumber;
        this.push(v);
        this.onStack[v] = true;
        if (this.adjList[v] != null) {
            int i = 0;
            while (i < this.adjList[v].length) {
                w = this.adjList[v][i].getNodeId();
                if (this.dfsnumber[w] == -1) {
                    this.strong(w);
                    if (this.highwater[w] < this.highwater[v]) {
                        this.highwater[v] = this.highwater[w];
                    }
                } else if (this.dfsnumber[w] < this.dfsnumber[v] && this.onStack[w] && this.dfsnumber[w] < this.highwater[v]) {
                    this.highwater[v] = this.dfsnumber[w];
                }
                ++i;
            }
        }
        if (this.highwater[v] == this.dfsnumber[v]) {
            do {
                w = this.pop();
                this.components[w] = v;
                this.onStack[w] = false;
            } while (w != v);
        }
    }
}

