/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.utils;

import com.sap.engine.tools.refsviewer.core.container.ComponentFactory;
import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;
import com.sap.engine.tools.refsviewer.core.container.CoreWrapper;
import com.sap.engine.tools.refsviewer.core.container.InterfaceWrapper;
import com.sap.engine.tools.refsviewer.core.container.LibraryWrapper;
import com.sap.engine.tools.refsviewer.core.container.Reference;
import com.sap.engine.tools.refsviewer.core.container.ServiceWrapper;
import com.sap.engine.tools.refsviewer.utils.SCCAlgorithm;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class ReferenceResolver {
    private Hashtable[] componentHashTables = null;
    private Vector cycles;
    private Vector visited;
    private HashSet unresolved = new HashSet();
    private String clusterType = null;

    public ReferenceResolver(String clType) {
        this.clusterType = clType;
        this.componentHashTables = clType.equals("Dispatcher") ? new Hashtable[]{ComponentFactory.getDispatcherHashInterfaces(), ComponentFactory.getDispatcherHashLibraries(), ComponentFactory.getDispatcherHashServices(), ComponentFactory.getDispatcherHashCores()} : new Hashtable[]{ComponentFactory.getServerHashInterfaces(), ComponentFactory.getServerHashLibraries(), ComponentFactory.getServerHashServices(), ComponentFactory.getServerHashCores(), ComponentFactory.getServerHashApplications()};
        this.cycles = new Vector();
        this.visited = new Vector();
    }

    public void resolveReferences() {
        ComponentWrapper component;
        boolean changed = true;
        Enumeration components = null;
        while (changed) {
            changed = false;
            int i = 0;
            while (i < this.componentHashTables.length) {
                components = this.componentHashTables[i].elements();
                while (components.hasMoreElements()) {
                    component = (ComponentWrapper)components.nextElement();
                    if (component.getStatus() != 2 || !this.resolveComponent(component)) continue;
                    changed = true;
                }
                ++i;
            }
        }
        int j = 0;
        while (j < this.componentHashTables.length) {
            components = this.componentHashTables[j].elements();
            while (components.hasMoreElements()) {
                component = (ComponentWrapper)components.nextElement();
                if (component.getStatus() != 2 || this.unresolved.contains(component)) continue;
                component.setStatus((byte)3);
            }
            ++j;
        }
        this.unresolved.clear();
    }

    private boolean resolveComponent(ComponentWrapper component) {
        if (this.unresolved.contains(component)) {
            return false;
        }
        Reference[] componentReferences = component.getReferences();
        if (componentReferences != null) {
            int i = 0;
            while (i < componentReferences.length) {
                Reference reference = componentReferences[i];
                if (reference.getType() != 2) {
                    this.getReferentComponent(reference.getReferentType(), reference.getName(), component);
                }
                ++i;
            }
        }
        return false;
    }

    public boolean findHardReferenceCycles() {
        this.visited.clear();
        this.cycles.clear();
        Vector traverced = new Vector();
        Enumeration components = null;
        int i = 0;
        while (i < this.componentHashTables.length) {
            components = this.componentHashTables[i].elements();
            while (components.hasMoreElements()) {
                ComponentWrapper component = (ComponentWrapper)components.nextElement();
                if (component.getStatus() != 3) continue;
                this.findReferenceCycle(component, component, traverced, true);
                this.visited.add(component);
            }
            ++i;
        }
        this.visited.clear();
        if (this.cycles.size() > 0) {
            int i2 = 0;
            while (i2 < this.cycles.size()) {
                Vector cycle = (Vector)this.cycles.get(i2);
                this.printCycle(cycle);
                ++i2;
            }
            this.cycles.clear();
            return false;
        }
        return true;
    }

    public Set[] findCommonLoaderAreas() {
        ComponentWrapper component;
        Vector<ComponentWrapper> resolved = new Vector<ComponentWrapper>();
        Enumeration enumeration = null;
        int i = 0;
        while (i < this.componentHashTables.length) {
            enumeration = this.componentHashTables[i].elements();
            while (enumeration.hasMoreElements()) {
                component = (ComponentWrapper)enumeration.nextElement();
                if (component.getStatus() != 3) continue;
                resolved.add(component);
            }
            ++i;
        }
        Vector<ComponentWrapper> refVector = new Vector<ComponentWrapper>();
        ComponentWrapper[] nodes = new ComponentWrapper[resolved.size()];
        ComponentWrapper[][] adjList = new ComponentWrapper[resolved.size()][];
        int i2 = 0;
        while (i2 < resolved.size()) {
            component = (ComponentWrapper)resolved.get(i2);
            component.setNodeId(i2);
            nodes[i2] = component;
            Reference[] references = component.getReferences();
            if (references != null) {
                refVector.clear();
                int j = 0;
                while (j < references.length) {
                    ComponentWrapper referent;
                    if (references[j].getType() != 2 && (referent = this.getReferentComponent(references[j].getReferentType(), references[j].getName(), component)).getStatus() == 3) {
                        refVector.add(referent);
                    }
                    ++j;
                }
                Object[] list = new ComponentWrapper[refVector.size()];
                refVector.copyInto(list);
                adjList[i2] = list;
            }
            ++i2;
        }
        SCCAlgorithm sccAlgorithm = new SCCAlgorithm(nodes, adjList);
        int[] areas = sccAlgorithm.strongComponents();
        Vector setsVector = new Vector();
        int i3 = 0;
        while (i3 < areas.length) {
            int color = areas[i3];
            if (color != -1) {
                HashSet<ComponentWrapper> set = new HashSet<ComponentWrapper>();
                setsVector.add(set);
                int j = i3;
                while (j < areas.length) {
                    if (areas[j] == color) {
                        set.add(nodes[j]);
                        areas[j] = -1;
                    }
                    ++j;
                }
            }
            ++i3;
        }
        Object[] result = new HashSet[setsVector.size()];
        setsVector.copyInto(result);
        return result;
    }

    private void findReferenceCycle(ComponentWrapper first, ComponentWrapper current, Vector traversed, boolean isHard) {
        if (this.visited.contains(current) || traversed.contains(current)) {
            return;
        }
        traversed.add(current);
        Reference[] references = current.getReferences();
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                if (this.checkReferenceType(references[i].getType(), isHard)) {
                    ComponentWrapper referer = this.getReferentComponent(references[i].getReferentType(), references[i].getName(), current);
                    if (first.equals(referer)) {
                        this.addCycle((Vector)traversed.clone());
                    } else {
                        this.findReferenceCycle(first, referer, traversed, isHard);
                    }
                }
                ++i;
            }
        }
        traversed.remove(traversed.size() - 1);
    }

    private boolean checkReferenceType(byte referenceType, boolean isHard) {
        if (isHard) {
            return referenceType == 0;
        }
        return referenceType != 2;
    }

    private ComponentWrapper getReferentComponent(byte referentType, String componentName, ComponentWrapper current) {
        ComponentWrapper result = null;
        switch (referentType) {
            case 0: {
                result = (ComponentWrapper)this.componentHashTables[0].get(componentName);
                if (result != null) break;
                System.out.println("Classload error; Can't load REFER_INTERFACE " + current.getComponentName() + " because referenced component " + componentName + " not found");
                result = new InterfaceWrapper(componentName, null);
                result.setWrong();
                if (this.clusterType.equals("Dispatcher")) {
                    ComponentFactory.addDispatcherHashInterfaces(result);
                    break;
                }
                ComponentFactory.addServerHashInterfaces(result);
                break;
            }
            case 1: {
                result = (ComponentWrapper)this.componentHashTables[1].get(componentName);
                if (result != null) break;
                System.out.println("Classload error; Can't load REFER_LIBRARY " + current.getComponentName() + " because referenced component " + componentName + " not found");
                result = new LibraryWrapper(componentName, null);
                result.setWrong();
                if (this.clusterType.equals("Dispatcher")) {
                    ComponentFactory.addDispatcherHashLibraries(result);
                    break;
                }
                ComponentFactory.addServerHashLibraries(result);
                break;
            }
            case 2: {
                result = (ComponentWrapper)this.componentHashTables[2].get(componentName);
                if (result != null) break;
                System.out.println("Classload error; Can't load REFER_SERVICE " + current.getComponentName() + " because referenced component " + componentName + " not found");
                result = new ServiceWrapper(componentName, null);
                result.setWrong();
                if (this.clusterType.equals("Dispatcher")) {
                    ComponentFactory.addDispatcherHashServices(result);
                    break;
                }
                ComponentFactory.addServerHashServices(result);
                break;
            }
            case 3: {
                result = (ComponentWrapper)this.componentHashTables[3].get(componentName);
                if (result != null) break;
                System.out.println("Classload error; Can't load REFER_CORE  " + current.getComponentName() + "because referenced component " + componentName + " not found");
                result = new CoreWrapper(componentName);
                result.setWrong();
                if (this.clusterType.equals("Dispatcher")) {
                    ComponentFactory.addDispatcherHashCores(result);
                    break;
                }
                ComponentFactory.addServerHashCores(result);
                break;
            }
            case 4: {
                result = (ComponentWrapper)this.componentHashTables[4].get(componentName);
                if (result != null) break;
                System.out.println("Classload error; Can't load REFER_APPLICATION  " + current.getComponentName() + "because referenced component " + componentName + " not found");
                result = new CoreWrapper(componentName);
                result.setWrong();
                ComponentFactory.addServerHashApplications(result);
            }
        }
        return result;
    }

    private void addCycle(Vector cycle) {
        int i = 0;
        while (i < cycle.size()) {
            if (this.cycles.contains(cycle)) {
                return;
            }
            this.rotate(cycle);
            ++i;
        }
        System.out.println("cycle added!");
        this.cycles.add(cycle);
    }

    private void rotate(Vector vector) {
        Object obj = vector.remove(0);
        vector.add(obj);
    }

    private void printCycle(Vector cycle) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ID000513: Cycle in hard references found: ");
        int i = 0;
        while (i < cycle.size()) {
            ComponentWrapper cw = (ComponentWrapper)cycle.get(i);
            String type = cw instanceof InterfaceWrapper ? "interface:" : (cw instanceof LibraryWrapper ? "library:" : (cw instanceof ServiceWrapper ? "service:" : (cw instanceof CoreWrapper ? "core:" : "application:")));
            buffer.append(type + cw.getComponentName() + " --> ");
            ++i;
        }
        System.out.println(buffer.toString());
    }
}

