/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectSerializer {
    static final int MAX_LEN = 1024;

    public static byte[] getByteArray(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
            oos.close();
        }
        catch (Exception ex) {
            oos.close();
            throw ex;
        }
        return baos.toByteArray();
    }

    public static Object getObject(byte[] obj) throws Exception {
        return ObjectSerializer.getObject(obj, 0, obj.length);
    }

    public static Object getObject(byte[] obj, int offset, int length) throws Exception {
        if (obj == null) {
            return null;
        }
        return ObjectSerializer.getObject(new ByteArrayInputStream(obj, offset, length));
    }

    public static Object getObject(ByteArrayInputStream bais) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object object = null;
        try {
            object = ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            ois.close();
            throw ex;
        }
        return object;
    }

    public static Object getObject(InputStream is) throws Exception {
        if (is == null) {
            return null;
        }
        byte[] byteRead = new byte[1024];
        byte[] result = new byte[]{};
        byte[] temp = new byte[]{};
        int current = -1;
        while ((current = is.read(byteRead)) > -1) {
            temp = result;
            result = new byte[temp.length + current];
            int i = 0;
            while (i < temp.length) {
                result[i] = temp[i];
                ++i;
            }
            int i2 = 0;
            while (i2 < current) {
                result[i2 + temp.length] = byteRead[i2];
                ++i2;
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(result, 0, result.length);
        return ObjectSerializer.getObject(bais);
    }
}

