/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.utils;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarExtractor {
    protected File jarFile = null;
    protected String outputDirectory = null;

    public JarExtractor() {
    }

    public JarExtractor(String jar) {
        this.setJarFile(jar);
    }

    public JarExtractor(String jar, String outputDir) {
        this.setJarFile(jar);
        this.setOutputDirectory(outputDir);
    }

    public void setJarFile(String jar) {
        if (jar == null) {
            return;
        }
        this.jarFile = new File(jar);
    }

    public void setOutputDirectory(String outputDir) {
        this.outputDirectory = outputDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractJar(String jarName, String outputDir) throws IOException {
        JarFile zip;
        block8: {
            block7: {
                if (jarName == null) return;
                if (outputDir == null) {
                    return;
                }
                zip = new JarFile(jarName);
                try {
                    File dir = new File(outputDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!dir.isDirectory()) {
                        Object var9_5 = null;
                        break block7;
                    }
                    Enumeration<JarEntry> enumeration = zip.entries();
                    String entryName = null;
                    JarEntry theEntry = null;
                    while (true) {
                        if (!enumeration.hasMoreElements()) {
                            break block8;
                        }
                        theEntry = enumeration.nextElement();
                        entryName = theEntry.getName();
                        if (entryName == null) continue;
                        this.extractFile(zip, entryName, outputDir);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    zip.close();
                    throw throwable;
                }
            }
            zip.close();
            return;
        }
        Object var9_6 = null;
        zip.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractJarEntry(String jarName, String outputDir, String entry) throws IOException {
        JarFile zip;
        block8: {
            block7: {
                if (jarName == null) return;
                if (outputDir == null) {
                    return;
                }
                zip = new JarFile(jarName);
                try {
                    File dir = new File(outputDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!dir.isDirectory()) {
                        Object var10_6 = null;
                        break block7;
                    }
                    Enumeration<JarEntry> enumeration = zip.entries();
                    String entryName = null;
                    JarEntry theEntry = null;
                    while (true) {
                        if (!enumeration.hasMoreElements()) {
                            break block8;
                        }
                        theEntry = enumeration.nextElement();
                        entryName = theEntry.getName();
                        if (entryName == null || !entry.equalsIgnoreCase(entryName)) continue;
                        this.extractFile(zip, entryName, outputDir);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    zip.close();
                    throw throwable;
                }
            }
            zip.close();
            return;
        }
        Object var10_7 = null;
        zip.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractJar(String jarName, String outputDir, Vector filters) throws IOException {
        JarFile zip;
        block9: {
            block8: {
                if (jarName == null) return;
                if (outputDir == null) {
                    return;
                }
                zip = new JarFile(jarName);
                try {
                    File dir = new File(outputDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!dir.isDirectory()) {
                        Object var12_6 = null;
                        break block8;
                    }
                    Enumeration<JarEntry> enumeration = zip.entries();
                    String entryName = null;
                    String ext = null;
                    int index = -1;
                    JarEntry theEntry = null;
                    while (true) {
                        if (!enumeration.hasMoreElements()) {
                            break block9;
                        }
                        ext = null;
                        index = -1;
                        theEntry = enumeration.nextElement();
                        entryName = theEntry.getName();
                        index = entryName.lastIndexOf(".");
                        if (index > 0) {
                            ext = entryName.substring(index);
                        }
                        if (entryName == null || ext == null || !filters.contains(ext) || theEntry.isDirectory()) continue;
                        this.extractFile(zip, entryName, outputDir);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    zip.close();
                    throw throwable;
                }
            }
            zip.close();
            return;
        }
        Object var12_7 = null;
        zip.close();
    }

    public void extractFile(JarFile zipf, String entryName, String dir) throws IOException {
        JarEntry tempent;
        if (zipf == null) {
            throw new IllegalArgumentException("Can not extract zip file, that is null.");
        }
        if (entryName == null) {
            throw new IllegalArgumentException("Can not extract zip entry, that is null.");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Can not extract zip file to directory that is null.");
        }
        String fName = entryName;
        fName = fName.replace('/', File.separatorChar);
        fName = fName.replace('\\', File.separatorChar);
        File f = new File(dir + File.separator + fName);
        if (f.isDirectory()) {
            return;
        }
        File parent = f.getParentFile();
        parent.mkdirs();
        JarEntry entry = (JarEntry)zipf.getEntry(entryName);
        if (entry == null) {
            entry = (JarEntry)zipf.getEntry(entryName.replace('\\', '/'));
        }
        if (entry == null) {
            entry = (JarEntry)zipf.getEntry(entryName.replace('/', '\\'));
        }
        if ((tempent = new JarEntry(entry)) == null || tempent.isDirectory()) {
            return;
        }
        BufferedInputStream in = new BufferedInputStream(zipf.getInputStream(tempent));
        FileOutputStream fos = new FileOutputStream(f);
        int count = 1024;
        byte[] buff = new byte[count];
        try {
            while (count == 1024) {
                count = ((InputStream)in).read(buff);
                if (count <= 0) continue;
                fos.write(buff, 0, count);
            }
            ((InputStream)in).close();
            fos.flush();
            fos.close();
        }
        catch (EOFException ex) {
            buff = new byte[(int)tempent.getSize()];
            ((InputStream)in).read(buff);
            ((InputStream)in).close();
            fos.flush();
            fos.close();
        }
    }

    public void extractFile(JarFile zipf, String fName, String dir, String relativeFileName) throws IOException {
        if (zipf == null) {
            throw new IllegalArgumentException("Can not extract zip file, that is null.");
        }
        if (fName == null) {
            throw new IllegalArgumentException("Can not extract zip entry, that is null.");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Can not extract zip file to directory that is null.");
        }
        if (relativeFileName == null) {
            throw new IllegalArgumentException("Can not extract zip file to relative file name that is null.");
        }
        fName = fName.replace('\\', '/');
        String relative = relativeFileName.replace('/', File.separatorChar);
        relative = relativeFileName.replace('\\', File.separatorChar);
        File f = new File(dir + File.separator + relative);
        JarEntry entry = (JarEntry)zipf.getEntry(fName);
        if (entry.isDirectory()) {
            return;
        }
        File parent = f.getParentFile();
        parent.mkdirs();
        BufferedInputStream in = new BufferedInputStream(zipf.getInputStream(entry));
        FileOutputStream fos = new FileOutputStream(f);
        int count = 0;
        byte[] buff = new byte[1024];
        try {
            while ((count = ((InputStream)in).read(buff)) > 0) {
                fos.write(buff, 0, count);
            }
            ((InputStream)in).close();
            fos.flush();
            fos.close();
        }
        catch (EOFException ex) {
            ((InputStream)in).close();
            fos.flush();
            fos.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractJar() throws IOException {
        JarFile jFile;
        block8: {
            block7: {
                if (this.jarFile == null) return;
                if (this.outputDirectory == null) {
                    return;
                }
                jFile = new JarFile(this.jarFile);
                try {
                    File dir = new File(this.outputDirectory);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!dir.isDirectory()) {
                        Object var7_3 = null;
                        break block7;
                    }
                    Enumeration<JarEntry> enumeration = jFile.entries();
                    String entryName = null;
                    JarEntry theEntry = null;
                    while (true) {
                        if (!enumeration.hasMoreElements()) {
                            break block8;
                        }
                        theEntry = enumeration.nextElement();
                        entryName = theEntry.getName();
                        if (entryName == null) continue;
                        this.extractFile(jFile, entryName, this.outputDirectory);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    jFile.close();
                    throw throwable;
                }
            }
            jFile.close();
            return;
        }
        Object var7_4 = null;
        jFile.close();
    }
}

