/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import com.sap.engine.tools.refsviewer.core.container.ApplicationMode;
import com.sap.engine.tools.refsviewer.core.container.PersistancePropertyFactory;
import com.sap.engine.tools.refsviewer.gui.ClassloaderMonitorFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PropertiesDialog
extends JDialog
implements WindowListener,
ActionListener {
    private static final String OFFLINE_FILE_MODE_STRING = "File mode";
    private static final String OFFLINE_DB_MODE_STRING = "DB mode - RECOMMENDABLE";
    private static final String OK_ACTION = "OK";
    private static final String CANCEL_ACTION = "CANCEL";
    private JTextField dirToCluster = null;
    private JTextField rdbmsUrl = null;
    private JTextField rdbmsDriver = null;
    private JTextField rdbmsUser = null;
    private JTextField rdbmsPassword = null;
    private JTextField tempDir = null;
    private JRadioButton offlineFileMode = null;
    private JRadioButton offlineDBMode = null;
    private static final String DIR_TO_CLUSTER_LABEL = "Directory to cluster elements(servers & dispatchers) : ";
    private static final String RDBMS_URL_LABEL = "Rdbms url : ";
    private static final String RDBMS_DRIVER_LABEL = "Rdbms driver : ";
    private static final String RDBMS_USER_LABEL = "Rdbms user : ";
    private static final String RDBMS_PASSWORD_LABEL = "Rdbms password : ";
    private static final String TEMP_DIR_LABEL = "Temp directory for jars from DB : ";
    private static final String PATH_TO_SYSTEM_PROPERTIES = "./rdb.properties";
    private File fileSystemProperties = new File("./rdb.properties");
    private Properties systemProperties = null;
    private ClassloaderMonitorFrame ownerFrame = null;

    public PropertiesDialog(JFrame ownerFrame) {
        super((Frame)ownerFrame, true);
        this.ownerFrame = (ClassloaderMonitorFrame)ownerFrame;
        this.setTitle("Choose a mode ...");
        this.loadConstantsFromPropertiesFile();
        this.initView();
    }

    private void loadConstantsFromPropertiesFile() {
        if (this.systemProperties != null) {
            return;
        }
        this.systemProperties = new Properties();
        try {
            this.systemProperties.load(new FileInputStream(this.fileSystemProperties));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        ButtonGroup bg = new ButtonGroup();
        this.offlineFileMode = new JRadioButton(OFFLINE_FILE_MODE_STRING);
        this.offlineFileMode.setActionCommand(OFFLINE_FILE_MODE_STRING);
        this.offlineFileMode.addActionListener(this);
        bg.add(this.offlineFileMode);
        this.offlineDBMode = new JRadioButton(OFFLINE_DB_MODE_STRING);
        this.offlineDBMode.setActionCommand(OFFLINE_DB_MODE_STRING);
        this.offlineDBMode.addActionListener(this);
        bg.add(this.offlineDBMode);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridLayout(0, 1));
        radioPanel.add(this.offlineFileMode);
        radioPanel.add(this.offlineDBMode);
        JPanel radioPanel1 = new JPanel();
        radioPanel1.setLayout(new BorderLayout());
        radioPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Please select necessary mode"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        radioPanel1.add((Component)radioPanel, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)radioPanel1, "North");
        JPanel textPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        textPanel.setLayout(gridbag);
        String dirToClusterString = "";
        String rdbmsUrlString = "";
        String rdbmsDriverString = "";
        String rdbmsUserString = "";
        String rdbmsPasswordString = "";
        dirToClusterString = this.systemProperties.getProperty("DIR_TO_CLUSTER", "D:\\develop\\AppServer\\dev\\bin\\cluster");
        rdbmsUrlString = this.systemProperties.getProperty("rdbms.url", "jdbc:sapdb://localhost/tst");
        rdbmsDriverString = this.systemProperties.getProperty("rdbms.driverLocation", "C:/Program Files/sapdb/j2ee/sapdbc.jar");
        rdbmsUserString = this.systemProperties.getProperty("rdbms.user", "test");
        rdbmsPasswordString = this.systemProperties.getProperty("rdbms.password", "test");
        PersistancePropertyFactory.tempDirectory = this.systemProperties.getProperty("TEMP_DIR", PersistancePropertyFactory.tempDirectory);
        this.dirToCluster = new JTextField(20);
        this.dirToCluster.setText(dirToClusterString);
        this.dirToCluster.setEditable(false);
        this.dirToCluster.addActionListener(this);
        JLabel textFieldLabelDirToCluster = new JLabel(DIR_TO_CLUSTER_LABEL);
        textFieldLabelDirToCluster.setLabelFor(this.dirToCluster);
        this.rdbmsUrl = new JTextField(20);
        this.rdbmsUrl.setText(rdbmsUrlString);
        this.rdbmsUrl.setEditable(false);
        this.rdbmsUrl.addActionListener(this);
        JLabel textFieldLabelRdbmsUrl = new JLabel(RDBMS_URL_LABEL);
        textFieldLabelRdbmsUrl.setLabelFor(this.rdbmsUrl);
        this.rdbmsDriver = new JTextField(20);
        this.rdbmsDriver.setText(rdbmsDriverString);
        this.rdbmsDriver.setEditable(false);
        this.rdbmsDriver.addActionListener(this);
        JLabel textFieldLabelRdbmsDriver = new JLabel(RDBMS_DRIVER_LABEL);
        textFieldLabelRdbmsDriver.setLabelFor(this.rdbmsDriver);
        this.rdbmsUser = new JTextField(20);
        this.rdbmsUser.setText(rdbmsUserString);
        this.rdbmsUser.setEditable(false);
        this.rdbmsUser.addActionListener(this);
        JLabel textFieldLabelRdbmsUser = new JLabel(RDBMS_USER_LABEL);
        textFieldLabelRdbmsUser.setLabelFor(this.rdbmsUser);
        this.rdbmsPassword = new JTextField(20);
        this.rdbmsPassword.setText(rdbmsPasswordString);
        this.rdbmsPassword.setEditable(false);
        this.rdbmsPassword.addActionListener(this);
        JLabel textFieldLabelRdbmsPassword = new JLabel(RDBMS_PASSWORD_LABEL);
        textFieldLabelRdbmsPassword.setLabelFor(this.rdbmsPassword);
        this.tempDir = new JTextField(20);
        this.tempDir.setText(PersistancePropertyFactory.tempDirectory);
        this.tempDir.setEditable(false);
        this.tempDir.addActionListener(this);
        JLabel textFieldLabelTempDir = new JLabel(TEMP_DIR_LABEL);
        textFieldLabelTempDir.setLabelFor(this.tempDir);
        JLabel[] labels = new JLabel[]{textFieldLabelDirToCluster, textFieldLabelRdbmsUrl, textFieldLabelRdbmsDriver, textFieldLabelRdbmsUser, textFieldLabelRdbmsPassword, textFieldLabelTempDir};
        JTextField[] textFields = new JTextField[]{this.dirToCluster, this.rdbmsUrl, this.rdbmsDriver, this.rdbmsUser, this.rdbmsPassword, this.tempDir};
        this.addLabelTextRows(labels, textFields, gridbag, textPanel);
        textPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("System properties"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.getContentPane().add((Component)textPanel, "Center");
        JPanel buttonPanel = new JPanel();
        JButton buttonOK = new JButton(OK_ACTION);
        buttonOK.setActionCommand(OK_ACTION);
        buttonOK.addActionListener(this);
        buttonPanel.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.setActionCommand(CANCEL_ACTION);
        buttonCancel.addActionListener(this);
        buttonPanel.add(buttonCancel);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.addWindowListener(this);
    }

    protected Image loadImage(String name) {
        try {
            URL url = this.getClass().getResource(name);
            return this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OFFLINE_FILE_MODE_STRING)) {
            this.dirToCluster.setEditable(true);
            this.rdbmsUrl.setEditable(false);
            this.rdbmsDriver.setEditable(false);
            this.rdbmsUser.setEditable(false);
            this.rdbmsPassword.setEditable(false);
            this.tempDir.setEditable(false);
        } else if (cmd.equals(OFFLINE_DB_MODE_STRING)) {
            this.dirToCluster.setEditable(false);
            this.rdbmsUrl.setEditable(true);
            this.rdbmsDriver.setEditable(true);
            this.rdbmsUser.setEditable(true);
            this.rdbmsPassword.setEditable(true);
            this.tempDir.setEditable(true);
        } else if (cmd.equals(OK_ACTION)) {
            if (this.isSelectedItem()) {
                this.notViewWithSave();
            } else {
                JOptionPane.showMessageDialog(this, "Please select one of possible mode !!!", "Select mode ...", -1);
            }
        } else if (cmd.equals(CANCEL_ACTION)) {
            this.notViewWithOutSave();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private void addLabelTextRows(JLabel[] labels, JTextField[] textFields, GridBagLayout gridbag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        int i = 0;
        while (i < numLabels) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridbag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(textFields[i], c);
            container.add(textFields[i]);
            ++i;
        }
    }

    public void notViewWithSave() {
        try {
            this.systemProperties.setProperty("DIR_TO_CLUSTER", this.getDirectoryToClusterFiles());
            this.systemProperties.setProperty("rdbms.url", this.getRdbmsUrl());
            this.systemProperties.setProperty("rdbms.driverLocation", this.getRdbmsDriver());
            this.systemProperties.setProperty("rdbms.user", this.getRdbmsUser());
            this.systemProperties.setProperty("rdbms.password", this.getRdbmsPassword());
            this.systemProperties.setProperty("TEMP_DIR", this.getTempDir());
            PersistancePropertyFactory.setSystemProperties(this.systemProperties);
            ApplicationMode am = new ApplicationMode(true, true);
            if (this.offlineDBMode.isSelected()) {
                am.fileMode = false;
                am.offLine = true;
            }
            this.ownerFrame.drawClassloadersPanel(am);
            FileOutputStream fos = new FileOutputStream(this.fileSystemProperties);
            this.systemProperties.store(fos, "");
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((Component)this).setVisible(false);
    }

    private void notViewWithOutSave() {
        ((Component)this).setVisible(false);
    }

    public String getDirectoryToClusterFiles() {
        return this.dirToCluster.getText();
    }

    public String getRdbmsUrl() {
        return this.rdbmsUrl.getText();
    }

    public String getRdbmsDriver() {
        return this.rdbmsDriver.getText();
    }

    public String getRdbmsUser() {
        return this.rdbmsUser.getText();
    }

    public String getRdbmsPassword() {
        return this.rdbmsPassword.getText();
    }

    public String getTempDir() {
        return this.tempDir.getText();
    }

    private boolean isSelectedItem() {
        return this.offlineFileMode.isSelected() || this.offlineDBMode.isSelected();
    }
}

