/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ComponentView
extends JLabel {
    public Color colorNode = null;
    public boolean isPaintParentOfCentral = true;

    public ComponentView(String name, Color colorNode, MouseListener owner) {
        super("  " + name + "  ");
        this.colorNode = colorNode;
        this.setHorizontalTextPosition(0);
        this.setFont(UIManager.getFont("Table.font"));
        this.addMouseListener(owner);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension dim = this.getSize();
        g.setColor(this.getForeground());
        g.drawRoundRect(0, 0, dim.width - 1, dim.height - 1, 5, 5);
    }

    public Point getPoint(Component component, int position) {
        Container parent = this.getParent();
        Point point = null;
        Rectangle rec = this.getBounds();
        if (position == 0) {
            point = new Point((int)(rec.getX() + rec.getWidth() / 2.0), (int)(rec.getY() - 1.0));
        } else if (position == 2) {
            point = new Point((int)(rec.getX() - 1.0), (int)(rec.getY() + rec.getHeight() / 2.0));
        } else if (position == 3) {
            point = new Point((int)(rec.getX() + rec.getWidth()), (int)(rec.getY() + rec.getHeight() / 2.0));
        } else if (position == 4) {
            point = new Point((int)(rec.getX() + rec.getWidth() / 2.0), (int)(rec.getY() + rec.getHeight()));
        }
        if (parent == component) {
            return point;
        }
        return SwingUtilities.convertPoint(parent, point, component);
    }
}

