/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import com.sap.engine.tools.refsviewer.gui.ImageHolder;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class ComponentTreeRenderer
extends JLabel
implements TreeCellRenderer {
    public ComponentTreeRenderer() {
        this.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)value;
        int level = dmtn.getLevel();
        Object node = dmtn.getUserObject();
        this.setText(node.toString());
        String tmpString = (String)node;
        if (level == 0) {
            this.setIcon(ImageHolder.clusterIcon);
        } else if (level == 1) {
            if (tmpString.equals("Dispatcher")) {
                this.setIcon(ImageHolder.dispatcherIcon);
            } else {
                this.setIcon(ImageHolder.serverIcon);
            }
        } else if (level == 2) {
            this.setIcon(ImageHolder.serviceGroupIcon);
        } else if (level == 3) {
            this.setIcon(ImageHolder.serviceIcon);
        } else if (level == 4) {
            this.setIcon(ImageHolder.archiveIcon);
        } else if (level == 5) {
            this.setIcon(ImageHolder.packageIcon);
        } else if (level == 6) {
            this.setIcon(ImageHolder.classIcon);
        } else {
            this.setIcon(null);
        }
        this.setBackground(sel ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(sel ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }
}

