/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import com.sap.engine.tools.refsviewer.core.container.ComponentFactory;
import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;
import com.sap.engine.tools.refsviewer.gui.CLArrowView;
import com.sap.engine.tools.refsviewer.gui.CLComponentView;
import com.sap.engine.tools.refsviewer.gui.ComponentTreeNode;
import com.sap.engine.tools.refsviewer.gui.ComponentTreePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public abstract class ClassLoadersPane
extends JPanel
implements MouseListener,
ActionListener {
    public static final int UP = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int DOWN = 4;
    public static final int ARROW_SOFT = 1;
    public static final int ARROW_HARD = 0;
    public static final int ARROW_NOTIFY = 2;
    public static final int ARROW_PARENT = 3;
    public static final int ARROW_CICLIC = 4;
    public static final int ARROW_OTHER = 5;
    protected static Color[] arrowColor = new Color[6];
    protected Vector components = new Vector();
    protected Vector arrows = new Vector();
    private Vector actionListeners = new Vector();
    public int marginX = 10;
    public int marginY = 20;
    protected int componentWidth = 50;
    protected int componentHeight = 20;
    private FontMetrics fontMetrics = null;
    private CLComponentView selectionComponent = null;
    private Color selectionColor = new Color(92, 92, 255);
    private Color oldColor;
    private ComponentWrapper cw = null;
    private String clusterType = null;

    public ClassLoadersPane() {
        this.setPreferredSize(new Dimension(500, 500));
        this.addActionListener(this);
        this.initDefaults();
    }

    public ClassLoadersPane(ComponentWrapper cw) {
        this.setPreferredSize(new Dimension(500, 500));
        this.cw = cw;
        this.initDefaults();
        this.addActionListener(this);
        this.initComponents(cw, "Server");
    }

    public abstract void initComponents(ComponentWrapper var1, String var2);

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        StringTokenizer st = new StringTokenizer(cmd, ":");
        String tmpType = null;
        String tmpName = null;
        if (st.hasMoreTokens()) {
            tmpType = st.nextToken().trim();
            if (this.isContainerType(tmpType)) {
                if (st.hasMoreTokens()) {
                    tmpName = st.nextToken().trim();
                    if (this.clusterType.equals("Server")) {
                        this.initComponents(ComponentFactory.getServerComponentWrapperByName(tmpName, tmpType), "Server");
                    } else {
                        this.initComponents(ComponentFactory.getDispatcherComponentWrapperByName(tmpName, tmpType), "Dispatcher");
                    }
                }
                if (ComponentTreePanel.tree != null) {
                    TreePath tp = null;
                    ComponentTreeNode rootNode = (ComponentTreeNode)ComponentTreePanel.model.getRoot();
                    int rootChildCount = ComponentTreePanel.model.getChildCount(rootNode);
                    int i = 0;
                    while (i < rootChildCount) {
                        Object tmpNode = ComponentTreePanel.model.getChild(rootNode, i);
                        if (tmpNode.toString().equalsIgnoreCase(this.clusterType)) {
                            int childOfContainerTypeCount = ComponentTreePanel.model.getChildCount(tmpNode);
                            int j = 0;
                            while (j < childOfContainerTypeCount) {
                                Object childOfContainer = ComponentTreePanel.model.getChild(tmpNode, j);
                                if (childOfContainer.toString().equalsIgnoreCase(tmpType)) {
                                    int childOfTypeCount = ComponentTreePanel.model.getChildCount(childOfContainer);
                                    int c = 0;
                                    while (c < childOfTypeCount) {
                                        Object component = ComponentTreePanel.model.getChild(childOfContainer, c);
                                        if (component.toString().equalsIgnoreCase(tmpName)) {
                                            Object[] objArr = new Object[]{rootNode, tmpNode, childOfContainer, component};
                                            tp = new TreePath(objArr);
                                            ComponentTreePanel.tree.expandPath(tp);
                                            ComponentTreePanel.tree.setSelectionPath(tp);
                                            return;
                                        }
                                        ++c;
                                    }
                                }
                                ++j;
                            }
                            break;
                        }
                        ++i;
                    }
                }
                return;
            }
            return;
        }
    }

    private boolean isContainerType(String strType) {
        if (strType.equalsIgnoreCase("Interfaces")) {
            return true;
        }
        if (strType.equalsIgnoreCase("Libraries")) {
            return true;
        }
        if (strType.equalsIgnoreCase("Services")) {
            return true;
        }
        return strType.equalsIgnoreCase("Applications");
    }

    protected void initDefaults() {
        ClassLoadersPane.setArrowColor(1, new Color(0, 130, 50));
        ClassLoadersPane.setArrowColor(0, new Color(100, 50, 50));
        ClassLoadersPane.setArrowColor(2, Color.cyan);
        ClassLoadersPane.setArrowColor(3, new Color(0, 0, 150));
        ClassLoadersPane.setArrowColor(4, Color.red);
        ClassLoadersPane.setArrowColor(5, Color.yellow);
        this.setBackground(Color.white);
        this.setLayout(new GridBagLayout());
        this.addMouseListener(this);
    }

    public void removeAll() {
        super.removeAll();
        this.components.clear();
        this.arrows.clear();
        this.reloadModel();
    }

    public void addCLComponent(String name, int position) {
        this.components.add(new CLComponentView(name, position));
        this.reloadModel();
    }

    public void addArrow(String from, String to, int type) {
        this.reloadModel();
    }

    public void removeCLComponent(String name) {
        CLComponentView comp = this.getComponentView(name);
        if (comp == null) {
            return;
        }
        this.components.remove(comp);
        this.reloadModel();
    }

    public void removeArrow(String from, String to) {
        CLArrowView comp = this.getArrowView(from, to);
        if (comp == null) {
            return;
        }
        this.arrows.remove(comp);
        this.reloadModel();
    }

    public static void setArrowColor(int type, Color color) {
        if (type >= 0 && type < arrowColor.length) {
            ClassLoadersPane.arrowColor[type] = color;
        }
    }

    public static Color getArrowColor(int type) {
        if (type >= 0 && type < arrowColor.length) {
            return arrowColor[type];
        }
        return arrowColor[5];
    }

    public void setCLComponentColor(String name, Color color) {
        CLComponentView comp = this.getComponentView(name);
        if (comp == null) {
            return;
        }
        comp.setColor(color);
        this.repaint();
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    protected void fireActionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(i)).actionPerformed(e);
            ++i;
        }
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int i = 0;
        while (i < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i);
            if (comp.isContain(x, y)) {
                if (this.selectionComponent != null) {
                    this.selectionComponent.setColor(this.oldColor);
                }
                this.selectionComponent = comp;
                this.oldColor = this.selectionComponent.getColor();
                this.selectionComponent.setColor(this.selectionColor);
                this.repaint();
                if (e.getClickCount() >= 2) {
                    ActionEvent event = new ActionEvent(comp, 1001, comp.toString());
                    this.fireActionPerformed(event);
                }
                return;
            }
            ++i;
        }
        if (this.selectionComponent != null) {
            this.selectionComponent.setColor(this.oldColor);
            this.repaint();
        }
        this.selectionComponent = null;
        this.oldColor = null;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    protected void reloadModel() {
        int rightDown;
        int up = 0;
        int left = 0;
        int right = 0;
        int down = 0;
        int center = 0;
        this.calculateFontMetrics();
        int x = this.getHeight() / 2;
        int y = this.marginY;
        int i = 0;
        while (i < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i);
            if (comp.position == 0) {
                ++up;
                comp.y = y;
                y += this.marginY + this.componentHeight;
            }
            ++i;
        }
        int upDown = y;
        int i2 = 0;
        while (i2 < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i2);
            if (comp.position == 2) {
                ++left;
                comp.y = y;
                y += this.marginY + this.componentHeight;
            }
            ++i2;
        }
        int leftDown = y;
        y = upDown;
        int i3 = 0;
        while (i3 < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i3);
            if (comp.position == 3) {
                ++right;
                comp.y = y;
                y += this.marginY + this.componentHeight;
            }
            ++i3;
        }
        if (left == 0 && right == 0) {
            y += this.marginY + this.componentHeight;
        }
        y = (rightDown = y) < leftDown ? leftDown : rightDown;
        y = (y - upDown) / 2 + upDown - this.componentHeight;
        int i4 = 0;
        while (i4 < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i4);
            if (comp.position == 1) {
                ++center;
                comp.y = y;
            }
            ++i4;
        }
        y = rightDown < leftDown ? leftDown : rightDown;
        int i5 = 0;
        while (i5 < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i5);
            if (comp.position == 4) {
                ++down;
                comp.y = y;
            }
            ++i5;
        }
        if (down == 0) {
            down = 1;
        }
        y += this.marginY + this.componentHeight;
        int deltaX = 0;
        if (down < 2) {
            deltaX = this.componentWidth / 2;
        }
        int prefX = (this.sign(left + 1) + this.sign(center + up) + this.sign(right + 1)) * (this.marginX + this.componentWidth) + down * (this.marginX + this.componentWidth) - this.componentWidth + 2 * deltaX;
        x = this.marginX + this.componentWidth + this.marginX + deltaX;
        int i6 = 0;
        while (i6 < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i6);
            if (comp.position == 0) {
                comp.x = (prefX - this.componentWidth) / 2;
            }
            if (comp.position == 2) {
                comp.x = this.marginX;
            }
            if (comp.position == 3) {
                comp.x = prefX - this.componentWidth - this.marginX;
            }
            if (comp.position == 1) {
                comp.x = (prefX - this.componentWidth) / 2;
            }
            if (comp.position == 4) {
                comp.x = x;
                x += this.marginX + this.componentWidth;
            }
            ++i6;
        }
        this.setPreferredSize(new Dimension(prefX, y));
        int i7 = 0;
        while (i7 < this.arrows.size()) {
            CLArrowView arrow = (CLArrowView)this.arrows.elementAt(i7);
            CLComponentView from = this.getComponentView(arrow.from);
            CLComponentView to = this.getComponentView(arrow.to);
            if (from != null && to != null) {
                Point p;
                if (from.position == 0 && to.position == 0) {
                    if (this.before(arrow.from, arrow.to) == 1) {
                        p = from.getDownPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getUpPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else {
                        p = to.getDownPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getUpPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    }
                } else if (from.position == 1) {
                    if (to.position == 0) {
                        p = to.getDownPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getUpPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    } else if (to.position == 2) {
                        p = to.getRightPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getLeftPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    } else if (to.position == 3) {
                        p = from.getRightPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getLeftPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else if (to.position == 4) {
                        p = from.getDownPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getUpPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    }
                } else if (to.position == 1) {
                    if (from.position == 0) {
                        p = from.getDownPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getUpPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else if (from.position == 2) {
                        p = from.getRightPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getLeftPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else if (from.position == 3) {
                        p = to.getRightPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getLeftPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    } else if (from.position == 4) {
                        p = to.getDownPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getUpPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    }
                } else if (from.position == 2 || to.position == 2 || from.position == 3 || to.position == 3 || from.position == 4 || from.position == 2) {
                    // empty if block
                }
            }
            ++i7;
        }
        this.repaint();
        this.validate();
    }

    protected CLComponentView getComponentView(String name) {
        int i = 0;
        while (i < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i);
            if (comp.toString().equals(name)) {
                return comp;
            }
            ++i;
        }
        return null;
    }

    protected CLArrowView getArrowView(String from, String to) {
        int i = 0;
        while (i < this.components.size()) {
            CLArrowView comp = (CLArrowView)this.components.elementAt(i);
            if (comp.from.equals(from) && comp.to.equals(to)) {
                return comp;
            }
            ++i;
        }
        return null;
    }

    protected int before(String name1, String name2) {
        int i = 0;
        while (i < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i);
            if (comp.toString().equals(name1)) {
                return 1;
            }
            if (comp.toString().equals(name2)) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private int sign(int value) {
        if (value == 0) {
            return 0;
        }
        if (value < 0) {
            return -1;
        }
        return 1;
    }

    protected void calculateFontMetrics() {
        if (this.fontMetrics == null) {
            return;
        }
        int width = 0;
        int i = 0;
        while (i < this.components.size()) {
            String name = this.components.elementAt(i).toString();
            if (width < this.fontMetrics.stringWidth(name)) {
                width = this.fontMetrics.stringWidth(name);
            }
            ++i;
        }
        this.componentWidth = width + 10;
        this.componentHeight = this.fontMetrics.getHeight() + 4;
        this.marginX = this.fontMetrics.stringWidth("m");
        this.marginY = this.fontMetrics.getHeight();
        CLComponentView.w = this.componentWidth;
        CLComponentView.h = this.componentHeight;
    }

    public void setFont(Font font) {
        this.fontMetrics = null;
        super.setFont(font);
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setFont(this.getFont());
        if (this.fontMetrics == null) {
            this.fontMetrics = g.getFontMetrics();
            this.reloadModel();
        }
        int width = this.getHeight();
        int height = this.getWidth();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, height, width);
        int i = 0;
        while (i < this.components.size()) {
            CLComponentView comp = (CLComponentView)this.components.elementAt(i);
            comp.paint(g);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.arrows.size()) {
            CLArrowView arrow = (CLArrowView)this.arrows.elementAt(i2);
            arrow.paint(g);
            ++i2;
        }
    }
}

