/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import com.sap.engine.tools.refsviewer.core.container.ArrayFactory;
import com.sap.engine.tools.refsviewer.core.container.ComponentFactory;
import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;
import com.sap.engine.tools.refsviewer.core.container.ContainerConstants;
import com.sap.engine.tools.refsviewer.core.container.Reference;
import com.sap.engine.tools.refsviewer.gui.ClassLoaderPaneView;
import com.sap.engine.tools.refsviewer.gui.ClassLoadersPaneNode;
import com.sap.engine.tools.refsviewer.gui.ComponentTreeNode;
import com.sap.engine.tools.refsviewer.gui.ComponentTreePanel;
import com.sap.engine.tools.refsviewer.gui.ComponentView;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.tree.TreePath;

public class ClassLoaderPaneLogical
extends ClassLoaderPaneView {
    private Set hardReferers = new HashSet();
    private Set notifyReferers = new HashSet();
    private Set centerSet = null;
    private ComponentWrapper cwLastSelected = null;
    private String clusterType;

    private void initCenterSet() {
        this.centerSet = ComponentFactory.getClassloaderAreaOfComponent(this.cwLastSelected, this.clusterType);
    }

    public void initComponents(ComponentWrapper cw, String clusterType) {
        boolean flag = false;
        if (cw == null) {
            return;
        }
        this.cwLastSelected = cw;
        this.removeAll();
        this.clusterType = clusterType;
        if (this.centerSet != null && this.clusterType.equals(clusterType) && this.centerSet.contains(cw)) {
            flag = true;
        } else {
            this.initCenterSet();
        }
        ComponentView comp = new ComponentView("Cores : " + ContainerConstants.CORE_ELEMENTS[0], null, this);
        this.addComponent(comp, 0);
        comp = new ComponentView("Cores : " + ContainerConstants.CORE_ELEMENTS[1], null, this);
        if (ContainerConstants.CORE_ELEMENTS[0].equals(cw.getComponentName()) || ContainerConstants.CORE_ELEMENTS[1].equals(cw.getComponentName())) {
            comp.isPaintParentOfCentral = false;
            this.addComponent(comp, 0);
            return;
        }
        this.addComponent(comp, 0);
        if (this.centerSet != null) {
            Iterator iter = this.centerSet.iterator();
            while (iter.hasNext()) {
                ComponentWrapper tmp = (ComponentWrapper)iter.next();
                String cwStringMain = tmp.getType() + " : " + tmp.getComponentName();
                comp = cw.equals(tmp) ? new ComponentView(cwStringMain, ClassLoaderPaneView.selectedColor, this) : new ComponentView(cwStringMain, null, this);
                this.addComponent(comp, 1);
            }
        } else {
            String cwStringMain = cw.getType() + " : " + cw.getComponentName();
            comp = new ComponentView(cwStringMain, ClassLoaderPaneView.selectedColor, this);
            this.addComponent(comp, 1);
        }
        ArrayFactory af = new ArrayFactory(cw, this.centerSet, clusterType);
        String refsName = "";
        int i = 0;
        if (clusterType.equals("Server")) {
            ClassLoadersPaneNode[] usedNodes;
            ClassLoadersPaneNode[] dependNode = af.getServerDependComponents();
            if (dependNode != null) {
                Reference tmpDependRef = null;
                i = 0;
                while (i < dependNode.length) {
                    tmpDependRef = dependNode[i].getReference();
                    refsName = tmpDependRef.getReferentTypeAsString() + " : " + tmpDependRef.getName();
                    comp = new ComponentView(refsName, dependNode[i].getNodeColor(), this);
                    this.addComponent(comp, 2);
                    this.checkReferenceType(comp, tmpDependRef.getType());
                    ++i;
                }
            }
            if ((usedNodes = af.getServerUsedComponents()) != null) {
                Reference tmpUsedRef = null;
                i = 0;
                while (i < usedNodes.length) {
                    tmpUsedRef = usedNodes[i].getReference();
                    refsName = tmpUsedRef.getReferentTypeAsString() + " : " + tmpUsedRef.getName();
                    comp = new ComponentView(refsName, usedNodes[i].getNodeColor(), this);
                    this.addComponent(comp, 3);
                    this.checkReferenceType(comp, tmpUsedRef.getType());
                    ++i;
                }
            }
        } else {
            ClassLoadersPaneNode[] usedNodes;
            ClassLoadersPaneNode[] dependNodes = af.getDispatcherDependComponents();
            if (dependNodes != null) {
                Reference tmpDependRef = null;
                i = 0;
                while (i < dependNodes.length) {
                    tmpDependRef = dependNodes[i].getReference();
                    refsName = tmpDependRef.getReferentTypeAsString() + " : " + tmpDependRef.getName();
                    comp = new ComponentView(refsName, dependNodes[i].getNodeColor(), this);
                    this.addComponent(comp, 2);
                    this.checkReferenceType(comp, tmpDependRef.getType());
                    ++i;
                }
            }
            if ((usedNodes = af.getDispatcherUsedComponents()) != null) {
                Reference tmpUsedNodes = null;
                i = 0;
                while (i < usedNodes.length) {
                    tmpUsedNodes = usedNodes[i].getReference();
                    refsName = tmpUsedNodes.getReferentTypeAsString() + " : " + tmpUsedNodes.getName();
                    comp = new ComponentView(refsName, usedNodes[i].getNodeColor(), this);
                    this.addComponent(comp, 3);
                    this.checkReferenceType(comp, tmpUsedNodes.getType());
                    ++i;
                }
            }
        }
        this.repaint();
        this.validate();
        this.updateUI();
    }

    public void removaAll() {
        super.removeAll();
        this.hardReferers.clear();
        this.notifyReferers.clear();
    }

    private boolean isContainerType(String strType) {
        if (strType.equalsIgnoreCase("Interfaces")) {
            return true;
        }
        if (strType.equalsIgnoreCase("Libraries")) {
            return true;
        }
        if (strType.equalsIgnoreCase("Services")) {
            return true;
        }
        if (strType.equalsIgnoreCase("Cores")) {
            return true;
        }
        return strType.equalsIgnoreCase("Applications");
    }

    protected void checkReferenceType(ComponentView comp, int type) {
        if (type == 0) {
            this.hardReferers.add(comp);
        } else if (type == 2) {
            this.notifyReferers.add(comp);
        }
    }

    protected int getReferenceType(ComponentView comp) {
        if (this.hardReferers.contains(comp)) {
            return 0;
        }
        if (this.notifyReferers.contains(comp)) {
            return 2;
        }
        return 1;
    }

    public void mouseClicked(MouseEvent e) {
        if (!(e.getSource() instanceof ComponentView)) {
            return;
        }
        ComponentView cv = (ComponentView)e.getSource();
        if (e.getSource() == this) {
            this.clearSelection();
        } else {
            this.setSelectedComponent(cv);
        }
        StringTokenizer st = new StringTokenizer(cv.getText().trim(), ":");
        String tmpType = null;
        String tmpName = null;
        if (st.hasMoreTokens()) {
            tmpType = st.nextToken().trim();
            if (this.isContainerType(tmpType)) {
                if (st.hasMoreTokens()) {
                    tmpName = st.nextToken().trim();
                    if (this.centerSet == null) {
                        this.initCenterSet();
                    }
                    if (this.clusterType.equals("Server")) {
                        this.cwLastSelected = ComponentFactory.getServerComponentWrapperByName(tmpName, tmpType);
                        if (!this.centerSet.contains(this.cwLastSelected)) {
                            this.initComponents(this.cwLastSelected, "Server");
                        }
                    } else {
                        this.cwLastSelected = ComponentFactory.getDispatcherComponentWrapperByName(tmpName, tmpType);
                        if (!this.centerSet.contains(this.cwLastSelected)) {
                            this.initComponents(this.cwLastSelected, "Dispatcher");
                        }
                    }
                }
                if (ComponentTreePanel.tree != null) {
                    TreePath tp = null;
                    ComponentTreeNode rootNode = (ComponentTreeNode)ComponentTreePanel.model.getRoot();
                    int rootChildCount = ComponentTreePanel.model.getChildCount(rootNode);
                    int i = 0;
                    while (i < rootChildCount) {
                        Object tmpNode = ComponentTreePanel.model.getChild(rootNode, i);
                        if (tmpNode.toString().equalsIgnoreCase(this.clusterType)) {
                            int childOfContainerTypeCount = ComponentTreePanel.model.getChildCount(tmpNode);
                            int j = 0;
                            while (j < childOfContainerTypeCount) {
                                Object childOfContainer = ComponentTreePanel.model.getChild(tmpNode, j);
                                if (childOfContainer.toString().equalsIgnoreCase(tmpType)) {
                                    int childOfTypeCount = ComponentTreePanel.model.getChildCount(childOfContainer);
                                    int c = 0;
                                    while (c < childOfTypeCount) {
                                        Object component = ComponentTreePanel.model.getChild(childOfContainer, c);
                                        if (component.toString().equalsIgnoreCase(tmpName)) {
                                            Object[] objArr = new Object[]{rootNode, tmpNode, childOfContainer, component};
                                            tp = new TreePath(objArr);
                                            ComponentTreePanel.tree.expandPath(tp);
                                            ComponentTreePanel.tree.setSelectionPath(tp);
                                            return;
                                        }
                                        ++c;
                                    }
                                }
                                ++j;
                            }
                            break;
                        }
                        ++i;
                    }
                }
                return;
            }
            return;
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

