/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class CLArrowView {
    public static int BLADE_SIZE = 10;
    public static double BLADE_EANGLE = 0.3141592653589793;
    protected int lengthArrow = 10;
    protected String from;
    protected String to;
    protected int type;
    protected Color color = Color.black;
    protected int x1 = 0;
    protected int y1 = 0;
    protected int x2 = 0;
    protected int y2 = 0;

    public CLArrowView(int x1, int y1, int x2, int y2, Color color) {
        this.setPosition(x1, y1, x2, y2);
        this.setColor(color);
    }

    public CLArrowView(Point from, Point to, Color color) {
        this.setPosition((int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY());
        this.setColor(color);
    }

    public void setPosition(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        g.drawLine(this.x1, this.y1, this.x2, this.y2);
        this.drawBlade(g, this.x1, this.y1, this.x2, this.y2);
    }

    protected void drawBlade(Graphics g, int x1, int y1, int x2, int y2) {
        double eangle = 1.5707963267948966 - Math.atan2(x2 - x1, y2 - y1);
        int x = x2 - (int)(Math.cos(eangle + BLADE_EANGLE) * (double)BLADE_SIZE);
        int y = y2 - (int)(Math.sin(eangle + BLADE_EANGLE) * (double)BLADE_SIZE);
        g.drawLine(x2, y2, x, y);
        x = x2 - (int)(Math.cos(eangle - BLADE_EANGLE) * (double)BLADE_SIZE);
        y = y2 - (int)(Math.sin(eangle - BLADE_EANGLE) * (double)BLADE_SIZE);
        g.drawLine(x2, y2, x, y);
    }
}

