/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.core.container.offline;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.frame.core.configuration.admin.PropertySheetExtension;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.tools.refsviewer.core.container.ApplicationWrapper;
import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;
import com.sap.engine.tools.refsviewer.core.container.ContainerConstants;
import com.sap.engine.tools.refsviewer.core.container.ContainerException;
import com.sap.engine.tools.refsviewer.core.container.CoreWrapper;
import com.sap.engine.tools.refsviewer.core.container.InterfaceWrapper;
import com.sap.engine.tools.refsviewer.core.container.LibraryWrapper;
import com.sap.engine.tools.refsviewer.core.container.PersistancePropertyFactory;
import com.sap.engine.tools.refsviewer.core.container.PersistenceContainerInterface;
import com.sap.engine.tools.refsviewer.core.container.ServiceWrapper;
import com.sap.engine.tools.refsviewer.utils.ObjectSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PersistentContainerOffline
implements EntityResolver,
PersistenceContainerInterface {
    public static final String CONFIG_ROOT = "cluster_data";
    public static final String CFG_BASE = "/cfg";
    public static final String SHARED_BASE = "/bin";
    private static final String PERSISTENT_BASE = "/persistent";
    private static String DTD_BASE = null;
    public static final byte CFG = 0;
    public static final byte BIN = 1;
    public static final String[] DESTINATIONS = new String[]{"dispatcher", "server"};
    public static final String PROVIDER = "provider.xml";
    public static final String RUNTIME_PROPS = "runtime.properties";
    public static final String PROPS = "properties";
    private File interfaceConfigDirectory;
    private File libraryConfigDirectory;
    private File serviceConfigDirectory;
    private File interfaceBinDirectory;
    private File libraryBinDirectory;
    private File serviceBinDirectory;
    private File coreBinDirectory;
    private StandardDOMParser domParser;
    private byte containerType;
    public static boolean fileMode = true;
    private String defaultReferencesString = null;
    private ConfigurationManagerBootstrapImpl cm = null;

    public PersistentContainerOffline(File configDirectory, File binDirectory, byte containerType, boolean isFile) throws ContainerException, IOException {
        this.containerType = containerType;
        fileMode = isFile;
        if (fileMode) {
            this.interfaceConfigDirectory = new File(configDirectory, "interfaces/");
            this.libraryConfigDirectory = new File(configDirectory, "ext/");
            this.serviceConfigDirectory = new File(configDirectory, "services/");
            this.interfaceBinDirectory = new File(binDirectory, "interfaces/");
            this.libraryBinDirectory = new File(binDirectory, "ext/");
            this.serviceBinDirectory = new File(binDirectory, "services/");
            if (!this.interfaceConfigDirectory.exists()) {
                System.out.println("Interface config directory " + this.getCanonicalFileName(this.interfaceConfigDirectory) + " doesn't exists");
            }
            if (!this.libraryConfigDirectory.exists()) {
                System.out.println("Library config directory " + this.getCanonicalFileName(this.libraryConfigDirectory) + " doesn't exists");
            }
            if (!this.serviceConfigDirectory.exists()) {
                System.out.println("Service config directory " + this.getCanonicalFileName(this.serviceConfigDirectory) + " doesn't exists");
            }
            if (!this.interfaceBinDirectory.exists()) {
                System.out.println("Interface bin directory " + this.getCanonicalFileName(this.interfaceConfigDirectory) + " doesn't exists");
            }
            if (!this.libraryBinDirectory.exists()) {
                System.out.println("Library bin directory " + this.getCanonicalFileName(this.libraryConfigDirectory) + " doesn't exists");
            }
            if (!this.serviceBinDirectory.exists()) {
                System.out.println("Service bin directory " + this.getCanonicalFileName(this.serviceConfigDirectory) + " doesn't exists");
            }
            DTD_BASE = PersistancePropertyFactory.getServerDirectory() + "/dtd";
        } else {
            try {
                this.cm = new ConfigurationManagerBootstrapImpl(PersistancePropertyFactory.getSystemProperties());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String tempDtdDirectory = PersistancePropertyFactory.tempDirectory + "/dtd";
            ConfigurationHandler handler = null;
            try {
                try {
                    handler = this.cm.getConfigurationHandler();
                    Configuration cfg = handler.openConfiguration("cluster_data/" + this.getElementType() + "/dtd", 0);
                    this.getDirFromDB(tempDtdDirectory, cfg);
                }
                catch (ConfigurationException e) {
                    throw new ContainerException("Can't load configuration for dtd. Nested exception is:\n" + ((Throwable)((Object)e)).toString());
                }
                catch (IOException ioe) {
                    throw new IOException("Can't create temp dtd directory " + tempDtdDirectory + " Nested exception is:\n" + ioe.toString());
                }
                Object var10_11 = null;
                this.closeConfigurationHandler(handler);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.closeConfigurationHandler(handler);
                throw throwable;
            }
            DTD_BASE = tempDtdDirectory;
        }
        this.domParser = new StandardDOMParser();
        this.domParser.setEntityResolver((EntityResolver)this);
        try {
            this.domParser.setValidation(true);
        }
        catch (SAXException e) {
            System.out.println("Can't turn on dom parser validation");
        }
    }

    public Hashtable createInterfaces() {
        return this.createComponents(this.interfaceConfigDirectory, "cluster_data/" + this.getElementType() + "/cfg/interfaces", (byte)100);
    }

    public Hashtable createLibraries() {
        return this.createComponents(this.libraryConfigDirectory, "cluster_data/" + this.getElementType() + "/cfg/ext", (byte)101);
    }

    public Hashtable createServices() {
        return this.createComponents(this.serviceConfigDirectory, "cluster_data/" + this.getElementType() + "/cfg/services", (byte)102);
    }

    public Hashtable createApplications() {
        Hashtable<String, ComponentWrapper> result;
        block16: {
            result = new Hashtable<String, ComponentWrapper>();
            if (fileMode) {
                Properties p = new Properties();
                try {
                    FileInputStream fis = new FileInputStream(PersistancePropertyFactory.getServerDirectory() + "/cfg/services/deploy.properties");
                    p.load(fis);
                    String appDir = p.getProperty("Applications_Folder", "./apps");
                    this.defaultReferencesString = p.getProperty("StandardApplicationReferences", "");
                    File serverApps = new File(PersistancePropertyFactory.getServerDirectory(), appDir);
                    if (serverApps.exists() && serverApps.isDirectory()) {
                        File[] providersDirs = serverApps.listFiles();
                        int i = 0;
                        while (i < providersDirs.length) {
                            File[] appsDirs = providersDirs[i].listFiles();
                            int j = 0;
                            while (j < appsDirs.length) {
                                if (appsDirs[j].isDirectory()) {
                                    String name = providersDirs[i].getName() + "/" + appsDirs[j].getName();
                                    ComponentWrapper tmpCW = this.createComponentWrapper(name, (byte)104);
                                    result.put(tmpCW.getComponentName(), tmpCW);
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ContainerException e) {
                    e.printStackTrace();
                }
            } else {
                ConfigurationHandlerExtension handler = null;
                try {
                    try {
                        handler = (ConfigurationHandlerExtension)this.cm.getConfigurationHandler();
                        ConfigurationExtension configuration = handler.openConfigurationExtension("apps", 0);
                        String[] subConfProviders = configuration.getAllSubConfigurationNames();
                        configuration.close();
                        int i = 0;
                        while (i < subConfProviders.length) {
                            ConfigurationExtension providerConfiguration = handler.openConfigurationExtension("apps/" + subConfProviders[i], 0);
                            String[] providerApps = providerConfiguration.getAllSubConfigurationNames();
                            providerConfiguration.close();
                            int j = 0;
                            while (j < providerApps.length) {
                                ConfigurationExtension appConfiguration = handler.openConfigurationExtension("apps/" + subConfProviders[i] + "/" + providerApps[j], 0);
                                String name = (String)appConfiguration.getConfigEntry("STR:ApplicationName");
                                ComponentWrapper tmpCW = this.createComponentWrapper(name, (byte)104);
                                result.put(tmpCW.getComponentName(), tmpCW);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (ConfigurationException e) {
                        e.printStackTrace();
                        Object var13_27 = null;
                        this.closeConfigurationHandler(handler);
                        break block16;
                    }
                    catch (ContainerException e) {
                        e.printStackTrace();
                        Object var13_28 = null;
                        this.closeConfigurationHandler(handler);
                    }
                    Object var13_26 = null;
                    this.closeConfigurationHandler(handler);
                }
                catch (Throwable throwable) {
                    Object var13_29 = null;
                    this.closeConfigurationHandler(handler);
                    throw throwable;
                }
            }
        }
        return result;
    }

    public Hashtable createCores() {
        Hashtable<String, ComponentWrapper> result = new Hashtable<String, ComponentWrapper>();
        try {
            int i = 0;
            while (i < ContainerConstants.CORE_ELEMENTS.length) {
                result.put(ContainerConstants.CORE_ELEMENTS[i], this.createComponentWrapper(ContainerConstants.CORE_ELEMENTS[i], (byte)103));
                ++i;
            }
        }
        catch (ContainerException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Hashtable createComponents(File componentConfigDirectory, String componentConfigConfiguration, byte componentType) {
        Hashtable<String, ComponentWrapper> result;
        block19: {
            block18: {
                result = new Hashtable<String, ComponentWrapper>();
                if (!fileMode) break block18;
                if (componentType == 101) {
                    try {
                        result.put("core_lib", this.createComponentWrapper("core_lib", componentType));
                    }
                    catch (ContainerException e) {
                        e.log();
                    }
                }
                if (!componentConfigDirectory.exists()) break block19;
                File[] files = componentConfigDirectory.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isFile() && files[i].getName().toLowerCase().endsWith("-provider.xml")) {
                        String name = this.getComponentName(files[i]);
                        try {
                            ComponentWrapper tmpCW = this.createComponentWrapper(name, componentType);
                            result.put(tmpCW.getComponentName(), tmpCW);
                        }
                        catch (ContainerException e) {
                            e.log();
                        }
                    }
                    ++i;
                }
                break block19;
            }
            ConfigurationHandler handler = null;
            try {
                try {
                    handler = this.cm.getConfigurationHandler();
                    Configuration cfg = handler.openConfiguration(componentConfigConfiguration, 0);
                    String[] files = cfg.getAllFileEntryNames();
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].toLowerCase().endsWith("-provider.xml")) {
                            String name = files[i].substring(0, files[i].lastIndexOf("-"));
                            try {
                                ComponentWrapper tmpCW = this.createComponentWrapper(name, componentType);
                                result.put(tmpCW.getComponentName(), tmpCW);
                            }
                            catch (ContainerException e) {
                                e.log();
                            }
                        }
                        ++i;
                    }
                    if (componentType == 101) {
                        try {
                            result.put("core_lib", this.createComponentWrapper("core_lib", componentType));
                        }
                        catch (ContainerException e) {
                            e.log();
                        }
                    }
                    Object var12_20 = null;
                    this.closeConfigurationHandler(handler);
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                    System.out.println("Detailed info is: " + ((Throwable)((Object)e)).toString());
                    Object var12_21 = null;
                    this.closeConfigurationHandler(handler);
                }
            }
            catch (Throwable throwable) {
                Object var12_22 = null;
                this.closeConfigurationHandler(handler);
                throw throwable;
            }
        }
        return result;
    }

    InterfaceWrapper createInterfaceWrapper(String interfaceName) throws ContainerException {
        InterfaceWrapper result = null;
        if (fileMode) {
            File providerXML = new File(this.interfaceConfigDirectory, interfaceName + "-provider.xml");
            if (providerXML.exists()) {
                Document document = this.parseDocument(providerXML);
                result = new InterfaceWrapper(interfaceName, document);
            } else {
                result = new InterfaceWrapper(interfaceName, null);
            }
        } else {
            ConfigurationHandler handler = null;
            try {
                block9: {
                    try {
                        handler = this.cm.getConfigurationHandler();
                        Configuration cfg = handler.openConfiguration("cluster_data/" + this.getElementType() + "/cfg/interfaces", 0);
                        if (cfg.existsFile(interfaceName + "-provider.xml")) {
                            Document document = this.parseDocument(cfg.getFile(interfaceName + "-provider.xml"));
                            result = new InterfaceWrapper(interfaceName, document);
                            break block9;
                        }
                        result = new InterfaceWrapper(interfaceName, null);
                    }
                    catch (ConfigurationException e) {
                        throw new ContainerException("Interface " + interfaceName + " error. Nested exception is:\n" + ((Throwable)((Object)e)).toString());
                    }
                }
                Object var7_9 = null;
                this.closeConfigurationHandler(handler);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.closeConfigurationHandler(handler);
                throw throwable;
            }
        }
        return result;
    }

    LibraryWrapper createLibraryWrapper(String libraryName) throws ContainerException {
        LibraryWrapper result = null;
        File providerXML = new File(this.libraryConfigDirectory, libraryName + "-provider.xml");
        if (fileMode) {
            if (libraryName.equals("core_lib")) {
                result = new LibraryWrapper(libraryName, null);
                File f = null;
                f = this.containerType == 2 ? new File(PersistancePropertyFactory.getBinServerDirectory() + "/" + "core_lib") : new File(PersistancePropertyFactory.getBinDispatcherDirectory() + "/" + "core_lib");
                result.jars = f.list();
            } else if (providerXML.exists()) {
                Document document = this.parseDocument(providerXML);
                result = new LibraryWrapper(libraryName, document);
            } else {
                result = new LibraryWrapper(libraryName, null);
            }
        } else {
            ConfigurationHandler handler = null;
            try {
                block12: {
                    try {
                        handler = this.cm.getConfigurationHandler();
                        Configuration cfg = null;
                        if (libraryName.equals("core_lib")) {
                            result = new LibraryWrapper(libraryName, null);
                            cfg = handler.openConfiguration("cluster_data/" + this.getElementType() + "/bin/" + "core_lib", 0);
                            String[] core_libJars = cfg.getAllFileEntryNames();
                            result.jars = core_libJars;
                            break block12;
                        }
                        cfg = handler.openConfiguration("cluster_data/" + this.getElementType() + "/cfg/ext", 0);
                        if (cfg.existsFile(libraryName + "-provider.xml")) {
                            Document document = this.parseDocument(cfg.getFile(libraryName + "-provider.xml"));
                            result = new LibraryWrapper(libraryName, document);
                            break block12;
                        }
                        result = new LibraryWrapper(libraryName, null);
                    }
                    catch (ConfigurationException e) {
                        throw new ContainerException("Library " + libraryName + " error. Nested exception is:\n" + ((Throwable)((Object)e)).toString());
                    }
                }
                Object var8_11 = null;
                this.closeConfigurationHandler(handler);
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.closeConfigurationHandler(handler);
                throw throwable;
            }
        }
        return result;
    }

    ServiceWrapper createServiceWrapper(String serviceName) throws ContainerException {
        ServiceWrapper result = null;
        if (fileMode) {
            File providerXML = new File(this.serviceConfigDirectory, serviceName + "-provider.xml");
            if (providerXML.exists()) {
                Document document = this.parseDocument(providerXML);
                result = new ServiceWrapper(serviceName, document);
            } else {
                result = new ServiceWrapper(serviceName, null);
            }
        } else {
            ConfigurationHandler handler = null;
            try {
                block9: {
                    try {
                        handler = this.cm.getConfigurationHandler();
                        Configuration cfg = handler.openConfiguration("cluster_data/" + this.getElementType() + "/cfg/services", 0);
                        if (cfg.existsFile(serviceName + "-provider.xml")) {
                            Document document = this.parseDocument(cfg.getFile(serviceName + "-provider.xml"));
                            result = new ServiceWrapper(serviceName, document);
                            break block9;
                        }
                        result = new ServiceWrapper(serviceName, null);
                    }
                    catch (ConfigurationException e) {
                        throw new ContainerException("Service " + serviceName + " error. Nested exception is:\n" + ((Throwable)((Object)e)).toString());
                    }
                }
                Object var7_9 = null;
                this.closeConfigurationHandler(handler);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.closeConfigurationHandler(handler);
                throw throwable;
            }
        }
        return result;
    }

    ApplicationWrapper createApplicationWrapper(String appName) throws ContainerException {
        ApplicationWrapper appWrapperResult = null;
        if (fileMode) {
            appWrapperResult = new ApplicationWrapper(appName, this.defaultReferencesString, null);
        } else {
            ConfigurationHandlerExtension handler = null;
            try {
                block7: {
                    try {
                        handler = (ConfigurationHandlerExtension)this.cm.getConfigurationHandler();
                        ConfigurationExtension defaultDeployReferences = handler.openConfigurationExtension("cluster_data/server/cfg/services/deploy", 0);
                        PropertySheetExtension pse = defaultDeployReferences.getPropertySheetExtensionInterface();
                        this.defaultReferencesString = (String)pse.getPropertyEntry("StandardApplicationReferences").getValue();
                        ConfigurationExtension appConfiguration = handler.openConfigurationExtension("apps/" + appName, 0);
                        if (appConfiguration.existsFile("HASH_STR_STR:Reference_type")) {
                            InputStream iStream = appConfiguration.getFile("HASH_STR_STR:Reference_type");
                            String[] str = (String[])ObjectSerializer.getObject(iStream);
                            appWrapperResult = new ApplicationWrapper(appName, this.defaultReferencesString, str);
                            break block7;
                        }
                        appWrapperResult = new ApplicationWrapper(appName, this.defaultReferencesString, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ContainerException("ID000589: Application " + appName + " error. Nested exception is:\n" + e.toString());
                    }
                }
                Object var10_10 = null;
                this.closeConfigurationHandler(handler);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.closeConfigurationHandler(handler);
                throw throwable;
            }
        }
        return appWrapperResult;
    }

    CoreWrapper createCoreWrapper(String coreName) throws ContainerException {
        CoreWrapper coreWrapperResult = null;
        if (fileMode) {
            File f = null;
            f = this.containerType == 2 ? new File(PersistancePropertyFactory.getBinServerDirectory() + "/" + coreName) : new File(PersistancePropertyFactory.getBinDispatcherDirectory() + "/" + coreName);
            coreWrapperResult = new CoreWrapper(coreName, f.list());
        } else {
            ConfigurationHandler handler = null;
            try {
                try {
                    handler = this.cm.getConfigurationHandler();
                    Configuration cfg = null;
                    cfg = handler.openConfiguration("cluster_data/" + this.getElementType() + "/bin/" + coreName, 0);
                    String[] core_libJars = cfg.getAllFileEntryNames();
                    coreWrapperResult = new CoreWrapper(coreName, core_libJars);
                }
                catch (ConfigurationException e) {
                    throw new ContainerException("Core " + coreName + " error. Nested exception is:\n" + ((Throwable)((Object)e)).toString());
                }
                Object var7_8 = null;
                this.closeConfigurationHandler(handler);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.closeConfigurationHandler(handler);
                throw throwable;
            }
        }
        return coreWrapperResult;
    }

    ComponentWrapper createComponentWrapper(String componentName, byte componentType) throws ContainerException {
        ComponentWrapper result = null;
        switch (componentType) {
            case 100: {
                result = this.createInterfaceWrapper(componentName);
                break;
            }
            case 101: {
                result = this.createLibraryWrapper(componentName);
                break;
            }
            case 102: {
                result = this.createServiceWrapper(componentName);
                break;
            }
            case 104: {
                result = this.createApplicationWrapper(componentName);
                break;
            }
            case 103: {
                result = this.createCoreWrapper(componentName);
            }
        }
        return result;
    }

    String gt(byte t) {
        switch (t) {
            case 100: {
                return "/interfaces";
            }
            case 101: {
                return "/ext";
            }
            case 102: {
                return "/services";
            }
        }
        return "";
    }

    void downloadInterface(String interfaceName) throws ContainerException {
        this.download(interfaceName, (byte)100);
    }

    void downloadLibrary(String libraryName) throws ContainerException {
        this.download(libraryName, (byte)101);
    }

    void downloadService(String serviceName) throws ContainerException {
        this.download(serviceName, (byte)102);
    }

    void downloadComponent(String componentName, byte componentType) throws ContainerException {
        this.download(componentName, componentType);
    }

    private void download(String componentName, byte componentType) throws ContainerException {
        ConfigurationHandler handler = null;
        try {
            try {
                try {
                    handler = this.cm.getConfigurationHandler();
                    Configuration cR = this.getRootConfiguration(handler, CONFIG_ROOT, 0);
                    String dst = this.getElementType();
                    if (dst == null) {
                        handler.commit();
                        throw new ContainerException("Can not find provider.xml in Jar file");
                    }
                    this.downloadDst(componentName, componentType, dst, cR);
                    Object var7_8 = null;
                    handler.closeAllConfigurations();
                }
                catch (Exception exc) {
                    handler.rollback();
                    throw new ContainerException(exc.toString());
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                handler.closeAllConfigurations();
                throw throwable;
            }
        }
        catch (ConfigurationException exc) {
            throw new ContainerException(((Throwable)((Object)exc)).toString());
        }
    }

    private void downloadDst(String componentName, byte componentType, String destination, Configuration cR) throws ContainerException, ConfigurationException {
        try {
            String[] jars;
            String fileName;
            String confEntryName;
            Configuration c = cR.getSubConfiguration(destination + CFG_BASE + this.gt(componentType));
            if (fileMode) {
                fileName = confEntryName = componentName + "-" + PROVIDER;
                this.getFileFromDB(c, confEntryName, this.getBaseDir(componentType, (byte)0), fileName);
            }
            if (componentType == 102) {
                if (fileMode) {
                    fileName = confEntryName = componentName + "-" + RUNTIME_PROPS;
                    this.getFileFromDB(c, confEntryName, this.getBaseDir(componentType, (byte)0), fileName);
                    fileName = confEntryName = componentName + "." + PROPS;
                    this.getFileFromDB(c, confEntryName, this.getBaseDir(componentType, (byte)0), fileName);
                }
                confEntryName = destination + PERSISTENT_BASE + "/" + componentName;
                try {
                    c = cR.getSubConfiguration(confEntryName);
                }
                catch (ConfigurationException e) {
                    c = null;
                }
                if (c != null) {
                    this.getDirFromDB("./persistent/" + componentName, c);
                }
            }
            confEntryName = componentName + "-" + PROVIDER;
            if (fileMode) {
                jars = this.getProviderJars(this.parseDocument(new File(this.getBaseDir(componentType, (byte)0) + "/" + confEntryName)));
            } else {
                InputStream is = this.getProviderStreamFromConfig(cR, destination + CFG_BASE + this.gt(componentType), confEntryName);
                if (is != null) {
                    jars = this.getProviderJars(this.parseDocument(is));
                } else {
                    return;
                }
            }
            c = cR.getSubConfiguration(destination + SHARED_BASE + this.gt(componentType));
            this.downloadJarEntries(c, jars, this.getBaseDir(componentType, (byte)1));
        }
        catch (IOException e) {
            throw new ContainerException(e.toString());
        }
    }

    private Document parseDocument(File xml) throws ContainerException {
        Document result;
        try {
            FileInputStream fis = new FileInputStream(xml);
            result = this.parseDocument(fis);
            fis.close();
        }
        catch (IOException e) {
            throw new ContainerException("ID000656: Parser exception occurs while parsing " + this.getCanonicalFileName(xml) + ". Detailed info is: " + e.getMessage());
        }
        return result;
    }

    private Document parseDocument(InputStream is) throws ContainerException {
        Document result = null;
        try {
            if (is != null) {
                result = this.domParser.parse(is);
            }
        }
        catch (Exception e) {
            throw new ContainerException("Parser exception occurs while parsing xml file. Detailed info is: " + e.getMessage());
        }
        return result;
    }

    private String getComponentName(File providerXML) {
        String fileName = providerXML.getName();
        return fileName.substring(0, fileName.lastIndexOf("-"));
    }

    private String getCanonicalFileName(File file) {
        String result = null;
        try {
            result = file.getCanonicalPath();
        }
        catch (IOException e) {
            result = file.getAbsolutePath();
        }
        return result;
    }

    private void closeConfigurationHandler(ConfigurationHandler handler) {
        try {
            handler.closeAllConfigurations();
        }
        catch (Exception e) {
            System.out.println("ID000666:  Error while handler.closeAllConfigurations() called. Detailed info is " + e.toString());
        }
    }

    private String[] getProviderJars(Document document) {
        Element baseElement = document.getDocumentElement();
        baseElement.normalize();
        NodeList list = baseElement.getChildNodes();
        Element element = null;
        String tag = null;
        String[] jars = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (tag = (element = (Element)list.item(i)).getTagName()).equals("jars")) {
                jars = this.parseJars(element);
            }
            ++i;
        }
        return jars;
    }

    private String[] parseJars(Element jars) {
        String[] result = null;
        String defaultJar = jars.getAttribute("default");
        if (defaultJar.equals("true")) {
            result = new String[]{};
        } else {
            NodeList jarList = jars.getElementsByTagName("jar-name");
            result = new String[jarList.getLength()];
            int i = 0;
            while (i < result.length) {
                Element jar = (Element)jarList.item(i);
                result[i] = this.getTextValue(jar);
                ++i;
            }
        }
        return result;
    }

    private String getTextValue(Element element) {
        Node node;
        String result = null;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            result = node.getNodeValue();
            result.trim();
            if (result.equals("") || result.equals("null")) {
                result = null;
            }
        }
        return result;
    }

    private File getBaseDir(byte componentType, byte baseType) {
        File result = null;
        switch (componentType) {
            case 100: {
                if (baseType == 0) {
                    result = this.interfaceConfigDirectory;
                    break;
                }
                result = this.interfaceBinDirectory;
                break;
            }
            case 101: {
                if (baseType == 0) {
                    result = this.libraryConfigDirectory;
                    break;
                }
                result = this.libraryBinDirectory;
                break;
            }
            case 102: {
                result = baseType == 0 ? this.serviceConfigDirectory : this.serviceBinDirectory;
            }
        }
        return result;
    }

    private String getElementType() {
        String result = null;
        switch (this.containerType) {
            case 2: {
                result = "server";
                break;
            }
            case 1: {
                result = "dispatcher";
            }
        }
        return result;
    }

    private Configuration getRootConfiguration(ConfigurationHandler handler, String configBase, int access) throws ConfigurationException {
        Configuration cR = null;
        try {
            int count = 5;
            boolean success = false;
            while (!success) {
                try {
                    cR = handler.createRootConfiguration(configBase);
                    success = true;
                }
                catch (ConfigurationLockedException e) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    if (--count != 0) continue;
                    throw e;
                }
            }
        }
        catch (NameAlreadyExistsException ex) {
            cR = handler.openConfiguration(configBase, access);
        }
        return cR;
    }

    private ZipEntry getZipEntry(ZipFile zipFile, String fname) throws ContainerException {
        ZipEntry entry = zipFile.getEntry(fname);
        if (entry == null) {
            throw new ContainerException("File " + fname + " not found in Jar!");
        }
        return entry;
    }

    public void getFileFromDB(String pathToComponent, String configEntryName, String baseDir, String fileName) {
        ConfigurationHandler handler = null;
        try {
            handler = this.cm.getConfigurationHandler();
            Configuration cfg = handler.openConfiguration(pathToComponent, 0);
            File f = new File(baseDir);
            if (!f.exists()) {
                f.mkdirs();
            }
            this.getFileFromDB(cfg, configEntryName, new File(baseDir), fileName);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getFileFromDB(Configuration c, String configEntryName, File baseDir, String fileName) throws ConfigurationException, IOException {
        FileOutputStream fileout = new FileOutputStream(new File(baseDir.getCanonicalPath(), fileName));
        InputStream in = c.getFile(configEntryName);
        byte[] buf = new byte[1024];
        int received = 0;
        while ((received = in.read(buf)) != -1) {
            fileout.write(buf, 0, received);
        }
        fileout.close();
    }

    private void getDirFromDB(String filename, Configuration config) throws IOException, ConfigurationException {
        Map fileEntries;
        File dir = new File(filename);
        if (dir.exists()) {
            dir.delete();
        }
        dir.mkdirs();
        Map subConfigs = config.getAllSubConfigurations();
        if (!subConfigs.isEmpty()) {
            Set keySet = subConfigs.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String nextSubName = (String)iter.next();
                Configuration subConfig = (Configuration)subConfigs.get(nextSubName);
                String subDir = filename + "/" + nextSubName;
                this.getDirFromDB(subDir, subConfig);
            }
        }
        if (!(fileEntries = config.getAllFileEntries()).isEmpty()) {
            Set keySet = fileEntries.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String nextFilename = (String)iter.next();
                this.getFileFromDB(config, nextFilename, new File(filename), nextFilename);
            }
        }
    }

    private void downloadJarEntries(Configuration c, String[] jars, File baseDir) throws ConfigurationException, IOException {
        int i = 0;
        while (i < jars.length) {
            FileOutputStream fileout = new FileOutputStream(baseDir.getAbsolutePath() + "/" + jars[i]);
            InputStream in = c.getFile(jars[i]);
            byte[] buf = new byte[1024];
            int received = 0;
            while ((received = in.read(buf)) != -1) {
                fileout.write(buf, 0, received);
            }
            fileout.close();
            ++i;
        }
    }

    private String[] getDestinationFromJar(File jar, String provider) throws IOException {
        Object[] result = null;
        Vector<String> v = new Vector<String>(3);
        ZipFile zipFile = new ZipFile(jar);
        int i = 0;
        while (i < DESTINATIONS.length) {
            String zipEntryName = DESTINATIONS[i] + "/" + provider;
            ZipEntry zipEntry = zipFile.getEntry(zipEntryName);
            if (zipEntry != null) {
                v.add(DESTINATIONS[i]);
            }
            ++i;
        }
        if (v.size() > 0) {
            result = new String[v.size()];
            v.copyInto(result);
        }
        return result;
    }

    private InputStream getProviderStreamFromConfig(Configuration cR, String destination, String provider) {
        InputStream result = null;
        try {
            Configuration c = cR.getSubConfiguration(destination);
            if (c.existsFile(provider)) {
                result = c.getFile(provider);
            }
        }
        catch (ConfigurationException exc) {
            exc.printStackTrace();
        }
        return result;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        File f = new File(DTD_BASE);
        String canonicName = null;
        try {
            canonicName = f.getCanonicalPath();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        FileInputStream in = new FileInputStream(canonicName + File.separator + systemId);
        InputSource src = new InputSource(in);
        src.setSystemId(systemId);
        return src;
    }
}

