/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.core.container;

import com.sap.engine.tools.refsviewer.core.container.ContainerConstants;

public class Reference {
    public static final byte REFER_INTERFACE = 0;
    public static final byte REFER_LIBRARY = 1;
    public static final byte REFER_SERVICE = 2;
    public static final byte REFER_CORE = 3;
    public static final byte REFER_APPLICATION = 4;
    public static final byte TYPE_HARD = 0;
    public static final byte TYPE_SOFT = 1;
    public static final byte TYPE_NOTIFY = 2;
    public static final byte TYPE_PARENT = 3;
    private String name;
    private byte referentType;
    private byte type;

    public Reference(String name, byte referentType, byte type) {
        if (name.startsWith("engine.sap.com/")) {
            name = name.substring("engine.sap.com/".length());
        }
        if (name.startsWith("sap.com/")) {
            name = name.substring("sap.com/".length());
        }
        this.name = name.replace('/', '~');
        this.referentType = referentType;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte getReferentType() {
        return this.referentType;
    }

    public String getReferentTypeAsString() {
        if (this.referentType == 0) {
            return "Interfaces";
        }
        if (this.referentType == 1) {
            return "Libraries";
        }
        if (this.referentType == 2) {
            return "Services";
        }
        if (this.referentType == 3) {
            return "Cores";
        }
        return "Applications";
    }

    public void setType(byte newType) {
        this.type = newType;
    }

    public byte getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.type == 1) {
            return "SOFT";
        }
        if (this.type == 0) {
            return "HARD";
        }
        return "NOTIFY";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Reference) {
            Reference r = (Reference)object;
            return this.name.equals(r.getName()) && this.referentType == r.getReferentType() && this.type == r.getType();
        }
        return false;
    }

    public static int compare(Reference arg1, Reference arg2) {
        if (arg1.getType() > arg2.getType()) {
            return -1;
        }
        if (arg1.getType() < arg2.getType()) {
            return 1;
        }
        if (arg1.getReferentType() > arg2.getReferentType()) {
            return -1;
        }
        if (arg1.getReferentType() < arg2.getReferentType()) {
            return 1;
        }
        return arg2.getName().compareTo(arg1.getName());
    }

    public String toString() {
        return "Reference :" + ContainerConstants.NL + "Name :" + this.name + " ReferentType :" + this.getReferentTypeAsString() + " Type :" + this.getTypeAsString();
    }
}

