/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.core.container;

import com.sap.engine.tools.refsviewer.core.container.ApplicationMode;
import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;
import com.sap.engine.tools.refsviewer.core.container.ContainerException;
import com.sap.engine.tools.refsviewer.core.container.PersistancePropertyFactory;
import com.sap.engine.tools.refsviewer.core.container.PersistenceContainerInterface;
import com.sap.engine.tools.refsviewer.core.container.offline.PersistentContainerOffline;
import com.sap.engine.tools.refsviewer.utils.ReferenceResolver;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class ComponentFactory {
    private static Hashtable hashServerInterfaces = null;
    private static Hashtable hashServerServices = null;
    private static Hashtable hashServerLibraries = null;
    private static Hashtable hashServerCores = null;
    private static Hashtable hashServerApplications = null;
    public static PersistenceContainerInterface persistentContainerServer = null;
    private static Hashtable hashDispatcherInterfaces = null;
    private static Hashtable hashDispatcherServices = null;
    private static Hashtable hashDispatcherLibraries = null;
    private static Hashtable hashDispatcherCores = null;
    public static PersistenceContainerInterface persistentContainerDispatcher = null;

    public static Hashtable getServerHashInterfaces() {
        return hashServerInterfaces;
    }

    public static Hashtable getServerHashServices() {
        return hashServerServices;
    }

    public static Hashtable getServerHashLibraries() {
        return hashServerLibraries;
    }

    public static Hashtable getServerHashCores() {
        return hashServerCores;
    }

    public static Hashtable getServerHashApplications() {
        return hashServerApplications;
    }

    public static void addServerHashInterfaces(ComponentWrapper cw) {
        hashServerInterfaces.put(cw.getComponentName(), cw);
    }

    public static void addServerHashServices(ComponentWrapper cw) {
        hashServerServices.put(cw.getComponentName(), cw);
    }

    public static void addServerHashLibraries(ComponentWrapper cw) {
        hashServerLibraries.put(cw.getComponentName(), cw);
    }

    public static void addServerHashCores(ComponentWrapper cw) {
        hashServerCores.put(cw.getComponentName(), cw);
    }

    public static void addServerHashApplications(ComponentWrapper cw) {
        hashServerApplications.put(cw.getComponentName(), cw);
    }

    public static Hashtable getDispatcherHashInterfaces() {
        return hashDispatcherInterfaces;
    }

    public static Hashtable getDispatcherHashServices() {
        return hashDispatcherServices;
    }

    public static Hashtable getDispatcherHashLibraries() {
        return hashDispatcherLibraries;
    }

    public static Hashtable getDispatcherHashCores() {
        return hashDispatcherCores;
    }

    public static void addDispatcherHashInterfaces(ComponentWrapper cw) {
        hashDispatcherInterfaces.put(cw.getComponentName(), cw);
    }

    public static void addDispatcherHashServices(ComponentWrapper cw) {
        hashDispatcherServices.put(cw.getComponentName(), cw);
    }

    public static void addDispatcherHashLibraries(ComponentWrapper cw) {
        hashDispatcherLibraries.put(cw.getComponentName(), cw);
    }

    public static void addDispatcherHashCores(ComponentWrapper cw) {
        hashDispatcherCores.put(cw.getComponentName(), cw);
    }

    public static Set getClassloaderAreaOfComponent(ComponentWrapper cw, String clusterType) {
        Set[] allAreas = ComponentFactory.getClassloadersAreas(clusterType);
        int i = 0;
        while (i < allAreas.length) {
            Set tmpSet = allAreas[i];
            Iterator iter = tmpSet.iterator();
            while (iter.hasNext()) {
                ComponentWrapper tmp = (ComponentWrapper)iter.next();
                if (!tmp.equals(cw)) continue;
                return tmpSet;
            }
            ++i;
        }
        return null;
    }

    public static Set[] getClassloadersAreas(String clusterType) {
        ReferenceResolver referenceResolver = null;
        referenceResolver = new ReferenceResolver(clusterType);
        referenceResolver.resolveReferences();
        if (!referenceResolver.findHardReferenceCycles()) {
            System.out.println("WARNING HARD REFERENCE CYCLE");
        }
        Set[] loaders = referenceResolver.findCommonLoaderAreas();
        return loaders;
    }

    public static void initInstance(ApplicationMode am) throws IOException, ContainerException {
        if (am.offLine) {
            persistentContainerServer = am.fileMode ? new PersistentContainerOffline(new File(PersistancePropertyFactory.getCfgServerDirectory()), new File(PersistancePropertyFactory.getBinServerDirectory()), 2, am.fileMode) : new PersistentContainerOffline(null, null, 2, am.fileMode);
            hashServerInterfaces = persistentContainerServer.createInterfaces();
            hashServerLibraries = persistentContainerServer.createLibraries();
            hashServerServices = persistentContainerServer.createServices();
            hashServerCores = persistentContainerServer.createCores();
            hashServerApplications = persistentContainerServer.createApplications();
            persistentContainerDispatcher = am.fileMode ? new PersistentContainerOffline(new File(PersistancePropertyFactory.getCfgDispatcherDirectory()), new File(PersistancePropertyFactory.getBinDispatcherDirectory()), 1, am.fileMode) : new PersistentContainerOffline(null, null, 1, am.fileMode);
            hashDispatcherInterfaces = persistentContainerDispatcher.createInterfaces();
            hashDispatcherLibraries = persistentContainerDispatcher.createLibraries();
            hashDispatcherServices = persistentContainerDispatcher.createServices();
            hashDispatcherCores = persistentContainerDispatcher.createCores();
        }
    }

    private static void printSetArray(Set[] loaders) {
        int i = 0;
        while (i < loaders.length) {
            Set tmpSet = loaders[i];
            Iterator iter = tmpSet.iterator();
            while (iter.hasNext()) {
                ComponentWrapper tmp = (ComponentWrapper)iter.next();
                System.out.println("ELEMENT " + i + " " + tmp.getComponentName());
            }
            ++i;
        }
    }

    public static ComponentWrapper getServerComponentWrapperByName(String name, String type) {
        ComponentWrapper cw = null;
        if (type.equalsIgnoreCase("Interfaces")) {
            cw = (ComponentWrapper)hashServerInterfaces.get(name);
        } else if (type.equalsIgnoreCase("Libraries")) {
            cw = (ComponentWrapper)hashServerLibraries.get(name);
        } else if (type.equalsIgnoreCase("Services")) {
            cw = (ComponentWrapper)hashServerServices.get(name);
        } else if (type.equalsIgnoreCase("Cores")) {
            cw = (ComponentWrapper)hashServerCores.get(name);
        } else if (type.equalsIgnoreCase("Applications")) {
            cw = (ComponentWrapper)hashServerApplications.get(name);
        }
        return cw;
    }

    public static ComponentWrapper getDispatcherComponentWrapperByName(String name, String type) {
        ComponentWrapper cw = null;
        name = name.toLowerCase();
        if (type.equalsIgnoreCase("Interfaces")) {
            cw = (ComponentWrapper)hashDispatcherInterfaces.get(name);
        } else if (type.equalsIgnoreCase("Libraries")) {
            cw = (ComponentWrapper)hashDispatcherLibraries.get(name);
        } else if (type.equalsIgnoreCase("Services")) {
            cw = (ComponentWrapper)hashDispatcherServices.get(name);
        } else if (type.equalsIgnoreCase("Cores")) {
            cw = (ComponentWrapper)hashDispatcherCores.get(name);
        }
        return cw;
    }

    public static ComponentWrapper[] getComponentWrapperArr(Hashtable hashTable) {
        ComponentWrapper[] cwArray = new ComponentWrapper[hashTable.size()];
        Enumeration keys = hashTable.keys();
        int iterator = 0;
        String currKey = null;
        while (keys.hasMoreElements()) {
            currKey = (String)keys.nextElement();
            ComponentWrapper cw = (ComponentWrapper)hashTable.get(currKey);
            cwArray[iterator++] = cw;
        }
        return ComponentFactory.sortArray(cwArray);
    }

    public static ComponentWrapper[] sortArray(ComponentWrapper[] array) {
        ComponentWrapper cwTmp = null;
        int i = 0;
        while (i < array.length - 1) {
            int j = i + 1;
            while (j < array.length) {
                if (array[i].getComponentName().compareTo(array[j].getComponentName()) > 0) {
                    cwTmp = array[i];
                    array[i] = array[j];
                    array[j] = cwTmp;
                }
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static void dumpHashTable(Hashtable hashTable) {
        ComponentWrapper[] cwArray = new ComponentWrapper[hashTable.size()];
        Enumeration keys = hashTable.keys();
        int iterator = 0;
        Object currKey = null;
        while (keys.hasMoreElements()) {
            currKey = keys.nextElement();
            ComponentWrapper cw = (ComponentWrapper)hashTable.get(currKey);
            cwArray[iterator++] = cw;
            System.out.println((Object)currKey);
        }
    }
}

