/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.core.container;

import com.sap.engine.tools.refsviewer.core.container.ComponentFactory;
import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;
import com.sap.engine.tools.refsviewer.core.container.Reference;
import com.sap.engine.tools.refsviewer.gui.ClassLoaderPaneView;
import com.sap.engine.tools.refsviewer.gui.ClassLoadersPaneNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class ArrayFactory {
    private Set centerSet = null;
    private ComponentWrapper mainCW = null;
    private String mainComponentName = null;
    private String mainComponentType = null;
    private String clusterType = null;

    public ArrayFactory(ComponentWrapper mainCW, Set centerSet, String clusterType) {
        this.mainCW = mainCW;
        this.centerSet = centerSet;
        this.clusterType = clusterType;
        this.mainComponentName = mainCW.getComponentName();
        this.mainComponentType = mainCW.getType();
    }

    private ArrayList getMainDepends() {
        ArrayList<ClassLoadersPaneNode> al = new ArrayList<ClassLoadersPaneNode>();
        Reference[] mainDepends = this.mainCW.getReferences();
        int i = 0;
        while (i < mainDepends.length) {
            if (!this.isReferenceToClasloader(mainDepends[i])) {
                al.add(new ClassLoadersPaneNode(mainDepends[i], ClassLoaderPaneView.referenceColor));
            }
            ++i;
        }
        return al;
    }

    private ArrayList getMainUsed() {
        ArrayList al = new ArrayList();
        int i = 0;
        int j = 0;
        Color colorOfComponent = null;
        if (this.clusterType.equals("Server")) {
            Reference ref;
            Reference[] tmpCWArray;
            ComponentWrapper[] cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashInterfaces());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 0, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashLibraries());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 1, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashServices());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 2, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashCores());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 3, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashApplications());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 4, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            Reference ref;
            Reference[] tmpCWArray;
            ComponentWrapper[] cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getDispatcherHashInterfaces());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 0, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getDispatcherHashLibraries());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 1, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getDispatcherHashServices());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 2, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getDispatcherHashCores());
            i = 0;
            while (i < cwArray.length) {
                tmpCWArray = cwArray[i].getReferences();
                if (tmpCWArray != null) {
                    colorOfComponent = cwArray[i].isWrong ? ClassLoaderPaneView.errorColor : ClassLoaderPaneView.referenceColor;
                    j = 0;
                    while (j < tmpCWArray.length) {
                        ref = new Reference(cwArray[i].getComponentName(), 3, tmpCWArray[j].getType());
                        if (tmpCWArray[j].getName().equalsIgnoreCase(this.mainComponentName) && tmpCWArray[j].getReferentTypeAsString().equalsIgnoreCase(this.mainComponentType) && !this.isReferenceToClasloader(ref)) {
                            al = this.mergeReference(al, new ClassLoadersPaneNode(ref, colorOfComponent));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return al;
    }

    private boolean isReferenceToClasloader(Reference ref) {
        if (this.centerSet != null) {
            Iterator iter = this.centerSet.iterator();
            while (iter.hasNext()) {
                ComponentWrapper tmp = (ComponentWrapper)iter.next();
                if (!ref.getName().equals(tmp.getComponentName()) || !ref.getReferentTypeAsString().equalsIgnoreCase(tmp.getType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReferenceInClasloader(Reference ref) {
        if (this.centerSet != null) {
            Iterator iter = this.centerSet.iterator();
            while (iter.hasNext()) {
                ComponentWrapper tmp = (ComponentWrapper)iter.next();
                if (!ref.getReferentTypeAsString().equals(tmp.getType()) || !ref.getName().equals(tmp.getComponentName())) continue;
                return true;
            }
        }
        return false;
    }

    public ClassLoadersPaneNode[] getServerDependComponents() {
        ArrayList vResults = this.getMainDepends();
        if (this.centerSet != null) {
            Iterator iter = this.centerSet.iterator();
            while (iter.hasNext()) {
                Reference[] tmpRefs;
                ComponentWrapper tmp = (ComponentWrapper)iter.next();
                if (tmp.equals(this.mainCW) || (tmpRefs = tmp.getReferences()) == null) continue;
                int i = 0;
                while (i < tmpRefs.length) {
                    if (!this.isReferenceInClasloader(tmpRefs[i])) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRefs[i], ClassLoaderPaneView.componentColor));
                    }
                    ++i;
                }
            }
        }
        return ArrayFactory.sortReference(vResults);
    }

    public ClassLoadersPaneNode[] getServerUsedComponents() {
        Reference tmpRef;
        Reference[] tmpCWArray;
        ArrayList vResults = this.getMainUsed();
        int i = 0;
        int j = 0;
        ComponentWrapper[] cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashInterfaces());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 0, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashLibraries());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 1, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashServices());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 2, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashCores());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 3, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashApplications());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 4, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ArrayFactory.sortReference(vResults);
    }

    public ClassLoadersPaneNode[] getDispatcherDependComponents() {
        ArrayList vResults = this.getMainDepends();
        if (this.centerSet != null) {
            Iterator iter = this.centerSet.iterator();
            while (iter.hasNext()) {
                ComponentWrapper tmp = (ComponentWrapper)iter.next();
                Reference[] tmpRefs = tmp.getReferences();
                if (tmpRefs == null) continue;
                int i = 0;
                while (i < tmpRefs.length) {
                    if (!this.isReferenceInClasloader(tmpRefs[i])) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRefs[i], ClassLoaderPaneView.componentColor));
                    }
                    ++i;
                }
            }
        }
        return ArrayFactory.sortReference(vResults);
    }

    public ClassLoadersPaneNode[] getDispatcherUsedComponents() {
        Reference tmpRef;
        Reference[] tmpCWArray;
        ArrayList vResults = this.getMainUsed();
        int i = 0;
        int j = 0;
        ComponentWrapper[] cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getDispatcherHashInterfaces());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 0, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getDispatcherHashLibraries());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 1, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getDispatcherHashServices());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 2, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        cwArray = ComponentFactory.getComponentWrapperArr(ComponentFactory.getServerHashCores());
        i = 0;
        while (i < cwArray.length) {
            tmpCWArray = cwArray[i].getReferences();
            if (tmpCWArray != null) {
                j = 0;
                while (j < tmpCWArray.length) {
                    if (this.isReferenceToClasloader(tmpCWArray[j]) && !this.isReferenceToClasloader(tmpRef = new Reference(cwArray[i].getComponentName(), 3, tmpCWArray[j].getType()))) {
                        vResults = this.mergeReference(vResults, new ClassLoadersPaneNode(tmpRef, ClassLoaderPaneView.componentColor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ArrayFactory.sortReference(vResults);
    }

    private static ClassLoadersPaneNode[] sortReference(ArrayList arrayList) {
        ClassLoadersPaneNode[] result = new ClassLoadersPaneNode[arrayList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (ClassLoadersPaneNode)arrayList.get(i);
            ++i;
        }
        ClassLoadersPaneNode rTmp = null;
        i = 0;
        while (i < result.length - 1) {
            int j = i + 1;
            while (j < result.length) {
                if (Reference.compare(result[i].getReference(), result[j].getReference()) < 0) {
                    rTmp = result[i];
                    result[i] = result[j];
                    result[j] = rTmp;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private ArrayList mergeReference(ArrayList arrayList, ClassLoadersPaneNode node) {
        Reference ref = node.getReference();
        if (arrayList.size() != 0) {
            ClassLoadersPaneNode tmpNode = null;
            Reference tmpRef = null;
            int i = 0;
            while (i < arrayList.size()) {
                tmpNode = (ClassLoadersPaneNode)arrayList.get(i);
                tmpRef = tmpNode.getReference();
                if (tmpRef.getName().equals(ref.getName()) && tmpRef.getReferentType() == ref.getReferentType()) {
                    if (tmpRef.getType() > ref.getType()) {
                        arrayList.remove(i);
                        node.setNodeColor(tmpNode.getNodeColor());
                        arrayList.add(node);
                    }
                    return arrayList;
                }
                ++i;
            }
        }
        arrayList.add(node);
        return arrayList;
    }
}

