/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.properties;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PropertiesEditor {
    public static final String REPLACE = "<number>";
    public static final String HEPL = "Ussage: PropertiesEditor -c <DBProperties> -s <ServiceName> -p <ServiceProperties>";
    public ConfigurationHandlerFactory factory = null;

    public PropertiesEditor(Properties configProperties) throws Exception {
        this.factory = new ConfigurationManagerBootstrapImpl(configProperties);
    }

    public PropertiesEditor(String filename) throws Exception {
        this.factory = new ConfigurationManagerBootstrapImpl(filename);
    }

    public void setLocalProperties(String serviceName, String propsFile) throws Exception {
        Properties sp = new Properties();
        FileInputStream is = new FileInputStream(propsFile);
        sp.load(is);
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration cfg = handler.openConfiguration("cluster_data/server", 1);
        String[] subCfgNames = cfg.getAllSubConfigurationNames();
        Vector<String> server_elements = new Vector<String>();
        int i = 0;
        while (i < subCfgNames.length) {
            if (this.isServerElement(subCfgNames[i])) {
                server_elements.add(subCfgNames[i]);
            }
            ++i;
        }
        Object[] servers = new String[server_elements.size()];
        server_elements.copyInto(servers);
        this.quickSort(0, servers.length - 1, (String[])servers);
        int i2 = 0;
        while (i2 < servers.length) {
            Configuration tmp = cfg.getSubConfiguration((String)servers[i2]);
            tmp = this.getSubConfiguration(tmp, "services", 0);
            Configuration serviceProps = this.getSubConfiguration(tmp, serviceName, 1);
            PropertySheet psi = serviceProps.getPropertySheetInterface();
            Enumeration keys = ((Hashtable)sp).keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                psi.deletePropertyEntry((String)key);
                psi.createPropertyEntry((String)key, PropertiesEditor.modifyProperty(sp.getProperty((String)key), i2), null);
            }
            ++i2;
        }
        handler.commit();
    }

    private static String modifyProperty(String property, int number) {
        int index = property.indexOf(REPLACE);
        if (index == -1) {
            return property;
        }
        String tmp = property.substring(0, index) + number + property.substring(index + REPLACE.length());
        return PropertiesEditor.modifyProperty(tmp, number);
    }

    private Configuration getSubConfiguration(Configuration root, String subName, int createFlag) throws Exception {
        Configuration result = root.existsSubConfiguration(subName) ? root.getSubConfiguration(subName) : root.createSubConfiguration(subName, createFlag);
        return result;
    }

    private boolean isServerElement(String name) {
        if (name.startsWith("ID")) {
            name = name.substring(2);
            int i = 0;
            while (i < name.length()) {
                if (!Character.isDigit(name.charAt(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private final void quickSort(int left, int right, String[] array) {
        String tmp = null;
        if (right > left) {
            String s1 = array[right];
            int i = left - 1;
            int j = right;
            while (true) {
                if (array[++i].compareTo(s1) < 0) {
                    continue;
                }
                while (j > 0) {
                    if (array[--j].compareTo(s1) <= 0) break;
                }
                if (i >= j) break;
                tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }
            tmp = array[i];
            array[i] = array[right];
            array[right] = tmp;
            this.quickSort(left, i - 1, array);
            this.quickSort(i + 1, right, array);
        }
    }

    private static Hashtable parseArgs(String[] args) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-c")) {
                result.put("-c", args[++i]);
            } else if (args[i].equals("-s")) {
                result.put("-s", args[++i]);
            } else if (args[i].equals("-p")) {
                result.put("-p", args[++i]);
            }
            ++i;
        }
        if (result.size() != 3) {
            System.out.println(HEPL);
            System.exit(1);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Hashtable arguments = PropertiesEditor.parseArgs(args);
        PropertiesEditor pe = new PropertiesEditor((String)arguments.get("-c"));
        pe.setLocalProperties((String)arguments.get("-s"), (String)arguments.get("-p"));
        System.exit(0);
    }
}

