/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinelikeyinst;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.security.core.server.likey.Persistence;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PersistenceImplStandAlone
implements Persistence {
    protected static final String ROOT_CONF_NAME = "Licensing";
    protected static final String SW_PRODUCTS_CONF_NAME = "SW_Products";
    private static final int MaxWriteAttemps = 30;
    private static final int MaxReadAttemps = 30;
    private String propertyFile = System.getProperty("propertyfile");
    private ConfigurationHandler configurationHandler;

    public boolean init() {
        System.out.println("PersistenceImpl:init()");
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(this.propertyFile);
            props.load(fis);
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        try {
            ConfigurationManagerBootstrapImpl cfgBootstrapImpl = new ConfigurationManagerBootstrapImpl(props);
            this.configurationHandler = cfgBootstrapImpl.getConfigurationHandler();
        }
        catch (ConfigurationException cfe) {
            cfe.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean insertKey(String key, String value) {
        System.out.println("PersistenceImpl: begin insertKey(String, String)");
        Configuration rootConfiguration = this.getLicensingConfigurationForModification();
        if (rootConfiguration != null) {
            try {
                try {
                    rootConfiguration.addConfigEntry(key, value);
                    this.configurationHandler.commit();
                    System.out.println("PersistenceImpl: end insertKey(String, String) with return value true");
                    boolean bl = true;
                    Object var7_6 = null;
                    this.closeAllConfigurations();
                    return bl;
                }
                catch (ConfigurationException ce) {
                    try {
                        this.configurationHandler.rollback();
                    }
                    catch (ConfigurationException ce1) {
                    }
                    Object var7_7 = null;
                    this.closeAllConfigurations();
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeAllConfigurations();
                throw throwable;
            }
        }
        System.out.println("PersistenceImpl: end insertKey(String, String) with return value false");
        return false;
    }

    public synchronized boolean updateKey(String key, String value) {
        System.out.println("PersistenceImpl: begin updateKey(String, String)");
        Configuration rootConfiguration = this.getLicensingConfigurationForModification();
        if (rootConfiguration != null) {
            try {
                try {
                    rootConfiguration.modifyConfigEntry(key, value);
                    this.configurationHandler.commit();
                    System.out.println("PersistenceImpl: end updateKey(String, String) with return value true");
                    boolean bl = true;
                    Object var7_6 = null;
                    this.closeAllConfigurations();
                    return bl;
                }
                catch (ConfigurationException ce) {
                    try {
                        this.configurationHandler.rollback();
                    }
                    catch (ConfigurationException ce2) {
                    }
                    Object var7_7 = null;
                    this.closeAllConfigurations();
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeAllConfigurations();
                throw throwable;
            }
        }
        System.out.println("PersistenceImpl: end update(String, String) with return value false");
        return false;
    }

    public synchronized boolean deleteKey(String key) {
        System.out.println("PersistenceImpl: begin deleteKey(String");
        Configuration rootConfiguration = this.getLicensingConfigurationForModification();
        if (rootConfiguration != null) {
            try {
                try {
                    rootConfiguration.deleteConfigEntry(key);
                    this.configurationHandler.commit();
                    System.out.println("PersistenceImpl: end deleteKey(String) with return value true");
                    boolean bl = true;
                    Object var6_5 = null;
                    this.closeAllConfigurations();
                    return bl;
                }
                catch (ConfigurationException ce) {
                    try {
                        this.configurationHandler.rollback();
                    }
                    catch (ConfigurationException ce3) {
                    }
                    Object var6_6 = null;
                    this.closeAllConfigurations();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeAllConfigurations();
                throw throwable;
            }
        }
        System.out.println("PersistenceImpl: end deleteKey(String) with return value false");
        return false;
    }

    public synchronized String getKey(String key) {
        System.out.println("PersistenceImpl: begin getKey(String)");
        String result = null;
        Configuration rootConfiguration = null;
        boolean successfullyRead = false;
        for (int readAttemps = 0; !successfullyRead && readAttemps < 30; ++readAttemps) {
            Object var9_7;
            try {
                try {
                    rootConfiguration = this.getRootConfiguration(0);
                    result = (String)rootConfiguration.getConfigEntry(key);
                    successfullyRead = true;
                }
                catch (InconsistentReadException ire) {
                    var9_7 = null;
                    this.closeAllConfigurations();
                    continue;
                }
                catch (ConfigurationException ce) {
                    var9_7 = null;
                    this.closeAllConfigurations();
                    break;
                }
                var9_7 = null;
                this.closeAllConfigurations();
                continue;
            }
            catch (Throwable throwable) {
                var9_7 = null;
                this.closeAllConfigurations();
                throw throwable;
            }
        }
        System.out.println("PersistenceImpl: end getKey(String) with result value " + result);
        return result;
    }

    public synchronized Properties getKeys() {
        System.out.println("PersistenceImpl: begin getKeys()");
        Properties result = new Properties();
        boolean successfullyRead = false;
        int readAttemps = 0;
        while (!successfullyRead && readAttemps < 30) {
            Object var9_10;
            ++readAttemps;
            try {
                try {
                    Configuration rootConfiguration = this.getRootConfiguration(0);
                    String[] entryNames = rootConfiguration.getAllConfigEntryNames();
                    int i = 0;
                    while (i < entryNames.length) {
                        String value = (String)rootConfiguration.getConfigEntry(entryNames[i]);
                        result.setProperty(entryNames[i], value);
                        ++i;
                    }
                    successfullyRead = true;
                }
                catch (InconsistentReadException ire) {
                    var9_10 = null;
                    this.closeAllConfigurations();
                    continue;
                }
                catch (ConfigurationException ce) {
                    var9_10 = null;
                    this.closeAllConfigurations();
                    break;
                }
                var9_10 = null;
                this.closeAllConfigurations();
            }
            catch (Throwable throwable) {
                var9_10 = null;
                this.closeAllConfigurations();
                throw throwable;
            }
        }
        System.out.println("PersistenceImpl: end getKeys() with result value " + result);
        return result;
    }

    boolean addSwProductToConfiguration(String swProduct) {
        Configuration rootConfiguration = this.getLicensingConfigurationForModification();
        if (rootConfiguration != null) {
            try {
                try {
                    Configuration swProductsConfiguration = null;
                    swProductsConfiguration = !rootConfiguration.existsSubConfiguration(SW_PRODUCTS_CONF_NAME) ? rootConfiguration.createSubConfiguration(SW_PRODUCTS_CONF_NAME) : rootConfiguration.getSubConfiguration(SW_PRODUCTS_CONF_NAME);
                    try {
                        swProductsConfiguration.getConfigEntry(swProduct);
                    }
                    catch (NameNotFoundException nnfe) {
                        swProductsConfiguration.addConfigEntry(swProduct, "");
                    }
                    this.configurationHandler.commit();
                    boolean nnfe = true;
                    Object var6_8 = null;
                    this.closeAllConfigurations();
                    return nnfe;
                }
                catch (ConfigurationException ce) {
                    try {
                        this.configurationHandler.rollback();
                    }
                    catch (ConfigurationException ce1) {
                    }
                    Object var6_9 = null;
                    this.closeAllConfigurations();
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.closeAllConfigurations();
                throw throwable;
            }
        }
        return false;
    }

    private Configuration getRootConfiguration(int accessMode) throws ConfigurationException {
        Configuration rootConfiguration;
        System.out.println("PersistenceImpl: begin getRootConfiguration()");
        try {
            rootConfiguration = this.configurationHandler.createRootConfiguration(ROOT_CONF_NAME);
            rootConfiguration.setCacheMode(18);
            this.configurationHandler.commit();
        }
        catch (NameAlreadyExistsException naee) {
            rootConfiguration = this.configurationHandler.openConfiguration(ROOT_CONF_NAME, accessMode);
        }
        catch (ConfigurationException ce) {
            ce.printStackTrace();
            throw ce;
        }
        System.out.println("PersistenceImpl: end getRootConfiguration() with result value " + rootConfiguration);
        return rootConfiguration;
    }

    private void closeAllConfigurations() {
        try {
            this.configurationHandler.closeAllConfigurations();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private Configuration getLicensingConfigurationForModification() {
        int writeAttemps = 0;
        Configuration rootConfiguration = null;
        while (writeAttemps < 30) {
            ++writeAttemps;
            try {
                rootConfiguration = this.getRootConfiguration(1);
                return rootConfiguration;
            }
            catch (ConfigurationException ce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException f) {
                    // empty catch block
                }
            }
        }
        return rootConfiguration;
    }
}

