/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinelikeyinst;

import com.sap.engine.tools.offlinelikeyinst.ConnectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MessageHeader {
    private ConnectionUtil.ComString eyeCatcher;
    public ConnectionUtil.ComByte version;
    public ConnectionUtil.ComByte msErrno;
    public ConnectionUtil.ComString toName;
    public ConnectionUtil.ComByte msgTypes;
    public ConnectionUtil.ComByte msgTypes2;
    public ConnectionUtil.ComByte msgDomain;
    public ConnectionUtil.ComInt msKey;
    public ConnectionUtil.ComByte msSubKey;
    public ConnectionUtil.ComByte msFlag;
    public ConnectionUtil.ComByte msiFlag;
    public ConnectionUtil.ComInt msgLen;
    public ConnectionUtil.ComString fromName;
    public ConnectionUtil.ComShort fromServno;
    public ConnectionUtil.ComInt senderClusterId;
    public ConnectionUtil.ComInt clusterId;
    public ConnectionUtil.ComInt serviceId;
    public ConnectionUtil.ComInt groupId;
    public ConnectionUtil.ComByte nodeType;
    public ConnectionUtil.ComInt totalLength;
    public ConnectionUtil.ComInt currentLength;
    public ConnectionUtil.ComInt currentOffset;
    public ConnectionUtil.ComByte totalBlocks;
    public ConnectionUtil.ComByte currentBlock;
    public ConnectionUtil.ComInt messageType;
    public ConnectionUtil.ComInt broadcastHeaderLength;
    public int maxBodyLength;
    public int receivedLength = 0;
    public boolean isExtendedHeader;
    protected byte[] buf;
    public static final byte MS_VERSION = 4;
    public static final byte MS_SEND_NAME = 1;
    public static final byte MS_SEND_TYPE = 2;
    public static final byte MS_LOGIN = 3;
    public static final byte MS_LOGOUT = 4;
    public static final byte MS_ADM_OPCODES = 5;
    public static final byte MS_MOD_MSGTYPES = 6;
    public static final byte MS_SEND_TYPE_ONCE = 7;
    public static final byte MS_LOGIN_2 = 8;
    public static final byte MS_MOD_STATE = 9;
    public static final byte MS_J2EE_LOGIN = 10;
    public static final byte MS_J2EE_LOGOUT = 11;
    public static final byte MS_J2EE_SEND_TO_CLUSTERID = 12;
    public static final byte MS_J2EE_SEND_BROADCAST = 13;
    private static final int MS_EYECLN = 12;
    private static final int MS_NAME_SIZ = 40;
    private static final int MS_RESERVE_SIZ = 1;
    private static final int MS_KEY_SIZ = 8;
    private static final int MS_TEXT_SIZ = 32000;
    public static final int MS_J2EE_SIZ = 31950;
    public static final int MS_HEADER_SIZ = 110;
    public static final int MS_J2EE_HEADER_LN = 40;
    public static final int MS_PING_SIZ = 8;
    public static final String MS_NIPING = "NI_PING";
    public static final int MS_PONG_SIZ = 8;
    public static final String MS_NIPONG = "NI_PONG";
    public static final String MS_MSGNAME = "MSG_SERVER";
    public static final String MS_EYECATCHER = "**MESSAGE**";
    public static final String MS_J2EE_PREFIX = "J2EE";
    public static final byte MS_DOMAIN_WAS = 0;
    public static final byte MS_DOMAIN_J2EE = 1;
    public static final byte MS_DEFAULT = 0;
    public static final byte MS_ONE_WAY = 1;
    public static final byte MS_REQUEST = 2;
    public static final byte MS_REPLY = 3;
    public static final byte MS_ADMIN = 4;
    public static final String[] MS_FLAG_TEXT = new String[]{"Default", "One-Way", "Request", "Reply", "Admin"};
    public static final int MS_NO_TYPES = 0;
    public static final byte MSEINTERN = -1;
    public static final byte MSENOMSG = -2;
    public static final byte MSEINVAL = -3;
    public static final byte MSENOTFOUND = -4;
    public static final byte MSEWAKEUP = -5;
    public static final byte MSEWRONGNAME = -6;
    public static final byte MSEWRONGTYPE = -7;
    public static final byte MSEPARTNERDIED = -8;
    public static final byte MSEPARTNERUNKNOWN = -9;
    public static final byte MSENOTUNIQUE = -10;
    public static final byte MSEMSGDESTROYED = -11;
    public static final byte MSEWRONGVERSION = -12;
    public static final byte MSEREPLYTOOLARGE = -13;
    public static final byte MSESHUTDOWN = -14;
    public static final byte MSENOSLOTFREE = -15;
    public static final byte MSESOCKTOOLARGE = -16;
    public static final byte MSEADMIN = -17;
    public static final byte MSEREADINCOMPLETE = -18;
    public static final byte MSEWRITEINCOMPLETE = -19;
    public static final byte MSEACCESSDENIED = -20;
    public static final byte MSETYPESNOTALLOWED = -21;
    public static final byte MSEHEADERINCOMPLETE = -22;
    public static final byte MSENOMEM = -23;
    public static final byte MSEVARBUF = -24;
    public static final byte MSESOFTSHUTDOWN = -25;
    public static final byte MSEDUPKEY = -26;
    public static final byte MSENILAYER = -100;
    public static final byte MSENIQUEUE = -101;
    public static final byte MSSTOPLISTENERQUEUE = -125;
    public static final byte MSNOLISTENERREGISTERED = -126;
    public static final byte MSATTACHCONFIRMATION = -127;
    public static final int MS_ATTACH_KEY = -1;
    public static final int MS_DETACH_KEY = -2;
    public static final int MSSERVER_SERVICEID = -1;
    private static int messageId = 1;

    public MessageHeader() {
        int pos = 0;
        if (this.buf == null) {
            this.buf = new byte[154];
        }
        this.msgLen = new ConnectionUtil.ComInt(this.buf, pos);
        this.eyeCatcher = new ConnectionUtil.ComString(12, this.buf, pos += this.msgLen.getMaxLength());
        this.version = new ConnectionUtil.ComByte(this.buf, pos += this.eyeCatcher.getMaxLength());
        this.msErrno = new ConnectionUtil.ComByte(this.buf, pos += this.version.getMaxLength());
        this.toName = new ConnectionUtil.ComString(40, this.buf, pos += this.msErrno.getMaxLength());
        this.msgTypes = new ConnectionUtil.ComByte(this.buf, pos += this.toName.getMaxLength());
        this.msgTypes2 = new ConnectionUtil.ComByte(this.buf, pos += this.msgTypes.getMaxLength());
        this.msgDomain = new ConnectionUtil.ComByte(this.buf, pos += this.msgTypes2.getMaxLength());
        pos += this.msgDomain.getMaxLength();
        this.msKey = new ConnectionUtil.ComInt(this.buf, ++pos);
        this.msSubKey = new ConnectionUtil.ComByte(this.buf, pos += 7);
        this.msFlag = new ConnectionUtil.ComByte(this.buf, pos += this.msSubKey.getMaxLength());
        this.msiFlag = new ConnectionUtil.ComByte(this.buf, pos += this.msFlag.getMaxLength());
        this.fromName = new ConnectionUtil.ComString(40, this.buf, pos += this.msiFlag.getMaxLength());
        this.fromServno = new ConnectionUtil.ComShort(this.buf, pos += this.fromName.getMaxLength());
        pos += this.fromServno.getMaxLength();
        pos = 114;
        this.senderClusterId = new ConnectionUtil.ComInt(this.buf, pos);
        this.clusterId = new ConnectionUtil.ComInt(this.buf, pos += this.senderClusterId.getMaxLength());
        this.serviceId = new ConnectionUtil.ComInt(this.buf, pos += this.clusterId.getMaxLength());
        this.groupId = new ConnectionUtil.ComInt(this.buf, pos += this.serviceId.getMaxLength());
        this.nodeType = new ConnectionUtil.ComByte(this.buf, pos += this.groupId.getMaxLength());
        this.totalLength = new ConnectionUtil.ComInt(this.buf, pos += this.nodeType.getMaxLength());
        this.currentLength = new ConnectionUtil.ComInt(this.buf, pos += this.totalLength.getMaxLength());
        this.currentOffset = new ConnectionUtil.ComInt(this.buf, pos += this.currentLength.getMaxLength());
        this.totalBlocks = new ConnectionUtil.ComByte(this.buf, pos += this.currentOffset.getMaxLength());
        this.currentBlock = new ConnectionUtil.ComByte(this.buf, pos += this.totalBlocks.getMaxLength());
        this.messageType = new ConnectionUtil.ComInt(this.buf, pos += this.currentBlock.getMaxLength());
        this.broadcastHeaderLength = new ConnectionUtil.ComInt(this.buf, pos += this.messageType.getMaxLength());
        pos += this.broadcastHeaderLength.getMaxLength();
        this.version.setByte((byte)4);
        this.eyeCatcher.setString(MS_EYECATCHER);
        this.msgDomain.setByte((byte)1);
        this.isExtendedHeader = false;
    }

    public void Deseralize() {
        this.msgLen.Deserialize();
        this.eyeCatcher.Deserialize();
        this.toName.Deserialize();
        this.msKey.Deserialize();
        this.fromName.Deserialize();
        this.fromServno.Deserialize();
        this.senderClusterId.Deserialize();
        this.clusterId.Deserialize();
        this.serviceId.Deserialize();
        this.groupId.Deserialize();
        this.totalLength.Deserialize();
        this.currentLength.Deserialize();
        this.currentOffset.Deserialize();
        this.messageType.Deserialize();
        this.broadcastHeaderLength.Deserialize();
    }

    public void write(OutputStream outputStream, String myNodeName, byte[] messageBody, int messageOffset, int messageLength) throws IOException {
        int sentLength = 0;
        this.fromName.setString(myNodeName);
        this.msgLen.setInt(110 + messageLength);
        int headerLength = 114;
        if (this.msgLen.getInt() > 32110) {
            throw new IllegalArgumentException("Invalid message length of " + this.msgLen.getInt() + " bytes");
        }
        outputStream.write(this.buf, 0, headerLength);
        sentLength += headerLength;
        if (messageLength > 0) {
            outputStream.write(messageBody, messageOffset, messageLength);
            sentLength += messageLength;
        }
        if (this.msgLen.getInt() + 4 != sentLength) {
            throw new IllegalArgumentException("Message inconsistency (" + this.msgLen.getInt() + " != " + (sentLength - 4) + ")");
        }
    }

    public int read(InputStream inputStream) throws IOException {
        int rBytes;
        int msgBodyLen = 0;
        if (inputStream.read(this.buf, 0, 4) != 4) {
            return -2;
        }
        this.msgLen.Deserialize();
        if (this.msgLen.getInt() == 8) {
            byte[] niPing = new byte[8];
            inputStream.read(niPing);
            return -1;
        }
        int length = 110;
        int offset = 4;
        do {
            rBytes = inputStream.read(this.buf, offset, length);
            offset += rBytes;
        } while ((length -= rBytes) > 0);
        this.eyeCatcher.DeserializeDelBlanks();
        if (this.eyeCatcher.getString().compareTo(MS_EYECATCHER) != 0) {
            return msgBodyLen;
        }
        this.toName.DeserializeDelBlanks();
        this.msKey.Deserialize();
        this.fromName.DeserializeDelBlanks();
        this.fromServno.Deserialize();
        msgBodyLen = this.msgLen.getInt() - 110;
        if (this.msiFlag.getByte() == 12 || this.msiFlag.getByte() == 13) {
            length = 40;
            offset = 114;
            do {
                rBytes = inputStream.read(this.buf, offset, length);
                offset += rBytes;
            } while ((length -= rBytes) > 0);
            this.clusterId.Deserialize();
            this.senderClusterId.Deserialize();
            this.serviceId.Deserialize();
            this.groupId.Deserialize();
            this.totalLength.Deserialize();
            this.currentLength.Deserialize();
            this.currentOffset.Deserialize();
            this.messageType.Deserialize();
            this.broadcastHeaderLength.Deserialize();
            this.isExtendedHeader = true;
            msgBodyLen -= 40;
        }
        if (msgBodyLen < 0) {
            msgBodyLen = 0;
        }
        if (msgBodyLen > 32000) {
            msgBodyLen = 32000;
        }
        if (!this.isExtendedHeader) {
            this.totalLength.setInt(msgBodyLen);
        }
        return msgBodyLen;
    }

    public void out() {
        System.out.println("##################################################");
        System.out.println("Message Type : " + MS_FLAG_TEXT[this.msFlag.getByte()]);
        System.out.println("Internal Type: " + this.msiFlag.getByte());
        System.out.println("Client Type  : " + this.msgTypes.getByte());
        System.out.println("Key          : " + this.msKey.getInt());
        System.out.println("SubKey       : " + this.msSubKey.getByte());
        System.out.println("From         : " + this.fromName.getString());
        System.out.println("To           : " + this.toName.getString());
        System.out.println("error code   : " + this.msErrno.getByte());
        System.out.println("##################################################");
    }

    public void init(String name, int msflag, int msiflag, int msgtypes, int key, int bodylen) {
        this.msiFlag.setByte((byte)msiflag);
        this.msFlag.setByte((byte)msflag);
        this.msgTypes.setByte((byte)msgtypes);
        this.msKey.setInt(key);
        this.toName.setString(name);
        this.msgLen.setInt(110 + bodylen);
    }

    public void initToName(String name, int msflag, int key, int bodylen) {
        this.init(name, msflag, 1, 0, key, bodylen);
    }

    public void initRequest(String name, int bodylen) {
        this.init(name, 2, 1, 0, MessageHeader.getKey(), bodylen);
    }

    public void initReply(MessageHeader msg) {
        this.toName.setString(msg.fromName.getString());
        this.fromName.setString(msg.toName.getString());
        this.msKey.setInt(msg.msKey.getInt());
        this.msSubKey.setByte(msg.msSubKey.getByte());
        this.msiFlag.setByte(msg.msiFlag.getByte());
        this.msFlag.setByte((byte)3);
        this.msgTypes.setByte(msg.msgTypes.getByte());
        this.isExtendedHeader = msg.isExtendedHeader;
    }

    public void initMessageToClusterId(int clusterId, int serviceId, int messageType, int totalLength) {
        String name = new String(MS_J2EE_PREFIX + clusterId);
        this.init(name, 1, 12, 0, MessageHeader.getKey(), 0);
        this.isExtendedHeader = true;
        this.serviceId.setInt(serviceId);
        this.messageType.setInt(messageType);
        this.clusterId.setInt(clusterId);
        this.totalLength.setInt(totalLength);
        this.totalBlocks.setByte((byte)(totalLength / 31950 + 1));
    }

    public void initRequestToClusterId(int clusterId, int serviceId, int messageType, int totalLength) {
        this.initMessageToClusterId(clusterId, serviceId, messageType, totalLength);
        this.msFlag.setByte((byte)2);
    }

    public void initMessageToGroup(int serviceId, int groupId, byte nodeType, int messageType, int totalLength) {
        String name = new String("J2EE_BROADCAST");
        this.init(name, 1, 13, 0, MessageHeader.getKey(), 0);
        this.isExtendedHeader = true;
        this.groupId.setInt(groupId);
        this.nodeType.setByte(nodeType);
        this.serviceId.setInt(serviceId);
        this.messageType.setInt(messageType);
        this.totalLength.setInt(totalLength);
        this.totalBlocks.setByte((byte)(totalLength / 31950 + 1));
    }

    public void initRequestToGroup(int serviceId, int groupId, byte nodeType, int messageType, int totalLength) {
        this.initMessageToGroup(serviceId, groupId, nodeType, messageType, totalLength);
        this.msFlag.setByte((byte)2);
    }

    public void initReplyToClusterId(MessageHeader receivedMessage, int totalLength) {
        this.isExtendedHeader = true;
        this.msiFlag.setByte((byte)12);
        this.clusterId.setInt(receivedMessage.senderClusterId.getInt());
        this.serviceId.setInt(receivedMessage.serviceId.getInt());
        this.messageType.setInt(receivedMessage.messageType.getInt());
        this.clusterId.setInt(receivedMessage.senderClusterId.getInt());
        this.totalLength.setInt(totalLength);
        this.totalBlocks.setByte((byte)(totalLength / 31950 + 1));
    }

    public byte getErrorCode() {
        return this.msErrno.getByte();
    }

    public String getErrorString() {
        return MessageHeader.getErrorString(this.msErrno.getByte());
    }

    public static String getErrorString(byte errorCode) {
        String retStr = null;
        switch (errorCode) {
            case -1: {
                retStr = "MSEINTERN";
                break;
            }
            case -2: {
                retStr = "MSEINTERN";
                break;
            }
            case -3: {
                retStr = "MSEINVAL";
                break;
            }
            case -4: {
                retStr = "MSENOTFOUND";
                break;
            }
            case -5: {
                retStr = "MSEWAKEUP";
                break;
            }
            case -6: {
                retStr = "MSEWRONGNAME";
                break;
            }
            case -7: {
                retStr = "MSEWRONGTYPE";
                break;
            }
            case -8: {
                retStr = "MSEPARTNERDIED";
                break;
            }
            case -9: {
                retStr = "MSEPARTNERUNKNOWN";
                break;
            }
            case -10: {
                retStr = "MSENOTUNIQUE";
                break;
            }
            case -11: {
                retStr = "MSEMSGDESTROYED";
                break;
            }
            case -12: {
                retStr = "MSEWRONGVERSION";
                break;
            }
            case -13: {
                retStr = "MSEREPLYTOOLARGE";
                break;
            }
            case -14: {
                retStr = "MSESHUTDOWN";
                break;
            }
            case -15: {
                retStr = "MSENOSLOTFREE";
                break;
            }
            case -16: {
                retStr = "MSESOCKTOOLARGE";
                break;
            }
            case -17: {
                retStr = "MSEADMIN";
                break;
            }
            case -18: {
                retStr = "MSEREADINCOMPLETE";
                break;
            }
            case -19: {
                retStr = "MSEWRITEINCOMPLETE";
                break;
            }
            case -20: {
                retStr = "MSEACCESSDENIED";
                break;
            }
            case -21: {
                retStr = "MSETYPESNOTALLOWED";
                break;
            }
            case -22: {
                retStr = "MSEHEADERINCOMPLETE";
                break;
            }
            case -23: {
                retStr = "MSENOMEM";
                break;
            }
            case -24: {
                retStr = "MSEVARBUF";
                break;
            }
            case -25: {
                retStr = "MSESOFTSHUTDOWN";
                break;
            }
            case -26: {
                retStr = "MSEDUPKEY";
                break;
            }
            case -100: {
                retStr = "MSENILAYER";
                break;
            }
            case -101: {
                retStr = "MSENIQUEUE";
                break;
            }
            default: {
                retStr = new String("Unknown Error");
            }
        }
        return retStr;
    }

    public static synchronized int getKey() {
        int msId = messageId++;
        if (messageId >= Integer.MAX_VALUE) {
            messageId = 1;
        }
        return msId;
    }
}

