/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinelikeyinst;

import com.sap.engine.tools.offlinelikeyinst.MSConnectionUtil;
import com.sap.engine.tools.offlinelikeyinst.MessageAnswer;
import com.sap.engine.tools.offlinelikeyinst.MessageHeader;
import com.sap.security.core.server.likey.KeySystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class KeySystemImpl
implements KeySystem {
    private static final int MS_HOST_CHARSET = 1;
    private static final int MS_SLIC_HWID_LENGTH = 100;
    private static final byte MS_GET_HWID = 10;
    private static final byte MS_DUMP_PARAMS = 3;
    private static final byte MS_DUMP_INFO = 30;
    private static final byte MS_DUMP_VERSION = 1;
    private static final byte MS_DUMP_BUFFER = 2;
    private static final String MS_MSGNAME = "MSG_SERVER";
    private static final int MS_NAME_SIZ = 40;
    private String msHostProp = "ms.host";
    private String msPortProp = "ms.port";
    private String msHost;
    private int msPort;
    private InetAddress msAddress;
    private byte[] msgBody;
    private int msgLength = 0;
    private int msgOffset = 0;
    private String hardwareId;
    private String systemId;

    public KeySystemImpl(Properties installProps) throws IOException {
        System.out.println("KeySystemImpl: begin constructor");
        this.msHost = installProps.getProperty(this.msHostProp);
        if (installProps.getProperty(this.msPortProp) != null) {
            this.msPort = Integer.parseInt(installProps.getProperty(this.msPortProp));
        }
        this.msAddress = InetAddress.getByName(this.msHost);
        System.out.println("KeySystemImpl: end constructor");
    }

    public boolean init() {
        System.out.println("KeySystemImpl: init()");
        return true;
    }

    public Vector getSwProducts() {
        System.out.println("KeySystemImpl: begin getSwProducts()");
        Vector<String> result = new Vector<String>();
        result.add("J2EE-Engine");
        System.out.println("KeySystemImpl: end getSwProducts()");
        return result;
    }

    public String getBasisRelease() {
        System.out.println("KeySystemImpl: getBasisRelease()");
        return "6.30";
    }

    public String getCmdPrefix() {
        System.out.println("KeySystemImpl: getCmdPrefix()");
        return null;
    }

    public String getHwId() {
        System.out.println("KeySystemImpl: begin getHwId()");
        try {
            Socket socket = new Socket(this.msAddress, this.msPort);
            OutputStream outStream = socket.getOutputStream();
            InputStream inStream = socket.getInputStream();
            byte[] sendBody = new byte[]{10, 0, 0, 1};
            MessageHeader sendMsg = new MessageHeader();
            MessageHeader readMsg = new MessageHeader();
            sendMsg.initRequest(MS_MSGNAME, 4);
            sendMsg.write(outStream, "MSCLIENT", sendBody, 0, 4);
            readMsg.read(inStream);
            if (readMsg.totalLength.getInt() == 0) {
                return "";
            }
            this.readBody(inStream, readMsg.totalLength.getInt());
            int pos = 4;
            int max = this.msgLength;
            MSConnectionUtil.ComString hwIdCom = new MSConnectionUtil.ComString(100, this.msgBody, 4);
            hwIdCom.DeserializeDelBlanks();
            this.hardwareId = new String(hwIdCom.getString());
            inStream.close();
            outStream.close();
            socket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.out.println("KeySystemImpl: end getHwId() with return value " + this.hardwareId);
        return this.hardwareId;
    }

    public String getSystemId() {
        System.out.println("KeySystemImpl: begin getSystemId()");
        try {
            TreeMap map = this.getParams();
            this.systemId = map.get("System name") != null ? new String((String)map.get("System name")) : new String("");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.out.println("KeySystemImpl: end getSystemId() with return value " + this.systemId);
        return this.systemId;
    }

    private TreeMap getParams() throws IOException {
        System.out.println("KeySystemImpl: begin getParams()");
        TreeMap msParamMap = new TreeMap();
        MessageAnswer message = this.getDumpInfo((byte)3);
        if (message == null) {
            return msParamMap;
        }
        this.addBufferToProperties(msParamMap, '=', message.getMessage(), message.getOffset(), message.getLength());
        System.out.println("KeySystemImpl: begin getParams()with return value " + msParamMap);
        return msParamMap;
    }

    private MessageAnswer getDumpInfo(byte infoType) throws IOException {
        System.out.println("KeySystemImpl: begin getDumpInfo(byte)");
        Socket socket = new Socket(this.msAddress, this.msPort);
        OutputStream outStream = socket.getOutputStream();
        InputStream inStream = socket.getInputStream();
        byte[] sendBody = new byte[16];
        MessageHeader sendMsg = new MessageHeader();
        MessageHeader readMsg = new MessageHeader();
        sendBody[0] = 30;
        sendBody[1] = 0;
        sendBody[2] = 1;
        sendBody[3] = 1;
        MSConnectionUtil.ComByte dumpDest = new MSConnectionUtil.ComByte(sendBody, 4);
        MSConnectionUtil.ComByteArray filler = new MSConnectionUtil.ComByteArray(3, sendBody, 5);
        MSConnectionUtil.ComShort index = new MSConnectionUtil.ComShort(sendBody, 8);
        MSConnectionUtil.ComShort command = new MSConnectionUtil.ComShort(sendBody, 10);
        MSConnectionUtil.ComString name = new MSConnectionUtil.ComString(40, sendBody, 12);
        dumpDest.setByte((byte)2);
        command.setShort(infoType);
        sendMsg.initRequest(MS_MSGNAME, 4);
        sendMsg.write(outStream, "MSCLIENT", sendBody, 0, 16);
        readMsg.read(inStream);
        if (readMsg.totalLength.getInt() == 0) {
            return null;
        }
        this.readBody(inStream, readMsg.totalLength.getInt());
        inStream.close();
        outStream.close();
        socket.close();
        System.out.println("KeySystemImpl: begin getDumpInfo(byte) with return value " + new MessageAnswer(this.msgBody));
        return new MessageAnswer(this.msgBody);
    }

    private void addBufferToProperties(TreeMap map, char tokenChar, byte[] buffer, int offset, int length) {
        System.out.println("KeySystemImpl: begin addBufferToProperties(TreeMap,char, byte[], int, int)");
        map.clear();
        if (length <= 0) {
            return;
        }
        String info = new String(buffer, offset, length);
        StringTokenizer infoTokenizer = new StringTokenizer(info, "\n");
        while (infoTokenizer.hasMoreTokens()) {
            String token = infoTokenizer.nextToken();
            int index = token.indexOf(tokenChar);
            if (index == -1) continue;
            String key = token.substring(0, index - 1).trim();
            String value = token.substring(index + 2).trim();
            map.put(key, value);
        }
        System.out.println("KeySystemImpl: end addBufferToProperties(TreeMap,char, byte[], int, int)");
    }

    private void readBody(InputStream in, int bodyLength) throws IOException {
        System.out.println("KeySystemImpl: begin readBody(InputStream, int)");
        this.msgBody = new byte[bodyLength];
        this.msgLength = bodyLength;
        int length = bodyLength;
        int offset = 0;
        while (length > 0) {
            int received = in.read(this.msgBody, offset, length);
            length -= received;
            offset += received;
        }
        System.out.println("KeySystemImpl: end readBody(InputStream, int)");
    }
}

