/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinelikeyinst;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.tools.offlinelikeyinst.KeySystemImpl;
import com.sap.engine.tools.offlinelikeyinst.PersistenceImpl;
import com.sap.security.core.server.likey.Admin;
import com.sap.security.core.server.likey.KeySystem;
import com.sap.security.core.server.likey.LogAndTrace;
import com.sap.security.core.server.likey.Persistence;
import com.sap.security.core.server.likey.StdLogAndTrace;
import java.util.Properties;
import java.util.Vector;

public class Installer {
    protected static final String ROOT_CONF_NAME = "Licensing";
    public static final String SW_PRODUCT_PROP = "licensing.sw_product";
    public static final String INSTALL_MODE = "licensing.mode";
    public static final String SYSTEM_TYPE = "licensing.system.type";
    public static final String OVERWRITE_MODE = "overwrite";
    public static final String OVERWRITE_ALL_MODE = "overwrite_all";
    protected static String SW_PRODUCT_PREFIX = "J2EE-Engine";
    protected static String SW_PRODUCT;
    public static final String[] SYSTEM_TYPES;
    protected ConfigurationHandler configurationHandler;
    protected PersistenceImpl persistence;
    protected KeySystem keySystem;
    protected Admin licenseAdmin;
    protected LogAndTrace logAndTrace;
    protected String installationMode = "";
    protected String systemType = "";
    protected String systemTypeAsCode = "0";

    Installer(Properties installProps) throws Exception {
        ConfigurationManagerBootstrapImpl cfgBootstrapImpl = new ConfigurationManagerBootstrapImpl(installProps);
        System.out.println("Installer: begin constructor");
        SW_PRODUCT_PREFIX = installProps.getProperty(SW_PRODUCT_PROP);
        this.configurationHandler = cfgBootstrapImpl.getConfigurationHandler();
        this.installationMode = installProps.getProperty(INSTALL_MODE);
        this.systemType = installProps.getProperty(SYSTEM_TYPE);
        int i = 0;
        while (i < SYSTEM_TYPES.length) {
            if (SYSTEM_TYPES[i].equalsIgnoreCase(this.systemType)) {
                this.systemTypeAsCode = Integer.toString(i);
            }
            ++i;
        }
        this.persistence = new PersistenceImpl(this.configurationHandler);
        this.persistence.init();
        String storageVendorID = cfgBootstrapImpl.getStorageInformation().getStorageVendorId();
        if (storageVendorID == null) {
            throw new Exception("Could not get storage vendor id");
        }
        SW_PRODUCT = this.generateSWProduct(storageVendorID);
        installProps.setProperty(SW_PRODUCT_PROP, SW_PRODUCT);
        this.keySystem = new KeySystemImpl(installProps);
        this.keySystem.init();
        this.logAndTrace = new StdLogAndTrace();
        this.licenseAdmin = new Admin((Persistence)this.persistence, this.keySystem, this.logAndTrace);
        System.out.println("Installer: end constructor");
    }

    boolean exec(Vector errorMessage) {
        System.out.println("Installer: exec(Vector)");
        if (null != this.installationMode && this.installationMode.equalsIgnoreCase(OVERWRITE_ALL_MODE)) {
            this.licenseAdmin.deleteLicenses("*", "*", "*", errorMessage);
            this.persistence.deleteAllSwProductFromConfiguration();
        } else if (null != this.installationMode && this.installationMode.equalsIgnoreCase(OVERWRITE_MODE)) {
            this.deleteAllLicenses(SW_PRODUCT_PREFIX, errorMessage);
            this.deleteAllSWProducts(SW_PRODUCT_PREFIX);
        }
        boolean addSwProductSuccessful = this.persistence.addSwProductToConfiguration(SW_PRODUCT);
        boolean addSystemTypeSuccessful = this.persistence.addSystemTypeToConfiguration(this.systemTypeAsCode);
        if (addSwProductSuccessful && addSystemTypeSuccessful) {
            return this.licenseAdmin.installFirstTempLicense(SW_PRODUCT, errorMessage);
        }
        return false;
    }

    void deleteAllSWProducts(String swProductPrefix) {
        String[] possibleSwProducts = this.getAllSWProductsForPrefix(swProductPrefix);
        this.persistence.deleteSwProductsFromConfiguration(possibleSwProducts);
    }

    void deleteAllLicenses(String swProductPrefix, Vector errorMessage) {
        String[] swProducts = this.getAllSWProductsForPrefix(swProductPrefix);
        int i = 0;
        while (i < swProducts.length) {
            this.licenseAdmin.deleteLicenses("*", "*", swProducts[i], errorMessage);
            ++i;
        }
    }

    String[] getAllSWProductsForPrefix(String swProductPrefix) {
        String[] possibleSwProducts = new String[]{swProductPrefix + "_DB6", swProductPrefix + "_DB2", swProductPrefix + "_AS4", swProductPrefix + "_INF", swProductPrefix + "_MSS", swProductPrefix + "_ORA", swProductPrefix + "_ADA"};
        return possibleSwProducts;
    }

    private String generateSWProduct(String storageVendorID) {
        String suffix = null;
        if (storageVendorID.equals("DB2_UDB")) {
            suffix = "DB6";
        } else if (storageVendorID.equals("DB2_UDB_AS400")) {
            suffix = "AS4";
        } else if (storageVendorID.equals("DB2_UDB_OS390")) {
            suffix = "DB2";
        } else if (storageVendorID.equals("INFORMIX")) {
            suffix = "INF";
        } else if (storageVendorID.equals("MS_SQL_SERVER")) {
            suffix = "MSS";
        } else if (storageVendorID.equals("ORACLE")) {
            suffix = "ORA";
        } else if (storageVendorID.equals("SAPDB")) {
            suffix = "ADA";
        }
        String result = SW_PRODUCT_PREFIX + "_" + suffix;
        return result;
    }

    static {
        SYSTEM_TYPES = new String[]{"N/A", "Development", "Test", "Training", "Production"};
    }
}

