/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinelikeyinst;

import com.sap.engine.tools.offlinelikeyinst.InstallFirstTempLicense;
import com.sap.engine.tools.offlinelikeyinst.Installer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class InstallFirstTempLicense {
    protected static int LICENSE_INSTALLATION_SUCCESS = 0;
    protected static int LICENSE_ALREADY_INSTALLED = 10;
    protected static int ERROR_READING_PROPERTIES = 11;
    protected static int ERROR_INSTALLING_LICENSE = 12;
    protected static int ERROR_CONNECTING_TO_EXTERNAL_SYSTEMS = 13;
    protected static InstallFirstTempLicense installFirstTempLicense;
    protected static int returnCode;
    protected Vector errorMessage = new Vector();

    public static void main(String[] args) {
        if (args.length == 1) {
            installFirstTempLicense = new InstallFirstTempLicense();
            returnCode = installFirstTempLicense.start(args[0]);
            System.exit(returnCode);
        } else {
            System.err.println("Wrong argument list.");
            System.err.println("Usage: java InstallFirstTempLicense <Runtime properties>");
            System.exit(ERROR_READING_PROPERTIES);
        }
    }

    public int start(String fileName) {
        Installer installer = null;
        Properties installProps = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            installProps = new Properties();
            installProps.load(fis);
            String traceProperty = installProps.getProperty("trace");
            InstallFirstTempLicense.redirectOut(traceProperty);
            fis.close();
        }
        catch (IOException ioe) {
            System.err.println("Problems installing the first temporary license, could not read the properties file");
            return ERROR_READING_PROPERTIES;
        }
        try {
            installer = new Installer(installProps);
            boolean result = installer.exec(this.errorMessage);
            if (!result) {
                this.showErrorMessage();
                if (this.isLicenseAlreadyInstalled()) {
                    return LICENSE_ALREADY_INSTALLED;
                }
                return ERROR_CONNECTING_TO_EXTERNAL_SYSTEMS;
            }
            System.out.println("First temp license was installed");
            return LICENSE_INSTALLATION_SUCCESS;
        }
        catch (Exception e) {
            System.err.println("Problems installing the first temporary license");
            e.printStackTrace();
            return ERROR_INSTALLING_LICENSE;
        }
    }

    private boolean isLicenseAlreadyInstalled() {
        System.out.println("InstallFirstTempLicense: begin isLicenseAlreadyInstalled()");
        Enumeration errorEnum = this.errorMessage.elements();
        StringBuffer sb = new StringBuffer();
        while (errorEnum.hasMoreElements()) {
            sb.append(errorEnum.nextElement());
        }
        System.out.println("InstallFirstTempLicense: end isLicenseAlreadyInstalled()");
        return sb.toString().startsWith("A license key for \"" + Installer.SW_PRODUCT + "\" already exists.") || sb.toString().startsWith("A permanent license key for \"" + Installer.SW_PRODUCT + "\" already existed in the system.");
    }

    private void showErrorMessage() {
        System.out.println("InstallFirstTempLicense: begin showErrorMessage()");
        Enumeration errorEnum = this.errorMessage.elements();
        StringBuffer sb = new StringBuffer();
        while (errorEnum.hasMoreElements()) {
            sb.append(errorEnum.nextElement());
        }
        System.out.println("Error:");
        System.out.println(sb);
        System.out.println("InstallFirstTempLicense: end showErrorMessage()");
    }

    private static void redirectOut(String traceProperty) {
        class NullPrintStream
        extends PrintStream {
            public NullPrintStream() {
                this(System.out);
            }

            public NullPrintStream(OutputStream out) {
                super(out);
            }

            public void println(String s) {
            }

            public void print(String s) {
            }
        }
        if (traceProperty == null) {
            System.setOut(new NullPrintStream());
            return;
        }
        if (traceProperty.equals("disabled")) {
            System.setOut(new NullPrintStream());
        } else if (traceProperty.equals("console")) {
            System.setOut(System.out);
        } else {
            try {
                File traceFile = new File("trace.installOfflineLicense");
                PrintStream printStream = new PrintStream(new FileOutputStream(traceFile));
                System.setOut(printStream);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.setOut(System.out);
            }
        }
    }
}

