/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinelikeyinst;

import java.io.UnsupportedEncodingException;

class ConnectionUtil {

    public static class ComBitMask {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private int maxLength = 0;
        private final byte[] bitMask = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

        public ComBitMask(int length, byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
            this.maxLength = length;
        }

        public void setBit(int bitNum) {
            int byteIndex = this.comBufferOffset + bitNum / 8;
            int bitIndex = bitNum % 8;
            int n = byteIndex;
            this.comBuffer[n] = (byte)(this.comBuffer[n] | this.bitMask[bitIndex]);
        }

        public void clearBit(int bitNum) {
            int byteIndex = this.comBufferOffset + bitNum / 8;
            int bitIndex = bitNum % 8;
            int n = byteIndex;
            this.comBuffer[n] = (byte)(this.comBuffer[n] & ~this.bitMask[bitIndex]);
        }

        public byte testBit(int bitNum) {
            int byteIndex = this.comBufferOffset + bitNum / 8;
            int bitIndex = bitNum % 8;
            return (byte)(this.comBuffer[byteIndex] & this.bitMask[bitIndex]);
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }

    public static class ComByteArray {
        private byte[] comBuffer;
        private int maxLength = 0;
        private int comBufferOffset = 0;

        public ComByteArray(int length, byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
            this.maxLength = length;
        }

        public void setByteArray(byte[] value) {
            System.arraycopy(value, 0, this.comBuffer, this.comBufferOffset, this.maxLength);
        }

        public byte[] getByteArray() {
            byte[] ret = new byte[this.maxLength];
            System.arraycopy(this.comBuffer, this.comBufferOffset, ret, 0, this.maxLength);
            return ret;
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }

    public static class ComByte {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private int maxLength = 1;

        public ComByte(byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
        }

        public void setByte(byte value) {
            this.comBuffer[this.comBufferOffset] = value;
        }

        public byte getByte() {
            return this.comBuffer[this.comBufferOffset];
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }

    public static class ComShort {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private short shortVal = 0;
        private int maxLength = 2;

        public ComShort(byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
        }

        public void setShort(short value) {
            this.shortVal = value;
            this.Serialize();
        }

        public short getShort() {
            return this.shortVal;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Deserialize(byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
            this.shortVal = 0;
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset] & 0xFF) << 8));
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 0));
        }

        public void Deserialize() {
            this.shortVal = 0;
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset] & 0xFF) << 8));
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 0));
        }

        public void Serialize() {
            this.comBuffer[this.comBufferOffset] = (byte)(this.shortVal >> 8 & 0xFF);
            this.comBuffer[this.comBufferOffset + 1] = (byte)(this.shortVal & 0xFF);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public static short get(byte[] buffer, int offset) {
            short shortVal = 0;
            shortVal = (short)(shortVal + ((buffer[offset] & 0xFF) << 8));
            shortVal = (short)(shortVal + ((buffer[offset + 1] & 0xFF) << 0));
            return shortVal;
        }

        public static void put(short value, byte[] buffer, int offset) {
            buffer[offset] = (byte)(value >> 8 & 0xFF);
            buffer[offset + 1] = (byte)(value & 0xFF);
        }
    }

    public static class ComInt {
        private byte[] comBuffer;
        private int maxLength = 4;
        private int intValue = 0;
        private int comBufferOffset = 0;

        public ComInt(byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
        }

        public void setInt(int value) {
            this.intValue = value;
            this.Serialize();
        }

        public int getInt() {
            return this.intValue;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Deserialize(byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
            this.intValue = 0;
            this.intValue += (this.comBuffer[this.comBufferOffset] & 0xFF) << 24;
            this.intValue += (this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 16;
            this.intValue += (this.comBuffer[this.comBufferOffset + 2] & 0xFF) << 8;
            this.intValue += (this.comBuffer[this.comBufferOffset + 3] & 0xFF) << 0;
        }

        public void Deserialize() {
            this.intValue = 0;
            this.intValue += (this.comBuffer[this.comBufferOffset] & 0xFF) << 24;
            this.intValue += (this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 16;
            this.intValue += (this.comBuffer[this.comBufferOffset + 2] & 0xFF) << 8;
            this.intValue += (this.comBuffer[this.comBufferOffset + 3] & 0xFF) << 0;
        }

        public void Serialize() {
            this.comBuffer[this.comBufferOffset] = (byte)(this.intValue >> 24 & 0xFF);
            this.comBuffer[this.comBufferOffset + 1] = (byte)(this.intValue >> 16 & 0xFF);
            this.comBuffer[this.comBufferOffset + 2] = (byte)(this.intValue >> 8 & 0xFF);
            this.comBuffer[this.comBufferOffset + 3] = (byte)(this.intValue & 0xFF);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public static int get(byte[] buffer, int offset) {
            int intValue = 0;
            intValue += (buffer[offset] & 0xFF) << 24;
            intValue += (buffer[offset + 1] & 0xFF) << 16;
            intValue += (buffer[offset + 2] & 0xFF) << 8;
            return intValue += (buffer[offset + 3] & 0xFF) << 0;
        }

        public static void put(int value, byte[] buffer, int offset) {
            buffer[offset] = (byte)(value >> 24 & 0xFF);
            buffer[offset + 1] = (byte)(value >> 16 & 0xFF);
            buffer[offset + 2] = (byte)(value >> 8 & 0xFF);
            buffer[offset + 3] = (byte)(value & 0xFF);
        }
    }

    public static class ComLong {
        private byte[] comBuffer;
        private int maxLength = 8;
        private long longValue = 0L;
        private int comBufferOffset = 0;

        public ComLong(byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
        }

        public void setLong(long value) {
            this.longValue = value;
            this.Serialize();
        }

        public long getLong() {
            return this.longValue;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Deserialize(byte[] buffer, int offset) {
            this.comBuffer = buffer;
            this.comBufferOffset = offset;
            this.longValue = 0L;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset] & 0xFFL) << 56;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 1] & 0xFFL) << 48;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 2] & 0xFFL) << 40;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 3] & 0xFFL) << 32;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 4] & 0xFFL) << 24;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 5] & 0xFFL) << 16;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 6] & 0xFFL) << 8;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 7] & 0xFFL) << 0;
        }

        public void Deserialize() {
            this.longValue = 0L;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset] & 0xFFL) << 56;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 1] & 0xFFL) << 48;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 2] & 0xFFL) << 40;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 3] & 0xFFL) << 32;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 4] & 0xFFL) << 24;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 5] & 0xFFL) << 16;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 6] & 0xFFL) << 8;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 7] & 0xFFL) << 0;
        }

        public void Serialize() {
            this.comBuffer[this.comBufferOffset] = (byte)(this.longValue >> 56 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 1] = (byte)(this.longValue >> 48 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 2] = (byte)(this.longValue >> 40 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 3] = (byte)(this.longValue >> 32 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 4] = (byte)(this.longValue >> 24 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 5] = (byte)(this.longValue >> 16 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 6] = (byte)(this.longValue >> 8 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 7] = (byte)(this.longValue & 0xFFL);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public static long get(byte[] buffer, int offset) {
            long longValue = 0L;
            longValue += ((long)buffer[offset] & 0xFFL) << 56;
            longValue += ((long)buffer[offset + 1] & 0xFFL) << 48;
            longValue += ((long)buffer[offset + 2] & 0xFFL) << 40;
            longValue += ((long)buffer[offset + 3] & 0xFFL) << 32;
            longValue += ((long)buffer[offset + 4] & 0xFFL) << 24;
            longValue += ((long)buffer[offset + 5] & 0xFFL) << 16;
            longValue += ((long)buffer[offset + 6] & 0xFFL) << 8;
            return longValue += ((long)buffer[offset + 7] & 0xFFL) << 0;
        }

        public static void put(long value, byte[] buffer, int offset) {
            buffer[offset] = (byte)(value >> 56 & 0xFFL);
            buffer[offset + 1] = (byte)(value >> 48 & 0xFFL);
            buffer[offset + 2] = (byte)(value >> 40 & 0xFFL);
            buffer[offset + 3] = (byte)(value >> 32 & 0xFFL);
            buffer[offset + 4] = (byte)(value >> 24 & 0xFFL);
            buffer[offset + 5] = (byte)(value >> 16 & 0xFFL);
            buffer[offset + 6] = (byte)(value >> 8 & 0xFFL);
            buffer[offset + 7] = (byte)(value & 0xFFL);
        }
    }

    public static class ComString {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private int maxLength = 0;
        private String string = "";
        private static byte[] blankBuf;

        public ComString(int length, byte[] buffer, int offset) {
            if (blankBuf == null) {
                blankBuf = new byte[1024];
            }
            this.comBuffer = buffer;
            this.maxLength = length;
            this.comBufferOffset = offset;
        }

        public void setString(String value) {
            this.string = value;
            this.Serialize();
        }

        public String getString() {
            return this.string;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Serialize() {
            int len = 0;
            try {
                byte[] utf8 = this.string.getBytes("UTF8");
                len = utf8.length;
                if (len > this.maxLength) {
                    len = this.maxLength;
                }
                System.arraycopy(utf8, 0, this.comBuffer, this.comBufferOffset, len);
                if (this.maxLength > len && len >= 0) {
                    int boff = this.comBufferOffset + len;
                    int blen = this.maxLength - len;
                    System.arraycopy(blankBuf, 0, this.comBuffer, boff, blen);
                }
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return;
            }
        }

        public void DeserializeDelBlanks() {
            int ndx = 0;
            while (ndx < this.maxLength) {
                if (this.comBuffer[this.comBufferOffset + ndx] == 32 || this.comBuffer[this.comBufferOffset + ndx] == 0) break;
                ++ndx;
            }
            this.string = new String(this.comBuffer, this.comBufferOffset, ndx);
        }

        public void Deserialize() {
            int ndx = 0;
            while (ndx < this.maxLength) {
                if (this.comBuffer[this.comBufferOffset + ndx] == 0) break;
                ++ndx;
            }
            this.string = new String(this.comBuffer, this.comBufferOffset, ndx);
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }
}

