/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipContainer {
    private String[] dirs = null;
    private String[] files = null;
    private ZipFile zf = null;
    private Hashtable ht = null;
    private HashSet _f = new HashSet();

    public ZipContainer(ZipFile zf, String[] dirs, String[] files) {
        this.zf = zf;
        this.dirs = dirs;
        this.files = files;
        this.ht = new Hashtable();
        int i = 0;
        while (i < files.length) {
            this._f.add(files[i]);
            ++i;
        }
        this.processZip();
    }

    private void processZip() {
        Enumeration<? extends ZipEntry> en = this.zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            String zen = ze.getName().toLowerCase();
            if (zen.endsWith("/") || this.addToFiles(ze, zen)) continue;
            this.addToDirs(ze, zen);
        }
    }

    private boolean addToDirs(ZipEntry ze, String zen) {
        if (this.dirs == null) {
            return false;
        }
        int i = 0;
        while (i < this.dirs.length) {
            String dir = this.dirs[i].toLowerCase();
            if (zen.startsWith(dir)) {
                Vector<ZipEntry> v = (Vector<ZipEntry>)this.ht.get(dir);
                if (v == null) {
                    v = new Vector<ZipEntry>();
                    v.add(ze);
                    this.ht.put(dir, v);
                } else {
                    v.add(ze);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean addToFiles(ZipEntry ze, String zen) {
        if (this.files == null) {
            return false;
        }
        if (this._f.contains(zen)) {
            this.ht.put(zen, ze);
            return true;
        }
        return false;
    }

    public ZipEntry getFile(String filename) {
        ZipEntry ze = null;
        Object ob = this.ht.get(filename.toLowerCase());
        ze = (ZipEntry)ob;
        return ze;
    }

    public Vector getDir(String dirname) {
        Vector v = null;
        Object ob = this.ht.get(dirname.toLowerCase());
        v = (Vector)ob;
        return v;
    }

    public void printHash() {
        if (this.ht.size() > 0) {
            System.out.println("printing...");
            Enumeration en = this.ht.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                System.out.println(key);
                Vector v = (Vector)this.ht.get(key);
                System.out.println("vector: " + v);
            }
        }
    }
}

