/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.tools.offlinedeploy.rdb.OfflineComponentDeployImpl;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class XMLParseInputStream
extends FilterInputStream {
    private BufferedReader br = null;
    private Properties variables = null;
    private byte[] buf = null;
    private int pos = 0;
    private String zipEntryName;
    private OfflineComponentDeployImpl deployImpl;

    public XMLParseInputStream(InputStream is, Properties variables, String zipEntryName, OfflineComponentDeployImpl deployImpl) {
        super(is);
        this.variables = variables;
        this.zipEntryName = zipEntryName;
        this.deployImpl = deployImpl;
        this.br = new BufferedReader(new InputStreamReader(this.in));
    }

    public int read() throws IOException {
        return this.getNextByte();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int k = 0;
        int i = 0;
        while (i < b.length) {
            if (k < len) {
                int j = this.read();
                if (j == -1) {
                    if (i != 0) break;
                    i = -1;
                    break;
                }
                b[i + off] = (byte)j;
                ++k;
            } else {
                if (i != 0) break;
                i = -1;
                break;
            }
            ++i;
        }
        return i;
    }

    private synchronized int getNextByte() throws IOException {
        int res = -2;
        if (this.buf == null) {
            res = this.readNext();
        }
        if (this.pos == this.buf.length) {
            res = this.readNext();
        }
        if (res != -1) {
            res = this.buf[this.pos];
            ++this.pos;
        }
        return res;
    }

    private int readNext() throws IOException {
        String s = this.br.readLine();
        if (s == null) {
            return -1;
        }
        StringBuffer line = new StringBuffer(s);
        line.append("\r\n");
        line = this.substituteTags(line);
        this.buf = line.toString().getBytes();
        this.pos = 0;
        return this.pos;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuffer substituteTags(StringBuffer line) {
        Enumeration en = ((Hashtable)this.variables).keys();
        block0: while (en.hasMoreElements()) {
            int i;
            String tagKey = (String)en.nextElement();
            String str = "${" + tagKey + "}";
            while ((i = line.toString().indexOf(str)) != -1) {
                void var2_3;
                if (this.deployImpl.isSystemSubstitutionVariable(str)) {
                    this.deployImpl.addToWarningBuffer("File " + this.zipEntryName + " uses forbiden system substitution variable " + str + ".\n");
                    continue block0;
                }
                if (str.equals("${com.sap.datasource.default}")) {
                    if (this.isDatasourceXML()) continue block0;
                    this.deployImpl.addToWarningBuffer("File " + this.zipEntryName + " uses forbiden system substitution variable " + str + ".\n");
                    continue block0;
                }
                line.replace((int)var2_3, (int)(var2_3 + str.length()), this.variables.getProperty(tagKey));
            }
        }
        return line;
    }

    private boolean isDatasourceXML() {
        int index = this.zipEntryName.lastIndexOf(47);
        String name = index != -1 ? this.zipEntryName.substring(index + 1) : this.zipEntryName;
        return name.equals("data-source-aliases.xml");
    }
}

