/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.tools.offlinedeploy.rdb.LogonData;
import com.sap.engine.tools.offlinedeploy.rdb.OnlineModule;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class OnlineModuleImpl
implements OnlineModule {
    private InitialContext ctx;
    private ConfigurationContext context;
    private LogonData data;

    public OnlineModuleImpl(LogonData logonData) {
        this.data = logonData;
    }

    public synchronized Properties getCurrentConfigurationProperties() throws Exception {
        try {
            this.connect();
            Properties properties = this.context.getCurrentProperties();
            Object var3_2 = null;
            this.disconnect();
            return properties;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.disconnect();
            throw throwable;
        }
    }

    public synchronized void getCurrentConfigurationProperties(File destinationFile) throws Exception {
        Properties props = this.getCurrentConfigurationProperties();
        props.store(new FileOutputStream(destinationFile), "");
    }

    public synchronized String getJDBCDriver() throws Exception {
        return null;
    }

    private void connect() throws Exception {
        Properties props = new Properties();
        ((Hashtable)props).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)props).put("java.naming.provider.url", this.data.getDestinationHost() + ":" + this.data.getDestinationPort());
        ((Hashtable)props).put("java.naming.security.principal", this.data.getLogonPrincipal());
        ((Hashtable)props).put("java.naming.security.credentials", this.data.getLogonCredentials());
        this.ctx = new InitialContext(props);
        ConfigurationRuntimeInterface remote = (ConfigurationRuntimeInterface)this.ctx.lookup("configuration");
        this.context = remote.getConfigurationContext();
    }

    private void disconnect() {
        this.context = null;
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.ctx = null;
        }
    }
}

