/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.core.configuration.impl.addons.hashindex.ConfigurationInDepthIterator;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.io.hash.InDepthIterator;
import com.sap.engine.lib.io.hash.Index;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.tools.offlinedeploy.rdb.ComponentNotDeployedException;
import com.sap.engine.tools.offlinedeploy.rdb.EntityResolverImpl;
import com.sap.engine.tools.offlinedeploy.rdb.ODeploymentException;
import com.sap.engine.tools.offlinedeploy.rdb.OWarningException;
import com.sap.engine.tools.offlinedeploy.rdb.OfflineComponentDeploy;
import com.sap.engine.tools.offlinedeploy.rdb.XMLParseInputStream;
import com.sap.engine.tools.offlinedeploy.rdb.ZipContainer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class OfflineComponentDeployImpl
implements OfflineComponentDeploy {
    public static final String BOOTSTRAP_INDEX = "bootstrapIndex";
    public static final String DISPATCHER_INDEX = "dispatcherIndex";
    public static final String SERVER_INDEX = "serverIndex";
    public static final String BIN_VERSION = "binVersion";
    public static final String OS_LIB_VERSION = "os_libVersion";
    private static final String CONFIG_ROOT = "cluster_data";
    private static final String CFG_BASE = "/cfg";
    private static final String BIN_BASE = "/bin";
    private static final String PERSISTENT_BASE = "/persistent";
    private static final String DESCRIPTORS_BASE = "/descriptors";
    private static final String[] ZIP_DIRS = new String[]{"dispatcher/persistent", "server/persistent", "dispatcher/descriptors", "server/descriptors"};
    private static String[] ZIP_FILES = new String[]{"dispatcher/provider.xml", "server/provider.xml", "meta-inf/manifest.mf", "meta-inf/sap_manifest.mf", "dispatcher/properties", "server/properties", "dispatcher/runtime.properties", "server/runtime.properties"};
    private static final String[] DESTINATIONS = new String[]{"dispatcher", "server"};
    private static final String PROVIDER = "provider.xml";
    private static final String PROPS = "properties";
    private static final String RUNTIME_PROPS = "runtime.properties";
    private static final String RUNTIME = "-runtime";
    private static final String INTERFACE_BASE = "/interfaces";
    private static final String LIBRARY_BASE = "/ext";
    private static final String SERVICE_BASE = "/services";
    private static final String VERSION_TXT = "version.txt";
    private static final String JITEXCLUDE = ".hotspot_compiler";
    private static final String[] KERNEL_BINARY_DISPATCHER = new String[]{"dispatcher/bin/boot", "dispatcher/bin/system", "dispatcher/bin/kernel", "dispatcher/bin/core_lib"};
    private static final String[] KERNEL_BINARY_SERVER = new String[]{"server/bin/boot", "server/bin/system", "server/bin/kernel", "server/bin/core_lib"};
    private static final String[] CFGS = new String[]{"dispatcher/cfg/kernel", "server/cfg/kernel", "server/META-INF", "dispatcher/dtd", "server/dtd"};
    private static final String[] FILTER = new String[]{"kernel.properties"};
    private static final String DEFAULT_PFNAME = "./config.input.properties";
    private static final String DEFAULT_PN = "engine.sap.com";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String SAP_MANIFEST = "META-INF/SAP_MANIFEST.MF";
    private static final String SEARCH_RULES = "META-INF/SearchRules.xml";
    private static final String OS_LIBS = "OS_libs/";
    private static final String NATIVE_DESCRIPTOR = "native.descriptor";
    private static final String[] SAP_PROVIDERS = new String[]{"engine.sap.com", "sap.com"};
    private static final String UNDEPLOY_LIST_KEY = "#undeploy&list#";
    private static final String UNDEPLOY_CONFIGURATION_NAME = "undeploy";
    private static final String UNDEPLOY_MAPPING = "mapping.txt";
    private static final String EXCLUDE_RELATIVE_PATH_PREFIX = "##";
    private static final String SECURED_CONFIGURATION = "SECURED";
    private static final String DATA_SOURCES_XML = "data-sources.xml";
    static final String DATA_SOURCE_ALIACE_XML = "data-source-aliases.xml";
    static final String[] SYSTEM_SUBSTITUTION_VARIABLES = new String[]{"${com.sap.InstanceNumber}", "${com.sap.SID}", "${com.sap.engine.installdir}", "${com.sap.instancedir}", "${com.sap.systemdir}"};
    static final String DATASOURCE_SUBSTITUTION_VARIABLE = "${com.sap.datasource.default}";
    private String dtd_base = "./dtd";
    private StandardDOMParser domParser;
    private int factoryIndex = -1;
    private ConfigurationHandler handler = null;
    private Configuration cR = null;
    private boolean overwrite = true;
    private StringBuffer warningBuff = new StringBuffer();
    private static final long FACTORY_EXPIRE_TIME = 480000L;
    private static final int initialSize = 10;
    private static Properties[] properties = new Properties[10];
    private static ConfigurationHandlerFactory[] factories = new ConfigurationHandlerFactory[10];
    private static long[] last_use = new long[10];
    private static int pos = 0;
    private static Object staticLock = new Object();
    private boolean isKernelComponent = false;
    private boolean componentNameOverridden = false;
    private String providerName_ = null;
    private String componentName_ = null;

    private ConfigurationHandlerFactory getConfigurationHandlerFactory() throws Exception {
        Object object = staticLock;
        synchronized (object) {
            if (System.currentTimeMillis() - last_use[this.factoryIndex] >= 480000L) {
                ((ConfigurationManagerBootstrapImpl)factories[this.factoryIndex]).shutdown();
                OfflineComponentDeployImpl.factories[this.factoryIndex] = new ConfigurationManagerBootstrapImpl(properties[this.factoryIndex]);
            }
            OfflineComponentDeployImpl.last_use[this.factoryIndex] = System.currentTimeMillis();
            ConfigurationHandlerFactory configurationHandlerFactory = factories[this.factoryIndex];
            return configurationHandlerFactory;
        }
    }

    public void close() {
        Object object = staticLock;
        synchronized (object) {
            int i = 0;
            while (i < factories.length) {
                if (factories[i] != null) {
                    ((ConfigurationManagerBootstrapImpl)factories[i]).shutdown();
                    OfflineComponentDeployImpl.factories[i] = null;
                }
                OfflineComponentDeployImpl.properties[i] = null;
                OfflineComponentDeployImpl.last_use[i] = 0L;
                ++i;
            }
            pos = 0;
            this.factoryIndex = -1;
        }
    }

    public OfflineComponentDeployImpl(String dtdDir, boolean overwrite) {
        if (dtdDir == null || dtdDir.equals("")) {
            dtdDir = this.dtd_base;
        }
        this.dtd_base = dtdDir.trim().endsWith("/dtd") || dtdDir.trim().endsWith("/dtd/") ? dtdDir : (dtdDir.endsWith("/") ? dtdDir + "dtd" : dtdDir + "/dtd");
        this.overwrite = overwrite;
        try {
            EntityResolverImpl er = new EntityResolverImpl(this.dtd_base);
            this.domParser = new StandardDOMParser();
            this.domParser.setEntityResolver((EntityResolver)er);
            this.domParser.setValidation(true);
        }
        catch (Exception exc) {
            System.out.println("ERROR: Can't initialize XML parser.");
            exc.printStackTrace();
            System.exit(11);
        }
    }

    public synchronized void setConfigurationProperties(Properties configProperties) throws OWarningException, ODeploymentException {
        try {
            this.componentNameOverridden = false;
            this.providerName_ = null;
            this.componentName_ = null;
            Object object = staticLock;
            synchronized (object) {
                int index = this.checkForEquals(configProperties);
                if (index == -1) {
                    if (pos == properties.length) {
                        int newLenght = properties.length * 2;
                        Properties[] p_tmp = new Properties[newLenght];
                        ConfigurationHandlerFactory[] f_tmp = new ConfigurationHandlerFactory[newLenght];
                        long[] l_tmp = new long[newLenght];
                        System.arraycopy(properties, 0, p_tmp, 0, properties.length);
                        System.arraycopy(factories, 0, f_tmp, 0, factories.length);
                        System.arraycopy(last_use, 0, l_tmp, 0, last_use.length);
                        properties = p_tmp;
                        factories = f_tmp;
                        last_use = l_tmp;
                    }
                    OfflineComponentDeployImpl.factories[OfflineComponentDeployImpl.pos] = new ConfigurationManagerBootstrapImpl(configProperties);
                    OfflineComponentDeployImpl.properties[OfflineComponentDeployImpl.pos] = configProperties;
                    OfflineComponentDeployImpl.last_use[OfflineComponentDeployImpl.pos] = System.currentTimeMillis();
                    this.factoryIndex = pos++;
                } else {
                    this.factoryIndex = index;
                }
            }
        }
        catch (Exception e) {
            this.throwOD(e, "ERROR: Can't initialize Conrfiguration manager!");
            System.exit(10);
        }
    }

    public synchronized void setConfigurationProperties(String filename) throws OWarningException, ODeploymentException {
        try {
            this.componentNameOverridden = false;
            this.providerName_ = null;
            this.componentName_ = null;
            Properties props = new Properties();
            props.load(new FileInputStream(new File(filename)));
            this.setConfigurationProperties(props);
        }
        catch (IOException e) {
            this.throwOD(e, "ERROR: Can't locate DB properties file: " + filename + "!");
            System.exit(10);
        }
    }

    public synchronized void deployComponent(File jar, String providerName, String componentName, byte componentType) throws OWarningException, ODeploymentException {
        if (providerName == null || componentName == null) {
            throw new NullPointerException("providerName and componentName can't be null");
        }
        this.setComponentName(providerName, componentName);
        this.deployComponent(jar, componentType);
    }

    public synchronized void deployComponent(File jar, byte componentType) throws OWarningException, ODeploymentException {
        this.deployComponent(jar, componentType, null);
    }

    public synchronized void deployComponent(File jar, String providerName, String componentName, byte componentType, Properties variables) throws OWarningException, ODeploymentException {
        if (providerName == null || componentName == null) {
            throw new NullPointerException("providerName and componentName can't be null");
        }
        this.setComponentName(providerName, componentName);
        this.deployComponent(jar, componentType, variables);
    }

    public synchronized void deployComponent(File jar, byte componentType, Properties variables) throws OWarningException, ODeploymentException {
        System.out.println("Upload information in " + jar.getName() + " file.");
        System.out.println("Processing...");
        String toRemove = this.getDCReplace(jar);
        if (toRemove != null) {
            StringTokenizer st = new StringTokenizer(toRemove, ";");
            while (st.hasMoreTokens()) {
                String name = st.nextToken().trim();
                if (name.equals("")) continue;
                name = name.replace('/', '~');
                try {
                    this.undeployComponent(name, componentType);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.deployComponent0(jar, componentType, variables);
        this.componentNameOverridden = false;
        this.providerName_ = null;
        this.componentName_ = null;
    }

    public synchronized void undeployComponent(String componentName, byte componentType) throws OWarningException, ODeploymentException {
        this.undeployComponent(DEFAULT_PN, componentName, componentType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void undeployComponent(String providerName, String originalComponentName, byte componentType) throws OWarningException, ODeploymentException {
        String componentName = this.modifyComponentName(originalComponentName, providerName);
        System.out.println("Remove " + componentName + ".");
        System.out.println("Processing...");
        try {
            try {
                this.handler = this.getHandler();
                if (componentType == 104) {
                    this.removeBootstrap();
                } else if (componentType == 103) {
                    this.removeKernel();
                } else {
                    this.remove(componentName, componentType, providerName, originalComponentName);
                }
                this.handler.commit();
                if (this.warningBuff.length() > 0) {
                    throw new OWarningException(this.warningBuff.toString());
                }
                Object var9_5 = null;
            }
            catch (OWarningException exc) {
                throw exc;
            }
            catch (ComponentNotDeployedException exc) {
                this.rollback();
                throw exc;
            }
            catch (Exception exc) {
                this.rollback();
                this.throwOD(exc, "WARNING: Can't remove component " + componentName);
                Object var9_6 = null;
                this.doFinally(null);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.doFinally(null);
            throw throwable;
        }
        this.doFinally(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void undeployComponent(File jar, byte componentType) throws OWarningException, ODeploymentException {
        System.out.println("Remove information in " + jar.getName() + " file.");
        System.out.println("Processing...");
        ZipFile zip = null;
        ZipContainer zc = null;
        try {
            try {
                this.handler = this.getHandler();
                zip = new ZipFile(jar);
                if (componentType == 104) {
                    this.removeBootstrap();
                } else if (componentType == 103) {
                    this.removeKernel();
                } else {
                    zc = new ZipContainer(zip, ZIP_DIRS, ZIP_FILES);
                    this.remove(zip, zc, componentType);
                }
                this.handler.commit();
                if (this.warningBuff.length() > 0) {
                    throw new OWarningException(this.warningBuff.toString());
                }
                Object var9_5 = null;
            }
            catch (OWarningException exc) {
                throw exc;
            }
            catch (ComponentNotDeployedException exc) {
                this.rollback();
                throw exc;
            }
            catch (Exception exc) {
                this.rollback();
                this.throwOD(exc, "WARNING: Can't remove component " + this.getPath(jar));
                Object var9_6 = null;
                this.doFinally(zip);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.doFinally(zip);
            throw throwable;
        }
        this.doFinally(zip);
    }

    private synchronized void setComponentName(String providerName, String componentName) {
        this.providerName_ = providerName;
        this.componentName_ = componentName;
        this.componentNameOverridden = true;
    }

    private int checkForEquals(Properties p) {
        int result = -1;
        int i = 0;
        while (i < properties.length) {
            if (this.propsEqual(p, properties[i])) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private ConfigurationHandler getHandler() throws Exception {
        if (this.factoryIndex == -1) {
            this.setConfigurationProperties(DEFAULT_PFNAME);
        }
        this.handler = this.getConfigurationHandlerFactory().getConfigurationHandler();
        this.cR = this.getRootConfiguration(this.handler, CONFIG_ROOT, 1);
        Integer ver = null;
        try {
            ver = (Integer)this.cR.getConfigEntry(BIN_VERSION);
            this.cR.modifyConfigEntry(BIN_VERSION, new Integer(ver + 1));
        }
        catch (ConfigurationException e) {
            this.cR.addConfigEntry(BIN_VERSION, new Integer(1));
        }
        return this.handler;
    }

    private boolean propsEqual(Properties p1, Properties p2) {
        boolean res = false;
        if (p1 != null && p2 != null && ((Hashtable)p1).size() == ((Hashtable)p2).size()) {
            Enumeration keys1 = ((Hashtable)p1).keys();
            while (keys1.hasMoreElements()) {
                String key1 = (String)keys1.nextElement();
                String value1 = p1.getProperty(key1);
                String value2 = p2.getProperty(key1);
                if (value1 != null && value2 != null && value1.equals(value2)) continue;
                return false;
            }
            res = true;
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deployComponent0(File jar, byte componentType, Properties variables) throws OWarningException, ODeploymentException {
        ZipFile zip = null;
        ZipContainer zc = null;
        try {
            try {
                if (!jar.exists()) {
                    this.throwOD(null, "WARNING: Can't deploy component sda " + this.getPath(jar) + " doesn't exists.");
                } else {
                    this.handler = this.getHandler();
                    zip = new ZipFile(jar);
                    if (componentType == 104) {
                        this.uploadBootstrap(zip);
                    } else if (componentType == 103) {
                        this.isKernelComponent = true;
                        this.uploadKernel(zip);
                    } else {
                        zc = new ZipContainer(zip, ZIP_DIRS, ZIP_FILES);
                        this.upload(zip, zc, componentType, variables);
                    }
                    this.handler.commit();
                    if (this.warningBuff.length() > 0) {
                        throw new OWarningException(this.warningBuff.toString());
                    }
                }
                Object var9_6 = null;
                this.isKernelComponent = false;
            }
            catch (OWarningException exc) {
                throw exc;
            }
            catch (Exception exc) {
                this.rollback();
                this.throwOD(exc, "WARNING: Can't deploy component with sda " + this.getPath(jar));
                Object var9_7 = null;
                this.isKernelComponent = false;
                this.doFinally(zip);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.isKernelComponent = false;
            this.doFinally(zip);
            throw throwable;
        }
        this.doFinally(zip);
    }

    private String getPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    private void doFinally(ZipFile zip) throws ODeploymentException {
        try {
            if (zip != null) {
                zip.close();
            }
        }
        catch (Exception e) {
            System.out.println("INFO: Warning can't close sda file. Detailed info: " + this.getStackTrace(e) + "\n");
        }
        this.warningBuff.delete(0, this.warningBuff.length());
        try {
            if (this.handler != null) {
                this.handler.closeAllConfigurations();
            }
        }
        catch (ConfigurationException exc) {
            this.throwOD((Exception)((Object)exc), null);
        }
        this.handler = null;
    }

    private void rollback() throws ODeploymentException {
        try {
            if (this.handler != null) {
                this.handler.rollback();
            }
        }
        catch (Exception e) {
            this.throwOD(e, "WARNING: Warning can't rollback. Detailed info: " + this.getStackTrace(e));
        }
    }

    private void uploadKernel(ZipFile zipFile) throws Exception {
        this.storeOSLibs(zipFile, "kernel", "kernel_native_undeploy_info");
        try {
            this.addFileInDB(zipFile, null, VERSION_TXT, this.cR, VERSION_TXT, true, null, null, null);
            this.addFileInDB(zipFile, null, JITEXCLUDE, this.cR, JITEXCLUDE, false, null, null, null);
        }
        catch (Exception e) {
            this.warningBuff.append("Kernel deploy: " + e.toString() + "\n");
        }
        Configuration cfg = this.createSubContfigurations(this.cR, "dispatcher/bin");
        Index index = this.getIndex(DISPATCHER_INDEX, cfg);
        int i = 0;
        while (i < KERNEL_BINARY_DISPATCHER.length) {
            this.addDirInDB(zipFile, null, KERNEL_BINARY_DISPATCHER[i], this.cR, null, false, null, false, index, "##dispatcher/bin");
            ++i;
        }
        this.updateIndex(DISPATCHER_INDEX, index);
        cfg = this.createSubContfigurations(this.cR, "server/bin");
        index = this.getIndex(SERVER_INDEX, cfg);
        int i2 = 0;
        while (i2 < KERNEL_BINARY_SERVER.length) {
            this.addDirInDB(zipFile, null, KERNEL_BINARY_SERVER[i2], this.cR, null, false, null, false, index, "##server/bin");
            ++i2;
        }
        this.updateIndex(SERVER_INDEX, index);
        int i3 = 0;
        while (i3 < CFGS.length) {
            this.addDirInDB(zipFile, null, CFGS[i3], this.cR, null, true, null, false, null, null);
            ++i3;
        }
        try {
            Configuration c = this.createSubContfigurations(this.cR, "dispatcher");
            if (!c.existsSubConfiguration("cfg")) {
                c.createSubConfiguration("cfg");
            }
            Configuration c1 = c.getSubConfiguration("cfg");
            this.addPropInDB(zipFile, null, "dispatcher/cfg/element-info.properties", c1, "element-info", true, null, null);
            this.addFileInDB(zipFile, null, "dispatcher/java.policy", c, "java.policy", true, null, null, null);
            c = this.createSubContfigurations(this.cR, "server");
            if (!c.existsSubConfiguration("cfg")) {
                c.createSubConfiguration("cfg");
            }
            c1 = c.getSubConfiguration("cfg");
            this.addPropInDB(zipFile, null, "server/cfg/element-info.properties", c1, "element-info", true, null, null);
            this.addFileInDB(zipFile, null, "server/java.policy", c, "java.policy", true, null, null, null);
            this.addFileInDB(zipFile, null, "server/remote.policy", c, "remote.policy", true, null, null, null);
        }
        catch (Exception e) {
            this.warningBuff.append("Kernel deploy: " + e.toString() + "\n");
        }
    }

    private void uploadBootstrap(ZipFile zipFile) throws Exception {
        this.storeOSLibs(zipFile, "bootstrap", "bootstrap_native_undeploy_info");
        Configuration c = this.createSubContfigurations(this.cR, "bootstrap");
        Index index = this.getIndex(BOOTSTRAP_INDEX, c);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        Configuration fr = null;
        while (en.hasMoreElements()) {
            String name;
            ZipEntry ze = en.nextElement();
            String zipEntryName = ze.getName();
            if (zipEntryName.indexOf(47) == -1) {
                if (zipEntryName.equals("jvm.properties")) {
                    this.addPropInDB(zipFile, null, zipEntryName, c, "jvm", false, null, null);
                    continue;
                }
                this.addFileInDB(zipFile, null, zipEntryName, c, zipEntryName, false, null, index, null);
                continue;
            }
            if (!zipEntryName.startsWith("flightrecorder/")) continue;
            if (fr == null) {
                fr = c.existsSubConfiguration("flightrecorder") ? c.getSubConfiguration("flightrecorder") : c.createSubConfiguration("flightrecorder");
            }
            if ((name = zipEntryName.substring("flightrecorder/".length())).equals("") || name.indexOf(47) != -1) continue;
            this.addFileInDB(zipFile, null, zipEntryName, fr, name, false, null, index, "flightrecorder");
        }
        this.updateIndex(BOOTSTRAP_INDEX, index);
    }

    private void updateIndex(String name, Index index) throws ConfigurationException {
        if (index != null) {
            this.cR.updateFileAsStream(name, new ByteArrayInputStream(index.toByteArr()), true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Index getIndex(String name, Configuration cfg) throws Exception {
        byte[] byteArrayIndex;
        block5: {
            Index result = null;
            byteArrayIndex = null;
            if (this.cR.existsFile(name)) {
                InputStream is = null;
                try {
                    is = this.cR.getFile(name);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[512];
                    while (true) {
                        void var8_8;
                        int r;
                        if ((r = is.read(buffer)) == -1) {
                            byteArrayIndex = baos.toByteArray();
                            Object var10_9 = null;
                            if (is == null) break block5;
                            break;
                        }
                        baos.write(buffer, 0, (int)var8_8);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
        }
        if (byteArrayIndex != null) return HashUtils.getIndex(byteArrayIndex, 0);
        return HashUtils.getIndex((InDepthIterator)new ConfigurationInDepthIterator(cfg));
    }

    private void removeBootstrap() throws Exception {
        Configuration c = this.cR.getSubConfiguration("bootstrap");
        Index index = this.getIndex(BOOTSTRAP_INDEX, c);
        if (this.cR.existsSubConfiguration("bootstrap")) {
            this.cR.deleteConfiguration("bootstrap");
            index.deleteAll(false);
            this.updateIndex(BOOTSTRAP_INDEX, index);
        }
        this.removeNativeParts("bootstrap", "bootstrap_native_undeploy_info");
    }

    private void upload(ZipFile zip, ZipContainer zc, byte componentType, Properties variables) throws Exception {
        String[] pncn = this.getPNCNFromJar(zip, zc);
        String[] kvkn = this.getKeyvendorKeyname(zip);
        if (!(kvkn[0] == null || kvkn[1] == null || kvkn[0].equals(pncn[0]) && kvkn[1].equals(pncn[1]))) {
            this.storeUndeployMapping(kvkn[0] + "$" + kvkn[1], pncn[0] + "$" + pncn[1]);
        }
        String componentName = null;
        componentName = this.componentNameOverridden ? this.modifyComponentName(this.componentName_, this.providerName_) : this.modifyComponentName(pncn[1], pncn[0]);
        this.storeOSLibs(zip, this.getTypeBase(componentType).substring(1), componentName + "_native_undeploy_info");
        String[] dst = this.getDestinationFromJar(zip, zc);
        if (dst != null) {
            int i = 0;
            while (i < dst.length) {
                this.uploadDst(componentName, componentType, dst[i], this.cR, zip, zc, variables);
                ++i;
            }
        } else {
            throw new RuntimeException("Can't find provider.xml for component " + componentName);
        }
    }

    private void uploadDst(String componentName, byte componentType, String destination, Configuration cR, ZipFile zipFile, ZipContainer zc, Properties variables) throws Exception {
        Index updatedIndex = this.deleteOldStructureJars(componentName, destination, componentType);
        Configuration c = this.createSubContfigurations(cR, destination + CFG_BASE + this.getTypeBase(componentType));
        String entryName = PROVIDER;
        String zipEntryName = destination + "/" + entryName;
        this.addFileInDB(zipFile, zc, zipEntryName, c, componentName + "-" + entryName, true, variables, null, null);
        ZipEntry sap_manifest = zc != null ? zc.getFile("meta-inf/sap_manifest.mf") : zipFile.getEntry(SAP_MANIFEST);
        if (sap_manifest != null) {
            Configuration sap_mf = this.createSubContfigurations(cR, destination + DESCRIPTORS_BASE + "/" + componentName);
            sap_mf.updateFileAsStream("SAP_MANIFEST.MF", zipFile.getInputStream(sap_manifest), true);
        }
        this.addDirInDB(zipFile, zc, destination + DESCRIPTORS_BASE, cR, componentName, false, variables, false, null, null);
        if (componentType == 102) {
            entryName = PROPS;
            zipEntryName = destination + "/" + entryName;
            this.addPropInDB(zipFile, zc, zipEntryName, c, componentName, true, variables, componentName);
            entryName = RUNTIME_PROPS;
            zipEntryName = destination + "/" + entryName;
            this.addPropInDB(zipFile, zc, zipEntryName, c, componentName + RUNTIME, true, variables, null);
            this.addDirInDB(zipFile, zc, destination + PERSISTENT_BASE, cR, componentName, false, variables, false, null, null);
        }
        entryName = PROVIDER;
        zipEntryName = destination + "/" + entryName;
        ZipEntry zipEntry = null;
        zipEntry = zc == null ? zipFile.getEntry(zipEntryName) : zc.getFile(zipEntryName);
        String[] jars = this.getJars(this.domParser.parse(zipFile.getInputStream(zipEntry)));
        String indexName = destination.equals(DESTINATIONS[0]) ? DISPATCHER_INDEX : SERVER_INDEX;
        c = this.createSubContfigurations(cR, destination + BIN_BASE);
        Index index = updatedIndex != null ? updatedIndex : this.getIndex(indexName, c);
        String relativePathPrefix = this.getTypeBase(componentType).substring(1) + "/" + componentName;
        c = this.createSubContfigurations(c, relativePathPrefix);
        HashSet existingFiles = new HashSet();
        this.getCompleteJarFileList(c, "", existingFiles);
        int i = 0;
        while (i < jars.length) {
            jars[i] = jars[i].replace('\\', '/');
            if (jars[i].charAt(0) == '/') {
                jars[i] = jars[i].substring(1);
            }
            if (jars[i].indexOf(47) == -1) {
                this.addFileInDB(zipFile, null, jars[i], c, jars[i], false, variables, index, relativePathPrefix);
            } else {
                String subDir = jars[i].substring(0, jars[i].lastIndexOf(47));
                Configuration cdir = this.createSubContfigurations(c, subDir);
                String currentPrefix = relativePathPrefix + "/" + subDir;
                this.addFileInDB(zipFile, null, jars[i], cdir, jars[i].substring(jars[i].lastIndexOf(47) + 1), false, variables, index, currentPrefix);
            }
            existingFiles.remove(jars[i]);
            ++i;
        }
        if (!existingFiles.isEmpty()) {
            String relativePath = this.getTypeBase(componentType).substring(1) + "/" + componentName;
            Iterator iterator = existingFiles.iterator();
            while (iterator.hasNext()) {
                String file = (String)iterator.next();
                try {
                    this.removeRecursive(c, file, index, relativePath);
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
            }
        }
        this.updateIndex(indexName, index);
    }

    private void getCompleteJarFileList(Configuration cfg, String prefix, Set files) throws ConfigurationException {
        String[] names = cfg.getAllFileEntryNames();
        int i = 0;
        while (i < names.length) {
            files.add(prefix + names[i]);
            ++i;
        }
        String[] cfgNames = cfg.getAllSubConfigurationNames();
        int i2 = 0;
        while (i2 < cfgNames.length) {
            this.getCompleteJarFileList(cfg.getSubConfiguration(cfgNames[i2]), prefix + cfgNames[i2] + "/", files);
            ++i2;
        }
    }

    private void removeRecursive(Configuration cfg, String file, Index index, String relativePath) throws Exception {
        if (file.indexOf(47) == -1) {
            cfg.deleteFile(file);
            index.deleteFileFrom(relativePath, file);
        } else {
            String dirName = file.substring(0, file.indexOf(47));
            String fileName = file.substring(file.indexOf(47) + 1);
            Configuration dirCfg = cfg.getSubConfiguration(dirName);
            this.removeRecursive(dirCfg, fileName, index, relativePath + "/" + dirName);
        }
        if (cfg.getAllSubConfigurationNames().length == 0 && cfg.getAllFileEntryNames().length == 0) {
            cfg.deleteConfiguration();
            String name = relativePath.substring(relativePath.lastIndexOf(47) + 1);
            String dir = relativePath.substring(0, relativePath.lastIndexOf(47));
            index.deleteFolderFrom(dir, name);
        }
    }

    private void addDirInDB(ZipFile zipFile, ZipContainer zc, String dirName, Configuration cR, String componentName, boolean props, Properties variables, boolean lowercase, Index index, String relativePathPrefix) throws Exception {
        Configuration cP = null;
        boolean firstElement = true;
        Enumeration<ZipEntry> en = null;
        if (zc == null) {
            en = zipFile.entries();
        } else {
            Vector v = zc.getDir(dirName);
            if (v != null) {
                en = v.elements();
            }
        }
        if (en != null) {
            while (en.hasMoreElements()) {
                String propConfigName;
                ZipEntry ze = en.nextElement();
                String zipEntryName = ze.getName();
                if (zc == null && !zipEntryName.startsWith(dirName)) continue;
                if (firstElement) {
                    String cName;
                    String string = cName = componentName == null ? dirName : dirName + "/" + componentName;
                    if (lowercase) {
                        cName = cName.toLowerCase();
                    }
                    cP = this.createSubContfigurations(cR, cName);
                    firstElement = false;
                }
                if (zipEntryName.endsWith("/")) continue;
                if (props && (propConfigName = this.getPropertiesConfigurationName(zipEntryName, FILTER)) != null) {
                    this.addPropInDB(zipFile, null, zipEntryName, cP, propConfigName, true, null, null);
                    continue;
                }
                String subName = zipEntryName.substring(dirName.length(), zipEntryName.lastIndexOf("/"));
                if (lowercase) {
                    subName = subName.toLowerCase();
                }
                Configuration c = !subName.equals("") ? this.createSubContfigurations(cP, subName.substring(1)) : cP;
                this.addFileInDB(zipFile, null, zipEntryName, c, zipEntryName.substring(zipEntryName.lastIndexOf("/") + 1), false, variables, index, relativePathPrefix);
            }
        }
    }

    private String getPropertiesConfigurationName(String zipEntryName, String[] filter) {
        String result = null;
        if (zipEntryName.endsWith(".properties")) {
            result = zipEntryName.substring(zipEntryName.lastIndexOf("/") + 1, zipEntryName.length());
            int i = 0;
            while (i < filter.length) {
                if (result.equals(filter[i])) {
                    return null;
                }
                ++i;
            }
            result = result.substring(0, result.length() - ".properties".length());
        }
        return result;
    }

    private String[] getJars(Document document) throws Exception {
        String[] result = null;
        Element root = document.getDocumentElement();
        NodeList list = root.getElementsByTagName("jars");
        if (list.getLength() > 0) {
            Element jars = (Element)list.item(0);
            String defaultJar = jars.getAttribute("default");
            if (defaultJar.equals("true")) {
                result = new String[]{};
            } else {
                NodeList jarList = jars.getElementsByTagName("jar-name");
                result = new String[jarList.getLength()];
                int i = 0;
                while (i < result.length) {
                    Element jar = (Element)jarList.item(i);
                    result[i] = this.getTextValue(jar);
                    ++i;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void addFileInDB(ZipFile zipFile, ZipContainer zc, String zipEntryName, Configuration c, String configEntryName, boolean require, Properties variables, Index index, String relativePathPrefix) throws Exception {
        boolean exists = c.existsFile(configEntryName);
        if (!this.overwrite && exists) {
            throw new RuntimeException("Entry " + c.getPath() + "/" + configEntryName + " already exists in Configuration.");
        }
        ZipEntry zipEntry = null;
        zipEntry = zc == null ? zipFile.getEntry(zipEntryName) : zc.getFile(zipEntryName);
        if (zipEntry == null) {
            if (this.isKernelComponent && c.existsFile(configEntryName)) {
                return;
            }
            if (require) {
                throw new RuntimeException("Required file " + zipEntryName + " not found in sda " + zipFile.getName());
            }
            this.warningBuff.append("INFO: File " + zipEntryName + " not found in sda " + zipFile.getName() + "\n");
        } else {
            InputStream in = zipFile.getInputStream(zipEntry);
            if (variables != null && zipEntryName.toLowerCase().endsWith("xml")) {
                in = new XMLParseInputStream(in, variables, zipEntryName, this);
            }
            if (index != null) {
                String relativePath;
                String name = configEntryName;
                String string = relativePath = relativePathPrefix != null ? relativePathPrefix : "";
                if (relativePath.startsWith(EXCLUDE_RELATIVE_PATH_PREFIX)) {
                    relativePath = relativePath.substring(EXCLUDE_RELATIVE_PATH_PREFIX.length());
                    int num = zipEntryName.lastIndexOf(47);
                    String path = num != -1 ? zipEntryName.substring(0, num) : "";
                    relativePath = path.startsWith(relativePath) ? path.substring(relativePath.length() + 1) : "";
                }
                index.addFileTo(relativePath, name, zipFile.getInputStream(zipEntry), true, true);
            }
            if (!configEntryName.equals(DATA_SOURCES_XML)) {
                c.updateFileAsStream(configEntryName, in, true);
            } else {
                int read;
                Configuration securedCfg;
                try {
                    securedCfg = c.getSubConfiguration(SECURED_CONFIGURATION);
                }
                catch (NameNotFoundException e) {
                    securedCfg = c.createSubConfiguration(SECURED_CONFIGURATION, 1);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[512];
                while ((read = in.read(buffer)) != -1) {
                    void path;
                    baos.write(buffer, 0, (int)path);
                }
                in.close();
                baos.flush();
                baos.close();
                String value = new String(baos.toByteArray());
                PropertySheet propertySheet = securedCfg.getPropertySheetInterface();
                try {
                    PropertyEntry entry = propertySheet.getPropertyEntry(configEntryName);
                    if (!entry.isSecure()) {
                        entry.setSecure(true);
                    }
                    entry.setDefault(value);
                }
                catch (NameNotFoundException e) {
                    PropertyEntry entry = propertySheet.createSecurePropertyEntry(configEntryName, value, null);
                }
            }
        }
    }

    private byte[] excludePropertiesMaintainingFromConfigTool(byte[] propertyFileByteArray, String zipEntryName, String serviceName) throws IOException {
        byte[] result = propertyFileByteArray;
        if (this.isKernelComponent && zipEntryName.endsWith("LockingManager.properties")) {
            result = this.doExclude(result, new String[]{"enq.profile.filename", "enqu.host", "enqu.port"});
        } else if (this.isKernelComponent && zipEntryName.endsWith("ClusterManager.properties")) {
            result = this.doExclude(result, new String[]{"ms.host", "ms.port"});
        } else if (serviceName != null && serviceName.equals("dbpool") && zipEntryName.endsWith(PROPS)) {
            result = this.doExclude(result, new String[]{"sysDS.DBConnectInfo", "sysDS.dataSourceName", "sysDS.aliases", "sysDS.initialConnections", "sysDS.maximumConnections", "sysDS.maxTimeToWaitConnection", "sysDS.connectionLifetime", "sysDS.isolationLevel", "sysDS.runCleanupThreadInterval", "sysDS.SQLEngine"});
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] doExclude(byte[] propertyFileByteArray, String[] keys) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(propertyFileByteArray)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Vector<void> lineVector = new Vector<void>(10);
        while ((line = reader.readLine()) != null) {
            void var6_6;
            if (var6_6.trim().startsWith("#") || var6_6.trim().startsWith("!") || var6_6.trim().equals("")) {
                lineVector.add(var6_6);
                continue;
            }
            int eqIndex = var6_6.indexOf(61);
            if (eqIndex != -1) {
                String key = var6_6.substring(0, eqIndex).trim();
                boolean remove = false;
                int i = 0;
                while (i < keys.length) {
                    if (key.equals(keys[i])) {
                        remove = true;
                        break;
                    }
                    ++i;
                }
                if (remove) {
                    lineVector.clear();
                    continue;
                }
                lineVector.add(var6_6);
                int i2 = 0;
                while (i2 < lineVector.size()) {
                    baos.write(((String)lineVector.get(i2)).getBytes());
                    baos.write("\n".getBytes());
                    baos.flush();
                    ++i2;
                }
                lineVector.clear();
                continue;
            }
            lineVector.add(var6_6);
        }
        int i = 0;
        while (i < lineVector.size()) {
            baos.write(((String)lineVector.get(i)).getBytes());
            baos.write("\n".getBytes());
            baos.flush();
            ++i;
        }
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private void addPropInDB(ZipFile zipFile, ZipContainer zc, String zipEntryName, Configuration c, String subconfigName, boolean require, Properties variables, String serviceName) throws Exception {
        Configuration sc = null;
        PropertySheet propSheet = null;
        byte[] propertyFileByteArray = null;
        ZipEntry zipEntry = null;
        zipEntry = zc == null ? zipFile.getEntry(zipEntryName) : zc.getFile(zipEntryName);
        if (zipEntry != null) {
            int r;
            InputStream is = zipFile.getInputStream(zipEntry);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[512];
            while ((r = is.read(buffer)) != -1) {
                void var16_16;
                baos.write(buffer, 0, (int)var16_16);
            }
            baos.close();
            is.close();
            propertyFileByteArray = this.excludePropertiesMaintainingFromConfigTool(baos.toByteArray(), zipEntryName, serviceName);
        } else {
            if (this.isKernelComponent && c.existsSubConfiguration(subconfigName)) {
                return;
            }
            if (require) {
                throw new RuntimeException("INFO: Can't find " + zipEntryName + " in file " + zipFile.getName());
            }
            this.warningBuff.append("INFO: Can't find " + zipEntryName + " in file " + zipFile.getName() + "\n");
        }
        if (c.existsSubConfiguration(subconfigName)) {
            if (!this.overwrite) {
                throw new RuntimeException("Subconfiguration " + c.getPath() + "/" + subconfigName + " already exists in Configuration!");
            }
            if (propertyFileByteArray != null) {
                sc = c.getSubConfiguration(subconfigName);
                propSheet = sc.getPropertySheetInterface();
                propSheet.updatePropertyEntries(propertyFileByteArray);
            }
        } else {
            sc = c.createSubConfiguration(subconfigName, 1);
            if (propertyFileByteArray != null) {
                propSheet = sc.getPropertySheetInterface();
                propSheet.createPropertyEntries(propertyFileByteArray);
            }
        }
        if (propertyFileByteArray != null && variables != null && !((Hashtable)variables).isEmpty()) {
            sc = c.getSubConfiguration(subconfigName);
            propSheet = sc.getPropertySheetInterface();
            Properties props = propSheet.getProperties();
            Properties substituteProps = this.substituteTags(props, variables, zipEntryName);
            Enumeration enumeration = ((Hashtable)substituteProps).keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = substituteProps.getProperty(key);
                PropertyEntry propertyEntry = propSheet.getPropertyEntry(key);
                propertyEntry.setDefault(value);
            }
        }
    }

    private Properties substituteTags(Properties props, Properties variables, String zipEntryName) {
        Properties result = new Properties();
        if (variables != null && props != null) {
            Enumeration<?> propsKeys = props.propertyNames();
            while (propsKeys.hasMoreElements()) {
                String variable;
                String propsKey = (String)propsKeys.nextElement();
                String propsVal = props.getProperty(propsKey);
                if (!propsVal.startsWith("${") || !propsVal.endsWith("}") || (variable = variables.getProperty(propsVal.substring(propsVal.indexOf("{") + 1, propsVal.length() - 1))) == null) continue;
                if (this.isSystemSubstitutionVariable(propsVal) || propsVal.equals(DATASOURCE_SUBSTITUTION_VARIABLE)) {
                    this.warningBuff.append("File " + zipEntryName + " uses forbiden system substitution variable " + propsVal + ".\n");
                    continue;
                }
                result.setProperty(propsKey, variable);
            }
        }
        return result;
    }

    private String getTypeBase(byte componentType) {
        String result = null;
        switch (componentType) {
            case 100: {
                result = INTERFACE_BASE;
                break;
            }
            case 101: {
                result = LIBRARY_BASE;
                break;
            }
            case 102: {
                result = SERVICE_BASE;
            }
        }
        return result;
    }

    private String[] getDestinationFromJar(ZipFile zipFile, ZipContainer zc) {
        Object[] result = null;
        Vector<String> tmp = new Vector<String>(DESTINATIONS.length);
        int i = 0;
        while (i < DESTINATIONS.length) {
            ZipEntry entry = zc == null ? zipFile.getEntry(DESTINATIONS[i] + "/" + PROVIDER) : zc.getFile(DESTINATIONS[i] + "/" + PROVIDER);
            if (entry != null) {
                tmp.add(DESTINATIONS[i]);
            }
            ++i;
        }
        if (tmp.size() > 0) {
            result = new String[tmp.size()];
            tmp.copyInto(result);
        }
        return result;
    }

    private String[] getPNCNFromJar(ZipFile zipFile, ZipContainer zc) throws Exception {
        String[] result = null;
        int i = 0;
        while (i < DESTINATIONS.length) {
            ZipEntry entry = zc == null ? zipFile.getEntry(DESTINATIONS[i] + "/" + PROVIDER) : zc.getFile(DESTINATIONS[i] + "/" + PROVIDER);
            if (entry != null) {
                result = new String[2];
                Document document = this.domParser.parse(zipFile.getInputStream(entry));
                Element root = document.getDocumentElement();
                NodeList list = root.getElementsByTagName("provider-name");
                if (list.getLength() > 0) {
                    result[0] = this.getTextValue((Element)list.item(0));
                }
                if (result[0] == null || result[0].equals("")) {
                    result[0] = SAP_PROVIDERS[0];
                }
                if ((list = root.getElementsByTagName("component-name")).getLength() > 0) {
                    result[1] = this.getTextValue((Element)list.item(0));
                }
            }
            if (result != null) break;
            ++i;
        }
        if (result == null) {
            throw new RuntimeException("ERROR: Can't find provider.xml entry in zip file " + zipFile.getName());
        }
        return result;
    }

    private String getTextValue(Element element) {
        Node node;
        String result = null;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            result = node.getNodeValue();
            result.trim();
            if (result.equals("") || result.equals("null")) {
                result = null;
            }
        }
        return result;
    }

    private Configuration createSubContfigurations(Configuration c, String configBase) throws Exception {
        if (configBase.indexOf("/") != -1) {
            String rootConfigBase = configBase.substring(0, configBase.indexOf("/"));
            try {
                c = c.createSubConfiguration(rootConfigBase);
            }
            catch (NameAlreadyExistsException exc) {
                c = c.getSubConfiguration(rootConfigBase);
            }
            String subConfigBase = configBase.substring(configBase.indexOf("/") + 1);
            c = this.createSubContfigurations(c, subConfigBase);
        } else {
            try {
                c = c.createSubConfiguration(configBase);
            }
            catch (NameAlreadyExistsException exc) {
                c = c.getSubConfiguration(configBase);
            }
        }
        return c;
    }

    private Configuration getRootConfiguration(ConfigurationHandler handler, String configBase, int access) throws ConfigurationException {
        Configuration cR;
        try {
            cR = handler.createRootConfiguration(configBase);
        }
        catch (NameAlreadyExistsException ex) {
            cR = handler.openConfiguration(configBase, access);
        }
        return cR;
    }

    private void remove(String componentName, byte componentType, String orginalProviderName, String originalComponentName) throws Exception {
        int index;
        String val;
        String[] dst = this.getDestinationFromConfig(this.cR, componentType, componentName + "-" + PROVIDER);
        if (dst == null && (val = this.getMapping(orginalProviderName + "$" + originalComponentName)) != null && (index = val.indexOf(36)) != -1) {
            componentName = this.modifyComponentName(val.substring(index + 1), val.substring(0, index));
            System.out.println("Found component name mapping : " + componentName);
            dst = this.getDestinationFromConfig(this.cR, componentType, componentName + "-" + PROVIDER);
        }
        if (dst != null) {
            int i = 0;
            while (i < dst.length) {
                this.removeDst(componentName, componentType, dst[i], this.cR);
                ++i;
            }
        } else {
            throw new ComponentNotDeployedException("Component " + componentName + " doesn't exists.");
        }
        this.removeNativeParts(this.getTypeBase(componentType).substring(1), componentName + "_native_undeploy_info");
    }

    private void remove(ZipFile jar, ZipContainer zc, byte componentType) throws Exception {
        String[] pncn = this.getPNCNFromJar(jar, zc);
        String componentName = this.modifyComponentName(pncn[1], pncn[0]);
        String[] dst = this.getDestinationFromJar(jar, zc);
        if (dst != null) {
            int i = 0;
            while (i < dst.length) {
                this.removeDst(componentName, componentType, dst[i], this.cR);
                ++i;
            }
        } else {
            throw new ComponentNotDeployedException("Component " + componentName + " doesn't exists.");
        }
        this.removeNativeParts(this.getTypeBase(componentType).substring(1), componentName + "_native_undeploy_info");
    }

    private void removeDst(String componentName, byte componentType, String destination, Configuration cR) throws Exception {
        Configuration c = cR.getSubConfiguration(destination + BIN_BASE);
        String indexName = destination.equals(DESTINATIONS[0]) ? DISPATCHER_INDEX : SERVER_INDEX;
        Index index = this.getIndex(indexName, c);
        String dir = this.getTypeBase(componentType).substring(1);
        if ((c = c.getSubConfiguration(dir)).existsSubConfiguration(componentName)) {
            index.deleteFolderFrom(dir, componentName);
            c.deleteConfiguration(componentName);
            this.updateIndex(indexName, index);
        }
        c = cR.getSubConfiguration(destination + CFG_BASE + this.getTypeBase(componentType));
        String confEntryName = componentName + "-" + PROVIDER;
        c.deleteFile(confEntryName);
        confEntryName = destination + DESCRIPTORS_BASE + "/" + componentName;
        this.deleteSubConfiguration(cR, confEntryName);
        if (componentType == 102) {
            confEntryName = destination + CFG_BASE + this.getTypeBase(componentType) + "/" + componentName;
            this.deleteSubConfiguration(cR, confEntryName);
            confEntryName = destination + CFG_BASE + this.getTypeBase(componentType) + "/" + componentName + RUNTIME;
            this.deleteSubConfiguration(cR, confEntryName);
            confEntryName = destination + PERSISTENT_BASE + "/" + componentName;
            this.deleteSubConfiguration(cR, confEntryName);
        }
    }

    private void deleteSubConfiguration(Configuration cR, String confEntryName) throws Exception {
        Configuration c;
        try {
            c = cR.getSubConfiguration(confEntryName);
        }
        catch (ConfigurationException e) {
            c = null;
        }
        if (c != null) {
            c.deleteAllSubConfigurations();
            c.deleteConfiguration();
        }
    }

    private String[] getDestinationFromConfig(Configuration cR, byte componentType, String provider) {
        Object[] result = null;
        Vector<String> v = new Vector<String>(DESTINATIONS.length);
        int i = 0;
        while (i < DESTINATIONS.length) {
            try {
                Configuration c = cR.getSubConfiguration(DESTINATIONS[i] + CFG_BASE + this.getTypeBase(componentType));
                if (c.existsFile(provider)) {
                    v.add(DESTINATIONS[i]);
                }
            }
            catch (ConfigurationException exc) {
                // empty catch block
            }
            ++i;
        }
        if (v.size() > 0) {
            result = new String[v.size()];
            v.copyInto(result);
        }
        return result;
    }

    private void removeKernel() throws Exception {
        this.cR.deleteFile(VERSION_TXT);
        if (this.cR.existsFile(JITEXCLUDE)) {
            this.cR.deleteFile(JITEXCLUDE);
        }
        Configuration c = this.cR.getSubConfiguration("dispatcher");
        c.deleteFile("java.policy");
        c = c.getSubConfiguration("cfg");
        c.deleteConfiguration("element-info");
        c = this.cR.getSubConfiguration("server");
        c.deleteFile("java.policy");
        c.deleteFile("remote.policy");
        c = c.getSubConfiguration("cfg");
        c.deleteConfiguration("element-info");
        Configuration cfg = this.createSubContfigurations(this.cR, "dispatcher/bin");
        Index index = this.getIndex(DISPATCHER_INDEX, cfg);
        int i = 0;
        while (i < KERNEL_BINARY_DISPATCHER.length) {
            String dirName = KERNEL_BINARY_DISPATCHER[i].substring("dispatcher/bin".length() + 1);
            index.deleteFolder(dirName);
            this.deleteSubConfiguration(this.cR, KERNEL_BINARY_DISPATCHER[i]);
            ++i;
        }
        this.updateIndex(DISPATCHER_INDEX, index);
        cfg = this.createSubContfigurations(this.cR, "server/bin");
        index = this.getIndex(SERVER_INDEX, cfg);
        int i2 = 0;
        while (i2 < KERNEL_BINARY_SERVER.length) {
            String dirName = KERNEL_BINARY_SERVER[i2].substring("server/bin".length() + 1);
            index.deleteFolder(dirName);
            this.deleteSubConfiguration(this.cR, KERNEL_BINARY_SERVER[i2]);
            ++i2;
        }
        this.updateIndex(SERVER_INDEX, index);
        int i3 = 0;
        while (i3 < CFGS.length) {
            this.deleteSubConfiguration(this.cR, CFGS[i3]);
            ++i3;
        }
        this.removeNativeParts("kernel", "kernel_native_undeploy_info");
    }

    private void throwOD(Exception e, String errMsg) throws ODeploymentException {
        errMsg = errMsg != null ? errMsg + "\n" : "";
        if (e != null) {
            errMsg = errMsg + this.getStackTrace(e);
        }
        if (errMsg.equals("")) {
            errMsg = "No message specified!";
        }
        throw new ODeploymentException(errMsg);
    }

    private String getStackTrace(Exception exc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        exc.printStackTrace(ps);
        return baos.toString();
    }

    private String getDCReplace(File jar) {
        String res = null;
        try {
            String line = null;
            ZipFile zip = new ZipFile(jar);
            ZipEntry entry = zip.getEntry(MANIFEST);
            if (entry != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                while ((line = in.readLine()) != null) {
                    if (line.indexOf("dc-replace:") == -1) continue;
                    res = line.substring(line.indexOf(":") + 1).trim();
                    break;
                }
                in.close();
            }
            zip.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private void storeOSLibs(ZipFile zipFile, String cfgStoreName, String fileStoreName) throws Exception {
        Set oldUndeployList = this.readUndeployList(cfgStoreName, fileStoreName);
        HashMap map = this.parseSearchRules(zipFile, oldUndeployList);
        Set undeployList = null;
        if (map.containsKey(UNDEPLOY_LIST_KEY)) {
            undeployList = (Set)map.remove(UNDEPLOY_LIST_KEY);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String configEntry = (String)iterator.next();
            Configuration cfg = this.createSubContfigurations(this.cR, configEntry);
            HashSet files = (HashSet)map.get(configEntry);
            Iterator fileIterator = files.iterator();
            while (fileIterator.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)fileIterator.next();
                String fileName = zipEntry.getName();
                int index = fileName.lastIndexOf(47);
                if (index != -1) {
                    fileName = fileName.substring(index + 1);
                }
                cfg.updateFileAsStream(fileName, zipFile.getInputStream(zipEntry), true);
            }
        }
        if (undeployList != null && undeployList.size() > 0) {
            Configuration cfg = this.createSubContfigurations(this.cR, "undeploy/" + cfgStoreName);
            this.storeUndeployList(undeployList, cfg, fileStoreName);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap loadNativeDescriptor() throws Exception {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Configuration cfg = this.createSubContfigurations(this.cR, "os_libs");
        if (!cfg.existsFile(NATIVE_DESCRIPTOR)) return result;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(cfg.getFile(NATIVE_DESCRIPTOR)));
            while ((line = reader.readLine()) != null) {
                void var4_4;
                line = var4_4.trim();
                if (line.equals("")) continue;
                String[] pl = this.parseNativeDescriptorLine(line);
                String key = pl[0] + "," + pl[1] + "," + pl[2] + "," + pl[4] + "," + pl[5];
                result.put(key, pl);
            }
            Object var8_7 = null;
            if (reader == null) return result;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
        return result;
    }

    private void storeNativeDescriptor(HashMap map) throws Exception {
        Configuration cfg = this.createSubContfigurations(this.cR, "os_libs");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            String[] pl = (String[])iterator.next();
            stringBuffer.append(pl[0]);
            stringBuffer.append(',');
            stringBuffer.append(pl[1]);
            stringBuffer.append(',');
            stringBuffer.append(pl[2]);
            stringBuffer.append(',');
            stringBuffer.append(pl[3]);
            stringBuffer.append(',');
            stringBuffer.append(pl[4]);
            stringBuffer.append(',');
            stringBuffer.append(pl[5]);
            stringBuffer.append('\n');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            cfg.updateFileAsStream(NATIVE_DESCRIPTOR, new ByteArrayInputStream(stringBuffer.toString().getBytes()), true);
            Integer osVer = null;
            try {
                osVer = (Integer)this.cR.getConfigEntry(OS_LIB_VERSION);
                this.cR.modifyConfigEntry(OS_LIB_VERSION, new Integer(osVer + 1));
            }
            catch (ConfigurationException e) {
                this.cR.addConfigEntry(OS_LIB_VERSION, new Integer(1));
            }
        }
    }

    private void storeUndeployList(Set set, Configuration cfg, String name) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append('\n');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        cfg.updateFileAsStream(name, new ByteArrayInputStream(stringBuffer.toString().getBytes()), true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set readUndeployList(Configuration cfg, String name) throws Exception {
        HashSet<String> result = new HashSet<String>();
        if (!cfg.existsFile(name)) return result;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(cfg.getFile(name)));
            while ((line = reader.readLine()) != null) {
                void var5_5;
                line = var5_5.trim();
                if (line.equals("")) continue;
                result.add(line);
            }
            Object var7_6 = null;
            if (reader == null) return result;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
        return result;
    }

    private void removeNativeParts(String cfgName, String fileName) throws Exception {
        Configuration cfg = null;
        if (this.cR.existsSubConfiguration(UNDEPLOY_CONFIGURATION_NAME) && (cfg = this.cR.getSubConfiguration(UNDEPLOY_CONFIGURATION_NAME)).existsSubConfiguration(cfgName) && (cfg = cfg.getSubConfiguration(cfgName)).existsFile(fileName)) {
            Set undeployList = this.readUndeployList(cfg, fileName);
            this.removeNativeList(undeployList);
            cfg.deleteFile(fileName);
        }
    }

    private Set readUndeployList(String cfgName, String fileName) throws Exception {
        Set result = null;
        Configuration cfg = null;
        if (this.cR.existsSubConfiguration(UNDEPLOY_CONFIGURATION_NAME) && (cfg = this.cR.getSubConfiguration(UNDEPLOY_CONFIGURATION_NAME)).existsSubConfiguration(cfgName)) {
            cfg = cfg.getSubConfiguration(cfgName);
            result = this.readUndeployList(cfg, fileName);
        }
        if (result == null) {
            result = new HashSet();
        }
        return result;
    }

    private HashMap parseSearchRules(ZipFile zipFile, Set oldUndeployList) throws Exception {
        HashMap result = new HashMap();
        ZipEntry zipEntry = zipFile.getEntry(SEARCH_RULES);
        if (zipEntry != null) {
            HashMap hashMap = this.loadNativeDescriptor();
            HashSet undeployList = new HashSet();
            result.put(UNDEPLOY_LIST_KEY, undeployList);
            Document document = this.domParser.parse(zipFile.getInputStream(zipEntry));
            Element root = document.getDocumentElement();
            NodeList nativeParts = root.getElementsByTagName("native-part");
            int i = 0;
            while (i < nativeParts.getLength()) {
                Element nativePart = (Element)nativeParts.item(i);
                NodeList paths = nativePart.getElementsByTagName("path");
                int k = 0;
                while (k < paths.getLength()) {
                    String platform;
                    Element path = (Element)paths.item(k);
                    String supported = path.getAttribute("supported");
                    if (supported.equals("true") && !(platform = path.getAttribute("platform")).equals("")) {
                        ZipEntry nativeLib;
                        String unicode = path.getAttribute("unicode");
                        String jvm_bitlength = path.getAttribute("jvm-bitlength");
                        String entryPath = this.getTextValue(path).replace('\\', '/');
                        if (entryPath.charAt(0) == '/') {
                            entryPath = entryPath.substring(1);
                        }
                        if (!entryPath.startsWith(OS_LIBS)) {
                            entryPath = OS_LIBS + entryPath;
                        }
                        if ((nativeLib = zipFile.getEntry(entryPath)) != null) {
                            String cfgPath = entryPath.toLowerCase().substring(0, entryPath.lastIndexOf(47));
                            String cfgName = entryPath.substring(entryPath.lastIndexOf(47) + 1);
                            if (unicode.equals("") && jvm_bitlength.equals("")) {
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), "32", "nuc", cfgPath, cfgName);
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), "32", "uc", cfgPath, cfgName);
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), "64", "nuc", cfgPath, cfgName);
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), "64", "uc", cfgPath, cfgName);
                            } else if (unicode.equals("")) {
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), jvm_bitlength.toLowerCase(), "nuc", cfgPath, cfgName);
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), jvm_bitlength.toLowerCase(), "uc", cfgPath, cfgName);
                            } else if (jvm_bitlength.equals("")) {
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), "32", unicode.toLowerCase(), cfgPath, cfgName);
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), "64", unicode.toLowerCase(), cfgPath, cfgName);
                            } else {
                                this.updateLine(hashMap, undeployList, oldUndeployList, platform.toLowerCase(), jvm_bitlength.toLowerCase(), unicode.toLowerCase(), cfgPath, cfgName);
                            }
                            HashSet<ZipEntry> files = (HashSet<ZipEntry>)result.get(cfgPath);
                            if (files == null) {
                                files = new HashSet<ZipEntry>();
                                result.put(cfgPath, files);
                            }
                            files.add(nativeLib);
                        } else {
                            System.out.println("File " + entryPath + ", declared in SearchRules.xml, not found in " + zipFile.getName());
                        }
                    }
                    ++k;
                }
                ++i;
            }
            if (result.size() > 1) {
                this.storeNativeDescriptor(hashMap);
            }
        }
        return result;
    }

    private void updateLine(HashMap map, Set undeployList, Set oldUndeployList, String platform, String bitlength, String unicode, String cfgPath, String cfgName) {
        String key = platform + "," + bitlength + "," + unicode + "," + cfgPath + "," + cfgName;
        undeployList.add(key);
        String[] pl = (String[])map.get(key);
        if (pl != null) {
            if (!oldUndeployList.contains(key)) {
                int num = Integer.parseInt(pl[3]) + 1;
                pl[3] = Integer.toString(num);
            }
        } else {
            pl = new String[]{platform, bitlength, unicode, "1", cfgPath, cfgName};
        }
        map.put(key, pl);
    }

    private String[] parseNativeDescriptorLine(String line) {
        String[] result = null;
        StringTokenizer token = new StringTokenizer(line, ",");
        int count = token.countTokens();
        result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = token.nextToken().trim();
            ++i;
        }
        return result;
    }

    void removeNativeList(Set undeployList) throws Exception {
        HashMap map = this.loadNativeDescriptor();
        Iterator it = undeployList.iterator();
        while (it.hasNext()) {
            int num;
            String key = (String)it.next();
            String[] pl = (String[])map.get(key);
            if (pl == null || (num = Integer.parseInt(pl[3])) == 0) continue;
            if (num == 1) {
                Configuration cfg = null;
                try {
                    cfg = this.cR.getSubConfiguration(pl[4]);
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                if (cfg != null && cfg.existsFile(pl[5])) {
                    cfg.deleteFile(pl[5]);
                }
                pl[3] = "0";
                map.put(key, pl);
                continue;
            }
            pl[3] = Integer.toString(num - 1);
            map.put(key, pl);
        }
        this.storeNativeDescriptor(map);
    }

    private String modifyComponentName(String componentName, String providerName) {
        int i = 0;
        while (i < SAP_PROVIDERS.length) {
            if (componentName.startsWith(SAP_PROVIDERS[i])) {
                componentName = componentName.substring(SAP_PROVIDERS[i].length());
            }
            ++i;
        }
        componentName = componentName.replace('/', '~');
        if (!this.isSapProvider(providerName)) {
            componentName = providerName + "~" + componentName;
        }
        return componentName;
    }

    private boolean isSapProvider(String providerName) {
        int i = 0;
        while (i < SAP_PROVIDERS.length) {
            if (providerName.equalsIgnoreCase(SAP_PROVIDERS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Index deleteOldStructureJars(String componentName, String destination, byte componentType) {
        Index result = null;
        try {
            Configuration cfg;
            String[] jars;
            block13: {
                jars = null;
                cfg = this.getSubconfig(destination + CFG_BASE + this.getTypeBase(componentType));
                if (cfg == null) return result;
                String confEntryName = componentName + "-" + PROVIDER;
                if (!cfg.existsFile(confEntryName)) return result;
                InputStream is = null;
                try {
                    is = cfg.getFile(confEntryName);
                    jars = this.getJars(this.domParser.parse(is));
                    Object var10_10 = null;
                    if (is == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            cfg = this.getSubconfig(destination + BIN_BASE + this.getTypeBase(componentType));
            if (cfg == null) return result;
            String indexName = destination.equals(DESTINATIONS[0]) ? DISPATCHER_INDEX : SERVER_INDEX;
            result = this.getIndex(indexName, this.getSubconfig(destination + BIN_BASE));
            String relativePathPrefix = this.getTypeBase(componentType).substring(1);
            int i = 0;
            while (true) {
                if (i >= jars.length) {
                    return result;
                }
                jars[i] = jars[i].replace('\\', '/');
                if (jars[i].indexOf(47) == -1) {
                    if (cfg.existsFile(jars[i])) {
                        result.deleteFileFrom(relativePathPrefix, jars[i]);
                        cfg.deleteFile(jars[i]);
                        this.transferDomainPermissions(this.getTypeBase(componentType).substring(1), componentName, jars[i]);
                    }
                } else {
                    if (jars[i].charAt(0) == '/') {
                        jars[i] = jars[i].substring(1);
                    }
                    String path = jars[i].substring(0, jars[i].lastIndexOf(47));
                    String name = jars[i].substring(jars[i].lastIndexOf(47) + 1);
                    Configuration cdir = this.createSubContfigurations(cfg, path);
                    if (cdir.existsFile(name)) {
                        String currentRelativePathPrefix = relativePathPrefix + "/" + path;
                        result.deleteFileFrom(currentRelativePathPrefix, name);
                        cdir.deleteFile(name);
                        StringTokenizer token = new StringTokenizer(jars[i], "/");
                        StringBuffer buffer = new StringBuffer();
                        while (true) {
                            if (!token.hasMoreTokens()) {
                                buffer.delete(buffer.length() - 2, buffer.length());
                                this.transferDomainPermissions(this.getTypeBase(componentType).substring(1), componentName, buffer.toString());
                                break;
                            }
                            buffer.append(token.nextToken());
                            buffer.append("$4");
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private Configuration getSubconfig(String subconfig) throws ConfigurationException {
        Configuration tmp = this.cR;
        StringTokenizer token = new StringTokenizer(subconfig, "/");
        while (token.hasMoreTokens()) {
            String next = token.nextToken();
            if (tmp.existsSubConfiguration(next)) {
                tmp = tmp.getSubConfiguration(next);
                continue;
            }
            return null;
        }
        return tmp;
    }

    /*
     * Loose catch block
     */
    private void transferDomainPermissions(String dir, String componentName, String jarname) {
        block15: {
            ConfigurationHandler handler;
            block14: {
                handler = null;
                handler = this.getConfigurationHandlerFactory().getConfigurationHandler();
                Configuration cfg = null;
                try {
                    cfg = handler.openConfiguration("protected_domains", 1);
                }
                catch (NameNotFoundException e) {
                    Object var9_10 = null;
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return;
                }
                if (!cfg.existsSubConfiguration("domains") || !(cfg = cfg.getSubConfiguration("domains")).existsSubConfiguration(dir + "$4" + jarname)) break block14;
                Configuration c1 = cfg.getSubConfiguration(dir + "$4" + jarname);
                Configuration c2 = cfg.createSubConfiguration(dir + "$4" + componentName + "$4" + jarname);
                this.copyConfigurations(c1, c2);
                c1.deleteConfiguration();
                handler.commit();
            }
            Object var9_11 = null;
            try {
                handler.closeAllConfigurations();
            }
            catch (Exception e2) {}
            break block15;
            {
                catch (Exception e) {
                    try {
                        handler.rollback();
                    }
                    catch (Exception e1) {
                    }
                    Object var9_12 = null;
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    handler.closeAllConfigurations();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void copyConfigurations(Configuration from, Configuration to) throws Exception {
        Map map = from.getAllFileEntries();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            to.addFileAsStream(name, (InputStream)map.get(name));
        }
        String[] enames = from.getAllConfigEntryNames();
        int i = 0;
        while (i < enames.length) {
            Object value = from.getConfigEntry(enames[i]);
            to.addConfigEntry(enames[i], value);
            ++i;
        }
        map = from.getAllSubConfigurations();
        it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Configuration tmp_from = (Configuration)map.get(name);
            Configuration tmp_to = to.createSubConfiguration(name, tmp_from.getMetaData().getConfigurationType());
            this.copyConfigurations(tmp_from, tmp_to);
        }
    }

    void addToWarningBuffer(String message) {
        this.warningBuff.append(message);
    }

    boolean isSystemSubstitutionVariable(String variable) {
        int i = 0;
        while (i < SYSTEM_SUBSTITUTION_VARIABLES.length) {
            if (variable.equals(SYSTEM_SUBSTITUTION_VARIABLES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeUndeployMapping(String key, String value) throws Exception {
        Properties map;
        Configuration cfg;
        block4: {
            cfg = null;
            map = new Properties();
            cfg = this.cR.existsSubConfiguration(UNDEPLOY_CONFIGURATION_NAME) ? this.cR.getSubConfiguration(UNDEPLOY_CONFIGURATION_NAME) : this.cR.createSubConfiguration(UNDEPLOY_CONFIGURATION_NAME);
            if (cfg.existsFile(UNDEPLOY_MAPPING)) {
                InputStream is = null;
                try {
                    is = cfg.getFile(UNDEPLOY_MAPPING);
                    map.load(is);
                    Object var7_6 = null;
                    if (is == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                is.close();
            }
        }
        map.setProperty(key, value);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        map.store(baos, "mapping list");
        baos.close();
        cfg.updateFileAsStream(UNDEPLOY_MAPPING, new ByteArrayInputStream(baos.toByteArray()), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMapping(String key) throws Exception {
        Configuration cfg;
        Properties map = new Properties();
        String result = null;
        if (this.cR.existsSubConfiguration(UNDEPLOY_CONFIGURATION_NAME) && (cfg = this.cR.getSubConfiguration(UNDEPLOY_CONFIGURATION_NAME)).existsFile(UNDEPLOY_MAPPING)) {
            block4: {
                InputStream is = null;
                try {
                    is = cfg.getFile(UNDEPLOY_MAPPING);
                    map.load(is);
                    Object var7_6 = null;
                    if (is == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                is.close();
            }
            result = (String)((Hashtable)map).remove(key);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            map.store(baos, "mapping list");
            baos.close();
            cfg.updateFileAsStream(UNDEPLOY_MAPPING, new ByteArrayInputStream(baos.toByteArray()));
        }
        return result;
    }

    private String[] getKeyvendorKeyname(ZipFile zip) {
        String[] res = new String[2];
        try {
            String line = null;
            ZipEntry entry = zip.getEntry(SAP_MANIFEST);
            if (entry != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                while ((line = in.readLine()) != null) {
                    if (line.indexOf("keyname:") != -1) {
                        res[1] = line.substring(line.indexOf(":") + 1).trim();
                        if (res[0] == null) continue;
                        break;
                    }
                    if (line.indexOf("keyvendor:") == -1) continue;
                    res[0] = line.substring(line.indexOf(":") + 1).trim();
                    if (res[1] != null) break;
                }
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

