/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.tools.offlinedeploy.rdb.LogonData;
import com.sap.engine.tools.offlinedeploy.rdb.ODeploymentException;
import com.sap.engine.tools.offlinedeploy.rdb.OWarningException;
import com.sap.engine.tools.offlinedeploy.rdb.OfflineComponentDeploy;
import com.sap.engine.tools.offlinedeploy.rdb.OfflineComponentDeployImpl;
import com.sap.engine.tools.offlinedeploy.rdb.OnlineModule;
import com.sap.engine.tools.offlinedeploy.rdb.OnlineModuleImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class OCDFactory {
    private static String currentDtdDir = null;
    private static OfflineComponentDeploy currentOfflineComponentDeploy = null;
    private static Properties currentProperties = null;

    public static OnlineModule createOnlineModule(LogonData logonData) {
        return new OnlineModuleImpl(logonData);
    }

    public static OfflineComponentDeploy createOfflineComponentDeploy(String dtdDir, boolean overwrite) {
        return new OfflineComponentDeployImpl(dtdDir, overwrite);
    }

    public static synchronized OfflineComponentDeploy createOfflineComponentDeploy(String dtdDir, boolean overwrite, Properties configProperties) throws OWarningException, ODeploymentException {
        if (currentOfflineComponentDeploy == null) {
            currentOfflineComponentDeploy = new OfflineComponentDeployImpl(dtdDir, overwrite);
            currentOfflineComponentDeploy.setConfigurationProperties(configProperties);
            currentProperties = configProperties;
            currentDtdDir = dtdDir;
        } else if (!OCDFactory.propsEqual(configProperties, currentProperties) || !dtdDir.equals(currentDtdDir)) {
            currentOfflineComponentDeploy.close();
            currentOfflineComponentDeploy = new OfflineComponentDeployImpl(dtdDir, overwrite);
            currentOfflineComponentDeploy.setConfigurationProperties(configProperties);
            currentProperties = configProperties;
            currentDtdDir = dtdDir;
        }
        return currentOfflineComponentDeploy;
    }

    public static synchronized void closeAll() {
        if (currentOfflineComponentDeploy != null) {
            currentOfflineComponentDeploy.close();
        }
        currentOfflineComponentDeploy = null;
        currentProperties = null;
        currentDtdDir = null;
    }

    private static boolean propsEqual(Properties p1, Properties p2) {
        boolean res = false;
        if (p1 != null && p2 != null && ((Hashtable)p1).size() == ((Hashtable)p2).size()) {
            Enumeration keys1 = ((Hashtable)p1).keys();
            while (keys1.hasMoreElements()) {
                String key1 = (String)keys1.nextElement();
                String value1 = p1.getProperty(key1);
                String value2 = p2.getProperty(key1);
                if (value1 != null && value2 != null && value1.equals(value2)) continue;
                return false;
            }
            res = true;
        }
        return res;
    }
}

