/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.library;

import com.sap.engine.tools.library.FormatException;
import com.sap.engine.tools.library.OutOfBoundsException;
import com.sap.engine.tools.library.OverwriteException;
import com.sap.engine.tools.library.Ternaries;
import com.sap.engine.tools.library.TernaryTuple;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class TernariesAdaptor
implements Ternaries {
    public BufferedReader in;
    public BufferedWriter out;
    private boolean loaded;
    private TernaryTuple[] tuples;
    private int current;
    private int len;
    private boolean endReached;

    public TernariesAdaptor(InputStream in, OutputStream out) {
        this.init(in, out);
    }

    private void init(InputStream in, OutputStream out) {
        if (in != null) {
            this.in = new BufferedReader(new InputStreamReader(in));
        }
        if (out != null) {
            this.out = new BufferedWriter(new OutputStreamWriter(out));
        }
        this.loaded = false;
        this.tuples = new TernaryTuple[0];
        this.current = 0;
        this.len = 0;
    }

    public TernariesAdaptor() {
        this.in = null;
        this.out = null;
        this.tuples = null;
        this.loaded = false;
        this.len = 0;
    }

    public boolean loaded() {
        return this.loaded;
    }

    public boolean hasNext() {
        return this.current < this.len;
    }

    public TernaryTuple next() {
        if (this.current < this.len) {
            return this.tuples[this.current++];
        }
        return null;
    }

    public TernaryTuple get(int index) throws OutOfBoundsException {
        if (index >= 0 && index < this.len) {
            return this.tuples[index];
        }
        throw new OutOfBoundsException();
    }

    public void remove() throws OutOfBoundsException {
        this.remove(this.current - 1);
    }

    public void remove(int index) throws OutOfBoundsException {
        if (index >= 0 && index < this.len) {
            if (index < this.len - 1) {
                System.arraycopy(this.tuples, index + 1, this.tuples, index, this.len - index);
            }
            --this.len;
        }
        throw new OutOfBoundsException();
    }

    public int size() {
        return this.len;
    }

    public void reset() {
        this.current = 0;
    }

    public void load() throws IOException, FormatException {
        if (!this.loaded) {
            String line;
            while ((line = this.getLine()) != null) {
                if (line.trim().length() == 0) continue;
                this.appendUnconditional(new TernaryTuple(line));
            }
            this.loaded = true;
            this.in.close();
        }
    }

    private String getLine() throws IOException {
        return this.in.readLine();
    }

    private void appendUnconditional(TernaryTuple tuple) {
        if (this.len >= this.tuples.length) {
            TernaryTuple[] tmp = new TernaryTuple[this.tuples.length + 10];
            System.arraycopy(this.tuples, 0, tmp, 0, this.tuples.length);
            this.tuples = tmp;
            Object var2_2 = null;
        }
        this.tuples[this.len] = tuple;
        ++this.len;
    }

    private void add(TernaryTuple tuple) throws OverwriteException {
        boolean allOk = true;
        boolean found = false;
        int savedIndex = -1;
        int i = 0;
        while (i < this.len) {
            if (this.tuples[i].equals(tuple)) {
                return;
            }
            if (this.hasConflict(this.tuples[i], tuple)) {
                allOk = this.canOverwrite();
                savedIndex = i;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.appendUnconditional(tuple);
        } else if (allOk) {
            this.tuples[savedIndex] = tuple;
        } else {
            throw new OverwriteException("Conflicting tuples", this.tuples[savedIndex], tuple);
        }
    }

    public void save() throws IOException {
        if (this.out == null) {
            throw new IOException("Uninitialized output stream!");
        }
        int i = 0;
        while (i < this.len) {
            String res = this.tuples[i].getFirst() + " " + this.tuples[i].getSecond() + " " + this.tuples[i].getThird();
            this.out.write(res, 0, res.length());
            if (i < this.len - 1) {
                this.out.newLine();
            }
            ++i;
        }
        this.out.flush();
        this.out.close();
    }

    public void insert(TernaryTuple tuple) throws OverwriteException {
        this.add(tuple);
    }

    public void setInputStream(InputStream in) {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.loaded = false;
    }

    public void setOutputStream(OutputStream out) {
        this.out = new BufferedWriter(new OutputStreamWriter(out));
    }

    public abstract boolean hasConflict(TernaryTuple var1, TernaryTuple var2);

    public abstract boolean canOverwrite();
}

