/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.library;

import com.sap.engine.tools.library.FileTernariesAdaptor;
import com.sap.engine.tools.library.LibraryFile;
import com.sap.engine.tools.library.TernaryTuple;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LibraryTernaries
extends FileTernariesAdaptor
implements LibraryFile {
    private String path;
    private boolean overwriteFlag = false;

    public LibraryTernaries(String src, String dst) throws FileNotFoundException, IOException {
        super(src, dst);
    }

    public boolean canOverwrite() {
        return this.overwriteFlag;
    }

    public boolean hasConflict(TernaryTuple oldTuple, TernaryTuple newTuple) {
        return oldTuple.getFirst().equals(newTuple.getFirst()) && oldTuple.getFirst().equals("library") && oldTuple.getSecond().equals(newTuple.getSecond()) && !oldTuple.getThird().equals(newTuple.getThird());
    }

    public boolean validate(TernaryTuple tuple) {
        String first = tuple.getFirst();
        if (!first.equals("library") && !first.equals("reference")) {
            return false;
        }
        if (first.equals("library")) {
            return this.valid(tuple.parseThird());
        }
        return true;
    }

    private boolean valid(String[] elements) {
        int i = 0;
        while (i < elements.length) {
            File file = null;
            file = elements[i].charAt(0) == '!' ? new File(elements[i].substring(1)) : new File(this.path + elements[i]);
            if (!file.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setJarDirectory(String dir) {
        this.path = dir;
    }

    public String getJarDirectory() {
        return this.path;
    }

    public boolean getOverWriteFlag() {
        return this.overwriteFlag;
    }

    public void setOverWriteFlag(boolean overwriteFlag) {
        this.overwriteFlag = overwriteFlag;
    }
}

