/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.library;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.tools.library.FormatException;
import com.sap.engine.tools.library.LibraryTernaries;
import com.sap.engine.tools.library.OutOfBoundsException;
import com.sap.engine.tools.library.OverwriteException;
import com.sap.engine.tools.library.TernaryTuple;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class LibraryEditor {
    private static boolean noNeed = false;
    private static String fileType = "library.txt";
    private static Properties options = new Properties();
    private static String command = null;
    private static LibraryTernaries library = null;
    private static LibraryTernaries destination = null;
    private static final String fs = File.separator;
    private boolean errorFlag = false;

    private LibraryEditor(String[] arguments) {
        try {
            this.parseArguments(arguments);
        }
        catch (Exception e) {
            System.out.println("Error occured while parsing parameters: " + e.getMessage());
            this.initialState();
        }
        String originalDir = null;
        try {
            if (options.getProperty("-s") == null) {
                System.out.println("Source file cluster element directory must be specified using '-s filename' parameter.");
                this.initialState();
            } else {
                originalDir = options.getProperty("-s") + fs;
                options.setProperty("-s", originalDir + "managers" + fs + fileType);
            }
            this.copyBakFile(options.getProperty("-s"));
            library = new LibraryTernaries(options.getProperty("-s"), options.getProperty("-s"));
            library.setOverWriteFlag("true".equals(options.getProperty("-r")));
            library.setJarDirectory(originalDir + fs + "additional-lib" + fs);
        }
        catch (FileNotFoundException e) {
            System.out.println("Source file " + options.getProperty("-s") + " not found.");
            this.initialState();
        }
        catch (IOException e) {
            System.out.println("Unable to initialize input/output stream of source file.");
            this.initialState();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Wrong parameters: " + e.getMessage());
            this.initialState();
        }
        if ("validate".equalsIgnoreCase(command)) {
            if (!noNeed) {
                this.validate();
            }
        } else if ("include".equalsIgnoreCase(command)) {
            this.include();
        }
    }

    public void parseArguments(String[] arguments) throws IllegalArgumentException {
        try {
            command = arguments[0];
            if (!command.equalsIgnoreCase("validate") && !command.equalsIgnoreCase("include")) {
                throw new IllegalArgumentException("Invalid command specified!");
            }
            int i = 1;
            while (i < arguments.length) {
                try {
                    if (arguments[i].equals("-s") || arguments[i].equals("-d")) {
                        options.setProperty(arguments[i], arguments[++i]);
                        ++i;
                        continue;
                    }
                    if (!arguments[i].equals("-r")) {
                        throw new IllegalArgumentException("Unknown parameter encountered: " + arguments[i]);
                    }
                    options.setProperty(arguments[i], "true");
                    ++i;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("More parameters expected!");
                }
            }
            if (options.getProperty("-r") == null) {
                options.setProperty("-r", "false");
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("More parameters expected!");
        }
    }

    public void validate() {
        System.out.println("\r\nProcessing 'validate' on " + fileType + "-s");
        try {
            library.load();
        }
        catch (FormatException e) {
            e.printStackTrace();
            System.out.println("Format exception while loading the file for validating: " + e.getMessage());
            this.initialState();
        }
        catch (IOException e) {
            System.out.println("IOException in validate block: " + e.getMessage());
            this.initialState();
        }
        try {
            int[] ndxs = new int[library.size()];
            int len = 0;
            library.reset();
            int i = -1;
            while (library.hasNext()) {
                ++i;
                if (library.validate(library.next())) continue;
                ndxs[len++] = i;
            }
            if (len != 0) {
                System.out.println("Invalid ternaries: ");
                try {
                    i = 0;
                    while (i < len) {
                        System.out.println("    " + library.get(ndxs[i]) + " (line " + (ndxs[i] + 1) + " of the source file)");
                        ++i;
                    }
                }
                catch (OutOfBoundsException e) {
                    System.out.println("This exception should never be thrown!");
                }
            } else {
                System.out.println("All typles are valid!");
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                library.save();
            }
            catch (IOException ioe) {
                System.out.println("Fatal error! Could not write to source file.");
            }
            throw throwable;
        }
        try {
            library.save();
        }
        catch (IOException ioe) {
            System.out.println("Fatal error! Could not write to source file.");
        }
    }

    public void include() {
        System.out.println("\r\nProcessing 'include' on " + fileType + "-s");
        boolean allOk = true;
        String originalDir = null;
        try {
            if (options.getProperty("-d") == null) {
                System.out.println("Destination file cluster element directory must be specified using '-d filename' parameter.");
                this.initialState();
            } else {
                originalDir = options.getProperty("-d") + fs;
                options.setProperty("-d", originalDir + "managers" + fs + fileType);
            }
            this.copyBakFile(options.getProperty("-d"));
            destination = new LibraryTernaries(options.getProperty("-d"), options.getProperty("-d"));
            destination.setOverWriteFlag("true".equals(options.getProperty("-r")));
            destination.setJarDirectory(originalDir + fs + "additional-lib" + fs);
        }
        catch (FileNotFoundException e) {
            System.out.println("Destination file " + options.getProperty("-d") + " not found. Creating");
            try {
                new File(new File(originalDir + "managers").getCanonicalPath()).mkdirs();
                new File(new File(options.getProperty("-d")).getCanonicalPath()).createNewFile();
                new File(new File(options.getProperty("-d") + ".bak").getCanonicalPath()).createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.out.println("Could not create destination file " + options.getProperty("-d"));
                this.initialState();
            }
            try {
                destination = new LibraryTernaries(options.getProperty("-d") + ".bak", options.getProperty("-d"));
                destination.setOverWriteFlag("true".equals(options.getProperty("-r")));
                destination.setJarDirectory(originalDir + fs + "additional-lib" + fs);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not read destination file " + options.getProperty("-d"));
                this.initialState();
            }
            catch (IOException ioe) {
                System.out.println("Could not read destination file " + options.getProperty("-d"));
                this.initialState();
            }
        }
        catch (IOException e) {
            System.out.println("Unable to initialize input/output stream of destination file.");
            this.initialState();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Wrong parameters: " + e.getMessage());
            this.initialState();
        }
        try {
            try {
                library.load();
            }
            catch (FormatException fe) {
                System.out.println("Format exception while loading the file for including from: " + fe.getMessage());
                this.initialState();
            }
            catch (IOException e) {
                System.out.println("IOException in validate block (source): " + e.getMessage());
                this.initialState();
            }
            try {
                destination.load();
            }
            catch (FormatException fe) {
                System.out.println("Format exception while loading the file for including to: " + fe.getMessage());
                this.initialState();
            }
            catch (IOException e) {
                System.out.println("IOException in validate block (destination): " + e.getMessage());
                this.initialState();
            }
            Vector<OverwriteException> faultIndices = new Vector<OverwriteException>();
            int counter = 0;
            library.reset();
            while (library.hasNext()) {
                try {
                    ++counter;
                    TernaryTuple candidateTuple = library.next();
                    destination.insert(candidateTuple);
                }
                catch (OverwriteException oe) {
                    allOk = false;
                    oe.setErrorIndex(counter);
                    faultIndices.add(oe);
                }
            }
            if (allOk) {
                System.out.println("Destination file update successfully.");
            } else {
                System.out.println("Conflicting rules: ");
                int i = 0;
                while (i < faultIndices.size()) {
                    OverwriteException oe = (OverwriteException)faultIndices.elementAt(i);
                    System.out.println("    Tuples (original | new): " + oe.getOriginalTuple() + " | " + oe.getNewTuple() + " at line " + oe.getErrorIndex() + " of source library file");
                    ++i;
                }
                this.initialState();
            }
            Object var8_20 = null;
        }
        catch (Throwable throwable) {
            Object var8_21 = null;
            try {
                destination.save();
            }
            catch (Exception e) {
                System.out.println("Fatal error! Could not write to destination file.");
                this.initialState();
            }
            try {
                library.save();
            }
            catch (Exception e) {
                System.out.println("Error! Could not write to source file.");
            }
            throw throwable;
        }
        try {
            destination.save();
        }
        catch (Exception e) {
            System.out.println("Fatal error! Could not write to destination file.");
            this.initialState();
        }
        try {
            library.save();
        }
        catch (Exception e) {
            System.out.println("Error! Could not write to source file.");
        }
    }

    private void copyBakFile(String name) {
        this.copyFile(name, name + ".bak");
    }

    private void uncopyBakFile(String name) {
        this.copyFile(name + ".bak", name);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private void copyFile(String name1, String name2) {
        block17: {
            int read;
            File src = new File(name1);
            File dest = new File(name2);
            FileInputStream fis = null;
            FileOutputStream fos = null;
            if (src == null || dest == null || !src.exists()) {
                return;
            }
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdirs();
            }
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((read = fis.read(buffer, 0, buffer.length)) != -1) {
                void var8_9;
                fos.write(buffer, 0, (int)var8_9);
            }
            Object var10_10 = null;
            try {
                fis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                fos.close();
            }
            catch (Exception e2) {}
            break block17;
            {
                catch (Exception e) {
                    Object var10_11 = null;
                    try {
                        fis.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        fos.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    fis.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    fos.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void initialState() {
        if (library != null && destination != null && destination.loaded()) {
            this.uncopyBakFile(destination.getOutputFile());
        }
        LibraryEditor.deleteBakFiles();
        System.exit(213);
    }

    public static void deleteBakFiles() {
        if (library != null) {
            new File(library.getOutputFile() + ".bak").delete();
            if (destination != null) {
                new File(destination.getOutputFile() + ".bak").delete();
            }
        }
    }

    private static void ebcdicConvert(String[] args) {
        String platform = SystemProperties.getProperty("platform.notASCII");
        if (platform != null && platform.equalsIgnoreCase("false")) {
            System.setErr(System.out);
            String ASCII = "ISO8859_1";
            String EBCDIC = "Cp1047";
            try {
                int i = 0;
                while (i < args.length) {
                    args[i] = new String(args[i].getBytes(ASCII), EBCDIC);
                    ++i;
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    public static void main(String[] arguments) {
        LibraryEditor.ebcdicConvert(arguments);
        try {
            new LibraryEditor(arguments);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            LibraryEditor.deleteBakFiles();
            throw throwable;
        }
        LibraryEditor.deleteBakFiles();
        fileType = "reference.txt";
        noNeed = true;
        try {
            new LibraryEditor(arguments);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            LibraryEditor.deleteBakFiles();
            throw throwable;
        }
        LibraryEditor.deleteBakFiles();
    }
}

