/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.launcher;

import com.sap.engine.tools.launcher.DoublePrintStream;
import com.sap.engine.tools.launcher.LauncherException;
import com.sap.engine.tools.launcher.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Launcher {
    private static final String TOOL_PATH_PROP = "ToolPath";
    private static final String LIB_DIRS_PROP = "LibDirs";
    private static final String SEC_LIB_DIR_PROP = "SecLibDir";
    private static final String MAIN_CLASS_PROP = "MainClass";
    private static final String ERROR_LOG_PROP = "LogErrorStream";
    private static final String OUTPUT_LOG_PROP = "LogOutputStream";
    private static final String DAYS_TO_KEEP_LOGS_PROP = "DaysToKeepLogs";
    private static final String DEBUG_LAUNCHER_PROP = "DebugLauncher";
    private static final String LOG_PER_USER_PROP = "LogPerUser";
    private static final String REQ_JAVA_VERSION_PROP = "ReqJavaVersion";
    private static final String CFG_DIR = "cfg";
    private static final String LOG_DIR = "log";
    private static final String CONSOLE_LOGS_DIR = "console_logs";
    private static final String WORK_DIR_ROOT = System.getProperty("user.home") + File.separatorChar + "SAP" + File.separatorChar + "j2ee" + File.separatorChar;
    private static final String DAYS_TO_KEEP_LOGS_DEFAULT = String.valueOf(10);
    private static final String REQ_JAVA_VERSION_DEFAULT = "1.4.1";
    private static final String NL = System.getProperty("line.separator");
    private static final String EQ = " = ";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String YES = "yes";
    private static final String LOCATION = (class$com$sap$engine$tools$launcher$Launcher == null ? (class$com$sap$engine$tools$launcher$Launcher = Launcher.class$("com.sap.engine.tools.launcher.Launcher")) : class$com$sap$engine$tools$launcher$Launcher).getName();
    private static final char SLASH = '/';
    private static final Class[] MAIN_METHOD_PARAMS = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    private static final String MAIN_METHOD = "main";
    private static final String PATH_SEPARATORS = ":;";
    private static final String LAUNCHER_PROPERTIES_FILE = "launcher.properties";
    private static final String ERROR_LOG = "error.log";
    private static final String OUTPUT_LOG = "output.log";
    private static final FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname != null && pathname.isFile();
        }
    };
    private static final FilenameFilter secLibInfoFileFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".list");
        }
    };
    private static final Properties props = new Properties();
    private static ClassLoader parentClassLoader;
    private static URL propsURL;
    private static String toolPath;
    private static String installDir;
    private static String workDir;
    private static String libDirs;
    private static String secLibDir;
    private static String mainClassName;
    private static boolean logError;
    private static boolean debugLauncher;
    private static boolean logOutput;
    private static long daysToKeepLogs;
    private static boolean initialized;
    private static boolean logPerUser;
    private static String reqJavaVersion;
    static /* synthetic */ Class class$com$sap$engine$tools$launcher$Launcher;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] args) {
        if (initialized) {
            throw new IllegalStateException(LOCATION + " " + Messages.getString("launcher_16"));
        }
        if (Launcher.init()) {
            Launcher.launch(args);
        }
    }

    public static String getInstallDir() {
        if (!initialized) {
            throw new IllegalStateException(LOCATION + " " + Messages.getString("launcher_17"));
        }
        try {
            return URLDecoder.decode(installDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            return installDir;
        }
    }

    public static String getWorkDir() {
        if (!initialized) {
            throw new IllegalStateException(LOCATION + " " + Messages.getString("launcher_17"));
        }
        return workDir;
    }

    public static String getToolCfgDir() {
        return Launcher.getInstallDir() + File.separatorChar + CFG_DIR;
    }

    public static String getToolLogDir() {
        return Launcher.getInstallDir() + File.separatorChar + LOG_DIR;
    }

    public static String getUserCfgDir() {
        return Launcher.getWorkDir() + File.separatorChar + CFG_DIR;
    }

    public static String getLogDir() {
        if (!initialized) {
            throw new IllegalStateException(LOCATION + " " + Messages.getString("launcher_17"));
        }
        if (logPerUser) {
            return Launcher.getWorkDir() + File.separatorChar + LOG_DIR;
        }
        return Launcher.getInstallDir() + File.separatorChar + LOG_DIR;
    }

    private static boolean init() {
        initialized = true;
        parentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Launcher.readLauncherPropertyFile();
            Launcher.initProperties();
        }
        catch (LauncherException e) {
            Launcher.logErr(Messages.getString("launcher_14") + " " + propsURL, e);
            return false;
        }
        Launcher.initLogs();
        String currJavaVersion = System.getProperty("java.version", "");
        Launcher.logOut(Messages.getString("launcher_1") + propsURL.toExternalForm() + NL + TOOL_PATH_PROP + EQ + toolPath + NL + Messages.getString("launcher_2") + EQ + installDir + NL + Messages.getString("launcher_3") + EQ + workDir + NL + MAIN_CLASS_PROP + EQ + mainClassName + NL + LIB_DIRS_PROP + EQ + libDirs + NL + SEC_LIB_DIR_PROP + EQ + secLibDir + NL + ERROR_LOG_PROP + EQ + logError + NL + OUTPUT_LOG_PROP + EQ + logOutput + NL + DAYS_TO_KEEP_LOGS_PROP + EQ + daysToKeepLogs + NL + DEBUG_LAUNCHER_PROP + EQ + debugLauncher + NL + LOG_PER_USER_PROP + EQ + logPerUser + NL + REQ_JAVA_VERSION_PROP + EQ + reqJavaVersion + NL + "currentJavaVersion" + EQ + currJavaVersion);
        return Launcher.isCompatibleWith(currJavaVersion, reqJavaVersion);
    }

    private static boolean isCompatibleWith(String current, String desired) {
        if (current == null || current.length() < 1) {
            Launcher.logErr(Messages.getString("launcher_20") + " " + current, null);
        }
        if (desired == null || desired.length() < 1) {
            Launcher.logErr(Messages.getString("launcher_21") + " " + desired, null);
        }
        StringTokenizer dtok = new StringTokenizer(desired, "._", true);
        StringTokenizer stok = new StringTokenizer(current, "._", true);
        while (dtok.hasMoreTokens() || stok.hasMoreTokens()) {
            int cver;
            int dver;
            block13: {
                block12: {
                    if (dtok.hasMoreTokens()) {
                        try {
                            dver = Integer.parseInt(dtok.nextToken());
                            break block12;
                        }
                        catch (NumberFormatException e) {
                            Launcher.logErr(Messages.getString("launcher_21") + " " + desired, null);
                            break;
                        }
                    }
                    dver = 0;
                }
                if (stok.hasMoreTokens()) {
                    try {
                        cver = Integer.parseInt(stok.nextToken());
                        break block13;
                    }
                    catch (NumberFormatException e) {
                        Launcher.logErr(Messages.getString("launcher_20") + " " + current, null);
                        break;
                    }
                }
                cver = 0;
            }
            if (cver < dver) {
                Launcher.logErr(Messages.getString("launcher_19") + " " + desired, null);
                return false;
            }
            if (cver > dver) {
                return true;
            }
            if (dtok.hasMoreTokens()) {
                dtok.nextToken();
            }
            if (!stok.hasMoreTokens()) continue;
            stok.nextToken();
        }
        return true;
    }

    private static void launch(String[] args) {
        URLClassLoader appLoader = new URLClassLoader(Launcher.getLibUrls(), parentClassLoader);
        Thread.currentThread().setContextClassLoader(appLoader);
        try {
            Class<?> mainClass = Class.forName(mainClassName, false, appLoader);
            Method mainMethod = mainClass.getDeclaredMethod(MAIN_METHOD, MAIN_METHOD_PARAMS);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            Launcher.logErr(Messages.getString("launcher_4") + " " + mainClassName, e);
        }
    }

    private static URL[] getLibUrls() {
        StringTokenizer tokenizer = new StringTokenizer(libDirs, PATH_SEPARATORS);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            String subPath = tokenizer.nextToken();
            subPath = subPath.replace('/', File.separatorChar);
            String libDirStr = Launcher.getInstallDir() + File.separatorChar + subPath;
            File libDir = new File(libDirStr);
            if (!libDir.exists() || !libDir.isDirectory()) {
                Launcher.logErr(Messages.getString("launcher_15") + " " + libDir, null);
                continue;
            }
            File[] jars = libDir.listFiles(filter);
            if (jars == null) continue;
            int i = 0;
            while (i < jars.length) {
                try {
                    urls.add(new URL("file", null, jars[i].getAbsolutePath()));
                }
                catch (MalformedURLException e) {
                    Launcher.logErr(Messages.getString("launcher_5") + " " + jars[i], e);
                }
                ++i;
            }
        }
        String libDirStr = Launcher.getInstallDir() + File.separatorChar + secLibDir;
        File libDir = new File(libDirStr);
        File[] jars = Launcher.getSecLibsToAdd(libDir);
        if (jars != null) {
            int i = 0;
            while (i < jars.length) {
                try {
                    urls.add(new URL("file", null, jars[i].getAbsolutePath()));
                }
                catch (MalformedURLException e) {
                    Launcher.logErr(Messages.getString("launcher_5") + " " + jars[i], e);
                }
                ++i;
            }
        }
        StringBuffer sb = new StringBuffer();
        if (debugLauncher) {
            sb.append(Messages.getString("launcher_6") + (urls.size() <= 0 ? Messages.getString("launcher_7") : ""));
        }
        URL[] urlArray = new URL[urls.size()];
        int i = 0;
        Iterator iter = ((AbstractList)urls).iterator();
        while (iter.hasNext()) {
            urlArray[i] = (URL)iter.next();
            if (debugLauncher) {
                sb.append(NL).append("   " + urlArray[i].toExternalForm());
            }
            ++i;
        }
        if (debugLauncher) {
            Launcher.logOut(sb.toString());
        }
        return urlArray;
    }

    /*
     * Unable to fully structure code
     */
    private static File[] getSecLibsToAdd(File libDir) {
        libPath = libDir.getAbsolutePath();
        infoDir = new File(libPath + File.separatorChar + "info");
        if (!infoDir.exists() || !infoDir.isDirectory()) {
            return libDir.listFiles(Launcher.filter);
        }
        infoFiles = infoDir.listFiles(Launcher.secLibInfoFileFilter);
        if (infoFiles == null || infoFiles.length == 0) {
            return libDir.listFiles(Launcher.filter);
        }
        filesToAdd = new HashSet<File>();
        i = 0;
        while (i < infoFiles.length) {
            block16: {
                reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(infoFiles[i])));
                    ln = null;
                    while ((ln = reader.readLine()) != null) {
                        if ((ln = ln.trim()).equals("")) continue;
                        fileToAdd = new File(libPath + File.separatorChar + ln);
                        if (fileToAdd.exists()) {
                            filesToAdd.add(fileToAdd);
                            continue;
                        }
                        Launcher.logErr(Messages.getString("launcher_5") + " " + fileToAdd.getAbsolutePath(), null);
                    }
                    var10_10 = null;
                    ** if (reader == null) goto lbl-1000
                }
                catch (Throwable var9_12) {
                    var10_10 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    throw var9_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        reader.close();
                    }
                    catch (IOException ignored) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (IOException e) {
                        Launcher.logErr(Messages.getString("launcher_18") + " " + infoFiles[i], e);
                        var10_10 = null;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException ignored) {}
                        }
                    }
                }
            }
            ++i;
        }
        return filesToAdd.toArray(new File[filesToAdd.size()]);
    }

    private static void initProperties() throws LauncherException {
        toolPath = props.getProperty(TOOL_PATH_PROP);
        mainClassName = props.getProperty(MAIN_CLASS_PROP);
        if (toolPath == null) {
            throw new LauncherException(Messages.getString("launcher_8") + TOOL_PATH_PROP);
        }
        String tmp = props.getProperty(ERROR_LOG_PROP, TRUE);
        logError = tmp.equalsIgnoreCase(YES) || tmp.equalsIgnoreCase(TRUE);
        tmp = props.getProperty(OUTPUT_LOG_PROP, TRUE);
        logOutput = tmp.equalsIgnoreCase(YES) || tmp.equalsIgnoreCase(TRUE);
        tmp = props.getProperty(DEBUG_LAUNCHER_PROP, FALSE);
        debugLauncher = tmp.equalsIgnoreCase(YES) || tmp.equalsIgnoreCase(TRUE);
        tmp = props.getProperty(LOG_PER_USER_PROP, FALSE);
        logPerUser = tmp.equalsIgnoreCase(YES) || tmp.equalsIgnoreCase(TRUE);
        daysToKeepLogs = Long.parseLong(props.getProperty(DAYS_TO_KEEP_LOGS_PROP, DAYS_TO_KEEP_LOGS_DEFAULT));
        libDirs = props.getProperty(LIB_DIRS_PROP, "");
        secLibDir = props.getProperty(SEC_LIB_DIR_PROP, "");
        installDir = new File(propsURL.getFile()).getParentFile().getParent();
        if (installDir == null) {
            throw new LauncherException(Messages.getString("launcher_9"));
        }
        workDir = WORK_DIR_ROOT + toolPath.replace('/', File.separatorChar);
        File dir = new File(workDir);
        dir.mkdirs();
        reqJavaVersion = props.getProperty(REQ_JAVA_VERSION_PROP, REQ_JAVA_VERSION_DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readLauncherPropertyFile() throws LauncherException {
        propsURL = parentClassLoader.getResource(LAUNCHER_PROPERTIES_FILE);
        if (propsURL == null) {
            throw new LauncherException(Messages.getString("launcher_10") + LAUNCHER_PROPERTIES_FILE);
        }
        InputStream stream = null;
        try {
            try {
                stream = propsURL.openStream();
                props.load(stream);
            }
            catch (IOException e) {
                throw new LauncherException(Messages.getString("launcher_11") + LAUNCHER_PROPERTIES_FILE, e);
            }
            Object var3_1 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        stream.close();
        return;
    }

    private static void logOut(String string) {
        if (debugLauncher) {
            String date = new SimpleDateFormat().format(new Date());
            System.out.println(date + " " + LOCATION + " Debug : " + string);
        }
    }

    private static void logErr(String string, Throwable e) {
        String date = new SimpleDateFormat().format(new Date());
        System.err.println(date + " " + LOCATION + " Error : " + (string != null ? string : (e != null ? e.getMessage() : "")));
        if (e != null) {
            e.printStackTrace(System.err);
        }
    }

    private static void logErr(Throwable e) {
        Launcher.logErr(null, e);
    }

    private static void initLogs() {
        try {
            File outputFile;
            String consoleLogDir = Launcher.getLogDir() + File.separator + CONSOLE_LOGS_DIR;
            new File(consoleLogDir).mkdirs();
            File errorFile = new File(consoleLogDir + File.separatorChar + ERROR_LOG);
            if (errorFile.exists()) {
                Launcher.changeLogName(errorFile, consoleLogDir);
                errorFile = new File(consoleLogDir + File.separatorChar + ERROR_LOG);
            }
            if ((outputFile = new File(consoleLogDir + File.separatorChar + OUTPUT_LOG)).exists()) {
                Launcher.changeLogName(outputFile, consoleLogDir);
                outputFile = new File(consoleLogDir + File.separatorChar + OUTPUT_LOG);
            }
            if (logError || logOutput) {
                GregorianCalendar calendar = new GregorianCalendar();
                int day_of_month = calendar.get(5);
                int month = calendar.get(2) + 1;
                int hour_of_day = calendar.get(11);
                int minute = calendar.get(12);
                int second = calendar.get(13);
                String dateString = calendar.get(1) + "_" + (month < 10 ? "0" + month : month + "") + "_" + (day_of_month < 10 ? "0" + day_of_month : day_of_month + "") + "_at_" + (hour_of_day < 10 ? "0" + hour_of_day : hour_of_day + "") + "_" + (minute < 10 ? "0" + minute : minute + "") + "_" + (second < 10 ? "0" + second : second + "");
                String headerLine = "# log generation timestamp : " + dateString;
                if (logError) {
                    PrintStream error = null;
                    try {
                        error = new PrintStream(new FileOutputStream(errorFile));
                        error.println(headerLine);
                        error.println();
                        System.setErr(new DoublePrintStream(System.err, error));
                    }
                    catch (Exception exc) {
                        Launcher.logErr(Messages.getString("launcher_12"), exc);
                    }
                }
                if (logOutput) {
                    PrintStream output = null;
                    try {
                        output = new PrintStream(new FileOutputStream(outputFile));
                        output.println(headerLine);
                        output.println();
                        System.setOut(new DoublePrintStream(System.out, output));
                    }
                    catch (Exception exc) {
                        Launcher.logErr(Messages.getString("launcher_13"), exc);
                    }
                }
            }
            long comparisonTimestamp = System.currentTimeMillis() - daysToKeepLogs * 86400000L;
            File[] files = new File(consoleLogDir).listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].lastModified() < comparisonTimestamp) {
                    files[i].delete();
                }
                ++i;
            }
        }
        catch (Exception exc) {
            Launcher.logErr(exc);
        }
    }

    private static void changeLogName(File f, String logDir) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "rw");
        }
        catch (FileNotFoundException fnfexc) {
            return;
        }
        try {
            String dateLine = raf.readLine().trim();
            raf.close();
            String date = dateLine.substring(29);
            date = date.replace('-', '_');
            if (!f.renameTo(new File(logDir + File.separator + date + "_" + f.getName()))) {
                f.delete();
            }
        }
        catch (Exception exc) {
            f.delete();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logError = true;
        debugLauncher = false;
        logOutput = true;
        initialized = false;
        logPerUser = false;
    }
}

