/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.devenv;

import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbModificationManager;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JDDSchemaSDADeploy {
    static final String DEFAULT_USER = "SAPC11DB";
    static final String DEFAULT_PASSWORD = "sap";
    static final String DEFAULT_DRIVER = "com.sap.dbtech.jdbcext.ConnectionPoolDataSourceSapDB";
    static final String DEFAULT_URL = "jdbc:sapdb://localhost/C11?timeout=0";
    static String _propValue;
    private Connection _con;
    private String _url;
    private String _driverName;
    private String _usr;
    private String _password;
    private String _sdaFile;

    public JDDSchemaSDADeploy(Properties props) {
        this._usr = props.getProperty("user");
        this._password = props.getProperty("password");
        this._url = props.getProperty("url");
        this._driverName = props.getProperty("driver");
        this._sdaFile = props.getProperty("sdaFile");
    }

    public boolean prepareSDA() {
        try {
            File sdaFile = new File(this._sdaFile);
            File temp = new File("temp/" + sdaFile.getName());
            this.deleteDir(temp);
            temp.mkdirs();
            System.out.println("Extract file -> " + sdaFile.getAbsolutePath());
            System.out.println("to dir -> " + temp.getAbsolutePath());
            JarExtractor extractor = new JarExtractor();
            extractor.extractJar(sdaFile.getAbsolutePath(), temp.getAbsolutePath());
            File[] listFile = temp.listFiles();
            if (listFile != null) {
                int index = 0;
                while (index < listFile.length) {
                    if (listFile[index].getName().endsWith(".gdbtable")) {
                        Text textNode;
                        System.out.println("Modify file -> " + listFile[index].getAbsolutePath());
                        StandardDOMParser parser = new StandardDOMParser();
                        parser.setValidation(false);
                        Document doc = parser.parse(listFile[index].getAbsolutePath());
                        Element dbTableNode = doc.getDocumentElement();
                        NodeList nodes = dbTableNode.getChildNodes();
                        Node actionNode = null;
                        Node columnsNode = null;
                        int ind = 0;
                        while (ind < nodes.getLength()) {
                            Node node = nodes.item(ind);
                            if (node.getNodeName().equals("predefined-action")) {
                                actionNode = node;
                                break;
                            }
                            if (node.getNodeName().equals("columns")) {
                                columnsNode = node;
                            }
                            ++ind;
                        }
                        if (actionNode != null) {
                            Node child = actionNode.getFirstChild();
                            if (child != null) {
                                child.setNodeValue("DROP_CREATE");
                            } else {
                                textNode = doc.createTextNode("DROP_CREATE");
                                actionNode.appendChild(textNode);
                            }
                        } else {
                            Element actionElement = doc.createElement("predefined-action");
                            textNode = doc.createTextNode("DROP_CREATE");
                            actionElement.appendChild(textNode);
                            dbTableNode.insertBefore(actionElement, columnsNode);
                        }
                        StandardDOMWriter writer = new StandardDOMWriter();
                        writer.write(doc, listFile[index].getAbsolutePath(), "");
                    }
                    ++index;
                }
            }
            sdaFile.delete();
            JarUtils jarUtils = new JarUtils();
            jarUtils.makeJarFromDir(sdaFile.getAbsolutePath(), temp.getAbsolutePath());
            System.out.println("Delete temp directory -> " + this.deleteDir(temp));
            System.out.println();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void deploySDA() {
        int rc = 0;
        Object return_exception = null;
        DbFactory factory = null;
        try {
            factory = new DbFactory(this._con);
        }
        catch (Exception ex) {
            System.out.println("Jdd could not be instantiated : ");
            ex.printStackTrace();
        }
        DbModificationManager distributor = new DbModificationManager(factory);
        rc = distributor.distribute(this._sdaFile, "jddSchema_sda_deploy.log");
        try {
            this._con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean initDB() {
        boolean success = false;
        try {
            Class.forName(this._driverName).newInstance();
            this._con = DriverManager.getConnection(this._url, this._usr, this._password);
            success = true;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Unexpected Exception:" + e.toString() + ".\nThis error usually indicates that your CLASSPATH " + "is not set correctly.");
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Unexpected Exception:" + e.toString());
        }
        return success;
    }

    public void restoreDB() {
        try {
            if (this._con != null) {
                this._con.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Properties processCommandLine(String[] args) throws Exception {
        boolean userPropsFile = false;
        Properties props = new Properties();
        ((Hashtable)props).put("user", DEFAULT_USER);
        ((Hashtable)props).put("password", DEFAULT_PASSWORD);
        ((Hashtable)props).put("url", DEFAULT_URL);
        ((Hashtable)props).put("driver", DEFAULT_DRIVER);
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-' && args[i].length() >= 2) {
                switch (args[i].charAt(1)) {
                    case 'P': {
                        String dbPropsFile = args[i].substring(2).trim();
                        Properties pr = new Properties();
                        pr.load(new FileInputStream(dbPropsFile));
                        props.setProperty("user", pr.getProperty("rdbms.user", DEFAULT_USER));
                        props.setProperty("password", pr.getProperty("rdbms.password", DEFAULT_PASSWORD));
                        props.setProperty("url", pr.getProperty("rdbms.url", DEFAULT_URL));
                        props.setProperty("driver", pr.getProperty("rdbms.driver", DEFAULT_DRIVER));
                        break;
                    }
                    case 'p': {
                        props.setProperty("sdaFile", args[i].substring(2).trim());
                        userPropsFile = true;
                    }
                }
            }
            ++i;
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(InputStream in) {
        if (in == null) {
            return null;
        }
        byte[] buff = null;
        ByteArrayOutputStream b = null;
        try {
            int c;
            b = in.available() > 1 ? new ByteArrayOutputStream(in.available()) : new ByteArrayOutputStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            while ((c = bin.read()) != -1) {
                void var3_6;
                b.write((int)var3_6);
            }
            b.flush();
            b.close();
            bin.close();
            buff = b.toByteArray();
            in.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return buff;
    }

    private boolean deleteDir(File dir) {
        File[] list = dir.listFiles();
        if (list != null) {
            int index = 0;
            while (index < list.length) {
                if (list[index].isDirectory()) {
                    this.deleteDir(list[index]);
                } else {
                    list[index].delete();
                }
                ++index;
            }
        }
        return dir.delete();
    }

    public static void main(String[] args) {
        JDDSchemaSDADeploy jddsd = null;
        Properties props = null;
        try {
            block7: {
                try {
                    props = JDDSchemaSDADeploy.processCommandLine(args);
                    if (props == null || !(jddsd = new JDDSchemaSDADeploy(props)).initDB() || !jddsd.prepareSDA()) break block7;
                    jddsd.deploySDA();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Object var5_4 = null;
                    if (jddsd != null) {
                        jddsd.restoreDB();
                    }
                }
            }
            Object var5_3 = null;
            if (jddsd != null) {
                jddsd.restoreDB();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (jddsd != null) {
                jddsd.restoreDB();
            }
            throw throwable;
        }
    }
}

